/*
 * Decompiled with CFR 0.152.
 */
package com.tom.core.task;

import com.tom.core.service.ICorePaperCheckService;
import com.tom.core.service.ICorePaperService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class PaperTask {
    private static final Logger logger = Logger.getLogger(PaperTask.class);
    @Autowired
    private ICorePaperService paperService;
    @Autowired
    private ICorePaperCheckService paperCheckService;
    private boolean loaded = false;

    @Scheduled(fixedRate=3600000L)
    public void doLoadPapers() {
        if (!this.loaded) {
            this.paperService.loadAllPapers();
            this.loaded = true;
        }
    }

    @Scheduled(fixedRate=5000L)
    public void doPaperCheck() {
        int rows = this.paperCheckService.doCheckPaperQueue();
        if (rows > 0) {
            logger.info((Object)("\u5b9a\u65f6\u4efb\u52a1:\u6210\u529f\u6279\u6539" + rows + "\u4efd\u8bd5\u5377."));
        }
    }
}

