/*
 * Decompiled with CFR 0.152.
 */
package com.tom.core.service.imp;

import com.tom.core.TomSystemQueue;
import com.tom.core.dao.ICoreSystemDao;
import com.tom.core.service.ICoreSystemService;
import com.tom.model.system.SysLogger;
import com.tom.system.service.IConfigService;
import com.tom.util.CacheHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="CoreSystemService")
public class CoreSystemServiceImp
implements ICoreSystemService {
    private static final Logger logger = Logger.getLogger(CoreSystemServiceImp.class);
    @Autowired
    private ICoreSystemDao dao;
    @Autowired
    private IConfigService service;

    @Override
    public int loadAllAdminPrivilege() {
        try {
            List<Map<String, Object>> list = this.dao.getAllAdminRoles();
            if (list != null && list.size() > 0) {
                for (Map<String, Object> map : list) {
                    String roleid = String.valueOf(map.get("r_id"));
                    String privilege = String.valueOf(map.get("r_privilege"));
                    CacheHelper.addCache("RoleCache", "R" + roleid, "," + privilege);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return 1;
    }

    @Override
    public Map<String, Object> getConfig() {
        Map<String, Object> config = (Map<String, Object>)CacheHelper.getCache("ConfigCache", "base");
        if (config == null) {
            config = this.service.getConfig("1");
            CacheHelper.addCache("ConfigCache", "base", config);
        }
        return config;
    }

    @Override
    public String getConfigValue(String key) {
        return String.valueOf(this.getConfig().get(key));
    }

    @Override
    public int doCheckSystemLogQueue() {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        try {
            int i = 0;
            while (i < 10) {
                SysLogger log = TomSystemQueue.SYSTEM_LOG_QUEUE.poll();
                if (log != null) {
                    ArrayList<Object> ls = new ArrayList<Object>();
                    ls.add(log.getUsertype());
                    ls.add(log.getUsername());
                    ls.add(log.getAction());
                    ls.add(log.getUrl());
                    ls.add(log.getLogdate());
                    ls.add(log.getDesc());
                    ls.add(log.getIp());
                    list.add(ls);
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        int ips = list.size();
        if (ips < 1) {
            return 0;
        }
        try {
            return this.dao.saveLog(list);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public int getTotalUsers() {
        try {
            return this.dao.getTotalUsers();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return -1;
        }
    }
}

