/*
 * Decompiled with CFR 0.152.
 */
package com.tom.core.service.imp;

import com.tom.core.dao.ICorePaperDao;
import com.tom.core.service.ICorePaperService;
import com.tom.model.ModelHelper;
import com.tom.model.paper.Paper;
import com.tom.model.paper.PaperSection;
import com.tom.model.paper.Question;
import com.tom.model.paper.QuestionBlankFill;
import com.tom.model.paper.QuestionEssay;
import com.tom.model.paper.QuestionJudgment;
import com.tom.model.paper.QuestionMultipleChoice;
import com.tom.model.paper.QuestionSingleChoice;
import com.tom.util.CacheHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="CorePaperService")
public class CorePaperServiceImp
implements ICorePaperService {
    private static final Logger logger = Logger.getLogger(CorePaperServiceImp.class);
    @Autowired
    private ICorePaperDao dao;

    @Override
    public Paper getPaper(String pid) {
        String cacheName = "PaperCache";
        String cacheKey = "P" + pid;
        Paper paper = (Paper)CacheHelper.getCache(cacheName, cacheKey);
        if (paper != null) {
            return paper;
        }
        paper = this.getBasicPaperFromDatabase(pid);
        if (paper == null) {
            logger.warn((Object)("PID=" + pid + "\u7684\u8bd5\u5377\u4e0d\u5b58\u5728"));
            return null;
        }
        if (paper.getPapertype() == 0) {
            paper = this.buildNormalPaper(paper);
        }
        CacheHelper.addCache(cacheName, cacheKey, paper);
        return paper;
    }

    @Override
    public Question getQuestion(String qid) {
        Question question;
        block21: {
            Map<String, Object> map;
            String cacheKey;
            String cacheName;
            block22: {
                cacheName = "QuestionCache";
                cacheKey = "Q" + qid;
                question = (Question)CacheHelper.getCache(cacheName, cacheKey);
                if (question != null) {
                    try {
                        String questionType = question.getType();
                        if ("1".equals(questionType)) {
                            return new QuestionSingleChoice((QuestionSingleChoice)question);
                        }
                        if ("2".equals(questionType)) {
                            return new QuestionMultipleChoice((QuestionMultipleChoice)question);
                        }
                        if ("3".equals(questionType)) {
                            return new QuestionJudgment((QuestionJudgment)question);
                        }
                        if ("4".equals(questionType)) {
                            return new QuestionBlankFill((QuestionBlankFill)question);
                        }
                        if ("5".equals(questionType)) {
                            return new QuestionEssay((QuestionEssay)question);
                        }
                        break block21;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        logger.error((Object)e);
                        return null;
                    }
                }
                map = this.dao.getQuestion(qid);
                if (map != null) break block22;
                logger.warn((Object)("QID=" + qid + "\u7684\u8bd5\u9898\u4e0d\u5b58\u5728"));
                return null;
            }
            try {
                String questionData = String.valueOf(map.get("q_data"));
                String questionType = String.valueOf(map.get("q_type"));
                question = (Question)ModelHelper.convertObject(questionData);
                if ("1".equals(questionType)) {
                    question = (QuestionSingleChoice)question;
                } else if ("2".equals(questionType)) {
                    question = (QuestionMultipleChoice)question;
                } else if ("3".equals(questionType)) {
                    question = (QuestionJudgment)question;
                } else if ("4".equals(questionType)) {
                    question = (QuestionBlankFill)question;
                } else if ("5".equals(questionType)) {
                    question = (QuestionEssay)question;
                }
                if (question != null) {
                    CacheHelper.addCache(cacheName, cacheKey, question);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return question;
    }

    @Override
    public Paper getUserRandomPaper(String uid, String pid) {
        Map<String, Object> map;
        Paper xpaper;
        block3: {
            xpaper = null;
            logger.info((Object)("\u83b7\u53d6\u5b66\u5458\u968f\u673a\u8bd5\u5377...pid=" + pid + ",uid=" + uid));
            map = this.dao.getUserRandomPaper(uid, pid);
            if (map != null) break block3;
            logger.info((Object)("\u83b7\u53d6\u5b66\u5458\u968f\u673a\u8bd5\u5377...pid=" + pid + ",uid=" + uid + ",\u4e0d\u5b58\u5728"));
            return null;
        }
        try {
            String paperData = String.valueOf(map.get("r_detail"));
            xpaper = (Paper)ModelHelper.convertObject(paperData);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return xpaper;
    }

    @Override
    public Paper buildUserRandomPaper(String uid, String pid) {
        Paper xpaper = null;
        Map<String, Object> map = null;
        logger.info((Object)("\u83b7\u53d6\u968f\u673a\u8bd5\u5377...pid=" + pid + ",uid=" + uid));
        try {
            map = this.dao.getUserRandomPaper(uid, pid);
            if (map == null) {
                logger.info((Object)("\u83b7\u53d6\u968f\u673a\u8bd5\u5377...pid=" + pid + ",uid=" + uid + ",\u9996\u6b21\u521b\u5efa"));
                xpaper = this.buildRandomPaper(pid);
                int row = this.dao.saveUserRandomPaper(uid, pid, ModelHelper.formatObject(xpaper));
                logger.info((Object)("\u4fdd\u5b58\u9996\u6b21\u751f\u6210\u7684\u8bd5\u5377\u5165\u5e93,pid=" + pid + ",uid=" + uid + ",rows=" + row));
            } else {
                logger.info((Object)("\u83b7\u53d6\u968f\u673a\u8bd5\u5377...pid=" + pid + ",uid=" + uid + ",\u6570\u636e\u5e93\u83b7\u53d6"));
                String paperData = String.valueOf(map.get("r_detail"));
                xpaper = (Paper)ModelHelper.convertObject(paperData);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return xpaper;
    }

    @Override
    public int loadAllPapers() {
        int rows = 0;
        try {
            List<Map<String, Object>> list = this.dao.getAllPapers();
            if (list != null && list.size() > 0) {
                for (Map<String, Object> map : list) {
                    String pid = String.valueOf(map.get("p_id"));
                    Paper paper = this.getPaper(pid);
                    if (paper == null) continue;
                    ++rows;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return rows;
    }

    private Paper getBasicPaperFromDatabase(String pid) {
        Map<String, Object> map;
        Paper paper;
        block3: {
            paper = null;
            map = this.dao.getPaper(pid);
            if (map != null) break block3;
            return null;
        }
        try {
            String paperData = String.valueOf(map.get("p_data"));
            paper = (Paper)ModelHelper.convertObject(paperData);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return paper;
    }

    private Paper buildNormalPaper(Paper paper) {
        List<PaperSection> sections = paper.getSections();
        if (sections != null) {
            for (PaperSection section : sections) {
                List<Question> questions = section.getQuestions();
                if (questions == null) continue;
                ArrayList<Question> newQuestions = new ArrayList<Question>();
                for (Question question : questions) {
                    int score = question.getScore();
                    String qid = question.getId();
                    if ((question = this.getQuestion(question.getId())) != null) {
                        question.setScore(score);
                        newQuestions.add(question);
                        continue;
                    }
                    logger.warn((Object)("\u7ec4\u5377\u9700\u8981\u7684\u8bd5\u9898\u4e0d\u5b58\u5728\uff1aqid=" + qid));
                }
                section.setQuestions(newQuestions);
            }
        }
        return paper;
    }

    private Paper buildRandomPaper(String pid) {
        Paper paper = new Paper(this.getPaper(pid));
        List<PaperSection> sections = paper.getSections();
        if (sections != null) {
            for (PaperSection section : sections) {
                List<Question> questions = this.getRandomQuestions(section);
                section.setQuestions(questions);
            }
        }
        return paper;
    }

    private List<Question> getRandomQuestions(PaperSection section) {
        ArrayList<Question> questions = new ArrayList<Question>();
        try {
            List<Map<String, Object>> list = this.dao.getQuestions(section.getRdbid(), section.getRtype(), section.getRlevel(), section.getRnum());
            if (list != null && list.size() > 0) {
                for (Map<String, Object> map : list) {
                    String qid = String.valueOf(map.get("q_id"));
                    Question question = this.getQuestion(qid);
                    question.setScore(section.getRscore());
                    questions.add(question);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return questions;
    }
}

