/*
 * Decompiled with CFR 0.152.
 */
package com.tom.core.service.imp;

import com.tom.core.TomSystemQueue;
import com.tom.core.dao.ICorePaperCheckDao;
import com.tom.core.service.ICorePaperCheckService;
import com.tom.core.service.ICorePaperService;
import com.tom.core.util.PaperServiceHelper;
import com.tom.model.paper.Paper;
import com.tom.model.paper.PaperCheckResult;
import com.tom.model.paper.PaperSection;
import com.tom.model.paper.Question;
import com.tom.model.paper.QuestionBlankFill;
import com.tom.util.BaseUtil;
import com.tom.util.Constants;
import com.tom.util.FileHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="CorePaperCheckService")
public class CorePaperCheckServiceImp
implements ICorePaperCheckService {
    private static final Logger logger = Logger.getLogger(CorePaperCheckServiceImp.class);
    @Autowired
    private ICorePaperCheckDao dao;
    @Autowired
    private ICorePaperService corePaperService;

    @Override
    public PaperCheckResult doCheckPaper(Paper paper, JSONObject json) {
        if (paper == null) {
            logger.error((Object)"\u81ea\u52a8\u6279\u6539:\u8bd5\u5377\u5bf9\u8c61\u4e0d\u5b58\u5728.");
            return null;
        }
        if (json == null) {
            logger.error((Object)"\u81ea\u52a8\u6279\u6539:\u7528\u6237\u7b54\u6848\u4e0d\u5b58\u5728.");
            return null;
        }
        if (paper.getSections() == null || paper.getSections().size() < 1) {
            logger.error((Object)"\u81ea\u52a8\u6279\u6539:\u8bd5\u5377\u4e0d\u5b8c\u6574.");
            return null;
        }
        JSONObject check = new JSONObject();
        int totalScore = 0;
        try {
            for (PaperSection section : paper.getSections()) {
                if (section == null || section.getQuestions() == null || section.getQuestions().size() <= 0) continue;
                for (Question question : section.getQuestions()) {
                    if (question == null) continue;
                    String qType = question.getType();
                    String userkey = "";
                    try {
                        userkey = json.getString("Q-" + question.getId());
                    }
                    catch (Exception e) {
                        logger.error((Object)("\u81ea\u52a8\u6279\u6539:\u83b7\u53d6\u7528\u6237\u7b54\u6848\u5931\u8d25\uff0c\u7b54\u6848\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u6ca1\u4f5c\u7b54." + e.getMessage()));
                    }
                    int userScore = 0;
                    if ("1".equals(qType) || "2".equals(qType) || "3".equals(qType)) {
                        String _userkey;
                        String _key = BaseUtil.isEmpty(question.getKey()) ? "" : question.getKey().replace(",", "").replace(Constants.TM_SPLITER, "").replace(" ", "");
                        String string = _userkey = userkey == null ? "" : userkey.replace(Constants.TM_SPLITER, "");
                        if (_key.equals(_userkey)) {
                            userScore = question.getScore();
                        }
                    } else if ("4".equals(qType)) {
                        QuestionBlankFill _question = (QuestionBlankFill)question;
                        userScore = PaperServiceHelper.BlankFillChecker(_question, userkey);
                    }
                    check.put((Object)("Q-" + question.getId()), (Object)userScore);
                    totalScore += userScore;
                }
            }
            String pid = json.getString("e_pid");
            String uid = json.getString("e_uid");
            JSONObject userdata = json;
            userdata.remove("e_pid");
            userdata.remove("e_uid");
            PaperCheckResult result = new PaperCheckResult();
            result.setResult(check);
            result.setScore(totalScore);
            result.setPid(pid);
            result.setUid(uid);
            result.setUserdata(userdata);
            result.setSuccess(true);
            logger.info((Object)("\u81ea\u52a8\u6279\u6539\u5b8c\u6210\uff0c\u7ed3\u679c\u5bf9\u8c61\uff1a" + result.toString()));
            return result;
        }
        catch (Exception e) {
            logger.error((Object)("\u81ea\u52a8\u6279\u6539:\u6279\u6539\u65f6\u53d1\u751f\u5f02\u5e38." + e.getMessage()));
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public int doSaveUserPapers(List<PaperCheckResult> list) {
        if (list == null || list.size() < 1) {
            logger.warn((Object)"\u81ea\u52a8\u6279\u6539:\u4fdd\u5b58\u7528\u6237\u8bd5\u5377\uff0c\u76ee\u6807\u961f\u5217\u4e3a\u7a7a.");
            return 0;
        }
        ArrayList<List<Object>> userpapers = new ArrayList<List<Object>>();
        for (PaperCheckResult result : list) {
            ArrayList<Object> ls = new ArrayList<Object>();
            ls.add(result.getUserdata() == null ? "" : result.getUserdata().toString());
            ls.add(result.getResult() == null ? "" : result.getResult().toString());
            ls.add(result.getScore());
            ls.add(result.getUid());
            ls.add(result.getPid());
            userpapers.add(ls);
        }
        try {
            return this.dao.saveUserPaper(userpapers);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public int doCheckPaperQueue() {
        ArrayList<Map> list = null;
        int i = 0;
        while (i < 10) {
            Map map = TomSystemQueue.USER_PAPER_QUEUE.poll();
            if (map != null) {
                if (list == null) {
                    list = new ArrayList<Map>();
                }
                list.add(map);
            }
            ++i;
        }
        if (list == null || list.size() < 1) {
            return 0;
        }
        logger.info((Object)("\u6279\u91cf\u6279\u6539:\u83b7\u53d6\u5230[" + list.size() + "]\u4efd\u7b54\u5377\u6570\u636e"));
        ArrayList<PaperCheckResult> results = new ArrayList<PaperCheckResult>();
        for (Map map : list) {
            String pid = String.valueOf(map.get("e_pid"));
            String uid = String.valueOf(map.get("e_uid"));
            if (BaseUtil.isEmpty(pid) || BaseUtil.isEmpty(uid)) {
                logger.error((Object)("\u6279\u91cf\u6279\u6539:\u7528\u6237\u6216\u8bd5\u5377\u4fe1\u606f\u4e22\u5931.pid=" + pid + ",uid=" + uid));
                continue;
            }
            Paper paper = this.corePaperService.getPaper(pid);
            if (paper == null) {
                logger.error((Object)("\u6279\u91cf\u6279\u6539:\u8bd5\u5377\u4e0d\u5b58\u5728!!!.pid=" + pid + ",uid=" + uid));
                continue;
            }
            if (1 == paper.getPapertype()) {
                paper = this.corePaperService.getUserRandomPaper(uid, pid);
            }
            if (paper == null) {
                logger.error((Object)("\u6279\u91cf\u6279\u6539:\u968f\u673a\u8bd5\u5377\u4e0d\u5b58\u5728!!!.pid=" + pid + ",uid=" + uid));
                continue;
            }
            JSONObject json = JSONObject.fromObject((Object)map);
            PaperCheckResult result = this.doCheckPaper(paper, json);
            if (result != null && result.isSuccess()) {
                results.add(result);
                continue;
            }
            logger.error((Object)("\u81ea\u52a8\u6279\u6539\u53d1\u751f\u5f02\u5e38\uff0c\u7b54\u5377\u88ab\u5b58\u5230\u78c1\u76d8\u6587\u4ef6, map = " + map));
            try {
                String filename = String.valueOf(pid) + "_" + uid + ".dat";
                String separator = System.getProperty("file.separator");
                String basepath = String.valueOf(separator) + "files" + separator + "data" + separator;
                String filepath = String.valueOf(Constants.getPhysicalPath()) + basepath + filename;
                FileHelper.doWriteFile(filepath, json.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (results != null && results.size() > 0) {
            return this.doSaveUserPapers(results);
        }
        return 0;
    }
}

