const electron = require('electron');
const { app, Menu, Tray } = electron;
const { BrowserWindow } = electron;
const path = require('path');
const ipc = require('electron').ipcMain;
const { shell } = require('electron')

let mainWindow
let newWindow
let timer = {}

function createWindow() {
    const electronScreen = require('electron').screen
    const size = electronScreen.getPrimaryDisplay().size
        // 创建 browser window.
    mainWindow = new BrowserWindow({ width: 1200, height: 800, frame: false, resizable: false })

    // 加载登录页
    mainWindow.loadFile('./page/index.html')

    //打开调试
    //  mainWindow.webContents.openDevTools()

    // 异常退出
    mainWindow.on('closed', function() {

        mainWindow = null
    })

    mainWindow.setMenu(null)
}



app.on('ready', createWindow)




app.on('window-all-closed', function() {

    if (process.platform !== 'darwin') {
        app.quit()
    }
})

app.commandLine.appendSwitch('autoplay-policy', 'no-user-gesture-required');

app.on('activate', function() {

    if (mainWindow === null) {
        createWindow()
    }
})

ipc.on('have-message', (sys, msg) => {
    if (newWindow.isVisible()) {

        newWindow.showInactive()
        newWindow.flashFrame(true)
    } else {

        newWindow.hide()

        let count = 0
        timer[msg] = setInterval(function() {
            count++;
            if (count % 2 == 0) {
                tray.setImage(path.join(__dirname, 'timely.ico'))
            } else {
                tray.setImage(path.join(__dirname, 'timely.png'))
            }
        }, 400)

    }
})

ipc.on('close', function() {
    mainWindow.close()
})

ipc.on('close-new-chat-cli', function(event) {
    newWindow.destroy()
})

ipc.on('close-chat-cli', function(event) {
    newWindow.hide();
    newWindow.setSkipTaskbar(true);
    event.preventDefault();
})

ipc.on('min', function() {
    newWindow.minimize()
})

ipc.on('login', function() {

    const electronScreen = require('electron').screen
    const size = electronScreen.getPrimaryDisplay().size

    newWindow = new BrowserWindow({
        frame: false,
        resizable: false
    })

    newWindow.maximize();


    newWindow.loadFile('./page/work.html')


    //newWindow.webContents.openDevTools()


    newWindow.on('closed', function() {

        newWindow = null
    })

    let trar = null

    tray = new Tray(path.join(__dirname, 'timely.ico'));

    newWindow.on('show', () => {
        tray.setHighlightMode('always')
    })

    newWindow.on('hide', () => {
        tray.setHighlightMode('never')
    })

    const contextMenu = Menu.buildFromTemplate([
        { label: '退出', click: () => { newWindow.destroy() } },
    ])

    tray.setToolTip('Timely客服')
    tray.setContextMenu(contextMenu)
    tray.on('click', () => {

        tray.setImage(path.join(__dirname, 'timely.ico'))
        for (var each in timer) {
            clearInterval(timer[each]);
        }
        newWindow.isVisible() ? newWindow.hide() : newWindow.show()
        newWindow.isVisible() ? newWindow.setSkipTaskbar(false) : newWindow.setSkipTaskbar(true)
    })

    newWindow.setMenu(null)
    mainWindow.destroy()
})

ipc.on('loginOut', function() {
    createWindow();
    newWindow.destroy();
})