/*!
 * jQuery Cookie Plugin
 * https://github.com/carhartl/jquery-cookie
 *
 * Copyright 2011, Klaus Hartl
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://www.opensource.org/licenses/mit-license.php
 * http://www.opensource.org/licenses/GPL-2.0
 */
(function ($) {
    $.cookie = function (key, value, options) {
        if (arguments.length > 1 && (!/Object/.test(Object.prototype.toString.call(value)) || value === null || value === undefined)) {
            options = $.extend({}, options); if (value === null || value === undefined) options.expires = -1; if (typeof options.expires === "number") { var days = options.expires, t = options.expires = new Date; t.setDate(t.getDate() + days) } value = String(value); return document.cookie = [encodeURIComponent(key), "=", options.raw ? value : encodeURIComponent(value), options.expires ? "; expires=" +
options.expires.toUTCString() : "", options.path ? "; path=" + options.path : "", options.domain ? "; domain=" + options.domain : "", options.secure ? "; secure" : ""].join("")
        } options = value || {}; var decode = options.raw ? function (s) { return s } : decodeURIComponent; var pairs = document.cookie.split("; "); for (var i = 0, pair; pair = pairs[i] && pairs[i].split("="); i++) if (decode(pair[0]) === key) return decode(pair[1] || ""); return null
    } 
})(jQuery);
/*  json2.js
    2011-10-19
    Public Domain.
    NO WARRANTY EXPRESSED OR IMPLIED. USE AT YOUR OWN RISK.
	See http://www.JSON.org/js.html */
var JSON; if (!JSON) JSON = {};
(function () {
    function f(n) { return n < 10 ? "0" + n : n } if (typeof Date.prototype.toJSON !== "function") { Date.prototype.toJSON = function (key) { return isFinite(this.valueOf()) ? this.getUTCFullYear() + "-" + f(this.getUTCMonth() + 1) + "-" + f(this.getUTCDate()) + "T" + f(this.getUTCHours()) + ":" + f(this.getUTCMinutes()) + ":" + f(this.getUTCSeconds()) + "Z" : null }; String.prototype.toJSON = Number.prototype.toJSON = Boolean.prototype.toJSON = function (key) { return this.valueOf() } } var cx = /[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g, escapable =
/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g, gap, indent, meta = { "\u0008": "\\b", "\t": "\\t", "\n": "\\n", "\u000c": "\\f", "\r": "\\r", '"': '\\"', "\\": "\\\\" }, rep; function quote(string) { escapable.lastIndex = 0; return escapable.test(string) ? '"' + string.replace(escapable, function (a) { var c = meta[a]; return typeof c === "string" ? c : "\\u" + ("0000" + a.charCodeAt(0).toString(16)).slice(-4) }) + '"' : '"' + string + '"' } function str(key, holder) {
    var i, k, v, length,
mind = gap, partial, value = holder[key]; if (value && typeof value === "object" && typeof value.toJSON === "function") value = value.toJSON(key); if (typeof rep === "function") value = rep.call(holder, key, value); switch (typeof value) {
        case "string": return quote(value); case "number": return isFinite(value) ? String(value) : "null"; case "boolean": case "null": return String(value); case "object": if (!value) return "null"; gap += indent; partial = []; if (Object.prototype.toString.apply(value) === "[object Array]") {
                length = value.length; for (i = 0; i < length; i +=
1) partial[i] = str(i, value) || "null"; v = partial.length === 0 ? "[]" : gap ? "[\n" + gap + partial.join(",\n" + gap) + "\n" + mind + "]" : "[" + partial.join(",") + "]"; gap = mind; return v
            } if (rep && typeof rep === "object") { length = rep.length; for (i = 0; i < length; i += 1) if (typeof rep[i] === "string") { k = rep[i]; v = str(k, value); if (v) partial.push(quote(k) + (gap ? ": " : ":") + v) } } else for (k in value) if (Object.prototype.hasOwnProperty.call(value, k)) { v = str(k, value); if (v) partial.push(quote(k) + (gap ? ": " : ":") + v) } v = partial.length === 0 ? "{}" : gap ? "{\n" + gap + partial.join(",\n" +
gap) + "\n" + mind + "}" : "{" + partial.join(",") + "}"; gap = mind; return v
    } 
} if (typeof JSON.stringify !== "function") JSON.stringify = function (value, replacer, space) { var i; gap = ""; indent = ""; if (typeof space === "number") for (i = 0; i < space; i += 1) indent += " "; else if (typeof space === "string") indent = space; rep = replacer; if (replacer && typeof replacer !== "function" && (typeof replacer !== "object" || typeof replacer.length !== "number")) throw new Error("JSON.stringify"); return str("", { "": value }) }; if (typeof JSON.parse !== "function") JSON.parse =
function (text, reviver) {
    var j; function walk(holder, key) { var k, v, value = holder[key]; if (value && typeof value === "object") for (k in value) if (Object.prototype.hasOwnProperty.call(value, k)) { v = walk(value, k); if (v !== undefined) value[k] = v; else delete value[k] } return reviver.call(holder, key, value) } text = String(text); cx.lastIndex = 0; if (cx.test(text)) text = text.replace(cx, function (a) { return "\\u" + ("0000" + a.charCodeAt(0).toString(16)).slice(-4) }); if (/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,
"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, "]").replace(/(?:^|:|,)(?:\s*\[)+/g, ""))) { j = eval("(" + text + ")"); return typeof reviver === "function" ? walk({ "": j }, "") : j } throw new SyntaxError("JSON.parse");
} 
})();
/*
* qTip2 - Pretty powerful tooltips
* http://craigsworks.com/projects/qtip2/
*
* Version: nightly
* Copyright 2009-2010 Craig Michael Thompson - http://craigsworks.com
*
* Dual licensed under MIT or GPLv2 licenses
*   http://en.wikipedia.org/wiki/MIT_License
*   http://en.wikipedia.org/wiki/GNU_General_Public_License
*
* Date: Tue Apr 10 11:58:19.0000000000 2012
*/

/*jslint browser: true, onevar: true, undef: true, nomen: true, bitwise: true, regexp: true, newcap: true, immed: true, strict: true */
/*global window: false, jQuery: false, console: false, define: false */

// Uses AMD or browser globals to create a jQuery plugin.
(function (n) { typeof define == "function" && define.amd ? define(["jquery"], n) : n(jQuery) })(function (n) { "use strict"; function y() { if (y.history = y.history || [], y.history.push(arguments), "object" == typeof console) { var t = console[console.warn ? "warn" : "log"], n = Array.prototype.slice.call(arguments), i; typeof arguments[0] == "string" && (n[0] = "qTip2: " + n[0]); i = t.apply ? t.apply(console, n) : t(n) } } function b(i) { var f; return !i || "object" != typeof i ? t : ((i.metadata === r || "object" != typeof i.metadata) && (i.metadata = { type: i.metadata }), "content" in i && ((i.content === r || "object" != typeof i.content || i.content.jquery) && (i.content = { text: i.content }), f = i.content.text || t, n.isFunction(f) || (f || f.attr) && !(f.length < 1) && ("object" != typeof f || f.jquery) || (i.content.text = t), "title" in i.content && ((i.content.title === r || "object" != typeof i.content.title) && (i.content.title = { text: i.content.title }), f = i.content.title.text || t, n.isFunction(f) || (f || f.attr) && !(f.length < 1) && ("object" != typeof f || f.jquery) || (i.content.title.text = t))), "position" in i && (i.position === r || "object" != typeof i.position) && (i.position = { my: i.position, at: i.position }), "show" in i && (i.show === r || "object" != typeof i.show) && (i.show = i.show.jquery ? { target: i.show } : { event: i.show }), "hide" in i && (i.hide === r || "object" != typeof i.hide) && (i.hide = i.hide.jquery ? { target: i.hide } : { event: i.hide }), "style" in i && (i.style === r || "object" != typeof i.style) && (i.style = { classes: i.style }), n.each(u, function () { this.sanitize && this.sanitize(i) }), i) } function tt(a, y, tt, it) { function pt(n) { for (var r = 0, u, t = y, i = n.split(".") ; t = t[i[r++]];) r < i.length && (u = t); return [u || y, i.pop()] } function wt() { var n = y.style.widget; ut.toggleClass(d, n).toggleClass(g, y.style.def && !n); ft.content.toggleClass(d + "-content", n); ft.titlebar && ft.titlebar.toggleClass(d + "-header", n); ft.button && ft.button.toggleClass(f + "-icon", !n) } function lt(n) { ft.title && (ft.titlebar.remove(), ft.titlebar = ft.title = ft.button = r, n !== t && rt.reposition()) } function bt() { var i = y.content.title.button, u = typeof i == "string", r = u ? i : "Close tooltip"; ft.button && ft.button.remove(); ft.button = i.jquery ? i : n("<a />", { "class": "ui-state-default ui-tooltip-close " + (y.style.widget ? "" : f + "-icon"), title: r, "aria-label": r }).prepend(n("<span />", { "class": "ui-icon ui-icon-close", html: "&times;" })); ft.button.appendTo(ft.titlebar).attr("role", "button").click(function (n) { return ut.hasClass(h) || rt.hide(n), t }); rt.redraw() } function at() { var t = ct + "-title"; ft.titlebar && lt(); ft.titlebar = n("<div />", { "class": f + "-titlebar " + (y.style.widget ? "ui-widget-header" : "") }).append(ft.title = n("<div />", { id: t, "class": f + "-title", "aria-atomic": i })).insertBefore(ft.content).delegate(".ui-tooltip-close", "mousedown keydown mouseup keyup mouseout", function (t) { n(this).toggleClass("ui-state-active ui-state-focus", t.type.substr(-4) === "down") }).delegate(".ui-tooltip-close", "mouseover mouseout", function (t) { n(this).toggleClass("ui-state-hover", t.type === "mouseover") }); y.content.title.button ? bt() : rt.rendered && rt.redraw() } function ni(n) { var i = ft.button, r = ft.title; if (!rt.rendered) return t; n ? (r || at(), bt()) : i.remove() } function vt(i, r) { var u = ft.title; if (!rt.rendered || !i) return t; if (n.isFunction(i) && (i = i.call(a, et.event, rt)), i !== t && (i || i === "")) i.jquery && i.length > 0 ? u.empty().append(i.css({ display: "block" })) : u.html(i); else return lt(t); rt.redraw(); r !== t && rt.rendered && ut[0].offsetWidth > 0 && rt.reposition(et.event) } function yt(i, r) { function f(i) { function e(u) { u && (delete f[u.src], clearTimeout(rt.timers.img[u.src]), n(u).unbind(ot)); n.isEmptyObject(f) && (rt.redraw(), r !== t && rt.reposition(et.event), i()) } var s, f = {}; if ((s = u.find("img[src]:not([height]):not([width])")).length === 0) return e(); s.each(function (t, i) { if (f[i.src] === o) { var r = 0, u = 3; (function s() { if (i.height || i.width || r > u) return e(i); r += 1; rt.timers.img[i.src] = setTimeout(s, 700) })(); n(i).bind("error" + ot + " load" + ot, function () { e(this) }); f[i.src] = i } }) } var u = ft.content; return !rt.rendered || !i ? t : (n.isFunction(i) && (i = i.call(a, et.event, rt) || ""), i.jquery && i.length > 0 ? u.empty().append(i.css({ display: "block" })) : u.html(i), rt.rendered < 0 ? ut.queue("fx", f) : (st = 0, f(n.noop)), rt) } function kt() { function o(n) { if (ut.hasClass(h)) return t; clearTimeout(rt.timers.show); clearTimeout(rt.timers.hide); var r = function () { rt.toggle(i, n) }; y.show.delay > 0 ? rt.timers.show = setTimeout(r, y.show.delay) : r() } function c(i) { if (ut.hasClass(h) || ht || st) return t; var f = n(i.relatedTarget || i.target), e = f.closest(v)[0] === ut[0], o = f[0] === r.show[0]; if (clearTimeout(rt.timers.show), clearTimeout(rt.timers.hide), u.target === "mouse" && e || y.hide.fixed && /mouse(out|leave|move)/.test(i.type) && (e || o)) { try { i.preventDefault(); i.stopImmediatePropagation() } catch (s) { } return } y.hide.delay > 0 ? rt.timers.hide = setTimeout(function () { rt.hide(i) }, y.hide.delay) : rt.hide(i) } function l(n) { if (ut.hasClass(h)) return t; clearTimeout(rt.timers.inactive); rt.timers.inactive = setTimeout(function () { rt.hide(n) }, y.hide.inactive) } function p(n) { rt.rendered && ut[0].offsetWidth > 0 && rt.reposition(n) } var u = y.position, r = { show: y.show.target, hide: y.hide.target, viewport: n(u.viewport), document: n(document), body: n(document.body), window: n(window) }, f = { show: n.trim("" + y.show.event).split(" "), hide: n.trim("" + y.hide.event).split(" ") }, w = n.browser.msie && parseInt(n.browser.version, 10) === 6; ut.bind("mouseenter" + ot + " mouseleave" + ot, function (n) { var t = n.type === "mouseenter"; t && rt.focus(n); ut.toggleClass(nt, t) }); y.hide.fixed && (r.hide = r.hide.add(ut), ut.bind("mouseover" + ot, function () { ut.hasClass(h) || clearTimeout(rt.timers.hide) })); /mouse(out|leave)/i.test(y.hide.event) ? y.hide.leave === "window" && r.window.bind("mouseout" + ot + " blur" + ot, function (n) { /select|option/.test(n.target) && !n.relatedTarget && rt.hide(n) }) : /mouse(over|enter)/i.test(y.show.event) && r.hide.bind("mouseleave" + ot, function () { clearTimeout(rt.timers.show) }); ("" + y.hide.event).indexOf("unfocus") > -1 && u.container.closest("html").bind("mousedown" + ot, function (t) { var i = n(t.target), u = rt.rendered && !ut.hasClass(h) && ut[0].offsetWidth > 0, r = i.parents(v).filter(ut[0]).length > 0; i[0] === a[0] || i[0] === ut[0] || r || a.has(i[0]).length || i.attr("disabled") || rt.hide(t) }); "number" == typeof y.hide.inactive && (r.show.bind("qtip-" + tt + "-inactive", l), n.each(e.inactiveEvents, function (n, t) { r.hide.add(ft.tooltip).bind(t + ot + "-inactive", l) })); n.each(f.hide, function (t, i) { var u = n.inArray(i, f.show), e = n(r.hide); u > -1 && e.add(r.show).length === e.length || i === "unfocus" ? (r.show.bind(i + ot, function (n) { ut[0].offsetWidth > 0 ? c(n) : o(n) }), delete f.show[u]) : r.hide.bind(i + ot, c) }); n.each(f.show, function (n, t) { r.show.bind(t + ot, o) }); "number" == typeof y.hide.distance && r.show.add(ut).bind("mousemove" + ot, function (n) { var t = et.origin || {}, i = y.hide.distance, r = Math.abs; (r(n.pageX - t.pageX) >= i || r(n.pageY - t.pageY) >= i) && rt.hide(n) }); u.target === "mouse" && (r.show.bind("mousemove" + ot, function (n) { s = { pageX: n.pageX, pageY: n.pageY, type: "mousemove" } }), u.adjust.mouse && (y.hide.event && (ut.bind("mouseleave" + ot, function (n) { (n.relatedTarget || n.target) !== r.show[0] && rt.hide(n) }), ft.target.bind("mouseenter" + ot + " mouseleave" + ot, function (n) { et.onTarget = n.type === "mouseenter" })), r.document.bind("mousemove" + ot, function (n) { rt.rendered && et.onTarget && !ut.hasClass(h) && ut[0].offsetWidth > 0 && rt.reposition(n || s) }))); (u.adjust.resize || r.viewport.length) && (n.event.special.resize ? r.viewport : r.window).bind("resize" + ot, p); (r.viewport.length || w && ut.css("position") === "fixed") && r.viewport.bind("scroll" + ot, p) } function dt() { var t = [y.show.target[0], y.hide.target[0], rt.rendered && ft.tooltip[0], y.position.container[0], y.position.viewport[0], window, document]; rt.rendered ? n([]).pushStack(n.grep(t, function (n) { return typeof n == "object" })).unbind(ot) : y.show.target.unbind(ot + "-create") } var rt = this, gt = document.body, ct = f + "-" + tt, ht = 0, st = 0, ut = n(), ot = ".qtip-" + tt, ft, et; rt.id = tt; rt.rendered = t; rt.elements = ft = { target: a }; rt.timers = { img: {} }; rt.options = y; rt.checks = {}; rt.plugins = {}; rt.cache = et = { event: {}, target: n(), disabled: t, attr: it, onTarget: t }; rt.checks.builtin = { "^id$": function (r, u, o) { var h = o === i ? e.nextid : o, s = f + "-" + h; h !== t && h.length > 0 && !n("#" + s).length && (ut[0].id = s, ft.content[0].id = s + "-content", ft.title[0].id = s + "-title") }, "^content.text$": function (n, t, i) { yt(i) }, "^content.title.text$": function (n, t, i) { if (!i) return lt(); !ft.title && i && at(); vt(i) }, "^content.title.button$": function (n, t, i) { ni(i) }, "^position.(my|at)$": function (n, t, i) { "string" == typeof i && (n[t] = new u.Corner(i)) }, "^position.container$": function (n, t, i) { rt.rendered && ut.appendTo(i) }, "^show.ready$": function () { rt.rendered ? rt.toggle(i) : rt.render(1) }, "^style.classes$": function (n, t, i) { ut.attr("class", f + " qtip ui-helper-reset " + i) }, "^style.widget|content.title": wt, "^events.(render|show|move|hide|focus|blur)$": function (t, i, r) { ut[(n.isFunction(r) ? "" : "un") + "bind"]("tooltip" + i, r) }, "^(show|hide|position).(event|target|fixed|inactive|leave|distance|viewport|adjust)": function () { var n = y.position; ut.attr("tracking", n.target === "mouse" && n.adjust.mouse); dt(); kt() } }; n.extend(rt, { render: function (r) { if (rt.rendered) return rt; var o = y.content.text, e = y.content.title.text, s = y.position, c = n.Event("tooltiprender"); return n.attr(a[0], "aria-describedby", ct), ut = ft.tooltip = n("<div/>", { id: ct, "class": f + " qtip ui-helper-reset " + g + " " + y.style.classes + " " + f + "-pos-" + y.position.my.abbrev(), width: y.style.width || "", height: y.style.height || "", tracking: s.target === "mouse" && s.adjust.mouse, role: "alert", "aria-live": "polite", "aria-atomic": t, "aria-describedby": ct + "-content", "aria-hidden": i }).toggleClass(h, et.disabled).data("qtip", rt).appendTo(y.position.container).append(ft.content = n("<div />", { "class": f + "-content", id: ct + "-content", "aria-atomic": i })), rt.rendered = -1, st = 1, ht = 1, e && (at(), n.isFunction(e) || vt(e, t)), n.isFunction(o) || yt(o, t), rt.rendered = i, wt(), n.each(y.events, function (t, i) { n.isFunction(i) && ut.bind(t === "toggle" ? "tooltipshow tooltiphide" : "tooltip" + t, i) }), n.each(u, function () { this.initialize === "render" && this(rt) }), kt(), ut.queue("fx", function (n) { c.originalEvent = et.event; ut.trigger(c, [rt]); st = 0; ht = 0; rt.redraw(); (y.show.ready || r) && rt.toggle(i, et.event, t); n() }), rt }, get: function (n) { var t, i; switch (n.toLowerCase()) { case "dimensions": t = { height: ut.outerHeight(), width: ut.outerWidth() }; break; case "offset": t = u.offset(ut, y.position.container); break; default: i = pt(n.toLowerCase()); t = i[0][i[1]]; t = t.precedance ? t.string() : t } return t }, set: function (u, f) { function a(n, t) { var i, r, u; for (i in s) for (r in s[i]) (u = new RegExp(r, "i").exec(n)) && (t.push(u), s[i][r].apply(rt, t)) } var c = /^position\.(my|at|adjust|target|container)|style|content|show\.ready/i, l = /^content\.(title|attr)|style/i, e = t, o = t, s = rt.checks, h; return "string" == typeof u ? (h = u, u = {}, u[h] = f) : u = n.extend(i, {}, u), n.each(u, function (t, i) { var r = pt(t.toLowerCase()), f; f = r[0][r[1]]; r[0][r[1]] = "object" == typeof i && i.nodeType ? n(i) : i; u[t] = [r[0], r[1], i, f]; e = c.test(t) || e; o = l.test(t) || o }), b(y), ht = st = 1, n.each(u, a), ht = st = 0, rt.rendered && ut[0].offsetWidth > 0 && (e && rt.reposition(y.position.target === "mouse" ? r : et.event), o && rt.redraw()), rt }, toggle: function (u, f) { function l() { u ? (n.browser.msie && ut[0].style.removeAttribute("filter"), ut.css("overflow", ""), "string" == typeof e.autofocus && n(e.autofocus, ut).focus(), e.target.trigger("qtip-" + tt + "-inactive")) : ut.css({ display: "", visibility: "", opacity: "", left: "", top: "" }); o = n.Event("tooltip" + (u ? "visible" : "hidden")); o.originalEvent = f ? et.event : r; ut.trigger(o, [rt]) } if (!rt.rendered) return u ? rt.render(1) : rt; var c = u ? "show" : "hide", e = y[c], d = y[u ? "hide" : "show"], a = y.position, h = y.content, p = ut[0].offsetWidth > 0, b = u || e.target.length === 1, k = !f || e.target.length < 2 || et.target[0] === f.target, o; if ((typeof u).search("boolean|number") && (u = !p), !ut.is(":animated") && p === u && k) return rt; if (f) { if (/over|enter/.test(f.type) && /out|leave/.test(et.event.type) && y.show.target.add(f.target).length === y.show.target.length && ut.has(f.relatedTarget).length) return rt; et.event = n.extend({}, f) } return (o = n.Event("tooltip" + c), o.originalEvent = f ? et.event : r, ut.trigger(o, [rt, 90]), o.isDefaultPrevented()) ? rt : (n.attr(ut[0], "aria-hidden", !!!u), u ? (et.origin = n.extend({}, s), rt.focus(f), n.isFunction(h.text) && yt(h.text, t), n.isFunction(h.title.text) && vt(h.title.text, t), !w && a.target === "mouse" && a.adjust.mouse && (n(document).bind("mousemove.qtip", function (n) { s = { pageX: n.pageX, pageY: n.pageY, type: "mousemove" } }), w = i), rt.reposition(f, arguments[2]), (o.solo = !!e.solo) && n(v, e.solo).not(ut).qtip("hide", o)) : (clearTimeout(rt.timers.show), delete et.origin, w && !n(v + '[tracking="true"]:visible', e.solo).not(ut).length && (n(document).unbind("mousemove.qtip"), w = t), rt.blur(f)), e.effect === t || b === t ? (ut[c](), l.call(ut)) : n.isFunction(e.effect) ? (ut.stop(1, 1), e.effect.call(ut, rt), ut.queue("fx", function (n) { l(); n() })) : ut.fadeTo(90, u ? 1 : 0, l), u && e.target.trigger("qtip-" + tt + "-inactive"), rt) }, show: function (n) { return rt.toggle(i, n) }, hide: function (n) { return rt.toggle(t, n) }, focus: function (t) { if (!rt.rendered) return rt; var r = n(v), f = parseInt(ut[0].style.zIndex, 10), u = e.zindex + r.length, o = n.extend({}, t), i; return ut.hasClass(p) || (i = n.Event("tooltipfocus"), i.originalEvent = o, ut.trigger(i, [rt, u]), i.isDefaultPrevented() || (f !== u && (r.each(function () { this.style.zIndex > f && (this.style.zIndex = this.style.zIndex - 1) }), r.filter("." + p).qtip("blur", o)), ut.addClass(p)[0].style.zIndex = u)), rt }, blur: function (t) { var r = n.extend({}, t), i; return ut.removeClass(p), i = n.Event("tooltipblur"), i.originalEvent = r, ut.trigger(i, [rt]), rt }, reposition: function (i, r) { if (!rt.rendered || ht) return rt; ht = 1; var o = y.position.target, b = y.position, c = b.my, a = b.at, k = b.adjust, tt = k.method.split(" "), g = ut.outerWidth(), nt = ut.outerHeight(), p = 0, w = 0, ot = n.Event("tooltipmove"), st = ut.css("position") === "fixed", h = b.viewport, e = { left: 0, top: 0 }, v = b.container, it = t, l = rt.plugins.tip, lt = ut[0].offsetWidth > 0, d = { horizontal: tt[0], vertical: tt[1] = tt[1] || tt[0], enabled: h.jquery && o[0] !== window && o[0] !== gt && k.method !== "none", left: function (n) { var o = d.horizontal === "shift", f = -v.offset.left + h.offset.left + h.scrollLeft, s = c.x === "left" ? g : c.x === "right" ? -g : -g / 2, b = a.x === "left" ? p : a.x === "right" ? -p : -p / 2, y = l && l.size ? l.size.width || 0 : 0, i = l && l.corner && l.corner.precedance === "x" && !o ? y : 0, u = f - n + i, r = n + g - h.width - f + i, t = s - (c.precedance === "x" || c.x === c.y ? b : 0) - (a.x === "center" ? p / 2 : 0), w = c.x === "center"; return o ? (i = l && l.corner && l.corner.precedance === "y" ? y : 0, t = (c.x === "left" ? 1 : -1) * s - i, e.left += u > 0 ? u : r > 0 ? -r : 0, e.left = Math.max(-v.offset.left + h.offset.left + (i && l.corner.x === "center" ? l.offset : 0), n - t, Math.min(Math.max(-v.offset.left + h.offset.left + h.width, n + t), e.left))) : (u > 0 && (c.x !== "left" || r > 0) ? e.left -= t : r > 0 && (c.x !== "right" || u > 0) && (e.left -= w ? -t : t), e.left !== n && w && (e.left -= k.x), e.left < f && -e.left > r && (e.left = n)), e.left - n }, top: function (n) { var f = d.vertical === "shift", o = -v.offset.top + h.offset.top + h.scrollTop, s = c.y === "top" ? nt : c.y === "bottom" ? -nt : -nt / 2, b = a.y === "top" ? w : a.y === "bottom" ? -w : -w / 2, y = l && l.size ? l.size.height || 0 : 0, i = l && l.corner && l.corner.precedance === "y" && !f ? y : 0, u = o - n + i, r = n + nt - h.height - o + i, t = s - (c.precedance === "y" || c.x === c.y ? b : 0) - (a.y === "center" ? w / 2 : 0), p = c.y === "center"; return f ? (i = l && l.corner && l.corner.precedance === "x" ? y : 0, t = (c.y === "top" ? 1 : -1) * s - i, e.top += u > 0 ? u : r > 0 ? -r : 0, e.top = Math.max(-v.offset.top + h.offset.top + (i && l.corner.x === "center" ? l.offset : 0), n - t, Math.min(Math.max(-v.offset.top + h.offset.top + h.height, n + t), e.top))) : (u > 0 && (c.y !== "top" || r > 0) ? e.top -= t : r > 0 && (c.y !== "bottom" || u > 0) && (e.top -= p ? -t : t), e.top !== n && p && (e.top -= k.y), e.top < 0 && -e.top > r && (e.top = n)), e.top - n } }, ct; if (n.isArray(o) && o.length === 2) a = { x: "left", y: "top" }, e = { left: o[0], top: o[1] }; else if (o === "mouse" && (i && i.pageX || et.event.pageX)) a = { x: "left", y: "top" }, i = (i && (i.type === "resize" || i.type === "scroll") ? et.event : i && i.pageX && i.type === "mousemove" ? i : s && s.pageX && (k.mouse || !i || !i.pageX) ? { pageX: s.pageX, pageY: s.pageY } : !k.mouse && et.origin && et.origin.pageX && y.show.distance ? et.origin : i) || i || et.event || s || {}, e = { top: i.pageY, left: i.pageX }; else { if (o = o === "event" ? i && i.target && i.type !== "scroll" && i.type !== "resize" ? et.target = n(i.target) : et.target : et.target = n(o.jquery ? o : ft.target), o = n(o).eq(0), o.length === 0) return rt; o[0] === document || o[0] === window ? (p = u.iOS ? window.innerWidth : o.width(), w = u.iOS ? window.innerHeight : o.height(), o[0] === window && (e = { top: (h || o).scrollTop(), left: (h || o).scrollLeft() })) : o.is("area") && u.imagemap ? e = u.imagemap(o, a, d.enabled ? tt : t) : o[0].namespaceURI === "http://www.w3.org/2000/svg" && u.svg ? e = u.svg(o, a) : (p = o.outerWidth(), w = o.outerHeight(), e = u.offset(o, v)); e.offset && (p = e.width, w = e.height, it = e.flipoffset, e = e.offset); (u.iOS < 4.1 && u.iOS > 3.1 || u.iOS == 4.3 || !u.iOS && st) && (ct = n(window), e.left -= ct.scrollLeft(), e.top -= ct.scrollTop()); e.left += a.x === "right" ? p : a.x === "center" ? p / 2 : 0; e.top += a.y === "bottom" ? w : a.y === "center" ? w / 2 : 0 } return (e.left += k.x + (c.x === "right" ? -g : c.x === "center" ? -g / 2 : 0), e.top += k.y + (c.y === "bottom" ? -nt : c.y === "center" ? -nt / 2 : 0), d.enabled ? (h = { elem: h, height: h[(h[0] === window ? "h" : "outerH") + "eight"](), width: h[(h[0] === window ? "w" : "outerW") + "idth"](), scrollLeft: st ? 0 : h.scrollLeft(), scrollTop: st ? 0 : h.scrollTop(), offset: h.offset() || { left: 0, top: 0 } }, v = { elem: v, scrollLeft: v.scrollLeft(), scrollTop: v.scrollTop(), offset: v.offset() || { left: 0, top: 0 } }, e.adjusted = { left: d.horizontal !== "none" ? d.left(e.left) : 0, top: d.vertical !== "none" ? d.top(e.top) : 0 }, e.adjusted.left + e.adjusted.top && ut.attr("class", ut[0].className.replace(/ui-tooltip-pos-\w+/i, f + "-pos-" + c.abbrev())), it && e.adjusted.left && (e.left += it.left), it && e.adjusted.top && (e.top += it.top)) : e.adjusted = { left: 0, top: 0 }, ot.originalEvent = n.extend({}, i), ut.trigger(ot, [rt, e, h.elem || h]), ot.isDefaultPrevented()) ? rt : (delete e.adjusted, r === t || !lt || isNaN(e.left) || isNaN(e.top) || o === "mouse" || !n.isFunction(b.effect) ? ut.css(e) : n.isFunction(b.effect) && (b.effect.call(ut, rt, n.extend({}, e)), ut.queue(function (t) { n(this).css({ opacity: "", height: "" }); n.browser.msie && this.style.removeAttribute("filter"); t() })), ht = 0, rt) }, redraw: function () { if (rt.rendered < 1 || st) return rt; var u = y.position.container, r, i, n, t; return st = 1, y.style.height && ut.css("height", y.style.height), y.style.width ? ut.css("width", y.style.width) : (ut.css("width", "").addClass(l), i = ut.width() + 1, n = ut.css("max-width") || "", t = ut.css("min-width") || "", r = (n + t).indexOf("%") > -1 ? u.width() / 100 : 0, n = (n.indexOf("%") > -1 ? r : 1) * parseInt(n, 10) || i, t = (t.indexOf("%") > -1 ? r : 1) * parseInt(t, 10) || 0, i = n + t ? Math.min(Math.max(i, t), n) : i, ut.css("width", Math.round(i)).removeClass(l)), st = 0, rt }, disable: function (t) { return "boolean" != typeof t && (t = !(ut.hasClass(h) || et.disabled)), rt.rendered ? (ut.toggleClass(h, t), n.attr(ut[0], "aria-disabled", t)) : et.disabled = !!t, rt }, enable: function () { return rt.disable(t) }, destroy: function () { var t = a[0], i = n.attr(t, c), r = a.data("qtip"); return rt.rendered && (ut.stop(1, 0).remove(), n.each(rt.plugins, function () { this.destroy && this.destroy() })), clearTimeout(rt.timers.show), clearTimeout(rt.timers.hide), dt(), r && rt !== r || (n.removeData(t, "qtip"), y.suppress && i && (n.attr(t, "title", i), a.removeAttr(c)), a.removeAttr("aria-describedby")), a.unbind(".qtip-" + tt), delete k[rt.id], a } }) } function it(f, o) { var v, h, p, s, d, l = n(this), g = n(document.body), w = this === document ? g : l, k = l.metadata ? l.metadata(o.metadata) : r, nt = o.metadata.type === "html5" && k ? k[o.metadata.name] : r, a = l.data(o.metadata.name || "qtipopts"); try { a = typeof a == "string" ? new Function("return " + a)() : a } catch (it) { y("Unable to parse HTML5 attribute data: " + a) } if (s = n.extend(i, {}, e.defaults, o, typeof a == "object" ? b(a) : r, b(nt || k)), h = s.position, s.id = f, "boolean" == typeof s.content.text) if (p = l.attr(s.content.attr), s.content.attr !== t && p) s.content.text = p; else return y("Unable to locate content for tooltip! Aborting render of tooltip on element: ", l), t; if (h.container.length || (h.container = g), h.target === t && (h.target = w), s.show.target === t && (s.show.target = w), s.show.solo === i && (s.show.solo = h.container.closest("body")), s.hide.target === t && (s.hide.target = w), s.position.viewport === i && (s.position.viewport = h.container), h.container = h.container.eq(0), h.at = new u.Corner(h.at), h.my = new u.Corner(h.my), n.data(this, "qtip")) if (s.overwrite) l.qtip("destroy"); else if (s.overwrite === t) return t; return s.suppress && (d = n.attr(this, "title")) && n(this).removeAttr("title").attr(c, d), v = new tt(l, s, f, !!p), n.data(this, "qtip", v), l.bind("remove.qtip-" + f + " removeqtip.qtip-" + f, function () { v.destroy() }), v } function rt(n, t, i) { var u = Math.ceil(t / 2), f = Math.ceil(i / 2), r = { bottomright: [[0, 0], [t, i], [t, 0]], bottomleft: [[0, 0], [t, 0], [0, i]], topright: [[0, i], [t, 0], [t, i]], topleft: [[0, 0], [0, i], [t, i]], topcenter: [[0, i], [u, 0], [t, i]], bottomcenter: [[0, 0], [t, 0], [u, i]], rightcenter: [[0, 0], [t, f], [0, i]], leftcenter: [[t, 0], [t, i], [0, f]] }; return r.lefttop = r.bottomright, r.righttop = r.bottomleft, r.leftbottom = r.topright, r.rightbottom = r.topleft, r[n.string()] } function ut(f) { function g(n, r, u) { if (s.tip) { var c = e.corner.clone(), l = u.adjusted, d = f.options.position.adjust.method.split(" "), b = d[0], k = d[1] || d[0], v = { left: t, top: t, x: 0, y: 0 }, h, w = {}, y; e.corner.fixed !== i && (b === "shift" && c.precedance === "x" && l.left && c.y !== "center" ? c.precedance = c.precedance === "x" ? "y" : "x" : b === "flip" && l.left && (c.x = c.x === "center" ? l.left > 0 ? "left" : "right" : c.x === "left" ? "right" : "left"), k === "shift" && c.precedance === "y" && l.top && c.x !== "center" ? c.precedance = c.precedance === "y" ? "x" : "y" : k === "flip" && l.top && (c.y = c.y === "center" ? l.top > 0 ? "top" : "bottom" : c.y === "top" ? "bottom" : "top"), c.string() !== p.corner.string() && (p.top !== l.top || p.left !== l.left) && e.update(c, t)); h = e.position(c, l); h.right !== o && (h.left = -h.right); h.bottom !== o && (h.top = -h.bottom); h.user = Math.max(0, a.offset); (v.left = b === "shift" && !!l.left) && (c.x === "center" ? w["margin-left"] = v.x = h["margin-left"] - l.left : (y = h.right !== o ? [l.left, -h.left] : [-l.left, h.left], (v.x = Math.max(y[0], y[1])) > y[0] && (u.left -= l.left, v.left = t), w[h.right !== o ? "right" : "left"] = v.x)); (v.top = k === "shift" && !!l.top) && (c.y === "center" ? w["margin-top"] = v.y = h["margin-top"] - l.top : (y = h.bottom !== o ? [l.top, -h.top] : [-l.top, h.top], (v.y = Math.max(y[0], y[1])) > y[0] && (u.top -= l.top, v.top = t), w[h.bottom !== o ? "bottom" : "top"] = v.y)); s.tip.css(w).toggle(!(v.x && v.y || c.x === "center" && v.y || c.y === "center" && v.x)); u.left -= h.left.charAt ? h.user : b !== "shift" || v.top || !v.left && !v.top ? h.left : 0; u.top -= h.top.charAt ? h.user : k !== "shift" || v.left || !v.left && !v.top ? h.top : 0; p.left = l.left; p.top = l.top; p.corner = c.clone() } } function k(n, t, i) { t = t ? t : n[n.precedance]; var f = v.hasClass(l), e = s.titlebar && n.y === "top", o = e ? s.titlebar : s.content, u = "border-" + t + "-width", r; return v.addClass(l), r = parseInt(o.css(u), 10), r = (i ? r || parseInt(v.css(u), 10) : r) || 0, v.toggleClass(l, f), r } function nt(t) { var f = s.titlebar && t.y === "top", e = f ? s.titlebar : s.content, i = n.browser.mozilla, o = i ? "-moz-" : n.browser.webkit ? "-webkit-" : "", r = t.y + (i ? "" : "-") + t.x, u = o + (i ? "border-radius-" + r : "border-" + r + "-radius"); return parseInt(e.css(u), 10) || parseInt(v.css(u), 10) || 0 } function d(n) { var r = n.precedance === "y", s = y[r ? "width" : "height"], f = y[r ? "height" : "width"], c = n.string().indexOf("center") > -1, l = s * (c ? .5 : 1), i = Math.pow, a = Math.round, v, e, o, u = Math.sqrt(i(l, 2) + i(f, 2)), t = [h / l * u, h / f * u]; return t[2] = Math.sqrt(i(t[0], 2) - i(h, 2)), t[3] = Math.sqrt(i(t[1], 2) - i(h, 2)), v = u + t[2] + t[3] + (c ? 0 : t[0]), e = v / u, o = [a(e * f), a(e * s)], { height: o[r ? 0 : 1], width: o[r ? 1 : 0] } } var e = this, a = f.options.style.tip, s = f.elements, v = s.tooltip, p = { top: 0, left: 0 }, y = { width: a.width, height: a.height }, c = {}, h = a.border || 0, w = ".qtip-tip", b = !!(n("<canvas />")[0] || {}).getContext && !(window.external && window.external.IsInnovasysDesigner); e.corner = r; e.mimic = r; e.border = h; e.offset = a.offset; e.size = y; f.checks.tip = { "^position.my|style.tip.(corner|mimic|border)$": function () { e.init() || e.destroy(); f.reposition() }, "^style.tip.(height|width)$": function () { y = { width: a.width, height: a.height }; e.create(); e.update(); f.reposition() }, "^content.title.text|style.(classes|widget)$": function () { s.tip && e.update() } }; n.extend(e, { init: function () { var t = e.detectCorner() && (b || n.browser.msie); return t && (e.create(), e.update(), v.unbind(w).bind("tooltipmove" + w, g)), t }, detectCorner: function () { var n = a.corner, r = f.options.position, s = r.at, o = r.my.string ? r.my.string() : r.my; return n === t || o === t && s === t ? t : (n === i ? e.corner = new u.Corner(o) : n.string || (e.corner = new u.Corner(n), e.corner.fixed = i), p.corner = new u.Corner(e.corner.string()), e.corner.string() !== "centercenter") }, detectColours: function (t) { var u, r, i = s.tip.css("cssText", ""), o = t || e.corner, w = o[o.precedance], b = "border-" + w + "-color", nt = "border" + w.charAt(0) + w.substr(1) + "Color", h = /rgba?\(0, 0, 0(, 0)?\)|transparent|#123456/i, p = "background-color", k = "transparent", d = " !important", tt = n(document.body).css("color"), rt = f.elements.content.css("color"), it = s.titlebar && (o.y === "top" || o.y === "center" && i.position().top + y.height / 2 + a.offset < s.titlebar.outerHeight(1)), g = it ? s.titlebar : s.content; v.addClass(l); c.fill = u = i.css(p); c.border = r = i[0].style[nt] || i.css(b) || v.css(b); (!u || h.test(u)) && (c.fill = g.css(p) || k, h.test(c.fill) && (c.fill = v.css(p) || u)); (!r || h.test(r) || r === tt) && (c.border = g.css(b) || k, h.test(c.border) && (c.border = r)); n("*", i).add(i).css("cssText", p + ":" + k + d + ";border:0" + d + ";"); v.removeClass(l) }, create: function () { var i = y.width, r = y.height, t; s.tip && s.tip.remove(); s.tip = n("<div />", { "class": "ui-tooltip-tip" }).css({ width: i, height: r }).prependTo(v); b ? n("<canvas />").appendTo(s.tip)[0].getContext("2d").save() : (t = '<vml:shape coordorigin="0,0" style="display:inline-block; position:absolute; behavior:url(#default#VML);"><\/vml:shape>', s.tip.html(t + t), n("*", s.tip).bind("click mousedown", function (n) { n.stopPropagation() })) }, update: function (f, o) { var ot = s.tip, ft = ot.children(), tt = y.width, it = y.height, l = a.mimic, ut = Math.round, et, v, w, nt, g; f || (f = p.corner || e.corner); l === t ? l = f : (l = new u.Corner(l), l.precedance = f.precedance, l.x === "inherit" ? l.x = f.x : l.y === "inherit" ? l.y = f.y : l.x === l.y && (l[f.precedance] = f[f.precedance])); et = l.precedance; e.detectColours(f); c.border !== "transparent" && c.border !== "#123456" ? (h = k(f, r, i), a.border === 0 && h > 0 && (c.fill = c.border), e.border = h = a.border !== i ? a.border : h) : e.border = h = 0; w = rt(l, tt, it); e.size = g = d(f); ot.css(g); nt = f.precedance === "y" ? [ut(l.x === "left" ? h : l.x === "right" ? g.width - tt - h : (g.width - tt) / 2), ut(l.y === "top" ? g.height - it : 0)] : [ut(l.x === "left" ? g.width - tt : 0), ut(l.y === "top" ? h : l.y === "bottom" ? g.height - it - h : (g.height - it) / 2)]; b ? (ft.attr(g), v = ft[0].getContext("2d"), v.restore(), v.save(), v.clearRect(0, 0, 3e3, 3e3), v.translate(nt[0], nt[1]), v.beginPath(), v.moveTo(w[0][0], w[0][1]), v.lineTo(w[1][0], w[1][1]), v.lineTo(w[2][0], w[2][1]), v.closePath(), v.fillStyle = c.fill, v.strokeStyle = c.border, v.lineWidth = h * 2, v.lineJoin = "miter", v.miterLimit = 100, h && v.stroke(), v.fill()) : (w = "m" + w[0][0] + "," + w[0][1] + " l" + w[1][0] + "," + w[1][1] + " " + w[2][0] + "," + w[2][1] + " xe", nt[2] = h && /^(r|b)/i.test(f.string()) ? parseFloat(n.browser.version, 10) === 8 ? 2 : 1 : 0, ft.css({ antialias: "" + (l.string().indexOf("center") > -1), left: nt[0] - nt[2] * Number(et === "x"), top: nt[1] - nt[2] * Number(et === "y"), width: tt + h, height: it + h }).each(function (t) { var i = n(this); i[i.prop ? "prop" : "attr"]({ coordsize: tt + h + " " + (it + h), path: w, fillcolor: c.fill, filled: !!t, stroked: !!!t }).css({ display: h || t ? "block" : "none" }); t || i.html() !== "" || i.html('<vml:stroke weight="' + h * 2 + 'px" color="' + c.border + '" miterlimit="1000" joinstyle="miter"  style="behavior:url(#default#VML); display:inline-block;" />') })); o !== t && e.position(f) }, position: function (r) { var l = s.tip, u = {}, v = Math.max(0, a.offset), f, o, c; return a.corner === t || !l ? t : (r = r || e.corner, f = r.precedance, o = d(r), c = [r.x, r.y], f === "x" && c.reverse(), n.each(c, function (n, t) { var e, s; t === "center" ? (e = f === "y" ? "left" : "top", u[e] = "50%", u["margin-" + e] = -Math.round(o[f === "y" ? "width" : "height"] / 2) + v) : (e = k(r, t, i), s = nt(r), u[t] = n ? h ? k(r, t) : 0 : v + (s > e ? s : 0)) }), u[r[f]] -= o[f === "x" ? "width" : "height"], l.css({ top: "", bottom: "", left: "", right: "", margin: "" }).css(u), u) }, destroy: function () { s.tip && s.tip.remove(); v.unbind(w) } }); e.init() } var i = !0, t = !1, r = null, o, e, u, s, k = {}, f = "ui-tooltip", d = "ui-widget", h = "ui-state-disabled", v = "div.qtip." + f, g = f + "-default", p = f + "-focus", nt = f + "-hover", l = f + "-fluid", a = "_replacedByqTip", c = "oldtitle", w; e = n.fn.qtip = function (u, f, s) { var h = ("" + u).toLowerCase(), a = r, v = n.makeArray(arguments).slice(1), c = v[v.length - 1], l = this[0] ? n.data(this[0], "qtip") : r; return !arguments.length && l || h === "api" ? l : "string" == typeof u ? (this.each(function () { var r = n.data(this, "qtip"); if (!r) return i; if (c && c.timeStamp && (r.cache.event = c), (h === "option" || h === "options") && f) if (n.isPlainObject(f) || s !== o) r.set(f, s); else return a = r.get(f), t; else r[h] && r[h].apply(r[h], v) }), a !== r ? a : this) : "object" == typeof u || !arguments.length ? (l = b(n.extend(i, {}, u)), e.bind.call(this, l, c)) : void 0 }; e.bind = function (r, f) { return this.each(function (h) { function w(i) { function r() { c.render(typeof i == "object" || l.show.ready); p.show.add(p.hide).unbind(y) } if (c.cache.disabled) return t; c.cache.event = n.extend({}, i); c.cache.target = i ? n(i.target) : [o]; l.show.delay > 0 ? (clearTimeout(c.timers.show), c.timers.show = setTimeout(r, l.show.delay), v.show !== v.hide && p.hide.bind(v.hide, function () { clearTimeout(c.timers.show) })) : r() } var l, p, v, y, c, a; if (a = n.isArray(r.id) ? r.id[h] : r.id, a = !a || a === t || a.length < 1 || k[a] ? e.nextid++ : k[a] = a, y = ".qtip-" + a + "-create", c = it.call(this, a, r), c === t) return i; l = c.options; n.each(u, function () { this.initialize === "initialize" && this(c) }); p = { show: l.show.target, hide: l.hide.target }; v = { show: n.trim("" + l.show.event).replace(/ /g, y + " ") + y, hide: n.trim("" + l.hide.event).replace(/ /g, y + " ") + y }; /mouse(over|enter)/i.test(v.show) && !/mouse(out|leave)/i.test(v.hide) && (v.hide += " mouseleave" + y); p.show.bind("mousemove" + y, function (n) { s = { pageX: n.pageX, pageY: n.pageY, type: "mousemove" }; c.cache.onTarget = i }); p.show.bind(v.show, w); (l.show.ready || l.prerender) && w(f) }) }; u = e.plugins = { Corner: function (n) { n = ("" + n).replace(/([A-Z])/, " $1").replace(/middle/gi, "center").toLowerCase(); this.x = (n.match(/left|right/i) || n.match(/center/) || ["inherit"])[0].toLowerCase(); this.y = (n.match(/top|bottom|center/i) || ["inherit"])[0].toLowerCase(); var t = n.charAt(0); this.precedance = t === "t" || t === "b" ? "y" : "x"; this.string = function () { return this.precedance === "y" ? this.y + this.x : this.x + this.y }; this.abbrev = function () { var n = this.x.substr(0, 1), t = this.y.substr(0, 1); return n === t ? n : n === "c" || n !== "c" && t !== "c" ? t + n : n + t }; this.clone = function () { return { x: this.x, y: this.y, precedance: this.precedance, string: this.string, abbrev: this.abbrev, clone: this.clone } } }, offset: function (t, i) { function h(n, t) { u.left += t * n.scrollLeft(); u.top += t * n.scrollTop() } var u = t.offset(), s = t.closest("body")[0], r = i, f, e, o; if (r) { do r.css("position") !== "static" && (e = r.position(), u.left -= e.left + (parseInt(r.css("borderLeftWidth"), 10) || 0) + (parseInt(r.css("marginLeft"), 10) || 0), u.top -= e.top + (parseInt(r.css("borderTopWidth"), 10) || 0) + (parseInt(r.css("marginTop"), 10) || 0), f || (o = r.css("overflow")) === "hidden" || o === "visible" || (f = r)); while ((r = n(r[0].offsetParent)).length); f && f[0] !== s && h(f, 1) } return u }, iOS: parseFloat(("" + (/CPU.*OS ([0-9_]{1,3})|(CPU like).*AppleWebKit.*Mobile/i.exec(navigator.userAgent) || [0, ""])[1]).replace("undefined", "3_2").replace("_", ".")) || t, fn: { attr: function (t, i) { if (this.length) { var u = this[0], f = "title", r = n.data(u, "qtip"); if (t === f && r && "object" == typeof r && r.options.suppress) return arguments.length < 2 ? n.attr(u, c) : (r && r.options.content.attr === f && r.cache.attr && r.set("content.text", i), this.attr(c, i)) } return n.fn["attr" + a].apply(this, arguments) }, clone: function (t) { var r = n([]), i = n.fn["clone" + a].apply(this, arguments); return t || i.filter("[" + c + "]").attr("title", function () { return n.attr(this, c) }).removeAttr(c), i } } }; n.each(u.fn, function (t, r) { if (!r || n.fn[t + a]) return i; var u = n.fn[t + a] = n.fn[t]; n.fn[t] = function () { return r.apply(this, arguments) || u.apply(this, arguments) } }); n.ui || (n["cleanData" + a] = n.cleanData, n.cleanData = function (t) { for (var i = 0, r; (r = t[i]) !== o; i++) try { n(r).triggerHandler("removeqtip") } catch (u) { } n["cleanData" + a](t) }); e.version = "nightly"; e.nextid = 0; e.inactiveEvents = "click dblclick mousedown mouseup mousemove mouseleave mouseenter".split(" "); e.zindex = 15e3; e.defaults = { prerender: t, id: t, overwrite: i, suppress: i, content: { text: i, attr: "title", title: { text: t, button: t } }, position: { my: "top left", at: "bottom right", target: t, container: t, viewport: t, adjust: { x: 0, y: 0, mouse: i, resize: i, method: "flip flip" }, effect: function (i, r) { n(this).animate(r, { duration: 200, queue: t }) } }, show: { target: t, event: "mouseenter", effect: i, delay: 90, solo: t, ready: t, autofocus: t }, hide: { target: t, event: "mouseleave", effect: i, delay: 0, fixed: t, inactive: t, leave: "window", distance: t }, style: { classes: "", widget: t, width: t, height: t, def: i }, events: { render: r, move: r, show: r, hide: r, toggle: r, visible: r, hidden: r, focus: r, blur: r } }; u.tip = function (n) { var t = n.plugins.tip; return "object" == typeof t ? t : n.plugins.tip = new ut(n) }; u.tip.initialize = "render"; u.tip.sanitize = function (n) { var r = n.style, t; r && "tip" in r && (t = n.style.tip, typeof t != "object" && (n.style.tip = { corner: t }), /string|boolean/i.test(typeof t.corner) || (t.corner = i), typeof t.width != "number" && delete t.width, typeof t.height != "number" && delete t.height, typeof t.border != "number" && t.border !== i && delete t.border, typeof t.offset != "number" && delete t.offset) }; n.extend(i, e.defaults, { style: { tip: { corner: i, mimic: t, width: 6, height: 6, border: i, offset: 0 } } }) });
/*!
 * clipboard.js v1.7.1
 * https://zenorocha.github.io/clipboard.js
 *
 * Licensed MIT © Zeno Rocha
 */
try {
    !function (t) { if ("object" == typeof exports && "undefined" != typeof module) module.exports = t(); else if ("function" == typeof define && define.amd) define([], t); else { var e; e = "undefined" != typeof window ? window : "undefined" != typeof global ? global : "undefined" != typeof self ? self : this, e.Clipboard = t() } }(function () { var t, e, n; return function t(e, n, o) { function i(a, c) { if (!n[a]) { if (!e[a]) { var l = "function" == typeof require && require; if (!c && l) return l(a, !0); if (r) return r(a, !0); var s = new Error("Cannot find module '" + a + "'"); throw s.code = "MODULE_NOT_FOUND", s } var u = n[a] = { exports: {} }; e[a][0].call(u.exports, function (t) { var n = e[a][1][t]; return i(n || t) }, u, u.exports, t, e, n, o) } return n[a].exports } for (var r = "function" == typeof require && require, a = 0; a < o.length; a++)i(o[a]); return i }({ 1: [function (t, e, n) { function o(t, e) { for (; t && t.nodeType !== i;) { if ("function" == typeof t.matches && t.matches(e)) return t; t = t.parentNode } } var i = 9; if ("undefined" != typeof Element && !Element.prototype.matches) { var r = Element.prototype; r.matches = r.matchesSelector || r.mozMatchesSelector || r.msMatchesSelector || r.oMatchesSelector || r.webkitMatchesSelector } e.exports = o }, {}], 2: [function (t, e, n) { function o(t, e, n, o, r) { var a = i.apply(this, arguments); return t.addEventListener(n, a, r), { destroy: function () { t.removeEventListener(n, a, r) } } } function i(t, e, n, o) { return function (n) { n.delegateTarget = r(n.target, e), n.delegateTarget && o.call(t, n) } } var r = t("./closest"); e.exports = o }, { "./closest": 1 }], 3: [function (t, e, n) { n.node = function (t) { return void 0 !== t && t instanceof HTMLElement && 1 === t.nodeType }, n.nodeList = function (t) { var e = Object.prototype.toString.call(t); return void 0 !== t && ("[object NodeList]" === e || "[object HTMLCollection]" === e) && "length" in t && (0 === t.length || n.node(t[0])) }, n.string = function (t) { return "string" == typeof t || t instanceof String }, n.fn = function (t) { return "[object Function]" === Object.prototype.toString.call(t) } }, {}], 4: [function (t, e, n) { function o(t, e, n) { if (!t && !e && !n) throw new Error("Missing required arguments"); if (!c.string(e)) throw new TypeError("Second argument must be a String"); if (!c.fn(n)) throw new TypeError("Third argument must be a Function"); if (c.node(t)) return i(t, e, n); if (c.nodeList(t)) return r(t, e, n); if (c.string(t)) return a(t, e, n); throw new TypeError("First argument must be a String, HTMLElement, HTMLCollection, or NodeList") } function i(t, e, n) { return t.addEventListener(e, n), { destroy: function () { t.removeEventListener(e, n) } } } function r(t, e, n) { return Array.prototype.forEach.call(t, function (t) { t.addEventListener(e, n) }), { destroy: function () { Array.prototype.forEach.call(t, function (t) { t.removeEventListener(e, n) }) } } } function a(t, e, n) { return l(document.body, t, e, n) } var c = t("./is"), l = t("delegate"); e.exports = o }, { "./is": 3, delegate: 2 }], 5: [function (t, e, n) { function o(t) { var e; if ("SELECT" === t.nodeName) t.focus(), e = t.value; else if ("INPUT" === t.nodeName || "TEXTAREA" === t.nodeName) { var n = t.hasAttribute("readonly"); n || t.setAttribute("readonly", ""), t.select(), t.setSelectionRange(0, t.value.length), n || t.removeAttribute("readonly"), e = t.value } else { t.hasAttribute("contenteditable") && t.focus(); var o = window.getSelection(), i = document.createRange(); i.selectNodeContents(t), o.removeAllRanges(), o.addRange(i), e = o.toString() } return e } e.exports = o }, {}], 6: [function (t, e, n) { function o() { } o.prototype = { on: function (t, e, n) { var o = this.e || (this.e = {}); return (o[t] || (o[t] = [])).push({ fn: e, ctx: n }), this }, once: function (t, e, n) { function o() { i.off(t, o), e.apply(n, arguments) } var i = this; return o._ = e, this.on(t, o, n) }, emit: function (t) { var e = [].slice.call(arguments, 1), n = ((this.e || (this.e = {}))[t] || []).slice(), o = 0, i = n.length; for (o; o < i; o++)n[o].fn.apply(n[o].ctx, e); return this }, off: function (t, e) { var n = this.e || (this.e = {}), o = n[t], i = []; if (o && e) for (var r = 0, a = o.length; r < a; r++)o[r].fn !== e && o[r].fn._ !== e && i.push(o[r]); return i.length ? n[t] = i : delete n[t], this } }, e.exports = o }, {}], 7: [function (e, n, o) { !function (i, r) { if ("function" == typeof t && t.amd) t(["module", "select"], r); else if (void 0 !== o) r(n, e("select")); else { var a = { exports: {} }; r(a, i.select), i.clipboardAction = a.exports } }(this, function (t, e) { "use strict"; function n(t) { return t && t.__esModule ? t : { "default": t } } function o(t, e) { if (!(t instanceof e)) throw new TypeError("Cannot call a class as a function") } var i = n(e), r = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (t) { return typeof t } : function (t) { return t && "function" == typeof Symbol && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t }, a = function () { function t(t, e) { for (var n = 0; n < e.length; n++) { var o = e[n]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(t, o.key, o) } } return function (e, n, o) { return n && t(e.prototype, n), o && t(e, o), e } }(), c = function () { function t(e) { o(this, t), this.resolveOptions(e), this.initSelection() } return a(t, [{ key: "resolveOptions", value: function t() { var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {}; this.action = e.action, this.container = e.container, this.emitter = e.emitter, this.target = e.target, this.text = e.text, this.trigger = e.trigger, this.selectedText = "" } }, { key: "initSelection", value: function t() { this.text ? this.selectFake() : this.target && this.selectTarget() } }, { key: "selectFake", value: function t() { var e = this, n = "rtl" == document.documentElement.getAttribute("dir"); this.removeFake(), this.fakeHandlerCallback = function () { return e.removeFake() }, this.fakeHandler = this.container.addEventListener("click", this.fakeHandlerCallback) || !0, this.fakeElem = document.createElement("textarea"), this.fakeElem.style.fontSize = "12pt", this.fakeElem.style.border = "0", this.fakeElem.style.padding = "0", this.fakeElem.style.margin = "0", this.fakeElem.style.position = "absolute", this.fakeElem.style[n ? "right" : "left"] = "-9999px"; var o = window.pageYOffset || document.documentElement.scrollTop; this.fakeElem.style.top = o + "px", this.fakeElem.setAttribute("readonly", ""), this.fakeElem.value = this.text, this.container.appendChild(this.fakeElem), this.selectedText = (0, i["default"])(this.fakeElem), this.copyText() } }, { key: "removeFake", value: function t() { this.fakeHandler && (this.container.removeEventListener("click", this.fakeHandlerCallback), this.fakeHandler = null, this.fakeHandlerCallback = null), this.fakeElem && (this.container.removeChild(this.fakeElem), this.fakeElem = null) } }, { key: "selectTarget", value: function t() { this.selectedText = (0, i["default"])(this.target), this.copyText() } }, { key: "copyText", value: function t() { var e = void 0; try { e = document.execCommand(this.action) } catch (t) { e = !1 } this.handleResult(e) } }, { key: "handleResult", value: function t(e) { this.emitter.emit(e ? "success" : "error", { action: this.action, text: this.selectedText, trigger: this.trigger, clearSelection: this.clearSelection.bind(this) }) } }, { key: "clearSelection", value: function t() { this.trigger && this.trigger.focus(), window.getSelection().removeAllRanges() } }, { key: "destroy", value: function t() { this.removeFake() } }, { key: "action", set: function t() { var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : "copy"; if (this._action = e, "copy" !== this._action && "cut" !== this._action) throw new Error('Invalid "action" value, use either "copy" or "cut"') }, get: function t() { return this._action } }, { key: "target", set: function t(e) { if (void 0 !== e) { if (!e || "object" !== (void 0 === e ? "undefined" : r(e)) || 1 !== e.nodeType) throw new Error('Invalid "target" value, use a valid Element'); if ("copy" === this.action && e.hasAttribute("disabled")) throw new Error('Invalid "target" attribute. Please use "readonly" instead of "disabled" attribute'); if ("cut" === this.action && (e.hasAttribute("readonly") || e.hasAttribute("disabled"))) throw new Error('Invalid "target" attribute. You can\'t cut text from elements with "readonly" or "disabled" attributes'); this._target = e } }, get: function t() { return this._target } }]), t }(); t.exports = c }) }, { select: 5 }], 8: [function (e, n, o) { !function (i, r) { if ("function" == typeof t && t.amd) t(["module", "./clipboard-action", "tiny-emitter", "good-listener"], r); else if (void 0 !== o) r(n, e("./clipboard-action"), e("tiny-emitter"), e("good-listener")); else { var a = { exports: {} }; r(a, i.clipboardAction, i.tinyEmitter, i.goodListener), i.clipboard = a.exports } }(this, function (t, e, n, o) { "use strict"; function i(t) { return t && t.__esModule ? t : { "default": t } } function r(t, e) { if (!(t instanceof e)) throw new TypeError("Cannot call a class as a function") } function a(t, e) { if (!t) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return !e || "object" != typeof e && "function" != typeof e ? t : e } function c(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function, not " + typeof e); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, enumerable: !1, writable: !0, configurable: !0 } }), e && (Object.setPrototypeOf ? Object.setPrototypeOf(t, e) : t.__proto__ = e) } function l(t, e) { var n = "data-clipboard-" + t; if (e.hasAttribute(n)) return e.getAttribute(n) } var s = i(e), u = i(n), f = i(o), d = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (t) { return typeof t } : function (t) { return t && "function" == typeof Symbol && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t }, h = function () { function t(t, e) { for (var n = 0; n < e.length; n++) { var o = e[n]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(t, o.key, o) } } return function (e, n, o) { return n && t(e.prototype, n), o && t(e, o), e } }(), p = function (t) { function e(t, n) { r(this, e); var o = a(this, (e.__proto__ || Object.getPrototypeOf(e)).call(this)); return o.resolveOptions(n), o.listenClick(t), o } return c(e, t), h(e, [{ key: "resolveOptions", value: function t() { var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {}; this.action = "function" == typeof e.action ? e.action : this.defaultAction, this.target = "function" == typeof e.target ? e.target : this.defaultTarget, this.text = "function" == typeof e.text ? e.text : this.defaultText, this.container = "object" === d(e.container) ? e.container : document.body } }, { key: "listenClick", value: function t(e) { var n = this; this.listener = (0, f["default"])(e, "click", function (t) { return n.onClick(t) }) } }, { key: "onClick", value: function t(e) { var n = e.delegateTarget || e.currentTarget; this.clipboardAction && (this.clipboardAction = null), this.clipboardAction = new s["default"]({ action: this.action(n), target: this.target(n), text: this.text(n), container: this.container, trigger: n, emitter: this }) } }, { key: "defaultAction", value: function t(e) { return l("action", e) } }, { key: "defaultTarget", value: function t(e) { var n = l("target", e); if (n) return document.querySelector(n) } }, { key: "defaultText", value: function t(e) { return l("text", e) } }, { key: "destroy", value: function t() { this.listener.destroy(), this.clipboardAction && (this.clipboardAction.destroy(), this.clipboardAction = null) } }], [{ key: "isSupported", value: function t() { var e = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : ["copy", "cut"], n = "string" == typeof e ? [e] : e, o = !!document.queryCommandSupported; return n.forEach(function (t) { o = o && !!document.queryCommandSupported(t) }), o } }]), e }(u["default"]); t.exports = p }) }, { "./clipboard-action": 7, "good-listener": 4, "tiny-emitter": 6 }] }, {}, [8])(8) });
} catch (e) { }
/*
 * JSizes - JQuery plugin v0.33
 *
 * Licensed under the revised BSD License.
 * Copyright 2008-2010 Bram Stein
 * All rights reserved.
 */
(function ($) {
    var num = function (value) { return parseInt(value, 10) || 0 }; $.each(["min", "max"], function (i, name) {
        $.fn[name + "Size"] = function (value) {
            var width, height; if (value) { if (value.width !== undefined) this.css(name + "-width", value.width); if (value.height !== undefined) this.css(name + "-height", value.height); return this } else {
                width = this.css(name + "-width"); height = this.css(name + "-height"); return { "width": name === "max" && (width === undefined || width === "none" || num(width) === -1) && Number.MAX_VALUE || num(width), "height": name ===
"max" && (height === undefined || height === "none" || num(height) === -1) && Number.MAX_VALUE || num(height)
                }
            } 
        } 
    }); $.fn.isVisible = function () { return this.is(":visible") }; $.each(["border", "margin", "padding"], function (i, name) {
        $.fn[name] = function (value) {
            if (value) {
                if (value.top !== undefined) this.css(name + "-top" + (name === "border" ? "-width" : ""), value.top); if (value.bottom !== undefined) this.css(name + "-bottom" + (name === "border" ? "-width" : ""), value.bottom); if (value.left !== undefined) this.css(name + "-left" + (name === "border" ? "-width" :
""), value.left); if (value.right !== undefined) this.css(name + "-right" + (name === "border" ? "-width" : ""), value.right); return this
            } else return { top: num(this.css(name + "-top" + (name === "border" ? "-width" : ""))), bottom: num(this.css(name + "-bottom" + (name === "border" ? "-width" : ""))), left: num(this.css(name + "-left" + (name === "border" ? "-width" : ""))), right: num(this.css(name + "-right" + (name === "border" ? "-width" : "")))}
        } 
    })
})(jQuery);
/*!
Slimbox v2.04 - The ultimate lightweight Lightbox clone for jQuery
(c) 2007-2010 Christophe Beyls <http://www.digitalia.be>
MIT-style license.
*/
/*! Innovasys Modifications
*
*  Changed default speed to 200 for most animations
*  Added linkMapper property so that urls can be fixed up in Mshv outputs
* 
*/
!function(i){function e(){var e=H.scrollLeft(),t=H.width();i([x,L]).css("left",e+t/2),g&&i(w).css({left:e,top:H.scrollTop(),width:t,height:H.height()})}function t(t){t?i("object").add(M?"select":"embed").each(function(i,e){E[i]=[e,e.style.visibility],e.style.visibility="hidden"}):(i.each(E,function(i,e){e[0].style.visibility=e[1]}),E=[]);var o=t?"bind":"unbind";H[o]("scroll resize",e),i(document)[o]("keydown",n)}function n(e){var t=e.keyCode,n=i.inArray;return n(t,h.closeKeys)>=0?c():n(t,h.nextKeys)>=0?a():n(t,h.previousKeys)>=0&&o()}function o(){return r(f)}function a(){return r(y)}function r(i){return i>=0&&(K=i,p=u[K][0],p=Innovasys.Content.Features.HelpViewerCompatibilityDocumentFeature.fixUrl(p),f=(K||(h.loop?u.length:0))-1,y=(K+1)%u.length||(h.loop?0:-1),d(),x.className="lbLoading",N=new Image,N.onload=s,N.src=p),!1}function s(){x.className="";var e=!0;try{var t=i(window).width()-20,n=i(window).height()-40,o=t>n?n:t,a=N.width,r=N.height;a>r?(r=o*r/a,a=o):(a=o*a/r,r=o),(N.width>a||N.height>r)&&(i(k).css({backgroundImage:"url("+p+")",backgroundSize:a+"px "+r+"px",visibility:"hidden",display:""}),i(D).width(a),i([D,I,z]).height(r),e=!1)}catch(s){}e&&(i(k).css({backgroundImage:"url("+p+")",backgroundSize:"",visibility:"hidden",display:""}),i(D).width(N.width),i([D,I,z]).height(N.height)),i(C).html(u[K][1]||""),i(F).html((u.length>1&&h.counterText||"").replace(/{x}/,K+1).replace(/{y}/,u.length)),f>=0&&(O.src=u[f][0]),y>=0&&(S.src=u[y][0]),b=k.offsetWidth,v=k.offsetHeight;var d=Math.max(0,m-v/2);x.offsetHeight!=v&&i(x).animate({height:v,top:d},h.resizeDuration,h.resizeEasing),x.offsetWidth!=b&&i(x).animate({width:b,marginLeft:-b/2},h.resizeDuration,h.resizeEasing),i(x).queue(function(){i(L).css({width:b,top:d+v,marginLeft:-b/2,visibility:"hidden",display:""}),i(k).css({display:"none",visibility:"",opacity:""}).fadeIn(h.imageFadeDuration,l)})}function l(){f>=0&&i(I).show(),y>=0&&i(z).show(),i(T).css("marginTop",-T.offsetHeight).animate({marginTop:0},h.captionAnimationDuration),L.style.visibility=""}function d(){N.onload=null,N.src=O.src=S.src=p,i([x,k,T]).stop(!0),i([I,z,k,L]).hide()}function c(){return K>=0&&(d(),K=f=y=-1,i(x).hide(),i(w).stop().fadeOut(h.overlayFadeDuration,t)),!1}var h,u,p,f,y,g,m,b,v,w,x,k,D,I,z,L,T,C,F,H=i(window),K=-1,M=!window.XMLHttpRequest,E=[],N=(document.documentElement,{}),O=new Image,S=new Image;i(function(){i("div.slimboxcontainer").add("body").first().append(i([w=i('<div id="lbOverlay" />')[0],x=i('<div id="lbCenter" />')[0],L=i('<div id="lbBottomContainer" />')[0]]).css("display","none")),k=i('<div id="lbImage" />').appendTo(x).append(D=i('<div style="position: relative;" />').append([I=i('<a id="lbPrevLink" href="#" />').click(o)[0],z=i('<a id="lbNextLink" href="#" />').click(a)[0]])[0])[0],T=i('<div id="lbBottom" />').appendTo(L).append([i('<a id="lbCloseLink" href="#" />').click(c)[0],C=i('<div id="lbCaption" />')[0],F=i('<div id="lbNumber" />')[0],i('<div style="clear: both;" />')[0]])[0]}),i.slimbox=function(n,o,a){return h=i.extend({loop:!1,overlayOpacity:.8,overlayFadeDuration:200,resizeDuration:200,resizeEasing:"swing",initialWidth:250,initialHeight:250,imageFadeDuration:200,captionAnimationDuration:200,counterText:"Image {x} of {y}",closeKeys:[27,88,67],previousKeys:[37,80],nextKeys:[39,78]},a),"string"==typeof n&&(n=[[n,o]],o=0),m=H.scrollTop()+H.height()/2,b=h.initialWidth,v=h.initialHeight,i(x).css({top:Math.max(0,m-v/2),width:b,height:v,marginLeft:-b/2}).show(),g=M||w.currentStyle&&"fixed"!=w.currentStyle.position,g&&(w.style.position="absolute"),i(w).css("opacity",h.overlayOpacity).fadeIn(h.overlayFadeDuration),e(),t(1),u=n,h.loop=h.loop&&u.length>1,r(o)},i.slimbox.linkMapper=function(e){var t=i(e).data("href");return t||(t=e.href),[t,e.title]},i.fn.slimbox=function(e,t,n){t=t||i.slimbox.linkMapper,n=n||function(){return!0};var o=this;return o.unbind("click").click(function(){var a,r,s=this,l=0,d=0;for(a=i.grep(o,function(i,e){return n.call(s,i,e)}),r=a.length;d<r;++d)a[d]==s&&(l=d),a[d]=t(a[d],d);return i.slimbox(a,l,e)})}}(jQuery);
/*!
* FitVids 1.1
*
* Copyright 2013, Chris Coyier - http://css-tricks.com + Dave Rupert - http://daverupert.com
* Credit to Thierry Koblentz - http://www.alistapart.com/articles/creating-intrinsic-ratios-for-video/
* Released under the WTFPL license - http://sam.zoy.org/wtfpl/
*
*/
!function(t){"use strict";t.fn.fitVids=function(e){var i={customSelector:null,ignore:null};if(!document.getElementById("fit-vids-style")){var r=document.head||document.getElementsByTagName("head")[0],a=".fluid-width-video-wrapper{width:100%;position:relative;padding:0;}.fluid-width-video-wrapper iframe,.fluid-width-video-wrapper object,.fluid-width-video-wrapper embed {position:absolute;top:0;left:0;width:100%;height:100%;}",d=document.createElement("div");d.innerHTML='<p>x</p><style id="fit-vids-style">'+a+"</style>",r.appendChild(d.childNodes[1])}return e&&t.extend(i,e),this.each(function(){var e=['iframe[src*="player.vimeo.com"]','iframe[src*="youtube.com"]','iframe[src*="youtube-nocookie.com"]','iframe[src*="kickstarter.com"][src*="video.html"]',"object","embed"];i.customSelector&&e.push(i.customSelector);var r=".fitvidsignore";i.ignore&&(r=r+", "+i.ignore);var a=t(this).find(e.join(","));a=a.not("object object"),a=a.not(r),a.each(function(){var e=t(this);if(!(e.parents(r).length>0||"embed"===this.tagName.toLowerCase()&&e.parent("object").length||e.parent(".fluid-width-video-wrapper").length)){e.css("height")||e.css("width")||!isNaN(e.attr("height"))&&!isNaN(e.attr("width"))||(e.attr("height",9),e.attr("width",16));var i="object"===this.tagName.toLowerCase()||e.attr("height")&&!isNaN(parseInt(e.attr("height"),10))?parseInt(e.attr("height"),10):e.height(),a=isNaN(parseInt(e.attr("width"),10))?e.width():parseInt(e.attr("width"),10),d=i/a;if(!e.attr("name")){var o="fitvid"+t.fn.fitVids._count;e.attr("name",o),t.fn.fitVids._count++}e.wrap('<div class="fluid-width-video-wrapper"></div>').parent(".fluid-width-video-wrapper").css("padding-top",100*d+"%"),e.removeAttr("height").removeAttr("width")}})})},t.fn.fitVids._count=0}(window.jQuery||window.Zepto);
/**
 * Modernizr 2.6.2 (Custom Build) | MIT & BSD
 * Build: http://modernizr.com/download/#-touch-shiv-mq-teststyles-prefixes-load
*/
window.Modernizr=function(j,d,F){var k={},o=d.documentElement,D=d.createElement("modernizr"),D=D.style,E=" -webkit- -moz- -o- -ms- ".split(" "),B={},s=[],v=s.slice,r,C=function(b,c,q,z){var k,j,n=d.createElement("div"),t=d.body,u=t||d.createElement("body");if(parseInt(q,10))for(;q--;)k=d.createElement("div"),k.id=z?z[q]:"modernizr"+(q+1),n.appendChild(k);q=['&#173;<style id="smodernizr">',b,"</style>"].join("");n.id="modernizr";(t?n:u).innerHTML+=q;u.appendChild(n);if(!t)u.style.background="",u.style.overflow=
"hidden",j=o.style.overflow,o.style.overflow="hidden",o.appendChild(u);b=c(n,b);t?n.parentNode.removeChild(n):(u.parentNode.removeChild(u),o.style.overflow=j);return!!b},x={}.hasOwnProperty,y;y=typeof x!=="undefined"&&typeof x.call!=="undefined"?function(b,c){return x.call(b,c)}:function(b,c){return c in b&&typeof b.constructor.prototype[c]==="undefined"};if(!Function.prototype.bind)Function.prototype.bind=function(b){var c=this;if(typeof c!="function")throw new TypeError;var d=v.call(arguments,1),
k=function(){if(this instanceof k){var j=function(){};j.prototype=c.prototype;var j=new j,o=c.apply(j,d.concat(v.call(arguments)));return Object(o)===o?o:j}else return c.apply(b,d.concat(v.call(arguments)))};return k};B.touch=function(){var b;"ontouchstart"in j||j.DocumentTouch&&d instanceof DocumentTouch?b=!0:C(["@media (",E.join("touch-enabled),("),"modernizr){#modernizr{top:9px;position:absolute}}"].join(""),function(c){b=c.offsetTop===9});return b};for(var A in B)y(B,A)&&(r=A.toLowerCase(),k[r]=
B[A](),s.push((k[r]?"":"no-")+r));k.addTest=function(b,c){if(typeof b=="object")for(var d in b)y(b,d)&&k.addTest(d,b[d]);else{b=b.toLowerCase();if(k[b]!==F)return k;c=typeof c=="function"?c():c;typeof enableClasses!=="undefined"&&enableClasses&&(o.className+=" "+(c?"":"no-")+b);k[b]=c}return k};D.cssText="";D=null;(function(b,c){function d(){var a=r.elements;return typeof a=="string"?a.split(" "):a}function k(g){var f=a[g[v]];f||(f={},h++,g[v]=h,a[h]=f);return f}function j(a,f,b){f||(f=c);if(m)return f.createElement(a);
b||(b=k(f));f=b.cache[a]?b.cache[a].cloneNode():w.test(a)?(b.cache[a]=b.createElem(a)).cloneNode():b.createElem(a);return f.canHaveChildren&&!u.test(a)?b.frag.appendChild(f):f}function o(a,b){if(!b.cache)b.cache={},b.createElem=a.createElement,b.createFrag=a.createDocumentFragment,b.frag=b.createFrag();a.createElement=function(c){return!r.shivMethods?b.createElem(c):j(c,a,b)};a.createDocumentFragment=Function("h,f","return function(){var n=f.cloneNode(),c=n.createElement;h.shivMethods&&("+d().join().replace(/\w+/g,
function(a){b.createElem(a);b.frag.createElement(a);return'c("'+a+'")'})+");return n}")(r,b.frag)}function n(a){a||(a=c);var b=k(a);if(r.shivCSS&&!s&&!b.hasCSS){var d,e=a;d=e.createElement("p");e=e.getElementsByTagName("head")[0]||e.documentElement;d.innerHTML="x<style>article,aside,figcaption,figure,footer,header,hgroup,nav,section{display:block}mark{background:#FF0;color:#000}</style>";d=e.insertBefore(d.lastChild,e.firstChild);b.hasCSS=!!d}m||o(a,b);return a}var t=b.html5||{},u=/^<|^(?:button|map|select|textarea|object|iframe|option|optgroup)$/i,
w=/^(?:a|b|code|div|fieldset|h1|h2|h3|h4|h5|h6|i|label|li|ol|p|q|span|strong|style|table|tbody|td|th|tr|ul)$/i,s,v="_html5shiv",h=0,a={},m;(function(){try{var a=c.createElement("a");a.innerHTML="<xyz></xyz>";s="hidden"in a;m=a.childNodes.length==1||function(){c.createElement("a");var a=c.createDocumentFragment();return typeof a.cloneNode=="undefined"||typeof a.createDocumentFragment=="undefined"||typeof a.createElement=="undefined"}()}catch(b){m=s=!0}})();var r={elements:t.elements||"abbr article aside audio bdi canvas data datalist details figcaption figure footer header hgroup mark meter nav output progress section summary time video",
shivCSS:t.shivCSS!==!1,supportsUnknownElements:m,shivMethods:t.shivMethods!==!1,type:"default",shivDocument:n,createElement:j,createDocumentFragment:function(a,b){a||(a=c);if(m)return a.createDocumentFragment();for(var b=b||k(a),i=b.frag.cloneNode(),e=0,h=d(),j=h.length;e<j;e++)i.createElement(h[e]);return i}};b.html5=r;n(c)})(this,d);k._version="2.6.2";k._prefixes=E;k.mq=function(b){var c=j.matchMedia||j.msMatchMedia;if(c)return c(b).matches;var d;C("@media "+b+" { #modernizr { position: absolute; } }",
function(b){d=(j.getComputedStyle?getComputedStyle(b,null):b.currentStyle).position=="absolute"});return d};k.testStyles=C;return k}(this,this.document);

window.yepnope=function(e,t,n){function r(){}function o(e){return Object(e)===e}function i(e){return"string"==typeof e}function a(){m&&m.parentNode||(m=t.getElementsByTagName("script")[0])}function u(e){return!e||"loaded"==e||"complete"==e||"uninitialized"==e}function c(t,n){n.call(e)}function l(e,n){var l,s,f;i(e)?l=e:o(e)&&(l=e._url||e.src,s=e.attrs,f=e.timeout),n=n||r,s=s||{};var d,y,g=t.createElement("script");f=f||p.errorTimeout,g.src=l;for(y in s)g.setAttribute(y,s[y]);g.onreadystatechange=g.onload=function(){!d&&u(g.readyState)&&(d=1,c(l,n)),g.onload=g.onreadystatechange=g.onerror=null},g.onerror=function(){d=1,n(new Error("Script Error: "+l))},h(function(){d||(d=1,n(new Error("Timeout: "+l)),g.parentNode.removeChild(g))},f),a(),m.parentNode.insertBefore(g,m)}function s(n,u){var c,l,s={};o(n)?(c=n._url||n.href,s=n.attrs||{}):i(n)&&(c=n);var f=t.createElement("link");u=u||r,f.href=c,f.rel="stylesheet",f.media="only x",f.type="text/css",h(function(){f.media=s.media||"all"});for(l in s)f.setAttribute(l,s[l]);a(),m.parentNode.appendChild(f),h(function(){u.call(e)})}function f(e){var t=e.split("?")[0];return t.substr(t.lastIndexOf(".")+1)}function d(e,t){var n=e,r=[],o=[];for(var i in t)t.hasOwnProperty(i)&&(t[i]?r.push(encodeURIComponent(i)):o.push(encodeURIComponent(i)));return(r.length||o.length)&&(n+="?"),r.length&&(n+="yep="+r.join(",")),o.length&&(n+=(r.length?"&":"")+"nope="+o.join(",")),n}function p(e,t,n){var r;o(e)&&(r=e,e=r.src||r.href),e=p.urlFormatter(e,t),r?r._url=e:r={_url:e};var i=f(e);if("js"===i)l(r,n);else{if("css"!==i)throw new Error("Unable to determine filetype.");s(r,n)}}var m,h=e.setTimeout;({}).toString;return p.errorTimeout=1e4,p.injectJs=l,p.injectCss=s,p.urlFormatter=d,p}(window,document);