/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.pipe;

import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Tube;

public final class NextAction {
    int kind;
    Tube next;
    Packet packet;
    Throwable throwable;
    Runnable onExitRunnable;
    static final int INVOKE = 0;
    static final int INVOKE_AND_FORGET = 1;
    static final int RETURN = 2;
    static final int THROW = 3;
    static final int SUSPEND = 4;
    static final int THROW_ABORT_RESPONSE = 5;
    static final int ABORT_RESPONSE = 6;
    static final int INVOKE_ASYNC = 7;

    private void set(int n, Tube tube, Packet packet, Throwable throwable) {
        this.kind = n;
        this.next = tube;
        this.packet = packet;
        this.throwable = throwable;
    }

    public void invoke(Tube tube, Packet packet) {
        this.set(0, tube, packet, null);
    }

    public void invokeAndForget(Tube tube, Packet packet) {
        this.set(1, tube, packet, null);
    }

    public void returnWith(Packet packet) {
        this.set(2, null, packet, null);
    }

    public void throwException(Packet packet, Throwable throwable) {
        this.set(2, null, packet, throwable);
    }

    public void throwException(Throwable throwable) {
        assert (throwable instanceof RuntimeException || throwable instanceof Error);
        this.set(3, null, null, throwable);
    }

    public void throwExceptionAbortResponse(Throwable throwable) {
        this.set(5, null, null, throwable);
    }

    public void abortResponse(Packet packet) {
        this.set(6, null, packet, null);
    }

    public void invokeAsync(Tube tube, Packet packet) {
        this.set(7, tube, packet, null);
    }

    public void suspend() {
        this.suspend(null, null);
    }

    public void suspend(Runnable runnable) {
        this.suspend(null, runnable);
    }

    public void suspend(Tube tube) {
        this.suspend(tube, null);
    }

    public void suspend(Tube tube, Runnable runnable) {
        this.set(4, tube, null, null);
        this.onExitRunnable = runnable;
    }

    public Tube getNext() {
        return this.next;
    }

    public void setNext(Tube tube) {
        this.next = tube;
    }

    public Packet getPacket() {
        return this.packet;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString()).append(" [");
        stringBuilder.append("kind=").append(this.getKindString()).append(',');
        stringBuilder.append("next=").append(this.next).append(',');
        stringBuilder.append("packet=").append(this.packet != null ? this.packet.toShortString() : null).append(',');
        stringBuilder.append("throwable=").append(this.throwable).append(']');
        return stringBuilder.toString();
    }

    public String getKindString() {
        switch (this.kind) {
            case 0: {
                return "INVOKE";
            }
            case 1: {
                return "INVOKE_AND_FORGET";
            }
            case 2: {
                return "RETURN";
            }
            case 3: {
                return "THROW";
            }
            case 4: {
                return "SUSPEND";
            }
            case 5: {
                return "THROW_ABORT_RESPONSE";
            }
            case 6: {
                return "ABORT_RESPONSE";
            }
            case 7: {
                return "INVOKE_ASYNC";
            }
        }
        throw new AssertionError(this.kind);
    }
}

