﻿
window.xzjd = 0;
window.arrowmode = 1;
$(function () {
    function onResize() {
        var height = window.innerHeight;
        var is_safari = navigator.userAgent.indexOf("Safari") > -1;
        if ((navigator.userAgent.match(/iPhone/i)) || (navigator.userAgent.match(/iPod/i))) {}
        $('#radar').attr("width", window.innerWidth).attr("height", height)
    }
    window.addEventListener('resize', onResize);
    onResize();

    // 禁止移动端弹性webview
    document.ontouchmove = function (event) {
        event.preventDefault();
    }
})

$(function () {
    var radar = new Radar($('#radar')[0]);
	//window.setInterval(redraw, 20);
    var socket = io();
    var socketUpdateCounter = new Utils.MinsCounter();
    socket.on('update', function (snapshot) {
        locations = snapshot;
        socketUpdateCounter.update();
        redraw();
    });
	
    var locations = {};
    var trackPlayerIndex = parseInt(Utils.getParameterByName('id') || 0);
    radar.LoadIcon();
    var maps = ['mapErangel.jpg', 'mapMiramar.jpg','mapSanhok.jpg','mapVihandi.jpg','mapkarakin.jpg'];
    var mapParameter = Utils.getParameterByName('map');
    if (mapParameter === '1') {
        radar.setMap(maps[0]);
    } else if (mapParameter === '2') {
        radar.setMap(maps[1]);
	} else if (mapParameter === '3') {
        radar.setMap(maps[2]);
	} else if (mapParameter === '4') {
        radar.setMap(maps[3]);
               }  else if (mapParameter === '5') {
        radar.setMap(maps[4]);
    } else {
        radar.setMap(maps[Math.random() < .5 ? Math.random() < .5 ? 2 : 3 : Math.random() < .5 ? 0 : 1]);
    }
     

    // 手势支持
    var hammertime = new Hammer.Manager($('.container')[0]);
    hammertime.add(new Hammer.Pan({
        threshold: 0
    }));
    hammertime.add(new Hammer.Pinch({
        threshold: 0
    }));

    // 拖动
    var lastDelta = {
        x: 0,
        y: 0
    }
    hammertime.on('panmove', function (ev) {
        radar.setMove(ev.deltaX - lastDelta.x, ev.deltaY - lastDelta.y,-xzjd);
        lastDelta.x = ev.deltaX;
        lastDelta.y = ev.deltaY;
        //redraw();
    });
    hammertime.on('panend', function (ev) {
        lastDelta = {
            x: 0,
            y: 0
        }
    });

    // 缩放
    var lastScale = 0;
    hammertime.on('pinchmove', function (ev) {
        var size = 0.6;
        if (lastScale > ev.scale) {
            size = -size;
        }
        radar.setZoom(Math.pow(1.1, size));
        lastScale = ev.scale;
        redraw();
    });
    hammertime.on('pinchend', function () {
        lastScale = 0;
    });

    // 鼠标滚轮缩放
    $('.container').on("mousewheel DOMMouseScroll", function (e) {
        var evt = e.originalEvent;
        var delta = evt.wheelDelta ? evt.wheelDelta / 100 : evt.detail ? -evt.detail : 0;
        if (delta) {
            radar.setZoom(Math.pow(1.1, delta));
            redraw();
        }
        return evt.preventDefault() && false;
    });

    function redraw() {
        radar.clear();
        // 视角追踪
        if (locations.players && locations.players[trackPlayerIndex]) {
            var player = locations.players[trackPlayerIndex];
            radar.setFocus(player.x, player.y);
        }
        // draw map


        radar.map(xzjd);
        drawPlayers(xzjd);
       // drawItems();
        //drawVehicles();
        //drawMisc();
    }

    function drawPlayers(an) {
        if (!locations.players) { 
		
            return;
        }
		
        var players = locations.players;
        for (var i = players.length - 1; i >= 0; i--) {

            var player = players[i];
			if (player.hp == 10001) //alt+q
			{
				radar.setZoom(Math.pow(1.1, 5))
                continue
            }
			if (player.hp == 10002) //alt+e
			{
				radar.setZoom(Math.pow(1.1, -5))
                continue
            }
			if (player.hp == 10003) //f5
			{
				window.location.reload();
                continue
            }
			var x0 = parseInt(players[0].x);
            var y0 = parseInt(players[0].y);
            var x1 = parseInt(players[i].x);
            var y1 = parseInt(players[i].y);
            var z0 = players[0].r;
            var z1 = players[i].r;
            var h0 = players[0].hp;
            var h1 = players[i].hp;
			if (players[0].hp == 0) {
                z0 = 0
            }
			xzjd = -(z0)
			radar.xz(an);
			var color1 = "";
            var color = "";
			var drawfov = false;
			if(player.hp > 0 && player.hp != 888)
				drawfov = true;
			
            if (i == trackPlayerIndex) {//本人
			    color = '#61c757';
                color1 = '#1cbc0c';
			    if(player.r != 0)
				{
					radar.myx(player.x, player.y, -(player.r), arrowmode);
					radar.lineWithAngle(player.x, player.y, 200, 1.2, player.r, color); 	
				}
						 
            } else if (players[trackPlayerIndex].t == player.t) {
                color = '#3496f7';
                color1 = '#066dd6';
				if(player.r != 0 && drawfov)
				{
					radar.teamx(player.x, player.y, -(player.r), arrowmode);
				}
            } else {
                color = '#ff303f';
                color1 = '#e00e11';	
				if(player.r != 0 && drawfov)
				{
					radar.direnx(player.x, player.y, -(player.r), arrowmode);
				}
            }

            if (player.hp == 0) {
                color = '#000000';
				radar.deathx(player.x, player.y, -(player.r));
            } else {
				if(player.hp == 888)
					radar.hpx(player.x, player.y, -(player.r));
				else
				{
					radar.dot(player.x, player.y, color,color1);
					radar.pieChart(player.x, player.y, ((100 - player.hp) / 100), 'gray')
					radar.text(player.x, player.y, player.t, 'white'); //团队编号
				}
      
				
                
                
            }
           // radar.text(player.x, player.y, i, 'white'); //编号ID
		   

		      
		  radar.restore()
        }
    }


	
    function drawItems() {
        if (!locations.items) {
            return;
        }
        var items = locations.items;
        for (var i = items.length - 1; i >= 0; i--) {
            var item = items[i];
            radar.text(item.x, item.y, item.n, 'red');
        }
    }

    function drawVehicles() {
        if (!locations.vehicles) {
            return;
        }
        var vehicles = locations.vehicles;
        for (var i = vehicles.length - 1; i >= 0; i--) {
            var vehicle = vehicles[i];
            var name = "";
            if (vehicle.v.indexOf('_') >= 0) {
                name = vehicle.v.split('_')[0];
            }
            radar.text(vehicle.x, vehicle.y, name, 'orange');
        }
    }

    function drawMisc() {
        // radar.floatText(0, 10, "Update: " + socketUpdateCounter.getPerSec() + "ps");
    }
});
