-- Path of Building
--
-- Module: Calc Sections
-- List of sections for the Calcs tab
--

return {
{ 3, "HitDamage", 1, "Skill Hit Damage", colorCodes.OFFENCE, {
	extra = "{output:DisplayDamage}",
	flag = "hit",
	colWidth = 95,
	{
		{ format = "All Types:", },
		{ format = "Physical:" },
		{ format = "Lightning:" },
		{ format = "Cold:" },
		{ format = "Fire:" },
		{ format = "Chaos:" },
	},
	{ label = "Added Min",
		{ },
		{ format = "{0:mod:1}", { modName = "PhysicalMin", modType = "BASE", cfg = "skill" }, },
		{ format = "{0:mod:1}", { modName = "LightningMin", modType = "BASE", cfg = "skill" }, },
		{ format = "{0:mod:1}", { modName = "ColdMin", modType = "BASE", cfg = "skill" }, },
		{ format = "{0:mod:1}", { modName = "FireMin", modType = "BASE", cfg = "skill" }, },
		{ format = "{0:mod:1}", { modName = "ChaosMin", modType = "BASE", cfg = "skill" }, },
	},
	{ label = "Added Max",
		{ },
		{ format = "{0:mod:1}", { modName = "PhysicalMax", modType = "BASE", cfg = "skill" }, },
		{ format = "{0:mod:1}", { modName = "LightningMax", modType = "BASE", cfg = "skill" }, },
		{ format = "{0:mod:1}", { modName = "ColdMax", modType = "BASE", cfg = "skill" }, },
		{ format = "{0:mod:1}", { modName = "FireMax", modType = "BASE", cfg = "skill" }, },
		{ format = "{0:mod:1}", { modName = "ChaosMax", modType = "BASE", cfg = "skill" }, },
	},
	-- Skill Hit Damage
	{ label = "Total Increased", notFlag = "attack",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "INC", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "INC", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "INC", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "INC", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "INC", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "INC", cfg = "skill" }, },
	},
	{ label = "Total More", notFlag = "attack",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "MORE", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "MORE", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "MORE", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "MORE", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "MORE", cfg = "skill" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "MORE", cfg = "skill" }, },
	},
	{ label = "Effective DPS Mod", notFlag = "attack", flag = "effective",
		{ },
		{ format = "x {3:output:PhysicalEffMult}",
			{ breakdown = "PhysicalEffMult" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "PhysicalDamageTaken" }, enemy = true }, 
		},
		{ format = "x {3:output:LightningEffMult}",
			{ breakdown = "LightningEffMult" },
			{ label = "Player modifiers", modName = { "LightningPenetration", "ElementalPenetration" }, cfg = "skill" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "LightningDamageTaken", "ElementalDamageTaken", "LightningResist", "ElementalResist" }, enemy = true },
		},
		{ format = "x {3:output:ColdEffMult}",
			{ breakdown = "ColdEffMult" },
			{ label = "Player modifiers", modName = { "ColdPenetration", "ElementalPenetration" }, cfg = "skill" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "ColdDamageTaken", "ElementalDamageTaken", "ColdResist", "ElementalResist" }, enemy = true },
		},
		{ format = "x {3:output:FireEffMult}",
			{ breakdown = "FireEffMult" },
			{ label = "Player modifiers", modName = { "FirePenetration", "ElementalPenetration" }, cfg = "skill" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "FireDamageTaken", "ElementalDamageTaken", "FireResist", "ElementalResist" }, enemy = true },
		},
		{ format = "x {3:output:ChaosEffMult}",
			{ breakdown = "ChaosEffMult" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "ChaosDamageTaken", "ChaosResist" }, enemy = true },
		},
	},
	{ label = "Skill Hit Damage", textSize = 12, notFlag = "attack",
		{ format = "{0:output:TotalMin} to {0:output:TotalMax}", },
		{ format = "{0:output:PhysicalMin} to {0:output:PhysicalMax}", 
			{ breakdown = "Physical" }, 
			{ label = "Conversions", modType = "BASE", cfg = "skill", modName = { "SkillPhysicalDamageConvertToLightning", "SkillPhysicalDamageConvertToCold", "SkillPhysicalDamageConvertToFire", "SkillPhysicalDamageConvertToChaos", "PhysicalDamageConvertToLightning", "PhysicalDamageConvertToCold", "PhysicalDamageConvertToFire", "PhysicalDamageConvertToChaos", "PhysicalDamageGainAsLightning", "PhysicalDamageGainAsCold", "PhysicalDamageGainAsFire", "PhysicalDamageGainAsChaos" } }, 
		},
		{ format = "{0:output:LightningMin} to {0:output:LightningMax}", 
			{ breakdown = "Lightning" }, 
			{ label = "Conversions", modType = "BASE", cfg = "skill", modName = { "LightningDamageConvertToCold", "LightningDamageConvertToFire", "LightningDamageConvertToChaos", "ElementalDamageConvertToChaos", "LightningDamageGainAsCold", "LightningDamageGainAsFire", "LightningDamageGainAsChaos", "ElementalDamageGainAsChaos" } }, 
		},
		{ format = "{0:output:ColdMin} to {0:output:ColdMax}", 
			{ breakdown = "Cold" }, 
			{ label = "Conversions", modType = "BASE", cfg = "skill", modName = { "SkillColdDamageConvertToFire", "ColdDamageConvertToFire", "ColdDamageConvertToChaos", "ElementalDamageConvertToChaos", "ColdDamageGainAsFire", "ColdDamageGainAsChaos", "ElementalDamageGainAsChaos" } }, 
		},
		{ format = "{0:output:FireMin} to {0:output:FireMax}", 
			{ breakdown = "Fire" }, 
			{ label = "Conversions", modType = "BASE", cfg = "skill", modName = { "FireDamageConvertToChaos", "ElementalDamageConvertToChaos", "FireDamageGainAsChaos", "ElementalDamageGainAsChaos" } }, 
		},
		{ format = "{0:output:ChaosMin} to {0:output:ChaosMax}", 
			{ breakdown = "Chaos" }, 
		},
	},
	{ label = "Skill Average Hit", notFlag = "attack", { format = "{1:output:AverageHit}", { breakdown = "AverageHit" }, }, },
	-- Main Hand Hit Damage
	{ label = "MH Total Increased", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "INC", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "INC", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "INC", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "INC", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "INC", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "INC", cfg = "weapon1" }, },
	},
	{ label = "MH Total More", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "MORE", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "MORE", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "MORE", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "MORE", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "MORE", cfg = "weapon1" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "MORE", cfg = "weapon1" }, },
	},
	{ label = "MH Eff. DPS Mod", bgCol = colorCodes.MAINHANDBG, flagList = {"weapon1Attack","effective"},
		{ },
		{ format = "x {3:output:MainHand.PhysicalEffMult}",
			{ breakdown = "MainHand.PhysicalEffMult" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "PhysicalDamageTaken" }, enemy = true }, 
		},
		{ format = "x {3:output:MainHand.LightningEffMult}",
			{ breakdown = "MainHand.LightningEffMult" },
			{ label = "Player modifiers", modName = { "LightningPenetration", "ElementalPenetration" }, cfg = "weapon1" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "LightningDamageTaken", "ElementalDamageTaken", "LightningResist", "ElementalResist" }, enemy = true },
		},
		{ format = "x {3:output:MainHand.ColdEffMult}",
			{ breakdown = "MainHand.ColdEffMult" },
			{ label = "Player modifiers", modName = { "ColdPenetration", "ElementalPenetration" }, cfg = "weapon1" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "ColdDamageTaken", "ElementalDamageTaken", "ColdResist", "ElementalResist" }, enemy = true },
		},
		{ format = "x {3:output:MainHand.FireEffMult}",
			{ breakdown = "MainHand.FireEffMult" },
			{ label = "Player modifiers", modName = { "FirePenetration", "ElementalPenetration" }, cfg = "weapon1" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "FireDamageTaken", "ElementalDamageTaken", "FireResist", "ElementalResist" }, enemy = true },
		},
		{ format = "x {3:output:MainHand.ChaosEffMult}",
			{ breakdown = "MainHand.ChaosEffMult" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "ChaosDamageTaken", "ChaosResist" }, enemy = true },
		},
	},
	{ label = "MH Hit Damage", bgCol = colorCodes.MAINHANDBG, textSize = 12, flag = "weapon1Attack",
		{ format = "{0:output:MainHand.TotalMin} to {0:output:MainHand.TotalMax}", },
		{ format = "{0:output:MainHand.PhysicalMin} to {0:output:MainHand.PhysicalMax}", 
			{ breakdown = "MainHand.Physical" }, 
			{ label = "Conversions", modType = "BASE", cfg = "weapon1", modName = { "SkillPhysicalDamageConvertToLightning", "SkillPhysicalDamageConvertToCold", "SkillPhysicalDamageConvertToFire", "SkillPhysicalDamageConvertToChaos", "PhysicalDamageConvertToLightning", "PhysicalDamageConvertToCold", "PhysicalDamageConvertToFire", "PhysicalDamageConvertToChaos", "PhysicalDamageGainAsLightning", "PhysicalDamageGainAsCold", "PhysicalDamageGainAsFire", "PhysicalDamageGainAsChaos" } },
		},
		{ format = "{0:output:MainHand.LightningMin} to {0:output:MainHand.LightningMax}", 
			{ breakdown = "MainHand.Lightning" }, 
			{ label = "Conversions", modType = "BASE", cfg = "weapon1", modName = { "LightningDamageConvertToCold", "LightningDamageConvertToFire", "LightningDamageConvertToChaos", "ElementalDamageConvertToChaos", "LightningDamageGainAsCold", "LightningDamageGainAsFire", "LightningDamageGainAsChaos", "ElementalDamageGainAsChaos" } }, 
		},
		{ format = "{0:output:MainHand.ColdMin} to {0:output:MainHand.ColdMax}", 
			{ breakdown = "MainHand.Cold" }, 
			{ label = "Conversions", modType = "BASE", cfg = "weapon1", modName = { "SkillColdDamageConvertToFire", "ColdDamageConvertToFire", "ColdDamageConvertToChaos", "ElementalDamageConvertToChaos", "ColdDamageGainAsFire", "ColdDamageGainAsChaos", "ElementalDamageGainAsChaos" } }, 
		},
		{ format = "{0:output:MainHand.FireMin} to {0:output:MainHand.FireMax}", 
			{ breakdown = "MainHand.Fire" }, 
			{ label = "Conversions", modType = "BASE", cfg = "weapon1", modName = { "FireDamageConvertToChaos", "ElementalDamageConvertToChaos", "FireDamageGainAsChaos", "ElementalDamageGainAsChaos" } }, 
		},
		{ format = "{0:output:MainHand.ChaosMin} to {0:output:MainHand.ChaosMax}", 
			{ breakdown = "MainHand.Chaos" }, 
		},
	},
	{ label = "MH Average Hit", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{1:output:MainHand.AverageHit}", { breakdown = "MainHand.AverageHit" }, }, },
	-- Off Hand Hit Damage
	{ label = "OH Total Increased", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "INC", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "INC", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "INC", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "INC", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "INC", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "INC", cfg = "weapon2" }, },
	},
	{ label = "OH Total More", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "MORE", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "MORE", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "MORE", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "MORE", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "MORE", cfg = "weapon2" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "MORE", cfg = "weapon2" }, },
	},
	{ label = "OH Eff. DPS Mod", bgCol = colorCodes.OFFHANDBG, flagList = {"weapon2Attack","effective"},
		{ },
		{ format = "x {3:output:OffHand.PhysicalEffMult}",
			{ breakdown = "OffHand.PhysicalEffMult" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "PhysicalDamageTaken" }, enemy = true }, 
		},
		{ format = "x {3:output:OffHand.LightningEffMult}",
			{ breakdown = "OffHand.LightningEffMult" },
			{ label = "Player modifiers", modName = { "LightningPenetration", "ElementalPenetration" }, cfg = "weapon2" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "LightningDamageTaken", "ElementalDamageTaken", "LightningResist", "ElementalResist" }, enemy = true },
		},
		{ format = "x {3:output:OffHand.ColdEffMult}",
			{ breakdown = "OffHand.ColdEffMult" },
			{ label = "Player modifiers", modName = { "ColdPenetration", "ElementalPenetration" }, cfg = "weapon2" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "ColdDamageTaken", "ElementalDamageTaken", "ColdResist", "ElementalResist" }, enemy = true },
		},
		{ format = "x {3:output:OffHand.FireEffMult}",
			{ breakdown = "OffHand.FireEffMult" },
			{ label = "Player modifiers", modName = { "FirePenetration", "ElementalPenetration" }, cfg = "weapon2" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "FireDamageTaken", "ElementalDamageTaken", "FireResist", "ElementalResist" }, enemy = true },
		},
		{ format = "x {3:output:OffHand.ChaosEffMult}",
			{ breakdown = "OffHand.ChaosEffMult" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "ChaosDamageTaken", "ChaosResist" }, enemy = true },
		},
	},
	{ label = "OH Hit Damage", bgCol = colorCodes.OFFHANDBG, textSize = 12, flag = "weapon2Attack",
		{ format = "{0:output:OffHand.TotalMin} to {0:output:OffHand.TotalMax}", },
		{ format = "{0:output:OffHand.PhysicalMin} to {0:output:OffHand.PhysicalMax}", 
			{ breakdown = "OffHand.Physical" }, 
			{ label = "Conversions", modType = "BASE", cfg = "weapon2", modName = { "SkillPhysicalDamageConvertToLightning", "SkillPhysicalDamageConvertToCold", "SkillPhysicalDamageConvertToFire", "SkillPhysicalDamageConvertToChaos", "PhysicalDamageConvertToLightning", "PhysicalDamageConvertToCold", "PhysicalDamageConvertToFire", "PhysicalDamageConvertToChaos", "PhysicalDamageGainAsLightning", "PhysicalDamageGainAsCold", "PhysicalDamageGainAsFire", "PhysicalDamageGainAsChaos" } },
		},
		{ format = "{0:output:OffHand.LightningMin} to {0:output:OffHand.LightningMax}", 
			{ breakdown = "OffHand.Lightning" }, 
			{ label = "Conversions", modType = "BASE", cfg = "weapon2", modName = { "LightningDamageConvertToCold", "LightningDamageConvertToFire", "LightningDamageConvertToChaos", "ElementalDamageConvertToChaos", "LightningDamageGainAsCold", "LightningDamageGainAsFire", "LightningDamageGainAsChaos", "ElementalDamageGainAsChaos" } }, 
		},
		{ format = "{0:output:OffHand.ColdMin} to {0:output:OffHand.ColdMax}", 
			{ breakdown = "OffHand.Cold" }, 
			{ label = "Conversions", modType = "BASE", cfg = "weapon2", modName = { "SkillColdDamageConvertToFire", "ColdDamageConvertToFire", "ColdDamageConvertToChaos", "ElementalDamageConvertToChaos", "ColdDamageGainAsFire", "ColdDamageGainAsChaos", "ElementalDamageGainAsChaos" } }, 
		},
		{ format = "{0:output:OffHand.FireMin} to {0:output:OffHand.FireMax}", 
			{ breakdown = "OffHand.Fire" }, 
			{ label = "Conversions", modType = "BASE", cfg = "weapon2", modName = { "FireDamageConvertToChaos", "ElementalDamageConvertToChaos", "FireDamageGainAsChaos", "ElementalDamageGainAsChaos" } }, 
		},
		{ format = "{0:output:OffHand.ChaosMin} to {0:output:OffHand.ChaosMax}", 
			{ breakdown = "OffHand.Chaos" },
		},
	},
	{ label = "OH Average Hit", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{1:output:OffHand.AverageHit}", { breakdown = "OffHand.AverageHit" }, }, },
	{ label = "Average Damage", flag = "attack", { format = "{1:output:AverageDamage}", 
		{ breakdown = "MainHand.AverageDamage" },
		{ breakdown = "OffHand.AverageDamage" },
		{ breakdown = "AverageDamage" },
	}, },
	{ label = "Skill DPS", flag = "notAverage", { format = "{1:output:TotalDPS}", { breakdown = "TotalDPS" }, }, },
	{ label = "Mana Cost", { format = "{0:output:ManaCost}", { breakdown = "ManaCost" }, { modName = "ManaCost", cfg = "skill" }, }, },
} },
{ 3, "Dot", 1, "Skill Damage over Time", colorCodes.OFFENCE, {
	extra = "{1:output:TotalDot} total DoT",
	flag = "dot",
	colWidth = 95,
	{ { format = "All Types:", }, { format = "Physical:" }, { format = "Lightning:" }, { format = "Cold:" }, { format = "Fire:" }, { format = "Chaos:" }, },
	{ label = "Total Increased",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "INC", cfg = "dot" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "INC", cfg = "dot" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "INC", cfg = "dot" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "INC", cfg = "dot" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "INC", cfg = "dot" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "INC", cfg = "dot" }, },
	},
	{ label = "Total More",
		{ format = "{0:mod:1}%", { modName = "Damage", modType = "MORE", cfg = "dot" }, },
		{ format = "{0:mod:1}%", { modName = "PhysicalDamage", modType = "MORE", cfg = "dot" }, },
		{ format = "{0:mod:1}%", { modName = { "LightningDamage", "ElementalDamage" }, modType = "MORE", cfg = "dot" }, },
		{ format = "{0:mod:1}%", { modName = { "ColdDamage", "ElementalDamage" }, modType = "MORE", cfg = "dot" }, },
		{ format = "{0:mod:1}%", { modName = { "FireDamage", "ElementalDamage" }, modType = "MORE", cfg = "dot" }, },
		{ format = "{0:mod:1}%", { modName = "ChaosDamage", modType = "MORE", cfg = "dot" }, },
	},
	{ label = "Effective DPS Mod", flag = "effective",
		{ },
		{ format = "x {3:output:PhysicalDotEffMult}",
			{ breakdown = "PhysicalDotEffMult" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "DamageTakenOverTime", "PhysicalDamageTaken", "PhysicalDamageTakenOverTime", "PhysicalDamageReduction" }, enemy = true }, 
		},
		{ format = "x {3:output:LightningDotEffMult}",
			{ breakdown = "LightningDotEffMult" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "DamageTakenOverTime", "LightningDamageTaken", "LightningDamageTakenOverTime", "ElementalDamageTaken", "LightningResist", "ElementalResist" }, enemy = true },
		},
		{ format = "x {3:output:ColdDotEffMult}",
			{ breakdown = "ColdDotEffMult" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "DamageTakenOverTime", "ColdDamageTaken", "ColdDamageTakenOverTime", "ElementalDamageTaken", "ColdResist", "ElementalResist" }, enemy = true },
		},
		{ format = "x {3:output:FireDotEffMult}",
			{ breakdown = "FireDotEffMult" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "DamageTakenOverTime", "FireDamageTaken", "FireDamageTakenOverTime", "ElementalDamageTaken", "FireResist", "ElementalResist" }, enemy = true },
		},
		{ format = "x {3:output:ChaosDotEffMult}",
			{ breakdown = "ChaosDotEffMult" },
			{ label = "Enemy modifiers", modName = { "DamageTaken", "DamageTakenOverTime", "ChaosDamageTaken", "ChaosDamageTakenOverTime", "ChaosResist" }, enemy = true },
		},
	},
	{ label = "Damage over Time",
		{ format = "{1:output:TotalDot}", },
		{ format = "{1:output:PhysicalDot}", { breakdown = "PhysicalDot" }, },
		{ format = "{1:output:LightningDot}", { breakdown = "LightningDot" }, },
		{ format = "{1:output:ColdDot}", { breakdown = "ColdDot" }, },
		{ format = "{1:output:FireDot}", { breakdown = "FireDot" }, },
		{ format = "{1:output:ChaosDot}", { breakdown = "ChaosDot" }, },
	},
	{ label = "Mana Cost", { format = "{0:output:ManaCost}", { breakdown = "ManaCost" }, { modName = "ManaCost", cfg = "skill" }, }, },
} },
{ 1, "Speed", 1, "Attack/Cast Rate", colorCodes.OFFENCE, {
	extra = "{2:output:Speed}/s",
	{ label = "MH Inc. Att. Speed", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{0:mod:1}%", { modName = "Speed", modType = "INC", cfg = "weapon1", }, }, },
	{ label = "MH More Att. Speed", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{0:mod:1}%", { modName = "Speed", modType = "MORE", cfg = "weapon1", }, }, },
	{ label = "MH Att. per second", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{2:output:MainHand.Speed}", { breakdown = "MainHand.Speed" }, }, },
	{ label = "OH Inc. Att. Speed", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{0:mod:1}%", { modName = "Speed", modType = "INC", cfg = "weapon2", }, }, },
	{ label = "OH More Att. Speed", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{0:mod:1}%", { modName = "Speed", modType = "MORE", cfg = "weapon2", }, }, },
	{ label = "OH Att. per second", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{2:output:OffHand.Speed}", { breakdown = "OffHand.Speed" }, }, },
	{ label = "Attacks per second", flag = "bothWeaponAttack", { format = "{2:output:Speed}", { breakdown = "Speed" }, }, },
	{ label = "Attack time", flag = "attack", { format = "{2:output:Time}s", }, },
	{ label = "Inc. Cast Speed", flag = "spell", { format = "{0:mod:1}%", { modName = "Speed", modType = "INC", cfg = "skill", }, }, },
	{ label = "More Cast Speed", flag = "spell", { format = "{0:mod:1}%", { modName = "Speed", modType = "MORE", cfg = "skill", }, }, },
	{ label = "Casts per second", flag = "spell", { format = "{2:output:Speed}", { breakdown = "Speed" }, }, },
	{ label = "Cast time", flag = "spell", { format = "{2:output:Time}s", }, },
} },
{ 1, "Crit", 1, "Crits", colorCodes.OFFENCE, {
	extra = "{2:output:CritChance}% x{2:output:CritMultiplier}",
	flag = "hit",
	-- Skill
	{ label = "Inc. Crit Chance", notFlag = "attack", { format = "{0:mod:1}%", { modName = "CritChance", modType = "INC", cfg = "skill" }, }, },
	{ label = "Crit Chance", notFlag = "attack", { format = "{2:output:CritChance}%", 
		{ breakdown = "CritChance" }, 
		{ label = "Player modifiers", modName = "CritChance", cfg = "skill" }, 
		{ label = "Enemy modifiers", modName = "SelfExtraCritChance", enemy = true }, 
	}, },
	{ label = "Crit Multiplier", notFlag = "attack", { format = "x {2:output:CritMultiplier}", 
		{ breakdown = "CritMultiplier" }, 
		{ label = "Player modifiers", modName = "CritMultiplier", cfg = "skill" }, 
		{ label = "Enemy modifiers", modName = "SelfCritMultiplier", enemy = true }, 
	}, },
	{ label = "Crit Effect Mod", notFlag = "attack", { format = "x {3:output:CritEffect}", { breakdown = "CritEffect" }, }, },
	-- Main Hand
	{ label = "MH Inc. Crit Chance", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{0:mod:1}%", { modName = "CritChance", modType = "INC", cfg = "weapon1" }, }, },
	{ label = "MH Crit Chance", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{2:output:MainHand.CritChance}%", 
		{ breakdown = "MainHand.CritChance" }, 
		{ label = "Player modifiers", modName = "CritChance", cfg = "weapon1" }, 
		{ label = "Enemy modifiers", modName = "SelfExtraCritChance", enemy = true }, 
	}, },
	{ label = "MH Crit Multiplier", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "x {2:output:MainHand.CritMultiplier}", 
		{ breakdown = "MainHand.CritMultiplier" }, 
		{ label = "Player modifiers", modName = "CritMultiplier", cfg = "weapon1" }, 
		{ label = "Enemy modifiers", modName = "SelfCritMultiplier", enemy = true },
	}, },
	{ label = "MH Crit Effect Mod", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "x {3:output:MainHand.CritEffect}", { breakdown = "MainHand.CritEffect" }, }, },
	-- Off Hand
	{ label = "OH Inc. Crit Chance", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{0:mod:1}%", { modName = "CritChance", modType = "INC", cfg = "weapon2" }, }, },
	{ label = "OH Crit Chance", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{2:output:OffHand.CritChance}%", 
		{ breakdown = "OffHand.CritChance" }, 
		{ label = "Player modifiers", modName = "CritChance", cfg = "weapon2" },
		{ label = "Enemy modifiers", modName = "SelfExtraCritChance", enemy = true }, 
	}, },
	{ label = "OH Crit Multiplier", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "x {2:output:OffHand.CritMultiplier}", 
		{ breakdown = "OffHand.CritMultiplier" }, 
		{ label = "Player modifiers", modName = "CritMultiplier", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = "SelfCritMultiplier", enemy = true },
	}, },
	{ label = "OH Crit Effect Mod", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "x {3:output:OffHand.CritEffect}", { breakdown = "OffHand.CritEffect" }, }, },
} },
{ 1, "HitChance", 1, "Accuracy", colorCodes.OFFENCE, {
	extra = "{0:output:HitChance}%",
	flag = "attack",
	{ label = "MH Accuracy", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{0:output:MainHand.Accuracy}", 
		{ breakdown = "MainHand.Accuracy" }, 
		{ modName = "Accuracy", cfg = "weapon1" }, 
	}, },
	{ label = "MH Chance to Hit", bgCol = colorCodes.MAINHANDBG, flag = "weapon1Attack", { format = "{0:output:MainHand.HitChance}%",
		{ breakdown = "MainHand.HitChance" }, 
		{ label = "Enemy Evasion modifiers", modName = "Evasion", enemy = true },
	}, },
	{ label = "OH Accuracy", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{0:output:OffHand.Accuracy}",
		{ breakdown = "OffHand.Accuracy" }, 
		{ modName = "Accuracy", cfg = "weapon2" },
	}, },
	{ label = "OH Chance to Hit", bgCol = colorCodes.OFFHANDBG, flag = "weapon2Attack", { format = "{0:output:OffHand.HitChance}%",
		{ breakdown = "OffHand.HitChance" },
		{ label = "Enemy Evasion modifiers", modName = "Evasion", enemy = true },
	}, },
} },
{ 1, "SkillTypeStats", 1, "Skill type-specific Stats", colorCodes.OFFENCE, {
	{ label = "Active Minion Limit", haveOutput = "ActiveMinionLimit", { format = "{0:output:ActiveMinionLimit}" } },
	{ label = "Skill Cooldown", haveOutput = "Cooldown", { format = "{2:output:Cooldown}s", 
		{ breakdown = "Cooldown" }, 
		{ modName = "CooldownRecovery", cfg = "skill" },
	}, },
	{ label = "Duration Mod", flag = "duration", { format = "x {2:output:DurationMod}", 
		{ breakdown = "DurationMod"}, 
		{ modName = "Duration", cfg = "skill" }, 
	}, },
	{ label = "Skill Duration", flag = "duration", haveOutput = "Duration", { format = "{2:output:Duration}s", { breakdown = "Duration" }, }, },
	{ label = "Max Chain Count", flag = "chaining", { format = "{0:output:ChainMax}", { modName = "ChainCountMax", cfg = "skill" }, }, }, 
	{ label = "Projectile Count", flag = "projectile", { format = "{0:output:ProjectileCount}", { modName = "ProjectileCount", cfg = "skill" }, }, },
	{ label = "Pierce Chance", flag = "projectile", { format = "{0:output:PierceChance}%", { modName = "PierceChance", cfg = "skill" }, }, },
	{ label = "Proj. Speed Mod", flag = "projectile", { format = "x {2:output:ProjectileSpeedMod}",
		{ breakdown = "ProjectileSpeedMod" },
		{ modName = "ProjectileSpeed", cfg = "skill" },
	}, },
	{ label = "Area of Effect Mod", flag = "area", { format = "x {2:output:AreaOfEffectMod}", 
		{ breakdown = "AreaOfEffectMod" }, 
		{ modName = "AreaOfEffect", cfg = "skill" },
	}, },
	{ label = "Radius", haveOutput = "AreaOfEffectRadius", { format = "{0:output:AreaOfEffectRadius}", { breakdown = "AreaOfEffectRadius" }, }, },
	{ label = "Secondary Radius", haveOutput = "AreaOfEffectRadiusSecondary", { format = "{0:output:AreaOfEffectRadiusSecondary}", { breakdown = "AreaOfEffectRadiusSecondary" }, }, },
	{ label = "Weapon Range", haveOutput = "WeaponRange", { format = "{0:output:WeaponRange}", { breakdown = "WeaponRange" }, }, },
	{ label = "Trap Throw Time", flag = "trap", { format = "{2:output:TrapThrowingTime}s", 
		{ breakdown = "TrapThrowingTime" },
		{ modName = "TrapThrowingSpeed", cfg = "skill" }, 
	}, },
	{ label = "Active Trap Limit", flag = "trap", { format = "{0:output:ActiveTrapLimit}", { modName = "ActiveTrapLimit", cfg = "skill" }, }, },
	{ label = "Trap Cooldown", flag = "trap", { format = "{2:output:TrapCooldown}s", 
		{ breakdown = "TrapCooldown" }, 
		{ modName = "CooldownRecovery", cfg = "skill" },
	}, },
	{ label = "Trap Trigg. Radius", flag = "trap", { format = "{0:output:TrapTriggerRadius}", 
		{ breakdown = "TrapTriggerRadius" },
		{ label = "Area of Effect modifiers", modName = "TrapTriggerAreaOfEffect", cfg = "skill" },
	}, },
	{ label = "Mine Laying Time", flag = "mine", { format = "{2:output:MineLayingTime}s", 
		{ breakdown = "MineLayingTime" },
		{ modName = "MineLayingSpeed", cfg = "skill" }, 
	}, },
	{ label = "Active Mine Limit", flag = "mine", { format = "{0:output:ActiveMineLimit}", { modName = "ActiveMineLimit", cfg = "skill" }, }, },
	{ label = "Mine Deton. Radius", flag = "mine", { format = "{0:output:MineDetonationRadius}", 
		{ breakdown = "MineDetonationRadius" },
		{ label = "Area of Effect modifiers", modName = "MineDetonationAreaOfEffect", cfg = "skill" },
	}, },
	{ label = "Totem Place Time", flag = "totem", { format = "{2:output:TotemPlacementTime}s", 
		{ breakdown = "TotemPlacementTime" },
		{ modName = "TotemPlacementSpeed", cfg = "skill" }, 
	}, },
	{ label = "Active Totem Limit", flag = "totem", { format = "{0:output:ActiveTotemLimit}", { modName = "ActiveTotemLimit", cfg = "skill" }, }, },
	{ label = "Totem Life Mod", flag = "totem", { format = "x {2:output:TotemLifeMod}", 
		{ breakdown = "TotemLifeMod" },
		{ modName = "TotemLife", cfg = "skill" },
	}, },
	{ label = "Totem Life", flag = "totem", { format = "{0:output:TotemLife}", { breakdown = "TotemLife" }, }, },
} },
{ 1, "Bleed", 1, "Bleed", colorCodes.OFFENCE, {
	extra = "{0:output:BleedChance}% {1:output:BleedDPS} {2:output:BleedDuration}s",
	flag = "bleed",
	{ label = "Chance to Bleed", { format = "{0:output:BleedChance}%", 
		{ breakdown = "MainHand.BleedChance" },
		{ breakdown = "OffHand.BleedChance" },
		{ breakdown = "BleedChance" },
		{ label = "Main Hand", flag = "weapon1Attack", modName = "BleedChance", modType = "BASE", cfg = "weapon1" },
		{ label = "Off Hand", flag = "weapon2Attack", modName = "BleedChance", modType = "BASE", cfg = "weapon2" },
	}, },
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = { "Damage", "PhysicalDamage" }, modType = "INC", cfg = "bleed" }, }, },
	{ label = "Total More", { format = "{0:mod:1}%", { modName = { "Damage", "PhysicalDamage" }, modType = "MORE", cfg = "bleed" }, }, },
	{ label = "Effective DPS Mod", flag = "effective", { format = "x {3:output:BleedEffMult}", { breakdown = "BleedEffMult" }, { label = "Enemy modifiers", modName = { "DamageTaken", "DamageTakenOverTime", "PhysicalDamageTaken", "PhysicalDamageTakenOverTime", "PhysicalDamageReduction" }, enemy = true }, }, },
	{ label = "Bleed DPS", { format = "{1:output:BleedDPS}", { breakdown = "BleedDPS" }, { breakdown = "MainHand.BleedDPS" }, { breakdown = "OffHand.BleedDPS" }, }, },
	{ label = "Bleed Duration", { format = "{2:output:BleedDuration}s", 
		{ breakdown = "BleedDuration" }, 
		{ label = "Player modifiers", modName = "Duration", cfg = "bleed" }, 
		{ label = "Enemy modifiers", modName = "SelfBleedDuration", enemy = true },
	}, },
} },
{ 1, "Poison", 1, "Poison", colorCodes.OFFENCE, {
	extra = "{0:output:PoisonChance}% {1:output:PoisonDPS} {2:output:PoisonDuration}s",
	flag = "poison",
	{ label = "Chance to Poison", { format = "{0:output:PoisonChance}%", 
		{ breakdown = "MainHand.PoisonChance" }, 
		{ breakdown = "OffHand.PoisonChance" }, 
		{ breakdown = "PoisonChance" }, 
		{ notFlag = "attack", modName = "PoisonChance", modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", flag = "weapon1Attack", modName = "PoisonChance", modType = "BASE", cfg = "weapon1" },
		{ label = "Off Hand", flag = "weapon2Attack", modName = "PoisonChance", modType = "BASE", cfg = "weapon2" },
	}, },
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = { "Damage", "ChaosDamage" }, modType = "INC", cfg = "poison" }, }, },
	{ label = "Total More", { format = "{0:mod:1}%", { modName = { "Damage", "ChaosDamage" }, modType = "MORE", cfg = "poison" }, }, },
	{ label = "Effective DPS Mod", flag = "effective", { format = "x {3:output:PoisonEffMult}", 
		{ breakdown = "PoisonEffMult" }, 
		{ label = "Enemy modifiers", modName = { "ChaosResist", "DamageTaken", "DamageTakenOverTime", "ChaosDamageTaken", "ChaosDamageTakenOverTime" }, enemy = true },
	}, },
	{ label = "Poison DPS", { format = "{1:output:PoisonDPS}", 
		{ breakdown = "PoisonDPS" }, 
		{ breakdown = "MainHand.PoisonDPS" },
		{ breakdown = "OffHand.PoisonDPS" },
	}, },
	{ label = "Poison Duration", { format = "{2:output:PoisonDuration}s", 
		{ breakdown = "PoisonDuration" },
		{ label = "Player modifiers", modName = "Duration", cfg = "poison" },
		{ label = "Enemy modifiers", modName = "SelfPoisonDuration", enemy = true },
	}, },
	{ label = "Dmg. per Poison", { format = "{1:output:PoisonDamage}", 
		{ breakdown = "MainHand.PoisonDamage" }, 
		{ breakdown = "OffHand.PoisonDamage" }, 
		{ breakdown = "PoisonDamage" }, 
	}, },
	{ flag = "notAverage", label = "Max Poison Stacks", { format = "{1:output:TotalPoisonStacks}",
		{ breakdown = "MainHand.TotalPoisonStacks" }, 
		{ breakdown = "OffHand.TotalPoisonStacks" }, 
		{ breakdown = "TotalPoisonStacks" }, 
	}, },
} },
{ 1, "Ignite", 1, "Ignite", colorCodes.OFFENCE, {	
	extra = "{0:output:IgniteChance}% {1:output:IgniteDPS} {2:output:IgniteDuration}s",
	flag = "ignite",
	{ label = "Chance to Ignite", { format = "{0:output:IgniteChance}%", 
		{ breakdown = "MainHand.IgniteChance" }, 
		{ breakdown = "OffHand.IgniteChance" },
		{ breakdown = "IgniteChance" },
		{ label = "Player modifiers", modName = "EnemyIgniteChance", cfg = "skill" },
		{ label = "Enemy modifiers", modName = "SelfIgniteChance", enemy = true },
	}, },
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = { "Damage", "FireDamage", "ElementalDamage" }, modType = "INC", cfg = "ignite" }, }, },
	{ label = "Total More", { format = "{0:mod:1}%", { modName = { "Damage", "FireDamage", "ElementalDamage" }, modType = "MORE", cfg = "ignite" }, }, },
	{ label = "Effective DPS Mod", flag = "effective", { format = "x {3:output:IgniteEffMult}", 
		{ breakdown = "IgniteEffMult" }, 
		{ label = "Enemy modifiers", modName = { "FireResist", "ElementalResist", "DamageTaken", "DamageTakenOverTime", "FireDamageTaken", "FireDamageTakenOverTime", "ElementalDamageTaken" }, enemy = true },
	}, },
	{ label = "Ignite DPS", { format = "{1:output:IgniteDPS}", 
		{ breakdown = "IgniteDPS" }, 
		{ breakdown = "MainHand.IgniteDPS" },
		{ breakdown = "OffHand.IgniteDPS" },
		{ modName = { "IgniteBurnRate" }, cfg = "skill" }, 
	}, },
	{ label = "Ignite Duration", { format = "{2:output:IgniteDuration}s", 
		{ breakdown = "IgniteDuration" },
		{ label = "Player modifiers", modName = "EnemyIgniteDuration", cfg = "skill" },
		{ label = "Enemy modifiers", modName = "SelfIgniteDuration", enemy = true },
	}, },
	{ label = "Dmg. per Ignite", flag = "igniteCanStack", { format = "{1:output:IgniteDamage}",
		{ breakdown = "MainHand.IgniteDamage" },
		{ breakdown = "OffHand.IgniteDamage" },
		{ breakdown = "IgniteDamage" },
	}, },
	{ flagList = { "notAverage", "igniteCanStack" }, label = "Max Ignite Stacks", { format = "{1:output:TotalIgniteStacks}",
		{ breakdown = "MainHand.TotalIgniteStacks" }, 
		{ breakdown = "OffHand.TotalIgniteStacks" }, 
		{ breakdown = "TotalIgniteStacks" }, 
	}, },
} },
{ 1, "Decay", 1, "Decay", colorCodes.OFFENCE, {
	extra = "{1:output:DecayDPS} {2:output:DecayDuration}s",
	flag = "decay",
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = { "Damage", "ChaosDamage" }, modType = "INC", cfg = "decay" }, }, },
	{ label = "Total More", { format = "{0:mod:1}%", { modName = { "Damage", "ChaosDamage" }, modType = "MORE", cfg = "decay" }, }, },
	{ label = "Effective DPS Mod", flag = "effective", { format = "x {3:output:DecayEffMult}", 
		{ breakdown = "DecayEffMult" }, 
		{ label = "Enemy modifiers", modName = { "ChaosResist", "DamageTaken", "DamageTakenOverTime", "ChaosDamageTaken", "ChaosDamageTakenOverTime" }, enemy = true },
	}, },
	{ label = "Decay DPS", { format = "{1:output:DecayDPS}", 
		{ breakdown = "DecayDPS" }, 
	}, },
	{ label = "Decay Duration", { format = "{2:output:DecayDuration}s", 
		{ breakdown = "DecayDuration" },
		{ modName = "Duration", cfg = "decay" },
	}, },
} },
{ 1, "LeechGain", 1, "Leech & Gain on Hit", colorCodes.OFFENCE, {
	{ label = "Life Leech Cap", flag = "leechLife", { format = "{1:output:MaxLifeLeechRate}", 
		{ breakdown = "MaxLifeLeechRate" },
		{ modName = "MaxLifeLeechRate" },
	}, },
	{ label = "Life Leech Rate", flag = "leechLife", notFlag = "showAverage", { format = "{1:output:LifeLeechRate}", 
		{ breakdown = "LifeLeech" }, 
		{ label = "Player modifiers", notFlagList = { "totem", "attack" }, modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", notFlag = "totem", flag = "weapon1Attack", modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", notFlag = "totem", flag = "weapon2Attack", modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "weapon2" }, 
		{ label = "Totem modifiers", flag = "totem", modName = { "DamageLifeLeechToPlayer" }, modType = "BASE", cfg = "skill" },
		{ label = "Enemy modifiers", modName = { "SelfDamageLifeLeech" }, modType = "BASE", enemy = true },
	}, },
	{ label = "Life Leech per Hit", flagList = { "leechLife", "showAverage" }, { format = "{1:output:LifeLeechPerHit}", 
		{ breakdown = "LifeLeech" },
		{ label = "Player modifiers", notFlagList = { "totem", "attack" }, modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", notFlag = "totem", flag = "weapon1Attack", modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", notFlag = "totem", flag = "weapon2Attack", modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "weapon2" }, 
		{ label = "Totem modifiers", flag = "totem", modName = { "DamageLifeLeechToPlayer" }, modType = "BASE", cfg = "skill" },
		{ label = "Enemy modifiers", modName = { "SelfDamageLifeLeech" }, modType = "BASE", enemy = true },
	}, },
	{ label = "Life Gain Rate", notFlag = "showAverage", haveOutput = "LifeOnHitRate", { format = "{1:output:LifeOnHitRate}", 
		{ label = "Player modifiers", notFlag = "attack", modName = "LifeOnHit", modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", flag = "weapon1Attack", modName = "LifeOnHit", modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", flag = "weapon2Attack", modName = "LifeOnHit", modType = "BASE", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = { "SelfLifeOnHit" }, modType = "BASE", cfg = "skill", enemy = true },
	}, },
	{ label = "Life Gain per Hit", flag = "showAverage", haveOutput = "LifeOnHit", { format = "{1:output:LifeOnHit}", 
		{ label = "Player modifiers", notFlag = "attack", modName = "LifeOnHit", modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", flag = "weapon1Attack", modName = "LifeOnHit", modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", flag = "weapon2Attack", modName = "LifeOnHit", modType = "BASE", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = { "SelfLifeOnHit" }, modType = "BASE", cfg = "skill", enemy = true },
	}, },
	{ label = "ES Leech Cap", flag = "leechES", { format = "{1:output:MaxEnergyShieldLeechRate}", 
		{ breakdown = "MaxEnergyShieldLeechRate" },
		{ modName = "MaxLifeLeechRate" },
	}, },
	{ label = "ES Leech Rate", flag = "leechES", notFlag = "showAverage", { format = "{1:output:EnergyShieldLeechRate}", 
		{ breakdown = "EnergyShieldLeech" },
		{ label = "Player modifiers", notFlagList = { "totem", "attack" }, modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", notFlag = "totem", flag = "weapon1Attack", modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", notFlag = "totem", flag = "weapon2Attack", modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "weapon2" }, 
		{ label = "Totem modifiers", flag = "totem", modName = { "DamageLifeLeechToPlayer" }, modType = "BASE", cfg = "skill" },
		{ label = "Enemy modifiers", modName = { "SelfDamageLifeLeech" }, modType = "BASE", enemy = true },
	}, },
	{ label = "ES Leech per Hit", flagList = { "leechES", "showAverage" }, { format = "{1:output:EnergyShieldLeechPerHit}",
		{ breakdown = "EnergyShieldLeech" },
		{ label = "Player modifiers", notFlagList = { "totem", "attack" }, modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", notFlag = "totem", flag = "weapon1Attack", modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", notFlag = "totem", flag = "weapon2Attack", modName = { "DamageLeech", "DamageLifeLeech", "PhysicalDamageLifeLeech", "LightningDamageLifeLeech", "ColdDamageLifeLeech", "FireDamageLifeLeech", "ChaosDamageLifeLeech", "ElementalDamageLifeLeech" }, modType = "BASE", cfg = "weapon2" }, 
		{ label = "Totem modifiers", flag = "totem", modName = { "DamageLifeLeechToPlayer" }, modType = "BASE", cfg = "skill" },
		{ label = "Enemy modifiers", modName = { "SelfDamageLifeLeech" }, modType = "BASE", enemy = true },
	}, },
	{ label = "ES Gain Rate", notFlag = "showAverage", haveOutput = "EnergyShieldOnHitRate", { format = "{1:output:EnergyShieldOnHitRate}", 
		{ label = "Player modifiers", notFlag = "attack", modName = "EnergyShieldOnHit", modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", flag = "weapon1Attack", modName = "EnergyShieldOnHit", modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", flag = "weapon2Attack", modName = "EnergyShieldOnHit", modType = "BASE", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = { "SelfEnergyShieldOnHit" }, modType = "BASE", enemy = true },
	}, },
	{ label = "ES Gain per Hit", flag = "showAverage", haveOutput = "EnergyShieldOnHit", { format = "{1:output:EnergyShieldOnHit}", 
		{ label = "Player modifiers", notFlag = "attack", modName = "EnergyShieldOnHit", modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", flag = "weapon1Attack", modName = "EnergyShieldOnHit", modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", flag = "weapon2Attack", modName = "EnergyShieldOnHit", modType = "BASE", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = { "SelfEnergyShieldOnHit" }, modType = "BASE", cfg = "skill", enemy = true },
	}, },
	{ label = "Mana Leech Cap", flag = "leechMana", { format = "{1:output:MaxManaLeechRate}", 
		{ breakdown = "MaxManaLeechRate" },
		{ modName = "MaxManaLeechRate" },
	}, },
	{ label = "Mana Leech Rate", flag = "leechMana", notFlag = "showAverage", { format = "{1:output:ManaLeechRate}", 
		{ breakdown = "ManaLeech" }, 
		{ label = "Player modifiers", notFlag = "attack", modName = { "DamageLeech", "DamageManaLeech", "PhysicalDamageManaLeech", "LightningDamageManaLeech", "ColdDamageManaLeech", "FireDamageManaLeech", "ChaosDamageManaLeech", "ElementalDamageManaLeech" }, modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", flag = "weapon1Attack", modName = { "DamageLeech", "DamageManaLeech", "PhysicalDamageManaLeech", "LightningDamageManaLeech", "ColdDamageManaLeech", "FireDamageManaLeech", "ChaosDamageManaLeech", "ElementalDamageManaLeech" }, modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", flag = "weapon2Attack", modName = { "DamageLeech", "DamageManaLeech", "PhysicalDamageManaLeech", "LightningDamageManaLeech", "ColdDamageManaLeech", "FireDamageManaLeech", "ChaosDamageManaLeech", "ElementalDamageManaLeech" }, modType = "BASE", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = { "SelfDamageManaLeech" }, modType = "BASE", cfg = "skill", enemy = true },
	}, },
	{ label = "Mana Leech per Hit", flagList = { "leechMana", "showAverage" }, { format = "{1:output:ManaLeechPerHit}", 
		{ breakdown = "ManaLeech" }, 
		{ label = "Player modifiers", notFlag = "attack", modName = { "DamageLeech", "DamageManaLeech", "PhysicalDamageManaLeech", "LightningDamageManaLeech", "ColdDamageManaLeech", "FireDamageManaLeech", "ChaosDamageManaLeech", "ElementalDamageManaLeech" }, modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", flag = "weapon1Attack", modName = { "DamageLeech", "DamageManaLeech", "PhysicalDamageManaLeech", "LightningDamageManaLeech", "ColdDamageManaLeech", "FireDamageManaLeech", "ChaosDamageManaLeech", "ElementalDamageManaLeech" }, modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", flag = "weapon2Attack", modName = { "DamageLeech", "DamageManaLeech", "PhysicalDamageManaLeech", "LightningDamageManaLeech", "ColdDamageManaLeech", "FireDamageManaLeech", "ChaosDamageManaLeech", "ElementalDamageManaLeech" }, modType = "BASE", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = { "SelfDamageManaLeech" }, modType = "BASE", enemy = true },
	}, },
	{ label = "Mana Gain Rate", notFlag = "showAverage", haveOutput = "ManaOnHitRate", { format = "{1:output:ManaOnHitRate}", 
		{ label = "Player modifiers", notFlag = "attack", modName = "ManaOnHit", modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", flag = "weapon1Attack", modName = "ManaOnHit", modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", flag = "weapon2Attack", modName = "ManaOnHit", modType = "BASE", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = { "SelfManaOnHit" }, modType = "BASE", cfg = "skill", enemy = true },
	}, },
	{ label = "Mana Gain per Hit", flag = "showAverage", haveOutput = "ManaOnHit", { format = "{1:output:ManaOnHit}",
		{ label = "Player modifiers", notFlag = "attack", modName = "ManaOnHit", modType = "BASE", cfg = "skill" }, 
		{ label = "Main Hand", flag = "weapon1Attack", modName = "ManaOnHit", modType = "BASE", cfg = "weapon1" }, 
		{ label = "Off Hand", flag = "weapon2Attack", modName = "ManaOnHit", modType = "BASE", cfg = "weapon2" }, 
		{ label = "Enemy modifiers", modName = { "SelfManaOnHit" }, modType = "BASE", cfg = "skill", enemy = true },
	}, },
} },
{ 1, "MiscEffects", 1, "Other Effects", colorCodes.OFFENCE, {
	{ label = "Chance to Shock", flag = "shock", { format = "{0:output:ShockChance}%", 
		{ breakdown = "MainHand.ShockChance" },
		{ breakdown = "OffHand.ShockChance" },
		{ breakdown = "ShockChance" },
		{ label = "Player modifiers", modName = "EnemyShockChance", cfg = "skill" },
		{ label = "Enemy modifiers", modName = "SelfShockChance", enemy = true },
	}, },
	{ label = "Shock Dur. Mod", flag = "shock", { format = "x {2:output:ShockDurationMod}", 
		{ breakdown = "MainHand.ShockDPS" },
		{ breakdown = "OffHand.ShockDPS" },
		{ breakdown = "ShockDPS" },
		{ label = "Player modifiers", modName = "EnemyShockDuration", cfg = "skill" }, 
		{ label = "Enemy modifiers", modName = "SelfShockDuration", enemy = true }, 
	}, },
	{ label = "Chance to Freeze", flag = "freeze", { format = "{0:output:FreezeChance}%", 
		{ breakdown = "MainHand.FreezeChance" }, 
		{ breakdown = "OffHand.FreezeChance" }, 
		{ breakdown = "FreezeChance" }, 
		{ label = "Player modifiers", modName = "EnemyFreezeChance", cfg = "skill" }, 
		{ label = "Enemy modifiers", modName = "SelfFreezeChance", enemy = true },
	}, },
	{ label = "Freeze Dur. Mod", flag = "freeze", { format = "x {2:output:FreezeDurationMod}", 
		{ breakdown = "MainHand.FreezeDPS" }, 
		{ breakdown = "OffHand.FreezeDPS" },
		{ breakdown = "FreezeDPS" },
		{ label = "Player modifiers", modName = "EnemyFreezeDuration", cfg = "skill" },
		{ label = "Enemy modifiers", modName = "SelfFreezeDuration", enemy = true },
	}, },
	{ label = "Stun Threshold", flag = "hit", notFlag = "attack", { format = "x {2:output:EnemyStunThresholdMod}", { modName = "EnemyStunThreshold", cfg = "skill" }, }, },
	{ label = "Stun Duration", flag = "hit", notFlag = "attack", { format = "{2:output:EnemyStunDuration}s", 
		{ breakdown = "EnemyStunDuration" }, 
		{ label = "Player modifiers", modName = { "EnemyStunDuration" }, cfg = "skill" },
		{ label = "Enemy modifiers", modName = { "StunRecovery" }, enemy = true },
	}, },
	{ label = "MH Stun Threshold", bgCol = colorCodes.MAINHANDBG, flagList = {"hit","weapon1Attack"}, { format = "x {2:output:MainHand.EnemyStunThresholdMod}", { modName = "EnemyStunThreshold", cfg = "weapon1" }, }, },
	{ label = "MH Stun Duration", bgCol = colorCodes.MAINHANDBG, flagList = {"hit","weapon1Attack"}, { format = "{2:output:MainHand.EnemyStunDuration}s", 
		{ breakdown = "MainHand.EnemyStunDuration" }, 
		{ label = "Player modifiers", modName = { "EnemyStunDuration" }, cfg = "weapon1" },
		{ label = "Enemy modifiers", modName = { "StunRecovery" }, enemy = true },
	}, },
	{ label = "OH Stun Threshold", bgCol = colorCodes.OFFHANDBG, flagList = {"hit","weapon2Attack"}, { format = "x {2:output:OffHand.EnemyStunThresholdMod}", { modName = "EnemyStunThreshold", cfg = "weapon2" }, }, },
	{ label = "OH Stun Duration", bgCol = colorCodes.OFFHANDBG, flagList = {"hit","weapon2Attack"}, { format = "{2:output:OffHand.EnemyStunDuration}s", 
		{ breakdown = "OffHand.EnemyStunDuration" }, 
		{ label = "Player modifiers", modName = { "EnemyStunDuration" }, cfg = "weapon2" },
		{ label = "Enemy modifiers", modName = { "StunRecovery" }, enemy = true },
	}, },
	{ label = "Knockback Chance", haveOutput = "KnockbackChance", { format = "{0:output:KnockbackChance}%", 
		{ label = "Player modifiers", modName = "EnemyKnockbackChance", cfg = "skill" }, 
		{ label = "Enemy modifiers", modName = "SelfKnockbackChance", enemy = true },
	}, },
	{ label = "Knockback Dist.", haveOutput = "KnockbackChance", { format = "{0:output:KnockbackDistance}", 
		{ breakdown = "KnockbackDistance" },
		{ modName = "EnemyKnockbackDistance", cfg = "skill" }, 
	}, },
	{ label = "MH K.B. Chance", bgCol = colorCodes.MAINHANDBG, haveOutput = "MainHand.KnockbackChance", { format = "{0:output:MainHand.KnockbackChance}%", 
		{ label = "Player modifiers", modName = "EnemyKnockbackChance", cfg = "weapon1" },
		{ label = "Enemy modifiers", modName = "SelfKnockbackChance", enemy = true },
	}, },
	{ label = "MH K.B. Dist.", bgCol = colorCodes.MAINHANDBG, haveOutput = "MainHand.KnockbackChance", { format = "{0:output:MainHand.KnockbackDistance}",
		{ breakdown = "MainHand.KnockbackDistance" },
		{ modName = "EnemyKnockbackDistance", cfg = "weapon1" },
	}, },
	{ label = "OH K.B. Chance", bgCol = colorCodes.OFFHANDBG, haveOutput = "OffHand.KnockbackChance", { format = "{0:output:OffHand.KnockbackChance}%", 
		{ label = "Player modifiers", modName = "EnemyKnockbackChance", cfg = "weapon2" },
		{ label = "Enemy modifiers", modName = "SelfKnockbackChance", enemy = true },
	}, },
	{ label = "OH K.B. Dist.", bgCol = colorCodes.OFFHANDBG, haveOutput = "OffHand.KnockbackChance", { format = "{0:output:OffHand.KnockbackDistance}",
		{ breakdown = "OffHand.KnockbackDistance" },
		{ modName = "EnemyKnockbackDistance", cfg = "weapon2" },
	}, },
	{ label = "Inc. Item Quantity", { format = "{0:mod:1}%", { modName = "LootQuantity", modType = "INC", cfg = "skill" }, }, },
	{ label = "Inc. Item Rarity", { format = "{0:mod:1}%", { modName = "LootRarity", modType = "INC", cfg = "skill" }, }, },
} },
{ 1, "Attributes", 2, "Attributes", colorCodes.NORMAL, {
	extra = colorCodes.STRENGTH.."{0:output:Str}^7, "..colorCodes.DEXTERITY.."{0:output:Dex}^7, "..colorCodes.INTELLIGENCE.."{0:output:Int}",
	{ label = "Strength", { format = "{0:output:Str}", { breakdown = "Str" }, { modName = "Str" }, }, },
	{ label = "Dexterity", { format = "{0:output:Dex}", { breakdown = "Dex" }, { modName = "Dex" }, }, },
	{ label = "Intelligence", { format = "{0:output:Int}", { breakdown = "Int" }, { modName = "Int" }, }, },
	{ notFlag = "minionSkill", label = "Str. Required", { format = "{output:ReqStrString}", { breakdown = "ReqStr" }, }, },
	{ notFlag = "minionSkill", label = "Dex. Required", { format = "{output:ReqDexString}", { breakdown = "ReqDex" }, }, },
	{ notFlag = "minionSkill", label = "Int. Required", { format = "{output:ReqIntString}", { breakdown = "ReqInt" }, }, },
} },
{ 1, "Life", 2, "Life", colorCodes.DEFENCE, {
	extra = "{0:output:LifeUnreserved}/{0:output:Life}",
	{ label = "Base from Gear", { format = "{0:mod:1}", { modName = "Life", modType = "BASE", modSource = "Item" }, }, },
	{ label = "Inc. from Tree", { format = "{0:mod:1}%", { modName = "Life", modType = "INC", modSource = "Tree" }, }, },
	{ label = "Total Base", { format = "{0:mod:1}", { modName = "Life", modType = "BASE" }, }, },
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = "Life", modType = "INC", }, }, },
	{ label = "Total More", { format = "{0:mod:1}%", { modName = "Life", modType = "MORE", }, }, },
	{ label = "Total", { format = "{0:output:Life}", { breakdown = "Life" }, }, },
	{ label = "Reserved", { format = "{0:output:LifeReserved} ({0:output:LifeReservedPercent}%)", { breakdown = "LifeReserved" }, }, },
	{ label = "Unreserved", { format = "{0:output:LifeUnreserved} ({0:output:LifeUnreservedPercent}%)" }, },
	{ label = "Regen", { format = "{1:output:LifeRegen} ({1:output:LifeRegenPercent}%)", 
		{ label = "Sources", modName = { "LifeRegen", "LifeRegenPercent" }, modType = "BASE" }, 
		{ label = "Recovery modifiers", modName = "LifeRecovery" },
	}, },
} },
{ 1, "Mana", 2, "Mana", colorCodes.DEFENCE, {
	extra = "{0:output:ManaUnreserved}/{0:output:Mana}",
	notFlag = "minionSkill",
	{ label = "Base from Gear", { format = "{0:mod:1}", { modName = "Mana", modType = "BASE", modSource = "Item" }, }, },
	{ label = "Inc. from Tree", { format = "{0:mod:1}%", { modName = "Mana", modType = "INC", modSource = "Tree" }, }, },
	{ label = "Total Base", { format = "{0:mod:1}", { modName = "Mana", modType = "BASE" }, }, },
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = "Mana", modType = "INC" }, }, },
	{ label = "Total", { format = "{0:output:Mana}", { breakdown = "Mana" }, }, },
	{ label = "Reserved", { format = "{0:output:ManaReserved} ({0:output:ManaReservedPercent}%)", { breakdown = "ManaReserved" }, }, },
	{ label = "Unreserved", { format = "{0:output:ManaUnreserved} ({0:output:ManaUnreservedPercent}%)" }, },
	{ label = "Increased Regen", { format = "{0:mod:1}%", { modName = "ManaRegen", modType = "INC" }, }, },
	{ label = "Regen", { format = "{1:output:ManaRegen}", 
		{ breakdown = "ManaRegen" }, 
		{ label = "Sources", modName = { "ManaRegen", "ManaRegenPercent" }, modType = "BASE" },
		{ label = "Recovery modifiers", modName = "ManaRecovery" },
	}, },
} },
{ 1, "EnergyShield", 2, "Energy Shield", colorCodes.DEFENCE, {
	extra = "{0:output:EnergyShield}",
	{ label = "Base from Armours", { format = "{0:output:Gear:EnergyShield}", }, },
	{ label = "Global Base", { format = "{0:mod:1}", { modName = "EnergyShield", modType = "BASE" }, }, },
	{ label = "Inc. from Tree", { format = "{0:mod:1}%", { modName = "EnergyShield", modType = "INC", modSource = "Tree" }, }, },
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = { "EnergyShield", "Defences" }, modType = "INC" }, }, },
	{ label = "Total More", { format = "{0:mod:1}%", { modName = { "EnergyShield", "Defences" }, modType = "MORE" }, }, },
	{ label = "Total", { format = "{0:output:EnergyShield}", { breakdown = "EnergyShield" }, }, },
	{ label = "Recharge Rate", { format = "{1:output:EnergyShieldRecharge}", 
		{ breakdown = "EnergyShieldRecharge" },
		{ modName = { "EnergyShieldRecharge", "EnergyShieldRecovery" }, },
	}, },
	{ label = "Recharge Delay", { format = "{2:output:EnergyShieldRechargeDelay}s", 
		{ breakdown = "EnergyShieldRechargeDelay" },
		{ modName = "EnergyShieldRechargeFaster" },
	}, },
	{ label = "Regen", { format = "{1:output:EnergyShieldRegen} ({1:output:EnergyShieldRegenPercent}%)", 
		{ label = "Sources", modName = { "EnergyShieldRegen", "EnergyShieldRegenPercent" }, modType = "BASE" }, 
		{ label = "Recovery modifiers", modName = "EnergyShieldRecovery" },
	}, },
} },
{ 1, "Armour", 3, "Armour", colorCodes.DEFENCE, {
	extra = "{0:output:Armour}",
	{ label = "Base from Armours", { format = "{0:output:Gear:Armour}" }, },
	{ label = "Global Base", { format = "{0:mod:1}", { modName = "Armour", modType = "BASE" }, }, },
	{ label = "Inc. from Tree", { format = "{0:mod:1}%", { modName = { "Armour", "ArmourAndEvasion" }, modType = "INC", modSource = "Tree", }, }, },
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = { "Armour", "ArmourAndEvasion", "Defences" }, modType = "INC" }, }, },
	{ label = "Total More", { format = "{0:mod:1}%", { modName = { "Armour", "ArmourAndEvasion", "Defences" }, modType = "MORE" }, }, },
	{ label = "Total", { format = "{0:output:Armour}", { breakdown = "Armour" }, }, },
	{ label = "Phys. Dmg. Reduct", { format = "{0:output:PhysicalDamageReduction}%", 
		{ breakdown = "PhysicalDamageReduction" },
		{ modName = { "PhysicalDamageReduction" } }, 
	}, },
} },
{ 1, "Evasion", 3, "Evasion", colorCodes.DEFENCE, {
	extra = "{0:output:Evasion}",
	{ label = "Base from Armours", { format = "{0:output:Gear:Evasion}", }, },
	{ label = "Global Base", { format = "{0:mod:1}", { modName = "Evasion", modType = "BASE" }, }, },
	{ label = "Inc. from Tree", { format = "{0:mod:1}%", { modName = { "Evasion", "ArmourAndEvasion" }, modType = "INC", modSource = "Tree" }, }, },
	{ label = "Total Increased", { format = "{0:mod:1}%", { modName = { "Evasion", "ArmourAndEvasion", "Defences" }, modType = "INC" }, }, },
	{ label = "Total More", { format = "{0:mod:1}%", { modName = { "Evasion", "ArmourAndEvasion", "Defences" }, modType = "MORE" }, }, },
	{ label = "Total", { format = "{0:output:Evasion}", { breakdown = "Evasion" }, }, },
	{ label = "Evade Chance", { format = "{0:output:EvadeChance}%", 
		{ breakdown = "EvadeChance" },
		{ modName = { "CannotEvade" } },
		{ label = "Enemy modifiers", modName = { "Accuracy", "HitChance" }, enemy = true },
	}, },
} },
{ 1, "Resist", 3, "Resists", colorCodes.DEFENCE, {
	extra = colorCodes.FIRE.."{0:output:FireResist}+{0:output:FireResistOverCap}^7/"..colorCodes.COLD.."{0:output:ColdResist}+{0:output:ColdResistOverCap}^7/"..colorCodes.LIGHTNING.."{0:output:LightningResist}+{0:output:LightningResistOverCap}",
	{ label = "Fire Resist", { format = "{0:output:FireResist}% (+{0:output:FireResistOverCap}%)",
		{ breakdown = "FireResist" }, 
		{ modName = { "FireResistMax", "FireResist", "ElementalResist" }, },
	}, },
	{ label = "Cold Resist", { format = "{0:output:ColdResist}% (+{0:output:ColdResistOverCap}%)", 
		{ breakdown = "ColdResist" },
		{ modName = { "ColdResistMax", "ColdResist", "ElementalResist" }, },
	}, },
	{ label = "Lightning Resist", { format = "{0:output:LightningResist}% (+{0:output:LightningResistOverCap}%)",
		{ breakdown = "LightningResist" },
		{ modName = { "LightningResistMax", "LightningResist", "ElementalResist" }, },
	}, },
	{ label = "Chaos Resist", { format = "{0:output:ChaosResist}% (+{0:output:ChaosResistOverCap}%)",
		{ breakdown = "ChaosResist" },
		{ modName = { "ChaosResistMax", "ChaosResist" }, }, 
	}, },
} },
{ 1, "DamageTaken", 3, "Damage Taken", colorCodes.DEFENCE, {
	{ label = "Physical Hit/DoT", { format = "x {2:output:PhysicalTakenHitMult} / x {2:output:PhysicalTakenDotMult}", 
		{ breakdown = "PhysicalTakenHitMult" }, 
		{ breakdown = "PhysicalTakenDotMult" },
		{ modName = { "DamageTaken", "DamageTakenWhenHit", "DamageTakenOverTime", "PhysicalDamageTaken", "PhysicalDamageTakenWhenHit", "PhysicalDamageTakenOverTime", "PhysicalDamageTakenAsFire", "PhysicalDamageTakenAsCold", "PhysicalDamageTakenAsLightning", "PhysicalDamageTakenAsChaos" } },
	}, },
	{ label = "Fire Hit/DoT", { format = "x {2:output:FireTakenHitMult} / x {2:output:FireTakenDotMult}",
		{ breakdown = "FireTakenHitMult" },
		{ breakdown = "FireTakenDotMult" },
		{ modName = { "DamageTaken", "DamageTakenWhenHit", "DamageTakenOverTime", "FireDamageTaken", "FireDamageTakenWhenHit", "FireDamageTakenOverTime", "ElementalDamageTaken", "FireDamageTakenAsPhysical", "FireDamageDamageTakenAsCold", "FireDamageTakenAsLightning", "FireDamageTakenAsChaos", "ElementalDamageTakenAsPhysical", "ElementalDamageTakenAsChaos" } },
	}, },
	{ label = "Cold Hit/DoT", { format = "x {2:output:ColdTakenHitMult} / x {2:output:ColdTakenDotMult}",
		{ breakdown = "ColdTakenHitMult" },
		{ breakdown = "ColdTakenDotMult" },
		{ modName = { "DamageTaken", "DamageTakenWhenHit", "DamageTakenOverTime", "ColdDamageTaken", "ColdDamageTakenWhenHit", "ColdDamageTakenOverTime", "ElementalDamageTaken", "ColdDamageTakenAsPhysical", "ColdDamageTakenAsFire", "ColdDamageTakenAsLightning", "ColdDamageTakenAsChaos", "ElementalDamageTakenAsPhysical", "ElementalDamageTakenAsChaos" } },
	}, },
	{ label = "Lightning Hit/DoT", { format = "x {2:output:LightningTakenHitMult} / x {2:output:LightningTakenDotMult}",
		{ breakdown = "LightningTakenHitMult" },
		{ breakdown = "LightningTakenDotMult" },
		{ modName = { "DamageTaken", "DamageTakenWhenHit", "DamageTakenOverTime", "LightningDamageTaken", "LightningDamageTakenWhenHit", "LightningDamageTakenOverTime", "ElementalDamageTaken", "LightningDamageTakenAsPhysical", "LightningDamageTakenAsFire", "LightningDamageTakenAsCold", "LightningDamageTakenAsChaos", "ElementalDamageTakenAsPhysical", "ElementalDamageTakenAsChaos" } },
	}, },
	{ label = "Chaos Hit/DoT", { format = "x {2:output:ChaosTakenHitMult} / x {2:output:ChaosTakenDotMult}",
		{ breakdown = "ChaosTakenHitMult" },
		{ breakdown = "ChaosTakenDotMult" },
		{ modName = { "DamageTaken", "DamageTakenWhenHit", "DamageTakenOverTime", "ChaosDamageTaken", "ChaosDamageTakenWhenHit", "ChaosDamageTakenOverTime", "ChaosDamageTakenAsPhysical", "ChaosDamageTakenAsFire", "ChaosDamageTakenAsCold", "ChaosDamageTakenAsLightning" } },
	}, },
	{ label = "Mind over Matter", haveOutput = "MindOverMatter", { format = "{0:output:MindOverMatter}%", 
		{ breakdown = "MindOverMatter" }, 
		{ modName = "DamageTakenFromManaBeforeLife" }, 
	}, },
	{ label = "Total Degen", haveOutput = "TotalDegen", { format = "{1:output:TotalDegen}", 
		{ breakdown = "TotalDegen" },
		{ label = "Sources", modName = { "PhysicalDegen", "FireDegen", "ColdDegen", "LightningDegen", "ChaosDegen" }, modType = "BASE" },
	}, },
	{ label = "Net Regen", haveOutput = "NetRegen", { format = "{1:output:NetRegen}", { breakdown = "NetRegen" }, }, },
} },
{ 1, "MiscDefences", 3, "Other Defences", colorCodes.DEFENCE, {
	{ label = "Movement Speed", { format = "x {2:output:EffectiveMovementSpeedMod}", { breakdown = "EffectiveMovementSpeedMod" }, { modName = "MovementSpeed" }, }, },
	{ label = "Dodge Chance", { format = "{0:output:AttackDodgeChance}%", { modName = "AttackDodgeChance" }, }, },
	{ label = "Spell Ddg. Chance", { format = "{0:output:SpellDodgeChance}%", { modName = "SpellDodgeChance" }, }, }, 
	{ label = "Block Chance", { format = "{0:output:BlockChance}%",
		{ breakdown = "BlockChance" },
		{ modName = "BlockChance" }, 
	}, },
	{ label = "Spell Block Chance", { format = "{0:output:SpellBlockChance}%", 
		{ breakdown = "SpellBlockChance" }, 
		{ modName = { "SpellBlockChance", "BlockChanceConv" }, },
	}, },
	{ label = "Melee Avoid Ch.", { format = "{0:output:MeleeAvoidChance}%", { breakdown = "MeleeAvoidChance" }, }, },
	{ label = "Projectile Avoid Ch.", { format = "{0:output:ProjectileAvoidChance}%", { breakdown = "ProjectileAvoidChance" }, }, },
	{ label = "Spell Avoid Ch.", { format = "{0:output:SpellAvoidChance}%", { breakdown = "SpellAvoidChance" }, }, },
	{ label = "Stun Avoid Chance", { format = "{0:output:StunAvoidChance}%", { modName = "AvoidStun" }, }, },
	{ label = "Stun Duration", { format = "{2:output:StunDuration}s", 
		{ breakdown = "StunDuration" },
		{ modName = "StunRecovery" },
	}, },
	{ label = "Block Duration", { format = "{2:output:BlockDuration}s", 
		{ breakdown = "BlockDuration" },
		{ modName = { "StunRecovery", "BlockRecovery" }, }, 
	}, },
	{ label = "Light Radius Mod", { format = "x {2:output:LightRadiusMod}", { breakdown = "LightRadiusMod" }, { modName = "LightRadius" }, }, },
} },
}