-- This file is automatically generated, do not edit!
-- Path of Building
--
-- Strength support gems
-- Skill data (c) Grinding Gear Games
--
local skills, mod, flag, skill = ...

skills["SupportAddedFireDamage"] = {
	name = "Added Fire Damage",
	color = 1,
	support = true,
	requireSkillTypes = { 10, 1, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 20), 
	},
	qualityMods = {
		mod("FireDamage", "INC", 0.5), --"fire_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("PhysicalDamageGainAsFire", "BASE", nil, 0, 0, nil), --"physical_damage_%_to_add_as_fire"
	},
	levels = {
		[1] = { 8, 25, },
		[2] = { 10, 26, },
		[3] = { 13, 27, },
		[4] = { 17, 28, },
		[5] = { 21, 29, },
		[6] = { 25, 30, },
		[7] = { 29, 31, },
		[8] = { 33, 32, },
		[9] = { 37, 33, },
		[10] = { 40, 34, },
		[11] = { 43, 35, },
		[12] = { 46, 36, },
		[13] = { 49, 37, },
		[14] = { 52, 38, },
		[15] = { 55, 39, },
		[16] = { 58, 40, },
		[17] = { 61, 41, },
		[18] = { 64, 42, },
		[19] = { 67, 43, },
		[20] = { 70, 44, },
		[21] = { 72, 45, },
		[22] = { 74, 46, },
		[23] = { 76, 47, },
		[24] = { 78, 48, },
		[25] = { 80, 49, },
		[26] = { 82, 50, },
		[27] = { 84, 51, },
		[28] = { 86, 52, },
		[29] = { 88, 53, },
		[30] = { 90, 54, },
	},
}
skills["SupportBloodMagic"] = {
	name = "Blood Magic",
	color = 1,
	support = true,
	requireSkillTypes = { },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		flag("SkillBloodMagic"), --"base_use_life_in_place_of_mana" = ?
	},
	qualityMods = {
		mod("ManaCost", "INC", -0.5), --"base_mana_cost_-%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("ManaCost", "MORE", nil), 
	},
	levels = {
		[1] = { 31, 145, },
		[2] = { 34, 142, },
		[3] = { 36, 139, },
		[4] = { 38, 137, },
		[5] = { 40, 134, },
		[6] = { 42, 132, },
		[7] = { 44, 129, },
		[8] = { 46, 126, },
		[9] = { 48, 124, },
		[10] = { 50, 121, },
		[11] = { 52, 118, },
		[12] = { 54, 116, },
		[13] = { 56, 113, },
		[14] = { 58, 111, },
		[15] = { 60, 108, },
		[16] = { 62, 105, },
		[17] = { 64, 103, },
		[18] = { 66, 100, },
		[19] = { 68, 97, },
		[20] = { 70, 96, },
		[21] = { 72, 93, },
		[22] = { 74, 90, },
		[23] = { 76, 87, },
		[24] = { 78, 84, },
		[25] = { 80, 81, },
		[26] = { 82, 78, },
		[27] = { 84, 75, },
		[28] = { 86, 72, },
		[29] = { 88, 69, },
		[30] = { 90, 66, },
	},
}
skills["SupportBloodlust"] = {
	name = "Bloodlust",
	color = 1,
	support = true,
	requireSkillTypes = { 24, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 25), 
		flag("CannotBleed"), --"cannot_cause_bleeding" = ?
	},
	qualityMods = {
		mod("PhysicalDamage", "INC", 0.5, ModFlag.Melee, 0, { type = "ActorCondition", actor = "enemy", var = "Bleeding" }), --"melee_damage_vs_bleeding_enemies_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("PhysicalDamage", "MORE", nil, ModFlag.Melee, 0, { type = "ActorCondition", actor = "enemy", var = "Bleeding" }), --"support_bloodlust_melee_physical_damage_+%_final_vs_bleeding_enemies"
	},
	levels = {
		[1] = { 18, 40, },
		[2] = { 22, 41, },
		[3] = { 26, 42, },
		[4] = { 29, 43, },
		[5] = { 32, 44, },
		[6] = { 35, 45, },
		[7] = { 38, 46, },
		[8] = { 41, 47, },
		[9] = { 44, 48, },
		[10] = { 47, 49, },
		[11] = { 50, 50, },
		[12] = { 53, 51, },
		[13] = { 56, 52, },
		[14] = { 58, 53, },
		[15] = { 60, 54, },
		[16] = { 62, 55, },
		[17] = { 64, 56, },
		[18] = { 66, 57, },
		[19] = { 68, 58, },
		[20] = { 70, 59, },
		[21] = { 72, 60, },
		[22] = { 74, 61, },
		[23] = { 76, 62, },
		[24] = { 78, 63, },
		[25] = { 80, 64, },
		[26] = { 82, 65, },
		[27] = { 84, 66, },
		[28] = { 86, 67, },
		[29] = { 88, 68, },
		[30] = { 90, 69, },
	},
}
skills["SupportCastOnMeleeKill"] = {
	name = "Cast on Melee Kill",
	color = 1,
	support = true,
	requireSkillTypes = { 24, 36, },
	addSkillTypes = { 42, },
	excludeSkillTypes = { 37, 41, 30, 44, 61, },
	baseMods = {
		mod("ManaCost", "MORE", 40), 
		skill("cooldown", 0.25), 
		--"cast_linked_spells_on_melee_kill_%" = 100
		skill("triggered", true, { type = "SkillType", skillType = SkillType.TriggerableSpell }), --"spell_uncastable_if_triggerable" = ?
	},
	qualityMods = {
		mod("Damage", "INC", 0.5, 0, 0, nil), --"damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "MORE", nil, ModFlag.Spell), --"support_cast_on_melee_kill_spell_damage_+%_final"
	},
	levels = {
		[1] = { 38, 20, },
		[2] = { 40, 21, },
		[3] = { 42, 22, },
		[4] = { 44, 23, },
		[5] = { 46, 24, },
		[6] = { 48, 25, },
		[7] = { 50, 26, },
		[8] = { 52, 27, },
		[9] = { 54, 28, },
		[10] = { 56, 29, },
		[11] = { 58, 30, },
		[12] = { 60, 31, },
		[13] = { 62, 32, },
		[14] = { 64, 33, },
		[15] = { 65, 34, },
		[16] = { 66, 35, },
		[17] = { 67, 36, },
		[18] = { 68, 37, },
		[19] = { 69, 38, },
		[20] = { 70, 39, },
		[21] = { 72, 40, },
		[22] = { 74, 41, },
		[23] = { 76, 42, },
		[24] = { 78, 43, },
		[25] = { 80, 44, },
		[26] = { 82, 45, },
		[27] = { 84, 46, },
		[28] = { 86, 47, },
		[29] = { 88, 48, },
		[30] = { 90, 49, },
	},
}
skills["SupportCastOnDamageTaken"] = {
	name = "Cast when Damage Taken",
	color = 1,
	support = true,
	requireSkillTypes = { 36, },
	addSkillTypes = { 42, },
	excludeSkillTypes = { 37, 41, 30, 44, 61, },
	baseMods = {
		skill("cooldown", 0.25), 
		--"cast_on_damage_taken_%" = 100
		skill("triggered", true, { type = "SkillType", skillType = SkillType.TriggerableSpell }), --"spell_uncastable_if_triggerable" = ?
		skill("showAverage", true), --"base_skill_show_average_damage_instead_of_dps" = ?
	},
	qualityMods = {
		mod("Damage", "INC", 0.5, 0, 0, nil), --"damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		--[2] = "cast_on_damage_taken_threshold"
		[3] = mod("Damage", "MORE", nil), --"cast_on_damage_taken_damage_+%_final"
		--[4] = "local_support_gem_max_skill_level_requirement_to_support"
	},
	levels = {
		[1] = { 38, 528, -70, 38, },
		[2] = { 40, 583, -66, 40, },
		[3] = { 42, 661, -62, 42, },
		[4] = { 44, 725, -58, 44, },
		[5] = { 46, 812, -54, 46, },
		[6] = { 48, 897, -50, 48, },
		[7] = { 50, 1003, -46, 50, },
		[8] = { 52, 1107, -42, 52, },
		[9] = { 54, 1221, -38, 54, },
		[10] = { 56, 1354, -34, 56, },
		[11] = { 58, 1485, -30, 58, },
		[12] = { 60, 1635, -26, 60, },
		[13] = { 62, 1804, -22, 62, },
		[14] = { 64, 1980, -18, 64, },
		[15] = { 65, 2184, -14, 65, },
		[16] = { 66, 2394, -10, 66, },
		[17] = { 67, 2621, -6, 67, },
		[18] = { 68, 2874, -2, 68, },
		[19] = { 69, 3142, 2, 69, },
		[20] = { 70, 3272, 6, 70, },
		[21] = { 72, 3580, 10, 72, },
		[22] = { 74, 3950, 14, 74, },
		[23] = { 76, 4350, 18, 76, },
		[24] = { 78, 4780, 22, 78, },
		[25] = { 80, 5240, 26, 80, },
		[26] = { 82, 5730, 30, 82, },
		[27] = { 84, 6250, 34, 84, },
		[28] = { 86, 6800, 38, 86, },
		[29] = { 88, 7380, 42, 88, },
		[30] = { 90, 7990, 46, 90, },
	},
}
skills["SupportColdToFire"] = {
	name = "Cold to Fire",
	color = 1,
	support = true,
	requireSkillTypes = { 10, 1, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 10), 
		mod("SkillColdDamageConvertToFire", "BASE", 50), --"skill_cold_damage_%_to_convert_to_fire" = 50
	},
	qualityMods = {
		mod("ColdDamage", "INC", 0.5), --"cold_damage_+%" = 0.5
		mod("FireDamage", "INC", 0.5), --"fire_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] =  mod("ColdDamageGainAsFire", "BASE", nil), --"cold_damage_%_to_add_as_fire"
	},
	levels = {
		[1] = { 18, 10, },
		[2] = { 22, 11, },
		[3] = { 26, 12, },
		[4] = { 29, 13, },
		[5] = { 32, 14, },
		[6] = { 35, 15, },
		[7] = { 38, 16, },
		[8] = { 41, 17, },
		[9] = { 44, 18, },
		[10] = { 47, 19, },
		[11] = { 50, 20, },
		[12] = { 53, 21, },
		[13] = { 56, 22, },
		[14] = { 58, 23, },
		[15] = { 60, 24, },
		[16] = { 62, 25, },
		[17] = { 64, 26, },
		[18] = { 66, 27, },
		[19] = { 68, 28, },
		[20] = { 70, 29, },
		[21] = { 72, 30, },
		[22] = { 74, 31, },
		[23] = { 76, 32, },
		[24] = { 78, 33, },
		[25] = { 80, 34, },
		[26] = { 82, 35, },
		[27] = { 84, 36, },
		[28] = { 86, 37, },
		[29] = { 88, 38, },
		[30] = { 90, 39, },
	},
}
skills["SupportAdditionalLevel"] = {
	name = "Empower",
	color = 1,
	support = true,
	requireSkillTypes = { },
	addSkillTypes = { },
	excludeSkillTypes = { },
	supportGemsOnly = true,
	baseMods = {
		mod("ManaCost", "MORE", 25), 
	},
	qualityMods = {
		--"local_gem_experience_gain_+%" = 5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("GemProperty", "LIST", { keyword = "active_skill", key = "level", value = nil }), --"supported_active_skill_gem_level_+"
	},
	levels = {
		[1] = { 1, 0, },
		[2] = { 10, 1, },
		[3] = { 45, 2, },
		[4] = { 60, 3, },
		[5] = { 75, 4, },
		[6] = { 90, 5, },
		[7] = { 100, 6, },
		[8] = { 100, 7, },
		[9] = { 100, 8, },
		[10] = { 100, 9, },
	},
}
skills["EnduranceChargeOnMeleeStun"] = {
	name = "Endurance Charge on Melee Stun",
	color = 1,
	support = true,
	requireSkillTypes = { 24, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 10), 
		--"gain_endurance_charge_on_melee_stun" = ?
	},
	qualityMods = {
		mod("EnemyStunDuration", "INC", 1), --"base_stun_duration_+%" = 1
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("EnemyStunThreshold", "INC", nil), --"base_stun_threshold_reduction_+%"
	},
	levels = {
		[1] = { 18, -0, },
		[2] = { 22, -1, },
		[3] = { 26, -2, },
		[4] = { 29, -3, },
		[5] = { 32, -4, },
		[6] = { 35, -5, },
		[7] = { 38, -6, },
		[8] = { 41, -7, },
		[9] = { 44, -8, },
		[10] = { 47, -9, },
		[11] = { 50, -10, },
		[12] = { 53, -11, },
		[13] = { 56, -12, },
		[14] = { 58, -13, },
		[15] = { 60, -14, },
		[16] = { 62, -15, },
		[17] = { 64, -16, },
		[18] = { 66, -17, },
		[19] = { 68, -18, },
		[20] = { 70, -19, },
		[21] = { 72, -20, },
		[22] = { 74, -21, },
		[23] = { 76, -22, },
		[24] = { 78, -23, },
		[25] = { 80, -24, },
		[26] = { 82, -25, },
		[27] = { 84, -26, },
		[28] = { 86, -27, },
		[29] = { 88, -28, },
		[30] = { 90, -29, },
	},
}
skills["SupportFirePenetration"] = {
	name = "Fire Penetration",
	color = 1,
	support = true,
	requireSkillTypes = { 10, 1, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 40), 
	},
	qualityMods = {
		mod("FireDamage", "INC", 0.5), --"fire_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("FirePenetration", "BASE", nil), --"base_reduce_enemy_fire_resistance_%"
	},
	levels = {
		[1] = { 31, 18, },
		[2] = { 34, 19, },
		[3] = { 36, 20, },
		[4] = { 38, 21, },
		[5] = { 40, 22, },
		[6] = { 42, 23, },
		[7] = { 44, 24, },
		[8] = { 46, 25, },
		[9] = { 48, 26, },
		[10] = { 50, 27, },
		[11] = { 52, 28, },
		[12] = { 54, 29, },
		[13] = { 56, 30, },
		[14] = { 58, 31, },
		[15] = { 60, 32, },
		[16] = { 62, 33, },
		[17] = { 64, 34, },
		[18] = { 66, 35, },
		[19] = { 68, 36, },
		[20] = { 70, 37, },
		[21] = { 72, 38, },
		[22] = { 74, 39, },
		[23] = { 76, 40, },
		[24] = { 78, 41, },
		[25] = { 80, 42, },
		[26] = { 82, 43, },
		[27] = { 84, 44, },
		[28] = { 86, 45, },
		[29] = { 88, 46, },
		[30] = { 90, 47, },
	},
}
skills["SupportFortify"] = {
	name = "Fortify",
	color = 1,
	support = true,
	requireSkillTypes = { 24, },
	addSkillTypes = { },
	excludeSkillTypes = { 47, },
	baseMods = {
		mod("ManaCost", "MORE", 10), 
		--"chance_to_fortify_on_melee_hit_+%" = 100
		mod("FortifyDuration", "INC", 25), --"fortify_duration_+%" = 25
	},
	qualityMods = {
		mod("FortifyDuration", "INC", 0.5), --"fortify_duration_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("PhysicalDamage", "INC", nil, ModFlag.Melee), --"melee_physical_damage_+%"
	},
	levels = {
		[1] = { 31, 25, },
		[2] = { 34, 26, },
		[3] = { 36, 27, },
		[4] = { 38, 28, },
		[5] = { 40, 29, },
		[6] = { 42, 30, },
		[7] = { 44, 31, },
		[8] = { 46, 32, },
		[9] = { 48, 33, },
		[10] = { 50, 34, },
		[11] = { 52, 35, },
		[12] = { 54, 36, },
		[13] = { 56, 37, },
		[14] = { 58, 38, },
		[15] = { 60, 39, },
		[16] = { 62, 40, },
		[17] = { 64, 41, },
		[18] = { 66, 42, },
		[19] = { 68, 43, },
		[20] = { 70, 44, },
		[21] = { 72, 45, },
		[22] = { 74, 46, },
		[23] = { 76, 47, },
		[24] = { 78, 48, },
		[25] = { 80, 49, },
		[26] = { 82, 50, },
		[27] = { 84, 51, },
		[28] = { 86, 52, },
		[29] = { 88, 53, },
		[30] = { 90, 54, },
	},
}
skills["SupportGenerosity"] = {
	name = "Generosity",
	color = 1,
	support = true,
	requireSkillTypes = { 44, },
	addSkillTypes = { },
	excludeSkillTypes = { 30, 32, },
	baseMods = {
		skill("auraCannotAffectSelf", true), --"aura_cannot_affect_self" = ?
	},
	qualityMods = {
		mod("AreaOfEffect", "INC", 2, 0, KeywordFlag.Aura), --"base_aura_area_of_effect_+%" = 2
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("AuraEffect", "INC", nil), --"non_curse_aura_effect_+%"
	},
	levels = {
		[1] = { 31, 20, },
		[2] = { 34, 21, },
		[3] = { 36, 22, },
		[4] = { 38, 23, },
		[5] = { 40, 24, },
		[6] = { 42, 25, },
		[7] = { 44, 26, },
		[8] = { 46, 27, },
		[9] = { 48, 28, },
		[10] = { 50, 29, },
		[11] = { 52, 30, },
		[12] = { 54, 31, },
		[13] = { 56, 32, },
		[14] = { 58, 33, },
		[15] = { 60, 34, },
		[16] = { 62, 35, },
		[17] = { 64, 36, },
		[18] = { 66, 37, },
		[19] = { 68, 38, },
		[20] = { 70, 39, },
		[21] = { 72, 40, },
		[22] = { 74, 41, },
		[23] = { 76, 42, },
		[24] = { 78, 43, },
		[25] = { 80, 44, },
		[26] = { 82, 45, },
		[27] = { 84, 46, },
		[28] = { 86, 47, },
		[29] = { 88, 48, },
		[30] = { 90, 49, },
	},
}
skills["SupportIncreasedBurningDamage"] = {
	name = "Increased Burning Damage",
	color = 1,
	support = true,
	requireSkillTypes = { 10, 1, 29, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 20), 
	},
	qualityMods = {
		mod("FireDamage", "INC", 0.5, ModFlag.Dot), --"burn_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("FireDamage", "INC", nil, ModFlag.Dot), --"burn_damage_+%"
	},
	levels = {
		[1] = { 31, 40, },
		[2] = { 34, 41, },
		[3] = { 36, 42, },
		[4] = { 38, 43, },
		[5] = { 40, 44, },
		[6] = { 42, 45, },
		[7] = { 44, 46, },
		[8] = { 46, 47, },
		[9] = { 48, 48, },
		[10] = { 50, 49, },
		[11] = { 52, 50, },
		[12] = { 54, 51, },
		[13] = { 56, 52, },
		[14] = { 58, 53, },
		[15] = { 60, 54, },
		[16] = { 62, 55, },
		[17] = { 64, 56, },
		[18] = { 66, 57, },
		[19] = { 68, 58, },
		[20] = { 70, 59, },
		[21] = { 72, 60, },
		[22] = { 74, 61, },
		[23] = { 76, 62, },
		[24] = { 78, 63, },
		[25] = { 80, 64, },
		[26] = { 82, 65, },
		[27] = { 84, 66, },
		[28] = { 86, 67, },
		[29] = { 88, 68, },
		[30] = { 90, 69, },
	},
}
skills["SupportIncreasedDuration"] = {
	name = "Increased Duration",
	color = 1,
	support = true,
	requireSkillTypes = { 12, 55, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 40), 
	},
	qualityMods = {
		mod("Duration", "INC", 0.5), --"skill_effect_duration_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Duration", "INC", nil), --"skill_effect_duration_+%"
	},
	levels = {
		[1] = { 31, 45, },
		[2] = { 34, 46, },
		[3] = { 36, 47, },
		[4] = { 38, 48, },
		[5] = { 40, 49, },
		[6] = { 42, 50, },
		[7] = { 44, 51, },
		[8] = { 46, 52, },
		[9] = { 48, 53, },
		[10] = { 50, 54, },
		[11] = { 52, 55, },
		[12] = { 54, 56, },
		[13] = { 56, 57, },
		[14] = { 58, 58, },
		[15] = { 60, 59, },
		[16] = { 62, 60, },
		[17] = { 64, 61, },
		[18] = { 66, 62, },
		[19] = { 68, 63, },
		[20] = { 70, 64, },
		[21] = { 72, 65, },
		[22] = { 74, 66, },
		[23] = { 76, 67, },
		[24] = { 78, 68, },
		[25] = { 80, 69, },
		[26] = { 82, 70, },
		[27] = { 84, 71, },
		[28] = { 86, 72, },
		[29] = { 88, 73, },
		[30] = { 90, 74, },
	},
}
skills["SupportIronGrip"] = {
	name = "Iron Grip",
	color = 1,
	support = true,
	requireSkillTypes = { 48, 56, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		flag("IronGrip"), --"keystone_strong_bowman" = ?
	},
	qualityMods = {
		mod("Damage", "INC", 0.5, ModFlag.Projectile), --"projectile_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "INC", nil, ModFlag.Projectile), --"projectile_damage_+%"
	},
	levels = {
		[1] = { 18, 0, },
		[2] = { 22, 2, },
		[3] = { 26, 4, },
		[4] = { 29, 6, },
		[5] = { 32, 8, },
		[6] = { 35, 10, },
		[7] = { 38, 12, },
		[8] = { 41, 14, },
		[9] = { 44, 16, },
		[10] = { 47, 18, },
		[11] = { 50, 20, },
		[12] = { 53, 22, },
		[13] = { 56, 24, },
		[14] = { 58, 26, },
		[15] = { 60, 28, },
		[16] = { 62, 30, },
		[17] = { 64, 32, },
		[18] = { 66, 34, },
		[19] = { 68, 36, },
		[20] = { 70, 38, },
		[21] = { 72, 40, },
		[22] = { 74, 42, },
		[23] = { 76, 44, },
		[24] = { 78, 46, },
		[25] = { 80, 48, },
		[26] = { 82, 50, },
		[27] = { 84, 52, },
		[28] = { 86, 54, },
		[29] = { 88, 56, },
		[30] = { 90, 58, },
	},
}
skills["SupportIronWill"] = {
	name = "Iron Will",
	color = 1,
	support = true,
	requireSkillTypes = { 10, 52, 59, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		flag("IronWill"), --"strong_casting" = ?
	},
	qualityMods = {
		mod("Damage", "INC", 0.5, ModFlag.Spell, 0, nil), --"spell_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Damage", "INC", nil, ModFlag.Spell, 0, nil), --"spell_damage_+%"
	},
	levels = {
		[1] = { 18, 0, },
		[2] = { 22, 2, },
		[3] = { 26, 4, },
		[4] = { 29, 6, },
		[5] = { 32, 8, },
		[6] = { 35, 10, },
		[7] = { 38, 12, },
		[8] = { 41, 14, },
		[9] = { 44, 16, },
		[10] = { 47, 18, },
		[11] = { 50, 20, },
		[12] = { 53, 22, },
		[13] = { 56, 24, },
		[14] = { 58, 26, },
		[15] = { 60, 28, },
		[16] = { 62, 30, },
		[17] = { 64, 32, },
		[18] = { 66, 34, },
		[19] = { 68, 36, },
		[20] = { 70, 38, },
		[21] = { 72, 40, },
		[22] = { 74, 42, },
		[23] = { 76, 44, },
		[24] = { 78, 46, },
		[25] = { 80, 48, },
		[26] = { 82, 50, },
		[27] = { 84, 52, },
		[28] = { 86, 54, },
		[29] = { 88, 56, },
		[30] = { 90, 58, },
	},
}
skills["SupportItemQuantity"] = {
	name = "Item Quantity",
	color = 1,
	support = true,
	requireSkillTypes = { 10, 1, 40, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
	},
	qualityMods = {
		mod("LootQuantity", "INC", 0.35), --"base_killed_monster_dropped_item_quantity_+%" = 0.35
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("LootQuantity", "INC", nil), --"base_killed_monster_dropped_item_quantity_+%"
	},
	levels = {
		[1] = { 24, 17, },
		[2] = { 27, 18, },
		[3] = { 30, 19, },
		[4] = { 33, 20, },
		[5] = { 36, 21, },
		[6] = { 39, 22, },
		[7] = { 42, 23, },
		[8] = { 45, 24, },
		[9] = { 48, 25, },
		[10] = { 50, 26, },
		[11] = { 52, 27, },
		[12] = { 54, 28, },
		[13] = { 56, 29, },
		[14] = { 58, 30, },
		[15] = { 60, 31, },
		[16] = { 62, 32, },
		[17] = { 64, 33, },
		[18] = { 66, 34, },
		[19] = { 68, 35, },
		[20] = { 70, 36, },
		[21] = { 72, 37, },
		[22] = { 74, 38, },
		[23] = { 76, 39, },
		[24] = { 78, 40, },
		[25] = { 80, 41, },
		[26] = { 82, 42, },
		[27] = { 84, 43, },
		[28] = { 86, 44, },
		[29] = { 88, 45, },
		[30] = { 90, 46, },
	},
}
skills["SupportKnockback"] = {
	name = "Knockback",
	color = 1,
	support = true,
	requireSkillTypes = { 10, 1, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("EnemyKnockbackDistance", "INC", 50), --"knockback_distance_+%" = 50
	},
	qualityMods = {
		mod("EnemyKnockbackChance", "BASE", 0.5), --"base_global_chance_to_knockback_%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("EnemyKnockbackChance", "BASE", nil), --"base_global_chance_to_knockback_%"
	},
	levels = {
		[1] = { 8, 25, },
		[2] = { 10, 26, },
		[3] = { 13, 27, },
		[4] = { 17, 28, },
		[5] = { 21, 29, },
		[6] = { 25, 30, },
		[7] = { 29, 31, },
		[8] = { 33, 32, },
		[9] = { 37, 33, },
		[10] = { 40, 34, },
		[11] = { 43, 35, },
		[12] = { 46, 36, },
		[13] = { 49, 37, },
		[14] = { 52, 38, },
		[15] = { 55, 39, },
		[16] = { 58, 40, },
		[17] = { 61, 41, },
		[18] = { 64, 42, },
		[19] = { 67, 43, },
		[20] = { 70, 44, },
		[21] = { 72, 45, },
		[22] = { 74, 46, },
		[23] = { 76, 47, },
		[24] = { 78, 48, },
		[25] = { 80, 49, },
		[26] = { 82, 50, },
		[27] = { 84, 51, },
		[28] = { 86, 52, },
		[29] = { 88, 53, },
		[30] = { 90, 54, },
	},
}
skills["SupportReducedDuration"] = {
	name = "Less Duration",
	color = 1,
	support = true,
	requireSkillTypes = { 12, 55, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 20), 
	},
	qualityMods = {
		mod("Duration", "INC", -0.5), --"skill_effect_duration_+%" = -0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Duration", "MORE", nil), --"support_reduced_duration_skill_effect_duration_+%_final"
		[3] = mod("Damage", "MORE", nil), --"support_reduced_duration_damage_+%_final"
	},
	levels = {
		[1] = { 31, -40, 10, },
		[2] = { 34, -40, 10, },
		[3] = { 36, -41, 11, },
		[4] = { 38, -41, 11, },
		[5] = { 40, -42, 12, },
		[6] = { 42, -42, 12, },
		[7] = { 44, -43, 13, },
		[8] = { 46, -43, 13, },
		[9] = { 48, -44, 14, },
		[10] = { 50, -44, 14, },
		[11] = { 52, -45, 15, },
		[12] = { 54, -45, 15, },
		[13] = { 56, -46, 16, },
		[14] = { 58, -46, 16, },
		[15] = { 60, -47, 17, },
		[16] = { 62, -47, 17, },
		[17] = { 64, -48, 18, },
		[18] = { 66, -48, 18, },
		[19] = { 68, -49, 19, },
		[20] = { 70, -49, 19, },
		[21] = { 72, -50, 20, },
		[22] = { 74, -50, 20, },
		[23] = { 76, -51, 21, },
		[24] = { 78, -51, 21, },
		[25] = { 80, -52, 22, },
		[26] = { 82, -52, 22, },
		[27] = { 84, -53, 23, },
		[28] = { 86, -53, 23, },
		[29] = { 88, -54, 24, },
		[30] = { 90, -54, 24, },
	},
}
skills["SupportLifeGainOnHit"] = {
	name = "Life Gain on Hit",
	color = 1,
	support = true,
	requireSkillTypes = { 1, 56, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 50), 
	},
	qualityMods = {
		mod("LifeOnHit", "BASE", 0.5, ModFlag.Attack, 0, nil), --"base_life_gain_per_target" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("LifeOnHit", "BASE", nil, ModFlag.Attack, 0, nil), --"base_life_gain_per_target"
	},
	levels = {
		[1] = { 8, 6, },
		[2] = { 10, 8, },
		[3] = { 13, 10, },
		[4] = { 17, 12, },
		[5] = { 21, 14, },
		[6] = { 25, 16, },
		[7] = { 29, 18, },
		[8] = { 33, 20, },
		[9] = { 37, 22, },
		[10] = { 40, 24, },
		[11] = { 43, 26, },
		[12] = { 46, 28, },
		[13] = { 49, 30, },
		[14] = { 52, 32, },
		[15] = { 55, 34, },
		[16] = { 58, 36, },
		[17] = { 61, 38, },
		[18] = { 64, 40, },
		[19] = { 67, 42, },
		[20] = { 70, 44, },
		[21] = { 72, 46, },
		[22] = { 74, 48, },
		[23] = { 76, 50, },
		[24] = { 78, 52, },
		[25] = { 80, 54, },
		[26] = { 82, 56, },
		[27] = { 84, 58, },
		[28] = { 86, 60, },
		[29] = { 88, 62, },
		[30] = { 90, 64, },
	},
}
skills["SupportLifeLeech"] = {
	name = "Life Leech",
	color = 1,
	support = true,
	requireSkillTypes = { 10, 1, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 30), 
		mod("DamageLifeLeech", "BASE", 2), --"life_leech_from_any_damage_permyriad" = 200
	},
	qualityMods = {
		mod("LifeLeechRate", "INC", 0.5), --"life_leech_speed_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("LifeLeechRate", "INC", nil), --"life_leech_speed_+%"
	},
	levels = {
		[1] = { 31, 0, },
		[2] = { 34, 2, },
		[3] = { 36, 4, },
		[4] = { 38, 6, },
		[5] = { 40, 8, },
		[6] = { 42, 10, },
		[7] = { 44, 12, },
		[8] = { 46, 14, },
		[9] = { 48, 16, },
		[10] = { 50, 18, },
		[11] = { 52, 20, },
		[12] = { 54, 22, },
		[13] = { 56, 24, },
		[14] = { 58, 26, },
		[15] = { 60, 28, },
		[16] = { 62, 30, },
		[17] = { 64, 32, },
		[18] = { 66, 34, },
		[19] = { 68, 36, },
		[20] = { 70, 38, },
		[21] = { 72, 40, },
		[22] = { 74, 42, },
		[23] = { 76, 44, },
		[24] = { 78, 46, },
		[25] = { 80, 48, },
		[26] = { 82, 50, },
		[27] = { 84, 52, },
		[28] = { 86, 54, },
		[29] = { 88, 56, },
		[30] = { 90, 58, },
	},
}
skills["SupportMeleeDamageOnFullLife"] = {
	name = "Melee Damage on Full Life",
	color = 1,
	support = true,
	requireSkillTypes = { 24, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 30), 
	},
	qualityMods = {
		mod("PhysicalDamage", "INC", 0.5, ModFlag.Melee), --"melee_physical_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("PhysicalDamage", "MORE", nil, ModFlag.Melee, 0, { type = "Condition", var = "FullLife" }), --"support_melee_physical_damage_+%_final_while_on_full_life"
	},
	levels = {
		[1] = { 18, 30, },
		[2] = { 22, 31, },
		[3] = { 26, 32, },
		[4] = { 29, 33, },
		[5] = { 32, 34, },
		[6] = { 35, 35, },
		[7] = { 38, 36, },
		[8] = { 41, 37, },
		[9] = { 44, 38, },
		[10] = { 47, 39, },
		[11] = { 50, 40, },
		[12] = { 53, 41, },
		[13] = { 56, 42, },
		[14] = { 58, 43, },
		[15] = { 60, 44, },
		[16] = { 62, 45, },
		[17] = { 64, 46, },
		[18] = { 66, 47, },
		[19] = { 68, 48, },
		[20] = { 70, 49, },
		[21] = { 72, 50, },
		[22] = { 74, 51, },
		[23] = { 76, 52, },
		[24] = { 78, 53, },
		[25] = { 80, 54, },
		[26] = { 82, 55, },
		[27] = { 84, 56, },
		[28] = { 86, 57, },
		[29] = { 88, 58, },
		[30] = { 90, 59, },
	},
}
skills["SupportMeleePhysicalDamage"] = {
	name = "Melee Physical Damage",
	color = 1,
	support = true,
	requireSkillTypes = { 24, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 40), 
	},
	qualityMods = {
		mod("PhysicalDamage", "INC", 0.5, ModFlag.Melee), --"melee_physical_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("PhysicalDamage", "MORE", nil, ModFlag.Melee), --"support_melee_physical_damage_+%_final"
	},
	levels = {
		[1] = { 18, 30, },
		[2] = { 22, 31, },
		[3] = { 26, 32, },
		[4] = { 29, 33, },
		[5] = { 32, 34, },
		[6] = { 35, 35, },
		[7] = { 38, 36, },
		[8] = { 41, 37, },
		[9] = { 44, 38, },
		[10] = { 47, 39, },
		[11] = { 50, 40, },
		[12] = { 53, 41, },
		[13] = { 56, 42, },
		[14] = { 58, 43, },
		[15] = { 60, 44, },
		[16] = { 62, 45, },
		[17] = { 64, 46, },
		[18] = { 66, 47, },
		[19] = { 68, 48, },
		[20] = { 70, 49, },
		[21] = { 72, 50, },
		[22] = { 74, 51, },
		[23] = { 76, 52, },
		[24] = { 78, 53, },
		[25] = { 80, 54, },
		[26] = { 82, 55, },
		[27] = { 84, 56, },
		[28] = { 86, 57, },
		[29] = { 88, 58, },
		[30] = { 90, 59, },
	},
}
skills["SupportMeleeSplash"] = {
	name = "Melee Splash",
	color = 1,
	support = true,
	requireSkillTypes = { 25, },
	addSkillTypes = { 11, },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 60), 
		--"support_melee_splash_damage_+%_final" = 0
		--"melee_splash" = ?
	},
	qualityMods = {
		mod("AreaOfEffect", "INC", 0.5), --"base_skill_area_of_effect_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		--[2] = "support_melee_splash_damage_+%_final_for_splash"
		--[3] = "melee_splash_area_of_effect_+%_final"
	},
	levels = {
		[1] = { 8, -35, 0, },
		[2] = { 10, -35, 3, },
		[3] = { 13, -34, 6, },
		[4] = { 17, -34, 9, },
		[5] = { 21, -33, 12, },
		[6] = { 25, -33, 15, },
		[7] = { 29, -32, 18, },
		[8] = { 33, -32, 21, },
		[9] = { 37, -31, 24, },
		[10] = { 40, -31, 27, },
		[11] = { 43, -30, 30, },
		[12] = { 46, -30, 33, },
		[13] = { 49, -29, 36, },
		[14] = { 52, -29, 39, },
		[15] = { 55, -28, 42, },
		[16] = { 58, -28, 45, },
		[17] = { 61, -27, 48, },
		[18] = { 64, -27, 51, },
		[19] = { 67, -26, 54, },
		[20] = { 70, -26, 57, },
		[21] = { 72, -25, 60, },
		[22] = { 74, -25, 63, },
		[23] = { 76, -24, 66, },
		[24] = { 78, -24, 69, },
		[25] = { 80, -23, 72, },
		[26] = { 82, -23, 75, },
		[27] = { 84, -22, 78, },
		[28] = { 86, -22, 81, },
		[29] = { 88, -21, 84, },
		[30] = { 90, -21, 87, },
	},
}
skills["SupportMultistrike"] = {
	name = "Multistrike",
	color = 1,
	support = true,
	requireSkillTypes = { 28, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 80), 
		--"base_melee_attack_repeat_count" = 2
		mod("Damage", "MORE", -30, ModFlag.Attack), --"support_multiple_attack_damage_+%_final" = -30
	},
	qualityMods = {
		mod("PhysicalDamage", "INC", 0.5, ModFlag.Melee), --"melee_physical_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("Speed", "MORE", nil, ModFlag.Attack), --"support_multiple_attacks_melee_attack_speed_+%_final"
	},
	levels = {
		[1] = { 38, 75, },
		[2] = { 40, 76, },
		[3] = { 42, 77, },
		[4] = { 44, 78, },
		[5] = { 46, 79, },
		[6] = { 48, 80, },
		[7] = { 50, 81, },
		[8] = { 52, 82, },
		[9] = { 54, 83, },
		[10] = { 56, 84, },
		[11] = { 58, 85, },
		[12] = { 60, 86, },
		[13] = { 62, 87, },
		[14] = { 64, 88, },
		[15] = { 65, 89, },
		[16] = { 66, 90, },
		[17] = { 67, 91, },
		[18] = { 68, 92, },
		[19] = { 69, 93, },
		[20] = { 70, 94, },
		[21] = { 72, 95, },
		[22] = { 74, 96, },
		[23] = { 76, 97, },
		[24] = { 78, 98, },
		[25] = { 80, 99, },
		[26] = { 82, 100, },
		[27] = { 84, 101, },
		[28] = { 86, 102, },
		[29] = { 88, 103, },
		[30] = { 90, 104, },
	},
}
skills["SupportRangedAttackTotem"] = {
	name = "Ranged Attack Totem",
	color = 1,
	support = true,
	requireSkillTypes = { 22, },
	addSkillTypes = { 12, 17, 19, 30, },
	excludeSkillTypes = { },
	addFlags = {
		totem = true,
	},
	baseMods = {
		mod("ManaCost", "MORE", 100), 
		--"is_totem" = 1
		--"base_totem_duration" = 8000
		--"base_totem_range" = 60
		mod("Speed", "MORE", -30, ModFlag.Attack), --"support_attack_totem_attack_speed_+%_final" = -30
		--"base_skill_is_totemified" = ?
		--"disable_skill_if_melee_attack" = ?
	},
	qualityMods = {
		mod("TotemPlacementSpeed", "INC", 1), --"summon_totem_cast_speed_+%" = 1
	},
	levelMods = {
		[1] = nil, 
		[2] = skill("totemLevel", nil), --"totem_support_gem_level"
		[3] = mod("Damage", "MORE", nil), --"support_totem_damage_+%_final"
	},
	levels = {
		[1] = { 8, 8, -35, },
		[2] = { 10, 10, -35, },
		[3] = { 13, 13, -34, },
		[4] = { 17, 17, -34, },
		[5] = { 21, 21, -33, },
		[6] = { 25, 25, -33, },
		[7] = { 29, 29, -32, },
		[8] = { 33, 33, -32, },
		[9] = { 37, 37, -31, },
		[10] = { 40, 40, -31, },
		[11] = { 43, 43, -30, },
		[12] = { 46, 46, -30, },
		[13] = { 49, 49, -29, },
		[14] = { 52, 52, -29, },
		[15] = { 55, 55, -28, },
		[16] = { 58, 58, -28, },
		[17] = { 61, 61, -27, },
		[18] = { 64, 64, -27, },
		[19] = { 67, 67, -26, },
		[20] = { 70, 70, -26, },
		[21] = { 72, 72, -25, },
		[22] = { 74, 74, -25, },
		[23] = { 76, 76, -24, },
		[24] = { 78, 78, -24, },
		[25] = { 80, 80, -23, },
		[26] = { 82, 82, -23, },
		[27] = { 84, 84, -22, },
		[28] = { 86, 86, -22, },
		[29] = { 88, 88, -21, },
		[30] = { 90, 90, -21, },
	},
}
skills["SupportReducedMana"] = {
	name = "Reduced Mana",
	color = 1,
	support = true,
	requireSkillTypes = { },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
	},
	qualityMods = {
		mod("ManaCost", "INC", -0.25), --"base_mana_cost_-%" = 0.25
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("ManaCost", "INC", nil), --"base_mana_cost_-%"
	},
	levels = {
		[1] = { 31, -25, },
		[2] = { 34, -25, },
		[3] = { 36, -26, },
		[4] = { 38, -26, },
		[5] = { 40, -27, },
		[6] = { 42, -27, },
		[7] = { 44, -28, },
		[8] = { 46, -28, },
		[9] = { 48, -29, },
		[10] = { 50, -29, },
		[11] = { 52, -30, },
		[12] = { 54, -30, },
		[13] = { 56, -31, },
		[14] = { 58, -31, },
		[15] = { 60, -32, },
		[16] = { 62, -32, },
		[17] = { 64, -33, },
		[18] = { 66, -33, },
		[19] = { 68, -34, },
		[20] = { 70, -34, },
		[21] = { 72, -35, },
		[22] = { 74, -35, },
		[23] = { 76, -36, },
		[24] = { 78, -36, },
		[25] = { 80, -37, },
		[26] = { 82, -37, },
		[27] = { 84, -38, },
		[28] = { 86, -38, },
		[29] = { 88, -39, },
		[30] = { 90, -39, },
	},
}
skills["SupportSpellTotem"] = {
	name = "Spell Totem",
	color = 1,
	support = true,
	requireSkillTypes = { 18, },
	addSkillTypes = { 12, 17, 19, 30, },
	excludeSkillTypes = { 61, },
	addFlags = {
		totem = true,
	},
	baseMods = {
		mod("ManaCost", "MORE", 100), 
		--"is_totem" = 1
		--"base_totem_duration" = 8000
		--"base_totem_range" = 60
		mod("Speed", "MORE", -30, ModFlag.Cast), --"support_spell_totem_cast_speed_+%_final" = -30
		--"base_skill_is_totemified" = ?
	},
	qualityMods = {
		mod("TotemPlacementSpeed", "INC", 1), --"summon_totem_cast_speed_+%" = 1
	},
	levelMods = {
		[1] = nil, 
		[2] = skill("totemLevel", nil), --"totem_support_gem_level"
		[3] = mod("Damage", "MORE", nil), --"support_totem_damage_+%_final"
	},
	levels = {
		[1] = { 8, 8, -35, },
		[2] = { 10, 10, -35, },
		[3] = { 13, 13, -34, },
		[4] = { 17, 17, -34, },
		[5] = { 21, 21, -33, },
		[6] = { 25, 25, -33, },
		[7] = { 29, 29, -32, },
		[8] = { 33, 33, -32, },
		[9] = { 37, 37, -31, },
		[10] = { 40, 40, -31, },
		[11] = { 43, 43, -30, },
		[12] = { 46, 46, -30, },
		[13] = { 49, 49, -29, },
		[14] = { 52, 52, -29, },
		[15] = { 55, 55, -28, },
		[16] = { 58, 58, -28, },
		[17] = { 61, 61, -27, },
		[18] = { 64, 64, -27, },
		[19] = { 67, 67, -26, },
		[20] = { 70, 70, -26, },
		[21] = { 72, 72, -25, },
		[22] = { 74, 74, -25, },
		[23] = { 76, 76, -24, },
		[24] = { 78, 78, -24, },
		[25] = { 80, 80, -23, },
		[26] = { 82, 82, -23, },
		[27] = { 84, 84, -22, },
		[28] = { 86, 86, -22, },
		[29] = { 88, 88, -21, },
		[30] = { 90, 90, -21, },
	},
}
skills["SupportStun"] = {
	name = "Stun",
	color = 1,
	support = true,
	requireSkillTypes = { 10, 1, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
	},
	qualityMods = {
		mod("EnemyStunDuration", "INC", 1.5), --"base_stun_duration_+%" = 1.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("EnemyStunThreshold", "INC", nil), --"base_stun_threshold_reduction_+%"
	},
	levels = {
		[1] = { 8, -30, },
		[2] = { 10, -31, },
		[3] = { 13, -32, },
		[4] = { 17, -33, },
		[5] = { 21, -34, },
		[6] = { 25, -35, },
		[7] = { 29, -36, },
		[8] = { 33, -37, },
		[9] = { 37, -38, },
		[10] = { 40, -39, },
		[11] = { 43, -40, },
		[12] = { 46, -41, },
		[13] = { 49, -42, },
		[14] = { 52, -43, },
		[15] = { 55, -44, },
		[16] = { 58, -45, },
		[17] = { 61, -46, },
		[18] = { 64, -47, },
		[19] = { 67, -48, },
		[20] = { 70, -49, },
		[21] = { 72, -50, },
		[22] = { 74, -51, },
		[23] = { 76, -52, },
		[24] = { 78, -53, },
		[25] = { 80, -54, },
		[26] = { 82, -55, },
		[27] = { 84, -56, },
		[28] = { 86, -57, },
		[29] = { 88, -58, },
		[30] = { 90, -59, },
	},
}
skills["SupportWeaponElementalDamage"] = {
	name = "Weapon Elemental Damage",
	color = 1,
	support = true,
	requireSkillTypes = { 1, 56, },
	addSkillTypes = { },
	excludeSkillTypes = { },
	baseMods = {
		mod("ManaCost", "MORE", 40), 
	},
	qualityMods = {
		mod("ElementalDamage", "INC", 0.5, ModFlag.Weapon), --"weapon_elemental_damage_+%" = 0.5
	},
	levelMods = {
		[1] = nil, 
		[2] = mod("ElementalDamage", "MORE", nil, ModFlag.Weapon), --"support_weapon_elemental_damage_+%_final"
	},
	levels = {
		[1] = { 18, 40, },
		[2] = { 22, 41, },
		[3] = { 26, 42, },
		[4] = { 29, 43, },
		[5] = { 32, 44, },
		[6] = { 35, 45, },
		[7] = { 38, 46, },
		[8] = { 41, 47, },
		[9] = { 44, 48, },
		[10] = { 47, 49, },
		[11] = { 50, 50, },
		[12] = { 53, 51, },
		[13] = { 56, 52, },
		[14] = { 58, 53, },
		[15] = { 60, 54, },
		[16] = { 62, 55, },
		[17] = { 64, 56, },
		[18] = { 66, 57, },
		[19] = { 68, 58, },
		[20] = { 70, 59, },
		[21] = { 72, 60, },
		[22] = { 74, 61, },
		[23] = { 76, 62, },
		[24] = { 78, 63, },
		[25] = { 80, 64, },
		[26] = { 82, 65, },
		[27] = { 84, 66, },
		[28] = { 86, 67, },
		[29] = { 88, 68, },
		[30] = { 90, 69, },
	},
}