/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.OptionalInt;

public class CharacterHit {
    private final OptionalInt charIdx;
    private final int insertionIndex;

    public static CharacterHit insertionAt(int insertionIndex) {
        return new CharacterHit(OptionalInt.empty(), insertionIndex);
    }

    public static CharacterHit leadingHalfOf(int charIdx) {
        return new CharacterHit(OptionalInt.of(charIdx), charIdx);
    }

    public static CharacterHit trailingHalfOf(int charIdx) {
        return new CharacterHit(OptionalInt.of(charIdx), charIdx + 1);
    }

    private CharacterHit(OptionalInt charIdx, int insertionIndex) {
        this.charIdx = charIdx;
        this.insertionIndex = insertionIndex;
    }

    public OptionalInt getCharacterIndex() {
        return this.charIdx;
    }

    public int getInsertionIndex() {
        return this.insertionIndex;
    }

    public CharacterHit offset(int offsetAmount) {
        return new CharacterHit(this.charIdx.isPresent() ? OptionalInt.of(this.charIdx.getAsInt() + offsetAmount) : this.charIdx, this.insertionIndex + offsetAmount);
    }
}

