/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.List;
import java.util.function.Function;
import javafx.collections.ObservableList;
import org.reactfx.Subscription;
import org.reactfx.collection.LiveList;
import org.reactfx.collection.LiveListBase;
import org.reactfx.collection.QuasiListChange;
import org.reactfx.collection.QuasiListModification;
import org.reactfx.collection.UnmodifiableByDefaultLiveList;
import org.reactfx.util.Lists;

class MappedList<E, F>
extends LiveListBase<F>
implements UnmodifiableByDefaultLiveList<F> {
    private final ObservableList<? extends E> source;
    private final Function<? super E, ? extends F> mapper;

    public MappedList(ObservableList<? extends E> source, Function<? super E, ? extends F> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    public F get(int index) {
        return this.mapper.apply(this.source.get(index));
    }

    @Override
    public int size() {
        return this.source.size();
    }

    @Override
    protected Subscription observeInputs() {
        return LiveList.observeQuasiChanges(this.source, this::sourceChanged);
    }

    private void sourceChanged(QuasiListChange<? extends E> change) {
        this.notifyObservers(MappedList.mappedChangeView(change, this.mapper));
    }

    static <E, F> QuasiListChange<F> mappedChangeView(final QuasiListChange<? extends E> change, final Function<? super E, ? extends F> mapper) {
        return new QuasiListChange<F>(){

            @Override
            public List<? extends QuasiListModification<? extends F>> getModifications() {
                List mods = change.getModifications();
                return Lists.mappedView(mods, mod -> new QuasiListModification<F>((QuasiListModification)mod, mapper){
                    final /* synthetic */ QuasiListModification val$mod;
                    final /* synthetic */ Function val$mapper;
                    {
                        this.val$mod = quasiListModification;
                        this.val$mapper = function;
                    }

                    @Override
                    public int getFrom() {
                        return this.val$mod.getFrom();
                    }

                    @Override
                    public int getAddedSize() {
                        return this.val$mod.getAddedSize();
                    }

                    @Override
                    public List<? extends F> getRemoved() {
                        return Lists.mappedView(this.val$mod.getRemoved(), this.val$mapper);
                    }
                });
            }
        };
    }
}

