/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.posick.mDNS.utils.Misc;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SingleNameBase;

public class MulticastDNSUtils {
    private static final Logger logger = Misc.getLogger(MulticastDNSUtils.class, Options.check((String)"mdns_verbose"));
    public static final Record[] EMPTY_RECORDS = new Record[0];

    public static boolean answersAll(Message query, Message response) {
        switch (response.getHeader().getOpcode()) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                int index = 0;
                Record[] qRecords = MulticastDNSUtils.extractRecords(query, 0);
                Record[] rRecords = MulticastDNSUtils.extractRecords(response, 0);
                boolean[] similarArray = new boolean[qRecords.length];
                for (Record qRecord : qRecords) {
                    similarArray[index] = false;
                    for (Record rRecord : rRecords) {
                        if (!qRecord.getName().equals((Object)rRecord.getName()) || rRecord.getType() != 255 && qRecord.getType() != rRecord.getType()) continue;
                        similarArray[index] = true;
                        break;
                    }
                    ++index;
                }
                for (boolean similar : similarArray) {
                    if (similar) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean answersAny(Message query, Message response) {
        Header h = response.getHeader();
        if (!h.getFlag(0)) {
            return false;
        }
        switch (h.getOpcode()) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                Record[] qRecords = MulticastDNSUtils.extractRecords(query, 0);
                Record[] rRecords = MulticastDNSUtils.extractRecords(response, 1, 3, 2);
                for (Record qRecord : qRecords) {
                    for (Record rRecord : rRecords) {
                        if (!qRecord.getName().equals((Object)rRecord.getName()) || qRecord.getType() != 255 && qRecord.getType() != rRecord.getType()) continue;
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    public static Record clone(Record record) {
        return record.cloneRecord();
    }

    public static Record[] extractRecords(Message message, int ... sections) {
        Record[] records = EMPTY_RECORDS;
        for (int section : sections) {
            Record[] tempRecords = message.getSectionArray(section);
            if (tempRecords == null || tempRecords.length <= 0) continue;
            int size = records.length + tempRecords.length;
            Record[] newRecords = new Record[size];
            System.arraycopy(records, 0, newRecords, 0, records.length);
            System.arraycopy(tempRecords, 0, newRecords, records.length, tempRecords.length);
            records = newRecords;
        }
        return records;
    }

    public static final Record[] extractRecords(RRset rrset) {
        if (rrset == null) {
            return new Record[0];
        }
        Record[] results = new Record[rrset.size()];
        if (results.length > 0) {
            int index = 0;
            Iterator iterator = rrset.rrs(false);
            if (iterator != null) {
                while (iterator.hasNext()) {
                    results[index++] = (Record)iterator.next();
                }
            }
        }
        return results;
    }

    public static final Record[] extractRecords(RRset[] rrs) {
        if (rrs == null || rrs.length == 0) {
            return EMPTY_RECORDS;
        }
        int capacity = 0;
        for (RRset rr : rrs) {
            capacity += rr.size();
        }
        Record[] results = new Record[capacity];
        int index = 0;
        for (RRset rr : rrs) {
            Record[] records;
            for (Record record : records = MulticastDNSUtils.extractRecords(rr)) {
                results[index++] = record;
            }
        }
        return results;
    }

    public static String getHostName() {
        String hostname = System.getenv().get("HOSTNAME");
        if (hostname == null || hostname.trim().length() == 0) {
            hostname = System.getenv().get("COMPUTERNAME");
        }
        if (hostname == null || hostname.trim().length() == 0) {
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                hostname = localhost.getHostName();
                if (hostname == null || hostname.startsWith("unknown")) {
                    hostname = localhost.getCanonicalHostName();
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return hostname;
    }

    public static InetAddress[] getLocalAddresses() {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> enet = NetworkInterface.getNetworkInterfaces();
            while (enet.hasMoreElements()) {
                NetworkInterface net = enet.nextElement();
                if (net.isLoopback()) continue;
                Enumeration<InetAddress> eaddr = net.getInetAddresses();
                while (eaddr.hasMoreElements()) {
                    addresses.add(eaddr.nextElement());
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return addresses.toArray(new InetAddress[addresses.size()]);
    }

    public static String getMachineName() {
        String name = null;
        try {
            Enumeration<NetworkInterface> enet = NetworkInterface.getNetworkInterfaces();
            block2: while (enet.hasMoreElements() && name == null) {
                NetworkInterface net = enet.nextElement();
                if (net.isLoopback()) continue;
                Enumeration<InetAddress> eaddr = net.getInetAddresses();
                while (eaddr.hasMoreElements()) {
                    InetAddress inet = eaddr.nextElement();
                    if (inet.getCanonicalHostName().equalsIgnoreCase(inet.getHostAddress())) continue;
                    name = inet.getCanonicalHostName();
                    continue block2;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return name;
    }

    public static Name getTargetFromRecord(Record record) {
        if (record instanceof SingleNameBase) {
            return ((SingleNameBase)record).getSingleName();
        }
        try {
            Object target;
            Method method = record.getClass().getMethod("getTarget", new Class[0]);
            if (method != null && (target = method.invoke((Object)record, new Object[0])) instanceof Name) {
                return (Name)target;
            }
        }
        catch (Exception e) {
            logger.logp(Level.FINE, MulticastDNSUtils.class.getName(), "getTargetFromRecord", "No target specified in record " + record.getClass().getSimpleName() + ": " + record);
        }
        return null;
    }

    public static boolean messagesEqual(Message message1, Message message2) {
        boolean headerEqual;
        Header queryHeader;
        if (message1 == message2) {
            return true;
        }
        if (message1 == null || message2 == null) {
            return false;
        }
        Header responseHeader = message1.getHeader();
        if (responseHeader == (queryHeader = message2.getHeader())) {
            headerEqual = false;
        } else if (responseHeader == null || queryHeader == null) {
            headerEqual = false;
        } else {
            boolean[] queryFlags;
            boolean[] responseFlags = responseHeader.getFlags();
            if (!Arrays.equals(responseFlags, queryFlags = queryHeader.getFlags())) {
                return false;
            }
            headerEqual = responseHeader.getOpcode() == queryHeader.getOpcode() && responseHeader.getRcode() == queryHeader.getRcode();
        }
        return headerEqual && Arrays.equals(MulticastDNSUtils.extractRecords(message2, 0, 1, 2, 3), MulticastDNSUtils.extractRecords(message1, 0, 1, 2, 3));
    }

    public static Message newQueryResponse(Record[] records, int section) {
        Message message = new Message();
        Header header = message.getHeader();
        header.setRcode(0);
        header.setOpcode(0);
        header.setFlag(0);
        for (int index = 0; index < records.length; ++index) {
            message.addRecord(records[index], section);
        }
        return message;
    }

    public static void setDClassForRecord(Record record, int dclass) {
        record.dclass = dclass;
    }

    public static void setTLLForRecord(Record record, long ttl) {
        record.setTTL(ttl);
    }

    public static Message[] splitMessage(Message message) {
        ArrayList<Message> messages = new ArrayList<Message>();
        int maxRecords = Options.intValue((String)"mdns_max_records_per_message");
        if (maxRecords > 1) {
            maxRecords = 10;
        }
        Message m = null;
        for (int section : new int[]{0, 1, 2, 3}) {
            Record[] records = message.getSectionArray(section);
            for (int index = 0; index < records.length; ++index) {
                if (m == null) {
                    m = new Message();
                    Header header = (Header)message.getHeader().clone();
                    header.setCount(0, 0);
                    header.setCount(1, 0);
                    header.setCount(2, 0);
                    header.setCount(3, 0);
                    m.setHeader(header);
                    m.addRecord(records[index], section);
                } else {
                    m.addRecord(records[index], section);
                }
                if (index == 0 || index % maxRecords != 0) continue;
                messages.add(m);
                m = null;
            }
        }
        return messages.toArray(new Message[messages.size()]);
    }
}

