/*
 * Decompiled with CFR 0.152.
 */
package net.posick.mDNS.utils;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerProcessor<T>
implements Closeable {
    private static final Logger logger = Logger.getLogger(ListenerProcessor.class.getName());
    private final Class<T> iface;
    private Object[] listeners = new Object[0];
    private T dispatcher;

    public ListenerProcessor(Class<T> iface) {
        this.iface = iface;
        if (!iface.isInterface()) {
            throw new IllegalArgumentException("\"" + iface.getName() + "\" is not an interface.");
        }
    }

    @Override
    public void close() throws IOException {
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i] = null;
        }
        this.listeners = new Object[0];
    }

    public T getDispatcher() {
        if (this.dispatcher == null) {
            this.dispatcher = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.iface}, (InvocationHandler)new Dispatcher(this));
        }
        return this.dispatcher;
    }

    public synchronized T registerListener(T listener) {
        if (listener != null && this.iface.isAssignableFrom(listener.getClass())) {
            for (int index = 0; index < this.listeners.length; ++index) {
                if (this.listeners[index] != listener && !this.listeners[index].equals(listener)) continue;
                return (T)this.listeners[index];
            }
            Object[] temp = Arrays.copyOf(this.listeners, this.listeners.length + 1);
            temp[temp.length - 1] = listener;
            this.listeners = temp;
            return listener;
        }
        return null;
    }

    public synchronized T unregisterListener(T listener) {
        if (listener != null) {
            Object[] temp = Arrays.copyOf(this.listeners, this.listeners.length);
            for (int index = 0; index < temp.length; ++index) {
                if (temp[index] != listener && !temp[index].equals(listener)) continue;
                Object foundListener = temp[index];
                System.arraycopy(temp, index + 1, temp, index, temp.length - index - 1);
                this.listeners = Arrays.copyOf(temp, temp.length - 1);
                return (T)foundListener;
            }
        }
        return null;
    }

    protected static final Class<?>[] getAllInterfaces(Class<?> clazz) {
        LinkedHashSet set = new LinkedHashSet();
        Stack stack = new Stack();
        stack.push(clazz);
        if (clazz.isInterface()) {
            set.add(clazz);
        }
        while (!stack.isEmpty()) {
            Class superClass;
            Class cls = (Class)stack.pop();
            Class<?>[] interfaces = cls.getInterfaces();
            if (interfaces != null && interfaces.length > 0) {
                for (Class<?> iface : interfaces) {
                    if (!set.add(iface)) continue;
                    stack.push(iface);
                }
            }
            if ((superClass = cls.getSuperclass()) == null) continue;
            if (superClass.isInterface()) {
                set.add(superClass);
            }
            stack.push(superClass);
        }
        return set.toArray(new Class[set.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Dispatcher
    implements InvocationHandler {
        ListenerProcessor<?> processor;

        protected Dispatcher(ListenerProcessor<?> processor) {
            this.processor = processor;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object[] tempListeners;
            for (Object listener : tempListeners = ((ListenerProcessor)this.processor).listeners) {
                try {
                    method.invoke(listener, args);
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                    throw e;
                }
                catch (IllegalAccessException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                    throw e;
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof StopDispatchException) break;
                    logger.log(Level.WARNING, e.getTargetException().getMessage(), e.getTargetException());
                    throw e.getTargetException();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                    throw e;
                }
            }
            return null;
        }
    }

    public static class StopDispatchException
    extends Exception {
        private static final long serialVersionUID = 201401211841L;
    }
}

