/*
 * Decompiled with CFR 0.152.
 */
package net.posick.mDNS.net;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.posick.mDNS.net.Packet;
import net.posick.mDNS.net.PacketListener;
import net.posick.mDNS.utils.ExecutionTimer;
import net.posick.mDNS.utils.Executors;
import net.posick.mDNS.utils.Misc;
import org.xbill.DNS.Options;

public abstract class NetworkProcessor
implements Runnable,
Closeable {
    protected static final Logger logger = Misc.getLogger(NetworkProcessor.class.getName(), Options.check((String)"mdns_network_verbose") || Options.check((String)"network_verbose") || Options.check((String)"mdns_verbose") || Options.check((String)"dns_verbose") || Options.check((String)"verbose"));
    public static final int DEFAULT_MTU = 1500;
    public static final int AVERAGE_QUEUE_THRESHOLD = 2;
    public static final int MAX_QUEUE_THRESHOLD = 10;
    public static final int PACKET_MONITOR_NO_PACKET_RECEIVED_TIMEOUT = 100000;
    protected Executors executors = Executors.newInstance();
    protected InetAddress ifaceAddress;
    protected InetAddress address;
    protected boolean ipv6;
    protected int port;
    protected int mtu = 1500;
    protected transient boolean exit = false;
    protected PacketListener listener;
    protected boolean threadMonitoring = Options.check((String)"mdns_network_thread_monitor");
    protected Thread networkReadThread = null;
    private ScheduledFuture<?> threadMonitoringFuture;

    public NetworkProcessor(InetAddress ifaceAddress, InetAddress address, int port, PacketListener listener) throws IOException {
        this.setInterfaceAddress(ifaceAddress);
        this.address = address;
        this.setPort(port);
        if (ifaceAddress.getAddress().length != address.getAddress().length) {
            throw new IOException("Interface Address and bind address bust be the same IP specifciation!");
        }
        this.ipv6 = address.getAddress().length > 4;
        this.listener = listener;
    }

    public void close() throws IOException {
        if (this.threadMonitoringFuture != null) {
            this.threadMonitoringFuture.cancel(true);
        }
        this.exit = true;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public InetAddress getInterfaceAddress() {
        return this.ifaceAddress;
    }

    public int getMTU() {
        return this.mtu;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isIPv4() {
        return !this.ipv6;
    }

    public boolean isIPv6() {
        return this.ipv6;
    }

    public boolean isOperational() {
        return !this.exit && this.executors.isNetworkExecutorOperational();
    }

    public abstract void send(byte[] var1) throws IOException;

    public void setInterfaceAddress(InetAddress address) {
        this.ifaceAddress = address;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void start() {
        this.exit = false;
        if (this.threadMonitoring) {
            this.threadMonitoringFuture = this.executors.schedule(new Runnable(){

                public void run() {
                    if (!NetworkProcessor.this.exit) {
                        long now = System.currentTimeMillis();
                        long lastPacket = PacketRunner.lastPacket;
                        boolean operational = NetworkProcessor.this.isOperational();
                        if (now > lastPacket + 100000L) {
                            String msg = "Network Processor has not received a mDNS packet in " + (double)(now - lastPacket) / 1000.0 + " seconds";
                            if (!NetworkProcessor.this.executors.isNetworkExecutorOperational()) {
                                msg = msg + " - NetworkProcessorExecutor has shutdown!";
                            }
                            logger.logp(Level.WARNING, this.getClass().getPackage().getName() + ".ThreadMonitor", "run", msg);
                        }
                        if (!operational) {
                            logger.logp(Level.WARNING, this.getClass().getPackage().getName() + ".ThreadMonitor", "run", "NetworkProcessor is NOT operational, closing it!");
                            try {
                                NetworkProcessor.this.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }, 1L, TimeUnit.SECONDS);
        }
        Thread t = new Thread(this);
        t.setName("NetworkProcessor IO Read Thread");
        t.setPriority(7);
        t.setDaemon(true);
        t.start();
        this.networkReadThread = t;
    }

    protected static class PacketRunner
    implements Runnable {
        private static long lastPacket = -1L;
        PacketListener dispatcher;
        private final Packet[] packets;

        protected PacketRunner(PacketListener dispatcher, Packet ... packets) {
            this.dispatcher = dispatcher;
            this.packets = packets;
            if (lastPacket <= 0L) {
                lastPacket = System.currentTimeMillis();
            }
        }

        public void run() {
            logger.logp(Level.FINE, this.getClass().getName(), "run", "Running " + this.packets.length + " on a single thread");
            lastPacket = System.currentTimeMillis();
            PacketListener dispatcher = this.dispatcher;
            for (Packet packet : this.packets) {
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        double took = packet.timer.took(TimeUnit.MILLISECONDS);
                        logger.logp(Level.FINE, this.getClass().getName(), "run", "NetworkProcessor took " + took + " milliseconds to start packet " + packet.id + ".");
                        ExecutionTimer._start();
                        logger.logp(Level.FINE, this.getClass().getName(), "run", "-----> Dispatching Packet " + packet.id + " <-----");
                    }
                    dispatcher.packetReceived(packet);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, this.getClass().getName(), "run", "Packet " + packet.id + " took " + ExecutionTimer._took(TimeUnit.MILLISECONDS) + " milliseconds to be dispatched to Listeners.");
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Error dispatching data packet - " + e.getMessage(), e);
                }
            }
        }
    }
}

