/*
 * Decompiled with CFR 0.152.
 */
package net.posick.mDNS;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.posick.mDNS.ServiceName;
import org.xbill.DNS.Name;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;

public class ServiceInstance
implements Serializable {
    private static final long serialVersionUID = 201210181454L;
    private final List pointers = new ArrayList();
    private final ServiceName name;
    private Name host;
    private List addresses = new ArrayList();
    private int priority;
    private int weight;
    private int port;
    private final Map textAttributes = new LinkedHashMap();
    private String niceText;
    private String[] text;

    public ServiceInstance(ServiceName name, int priority, int weight, int port, Name host, String ... txtRecords) throws UnknownHostException {
        this(name, priority, weight, port, host, new InetAddress[]{InetAddress.getLocalHost()}, txtRecords);
    }

    public ServiceInstance(ServiceName name, int priority, int weight, int port, Name host, InetAddress[] addresses, Collection textRecords) {
        this(name, priority, weight, port, host, addresses, ServiceInstance.parseTextRecords(textRecords));
    }

    public ServiceInstance(ServiceName name, int priority, int weight, int port, Name host, InetAddress[] addresses, Map textAttributes) {
        this.name = name;
        this.host = host;
        this.priority = priority;
        this.weight = weight;
        this.port = port;
        if (addresses != null) {
            this.addresses = new ArrayList<InetAddress>(Arrays.asList(addresses));
        }
        if (textAttributes != null) {
            this.textAttributes.putAll(textAttributes);
            this.text = new String[textAttributes.size()];
            Map.Entry[] entries = textAttributes.entrySet().toArray(new Map.Entry[textAttributes.size()]);
            for (int index = 0; index < entries.length; ++index) {
                this.text[index] = entries[index].getKey() + "=" + entries[index].getValue();
            }
        }
    }

    public ServiceInstance(ServiceName name, int priority, int weight, int port, Name host, InetAddress[] addresses, String ... textRecords) {
        this(name, priority, weight, port, host, addresses, ServiceInstance.parseTextRecords(textRecords));
    }

    public ServiceInstance(ServiceName name, int priority, int weight, int port, Name host, InetAddress[] addresses, TXTRecord ... textRecords) {
        this(name, priority, weight, port, host, addresses, ServiceInstance.parseTextRecords(textRecords));
    }

    public ServiceInstance(SRVRecord srv) throws TextParseException {
        this(new ServiceName(srv.getName()), srv.getPriority(), srv.getWeight(), srv.getPort(), srv.getTarget(), null, (Map)null);
    }

    public void addAddress(InetAddress address) {
        if (!this.addresses.contains(address)) {
            this.addresses.add(address);
        }
    }

    public void addPointer(Name pointer) {
        if (!this.pointers.contains(pointer)) {
            this.pointers.add(pointer);
        }
    }

    public void addText(Map textRecords) {
        if (textRecords != null) {
            this.textAttributes.putAll(textRecords);
        }
    }

    public void addText(String name, String value) {
        this.textAttributes.put(name, value);
    }

    public void addTextRecords(TXTRecord ... textRecords) {
        Map newTextRecords = ServiceInstance.parseTextRecords(textRecords);
        if (newTextRecords != null) {
            this.textAttributes.putAll(newTextRecords);
        }
    }

    public InetAddress[] getAddresses() {
        return this.addresses == null || this.addresses.size() == 0 ? null : this.addresses.toArray(new InetAddress[this.addresses.size()]);
    }

    public Name getHost() {
        return this.host;
    }

    public ServiceName getName() {
        return this.name;
    }

    public String getNiceText() {
        return this.niceText;
    }

    public Name[] getPointers() {
        return this.pointers == null || this.pointers.size() == 0 ? null : this.pointers.toArray(new Name[this.pointers.size()]);
    }

    public int getPort() {
        return this.port;
    }

    public int getPriority() {
        return this.priority;
    }

    public String[] getText() {
        return this.text;
    }

    public Map getTextAttributes() {
        return this.textAttributes;
    }

    public int getWeight() {
        return this.weight;
    }

    public void removeAddress(InetAddress address) {
        this.addresses.remove(address);
    }

    public void removePointer(Name pointer) {
        this.pointers.remove(pointer);
    }

    public void removeTextRecords(TXTRecord ... textRecords) {
        Map removedTextRecords = ServiceInstance.parseTextRecords(textRecords);
        if (removedTextRecords != null) {
            for (Object key : removedTextRecords.keySet()) {
                this.textAttributes.remove(key);
            }
        }
    }

    public void setAddresses(List addresses) {
        if (addresses != null) {
            this.addresses.clear();
            this.addresses.addAll(addresses);
        }
    }

    public void setHost(Name host) {
        this.host = host;
    }

    public void setNiceText(String niceText) {
        this.niceText = niceText;
    }

    public void setPointers(List pointers) {
        if (pointers != null) {
            this.pointers.clear();
            this.pointers.addAll(pointers);
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Service (\"").append((Object)this.name).append("\"");
        if (this.host != null) {
            builder.append(" can be reached at \"").append(this.host).append("\" ").append(Arrays.toString(this.getAddresses()));
        }
        if (this.port > 0) {
            builder.append(" on port ").append(this.getPort());
        }
        StringBuilder textBuilder = new StringBuilder();
        if (this.textAttributes != null && this.textAttributes.size() > 0) {
            Iterator iterator = this.textAttributes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                if (textBuilder.length() == 0) {
                    builder.append("\n\tTXT: ");
                }
                textBuilder.append(entry.getKey());
                Object value = entry.getValue();
                if (value != null) {
                    textBuilder.append("=\"").append(value.toString()).append("\"");
                }
                textBuilder.append(", ");
                if (textBuilder.length() <= 100) continue;
                textBuilder.setLength(builder.length() - 2);
                builder.append((CharSequence)textBuilder);
                textBuilder.setLength(0);
            }
            if (textBuilder.length() > 0) {
                textBuilder.setLength(builder.length() - 2);
                builder.append((CharSequence)textBuilder);
                textBuilder.setLength(0);
            }
        }
        builder.append(")");
        return builder.toString();
    }

    protected static Map parseTextRecords(Object rawText) {
        String[] pairs;
        if (rawText == null) {
            return null;
        }
        if (rawText instanceof Map) {
            return (Map)rawText;
        }
        if (rawText.getClass().isArray()) {
            LinkedHashMap textAttributes = new LinkedHashMap();
            Object[] array = (Object[])rawText;
            if (array != null && array.length > 0) {
                textAttributes = new LinkedHashMap();
                for (int index = 0; index < array.length; ++index) {
                    Map map = ServiceInstance.parseTextRecords(array[index]);
                    if (map == null || map.size() <= 0) continue;
                    textAttributes.putAll(map);
                }
            }
            return textAttributes;
        }
        if (rawText instanceof Collection) {
            return ServiceInstance.parseTextRecords(((Collection)rawText).toArray());
        }
        if (rawText instanceof TXTRecord) {
            return ServiceInstance.parseTextRecords(((TXTRecord)rawText).getStrings().toArray());
        }
        LinkedHashMap<String, String> textAttributes = new LinkedHashMap<String, String>();
        for (String pair : pairs = ServiceInstance.split(rawText.toString())) {
            if (pair == null || pair.length() <= 0) continue;
            String key = "";
            String value = "";
            int index = pair.indexOf(61);
            if (index >= 0) {
                key = pair.substring(0, index);
                if (++index <= pair.length()) {
                    value = pair.substring(index);
                }
            } else {
                key = pair;
            }
            textAttributes.put(key, value);
        }
        return textAttributes;
    }

    private static String[] split(String text) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        boolean inQuote = false;
        boolean escape = false;
        char[] chars = (text + '\n').toCharArray();
        block4: for (int index = 0; index < chars.length; ++index) {
            if (!Character.isWhitespace(chars[index])) {
                switch (chars[index]) {
                    case '\\': {
                        escape = true;
                        break;
                    }
                    case '\"': {
                        if (!escape) {
                            inQuote = !inQuote;
                            break;
                        }
                        builder.append(chars[index]);
                        break;
                    }
                    default: {
                        builder.append(chars[index]);
                        if (!escape) continue block4;
                        escape = false;
                        break;
                    }
                }
                continue;
            }
            list.add(builder.toString());
            builder.setLength(0);
        }
        return list.toArray(new String[list.size()]);
    }
}

