/*
 * Decompiled with CFR 0.152.
 */
package net.posick.mDNS;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.posick.mDNS.MulticastDNSMulticastOnlyQuerier;
import net.posick.mDNS.utils.Executors;
import net.posick.mDNS.utils.Misc;
import org.xbill.DNS.Cache;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.MulticastDNSUtils;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SetResponse;

public class MulticastDNSCache
extends Cache
implements Closeable {
    protected static final Logger logger;
    protected static final MulticastDNSCache DEFAULT_MDNS_CACHE;
    public static final String MDNS_CACHE_FILENAME;
    private CacheMonitor cacheMonitor = null;
    private LinkedHashMap dataCopy;
    private Field dataField = null;
    private Method findElement = null;
    private Method removeElement = null;
    private Executors executors = Executors.newInstance();

    public MulticastDNSCache() throws NoSuchFieldException, NoSuchMethodException {
        this.populateReflectedFields();
    }

    public MulticastDNSCache(int dclass) throws NoSuchFieldException, NoSuchMethodException {
        super(dclass);
        this.populateReflectedFields();
    }

    public MulticastDNSCache(String file) throws IOException, NoSuchFieldException, NoSuchMethodException {
        super(file);
        this.populateReflectedFields();
    }

    MulticastDNSCache(Cache cache) throws NoSuchFieldException, NoSuchMethodException, IllegalAccessException {
        this();
        Field field = cache.getClass().getDeclaredField("data");
        field.setAccessible(true);
        Object cacheData = field.get(cache);
        field = super.getClass().getDeclaredField("data");
        field.setAccessible(true);
        field.set(this, cacheData);
        this.populateReflectedFields();
    }

    public synchronized void addRecord(Record r, int cred, Object o) {
        super.addRecord(r, cred, o);
    }

    public synchronized void addRRset(RRset rrset, int cred) {
        super.addRRset(rrset, cred);
    }

    public synchronized void close() throws IOException {
        if (this != DEFAULT_MDNS_CACHE && this.cacheMonitor != null) {
            MonitorTask task = new MonitorTask(true);
            task.run();
        }
    }

    public CacheMonitor getCacheMonitor() {
        return this.cacheMonitor;
    }

    public Message queryCache(Message query) {
        return this.queryCache(query, 1);
    }

    public Message queryCache(Message query, int credibility) {
        if (query.getHeader().getOpcode() == 5) {
            Record[] updates;
            Message message = new Message(query.getHeader().getID());
            Header header = message.getHeader();
            header.setRcode(3);
            Stack<Name> stack = new Stack<Name>();
            for (Record record : updates = MulticastDNSUtils.extractRecords(query, 2)) {
                stack.push(record.getName());
            }
            while (!stack.isEmpty()) {
                Record[] answers;
                Name name = (Name)stack.pop();
                SetResponse response = this.lookupRecords(name, 255, credibility);
                if (!response.isSuccessful()) continue;
                header.setRcode(0);
                header.setOpcode(0);
                header.setFlag(0);
                for (Record answer : answers = MulticastDNSUtils.extractRecords(response.answers())) {
                    Name target;
                    if (!message.findRecord(answer)) {
                        message.addRecord(answer, 1);
                    }
                    if ((target = MulticastDNSUtils.getTargetFromRecord(answer)) == null) continue;
                    stack.push(target);
                }
            }
            return message;
        }
        Message message = new Message(query.getHeader().getID());
        Header header = message.getHeader();
        header.setRcode(3);
        Record[] questions = MulticastDNSUtils.extractRecords(query, 0);
        if (questions != null && questions.length > 0) {
            for (Record question : questions) {
                message.addRecord(question, 0);
                MulticastDNSUtils.setDClassForRecord(question, question.getDClass() & Short.MAX_VALUE);
                SetResponse setResponse = this.lookupRecords(question.getName(), 255, credibility);
                if (!setResponse.isSuccessful()) continue;
                header.setRcode(0);
                header.setOpcode(0);
                header.setFlag(0);
                Record[] answers = MulticastDNSUtils.extractRecords(setResponse.answers());
                if (answers == null || answers.length <= 0) continue;
                for (Record answer : answers) {
                    Record[] additionalAnswers;
                    if (!message.findRecord(answer)) {
                        message.addRecord(answer, 1);
                    }
                    for (Record additionalAnswer : additionalAnswers = this.queryCacheForAdditionalRecords(answer, credibility)) {
                        if (message.findRecord(additionalAnswer)) continue;
                        message.addRecord(additionalAnswer, 3);
                    }
                }
            }
        }
        return message;
    }

    public Record[] queryCacheForAdditionalRecords(Record record, int credibility) {
        SetResponse response;
        if (record == null) {
            return MulticastDNSUtils.EMPTY_RECORDS;
        }
        LinkedList<Record> results = new LinkedList<Record>();
        Name target = MulticastDNSUtils.getTargetFromRecord(record);
        if (target != null && (response = this.lookupRecords(target, 255, credibility)).isSuccessful()) {
            Record[] answers;
            for (Record answer : answers = MulticastDNSUtils.extractRecords(response.answers())) {
                Record[] tempRecords;
                results.add(answer);
                for (Record tempRecord : tempRecords = this.queryCacheForAdditionalRecords(answer, credibility)) {
                    results.add(tempRecord);
                }
            }
        }
        return results.toArray(new Record[results.size()]);
    }

    public void removeElementCopy(Name name, int type) {
        try {
            this.removeElement.invoke((Object)this, name, new Integer(type));
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public synchronized void setCacheMonitor(CacheMonitor monitor) {
        if (monitor != null) {
            this.cacheMonitor = monitor;
        }
    }

    synchronized void removeRRset(RRset rrset) {
        this.removeElementCopy(rrset.getName(), rrset.getType());
    }

    synchronized void updateRRset(Record record, int cred) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int type;
        long ttl = record.getTTL();
        Name name = record.getName();
        ElementHelper element = this.findElementCopy(name, type = record.getType(), 0);
        if (element != null) {
            if (element.compareCredibility(cred) <= 0) {
                if (element.getElement() instanceof RRset) {
                    ((RRset)element.getElement()).addRR(record);
                    if (element.getTTL() == ttl) {
                        element.resetExpire();
                    } else {
                        this.addRecord(record, cred, this);
                    }
                } else {
                    this.addRecord(record, cred, this);
                }
            }
        } else {
            this.addRecord(record, cred, this);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            super.finalize();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, t.getMessage(), t);
        }
    }

    protected void populateReflectedFields() throws NoSuchFieldException, NoSuchMethodException {
        this.executors.scheduleAtFixedRate(new MonitorTask(), 1L, 1L, TimeUnit.SECONDS);
        Class<?> clazz = this.getClass().getSuperclass();
        try {
            this.dataField = MulticastDNSCache.findField(clazz, "data");
            AccessibleObject.setAccessible(new AccessibleObject[]{this.dataField}, true);
            this.dataCopy = (LinkedHashMap)this.dataField.get(this);
        }
        catch (NoSuchFieldException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        try {
            this.findElement = MulticastDNSCache.findMethod(clazz, "findElement", new Class[]{Name.class, Integer.TYPE, Integer.TYPE});
            this.removeElement = MulticastDNSCache.findMethod(clazz, "removeElement", new Class[]{Name.class, Integer.TYPE});
            AccessibleObject.setAccessible(new AccessibleObject[]{this.findElement, this.removeElement}, true);
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private ElementHelper findElementCopy(Name name, int type, int minCred) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object o = this.findElement.invoke((Object)this, name, new Integer(type), new Integer(minCred));
        try {
            return o == null ? (ElementHelper)null : new ElementHelper(this, o);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            return null;
        }
    }

    private static Field findField(Class clazz, String name) throws NoSuchFieldException {
        Field field = null;
        for (Class clz = clazz; clz != null && field == null; clz = clz.getSuperclass()) {
            try {
                field = clz.getDeclaredField(name);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (field == null) continue;
            return field;
        }
        throw new NoSuchFieldException("Field \"" + name + "\" does not exist in class \"" + clazz.getName() + "\".");
    }

    private static Method findMethod(Class clazz, String name, Class[] parameters) throws NoSuchMethodException {
        Method method = null;
        for (Class clz = clazz; clz != null && method == null; clz = clz.getSuperclass()) {
            try {
                method = clz.getDeclaredMethod(name, parameters);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method == null) continue;
            return method;
        }
        throw new NoSuchMethodException("Method \"" + name + "\" does not exist in class \"" + clazz.getName() + "\".");
    }

    private static int limitExpire(long ttl, long maxttl) {
        long expire;
        if (maxttl >= 0L && maxttl < ttl) {
            ttl = maxttl;
        }
        if ((expire = System.currentTimeMillis() / 1000L + ttl) < 0L || expire > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)expire;
    }

    static {
        MulticastDNSCache temp;
        block6: {
            logger = Misc.getLogger(MulticastDNSCache.class.getName(), Options.check((String)"mdns_verbose") || Options.check((String)"dns_verbose") || Options.check((String)"verbose"));
            MDNS_CACHE_FILENAME = MulticastDNSMulticastOnlyQuerier.class.getSimpleName() + ".cache";
            temp = null;
            try {
                try {
                    String filename = MDNS_CACHE_FILENAME;
                    File file = new File(filename);
                    if (file.exists() && file.canRead()) {
                        temp = new MulticastDNSCache(filename);
                        break block6;
                    }
                    temp = new MulticastDNSCache();
                }
                catch (IOException e) {
                    temp = new MulticastDNSCache();
                    logger.log(Level.WARNING, "Error loading default cache values - " + e.getMessage(), e);
                }
            }
            catch (NoSuchFieldException e) {
                logger.log(Level.WARNING, "Unrecoverable Error: The base " + Cache.class + " class does not implement required fields - " + e.getMessage(), e);
            }
            catch (NoSuchMethodException e) {
                logger.log(Level.WARNING, "Unrecoverable Error: The base " + Cache.class + " class does not implement required methods - " + e.getMessage(), e);
            }
        }
        DEFAULT_MDNS_CACHE = temp;
    }

    private class MonitorTask
    implements Runnable {
        private boolean shutdown = false;

        MonitorTask() {
            this(false);
        }

        MonitorTask(boolean shutdown) {
            this.shutdown = shutdown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object[] sets;
                CacheMonitor cacheMonitor = MulticastDNSCache.this.getCacheMonitor();
                if (cacheMonitor == null || this.shutdown) {
                    return;
                }
                try {
                    cacheMonitor.begin();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
                MulticastDNSCache multicastDNSCache = MulticastDNSCache.this;
                synchronized (multicastDNSCache) {
                    Collection values = MulticastDNSCache.this.dataCopy.values();
                    sets = values.toArray(new Object[values.size()]);
                }
                for (int index = 0; index < sets.length; ++index) {
                    try {
                        Object types = sets[index];
                        if (types instanceof List) {
                            Object[] elements;
                            List list = (List)types;
                            MulticastDNSCache multicastDNSCache2 = MulticastDNSCache.this;
                            synchronized (multicastDNSCache2) {
                                elements = list.toArray(new Object[list.size()]);
                            }
                            for (int eIndex = 0; eIndex < elements.length; ++eIndex) {
                                this.processElement(new ElementHelper(MulticastDNSCache.this, elements[eIndex]));
                            }
                            continue;
                        }
                        this.processElement(new ElementHelper(MulticastDNSCache.this, types));
                        continue;
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                try {
                    cacheMonitor.end();
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }

        private void processElement(ElementHelper element) {
            try {
                if (element.getElement() instanceof RRset) {
                    RRset rrs = (RRset)element.getElement();
                    if (this.shutdown) {
                        Record[] records;
                        for (Record record : records = MulticastDNSUtils.extractRecords(rrs)) {
                            if (element.getCredibility() < 4) continue;
                            MulticastDNSUtils.setTLLForRecord(record, 0L);
                        }
                    }
                    CacheMonitor cacheMonitor = MulticastDNSCache.this.getCacheMonitor();
                    int expiresIn = element.getExpiresIn();
                    if (expiresIn <= 0 || rrs.getTTL() <= 0L) {
                        cacheMonitor.expired(rrs, element.getCredibility());
                    } else {
                        cacheMonitor.check(rrs, element.getCredibility(), expiresIn);
                    }
                } else {
                    logger.logp(Level.INFO, this.getClass().getName(), "processElement", "Element is an unexpected type \"" + (element.getElement() != null ? element.getElement().getClass().getName() : "null") + "\"");
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    protected static class ElementHelper {
        private Cache cache = null;
        private Object element = null;
        private Class clazz = null;
        private Method expired = null;
        private Method compareCredibility = null;
        private Method getType = null;
        private Method getTTL = null;
        private Field expireField = null;
        private Field credibilityField = null;

        protected ElementHelper(Cache cache, Object element) throws SecurityException, NoSuchMethodException, NoSuchFieldException, IllegalArgumentException {
            this.cache = cache;
            this.element = element;
            this.clazz = element.getClass();
            this.expireField = MulticastDNSCache.findField(this.clazz, "expire");
            this.credibilityField = MulticastDNSCache.findField(this.clazz, "credibility");
            this.expired = MulticastDNSCache.findMethod(this.clazz, "expired", new Class[0]);
            this.compareCredibility = MulticastDNSCache.findMethod(this.clazz, "compareCredibility", new Class[]{Integer.TYPE});
            this.getType = MulticastDNSCache.findMethod(this.clazz, "getType", new Class[0]);
            this.getTTL = MulticastDNSCache.findMethod(this.clazz, "getTTL", new Class[0]);
            AccessibleObject.setAccessible(new AccessibleObject[]{this.expireField, this.credibilityField}, true);
            AccessibleObject.setAccessible(new AccessibleObject[]{this.expired, this.compareCredibility, this.getType, this.getTTL, this.expireField, this.credibilityField}, true);
        }

        public int getCredibility() throws IllegalArgumentException, IllegalAccessException {
            return this.credibilityField.getInt(this.element);
        }

        public int getExpiresIn() throws IllegalArgumentException, IllegalAccessException {
            return this.getExpire() - (int)(System.currentTimeMillis() / 1000L);
        }

        public long getTTL() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            if (this.getTTL != null) {
                Long value = (Long)this.getTTL.invoke(this.element, new Object[0]);
                return value == null ? 0L : value;
            }
            return 0L;
        }

        public void resetExpire() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.expireField.setInt(this.element, MulticastDNSCache.limitExpire(this.getTTL(), this.cache.getMaxCache()));
        }

        protected int compareCredibility(int cred) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return (Integer)this.compareCredibility.invoke(this.element, cred);
        }

        protected boolean expired() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return (Boolean)this.expired.invoke(this.element, new Object[0]);
        }

        protected Object getElement() {
            return this.element;
        }

        protected int getExpire() throws IllegalArgumentException, IllegalAccessException {
            return this.expireField.getInt(this.element);
        }

        protected int getType() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return (Integer)this.getType.invoke(this.element, new Object[0]);
        }
    }

    public static interface CacheMonitor {
        public void begin();

        public void check(RRset var1, int var2, int var3);

        public void end();

        public void expired(RRset var1, int var2);

        public boolean isOperational();
    }
}

