/*
 * Decompiled with CFR 0.152.
 */
package net.posick.mDNS;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.posick.mDNS.MulticastDNSLookupBase;
import net.posick.mDNS.utils.Executors;
import net.posick.mDNS.utils.ListenerProcessor;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.MulticastDNSUtils;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolverListener;

public class Browse
extends MulticastDNSLookupBase {
    static final Logger logger = Logger.getLogger(Browse.class.getName());
    protected List browseOperations = new LinkedList();
    Executors executors = Executors.newInstance();

    protected Browse() throws IOException {
    }

    public Browse(Name ... names) throws IOException {
        super(names);
    }

    public Browse(Name[] names, int type) throws IOException {
        super(names, type);
    }

    public Browse(Name[] names, int type, int dclass) throws IOException {
        super(names, type, dclass);
    }

    protected Browse(Message message) throws IOException {
        super(message);
    }

    public Browse(String ... names) throws IOException {
        super(names);
    }

    public Browse(String[] names, int type) throws IOException {
        super(names, type);
    }

    public Browse(String[] names, int type, int dclass) throws IOException {
        super(names, type, dclass);
    }

    public synchronized void start(ResolverListener listener) {
        if (listener == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, this.getClass().getName(), "start", "Error sending asynchronous query, listener is null!");
            }
            throw new NullPointerException("Error sending asynchronous query, listener is null!");
        }
        if (this.queries == null || this.queries.length == 0) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, this.getClass().getName(), "start", "Error sending asynchronous query, No queries specified!");
            }
            throw new NullPointerException("Error sending asynchronous query, No queries specified!");
        }
        BrowseOperation browseOperation = new BrowseOperation(listener);
        this.browseOperations.add(browseOperation);
        this.querier.registerListener(browseOperation);
        this.executors.execute(browseOperation);
    }

    public void close() throws IOException {
        for (Object o : this.browseOperations) {
            BrowseOperation browseOperation = (BrowseOperation)o;
            try {
                browseOperation.close();
            }
            catch (Exception exception) {}
        }
    }

    protected class BrowseOperation
    implements ResolverListener,
    Runnable {
        private int broadcastDelay = 0;
        private ListenerProcessor<ResolverListener> listenerProcessor = new ListenerProcessor<ResolverListener>(ResolverListener.class);
        private long lastBroadcast;

        BrowseOperation() {
            this(null);
        }

        BrowseOperation(ResolverListener listener) {
            if (listener != null) {
                this.registerListener(listener);
            }
        }

        Message[] getQueries() {
            return Browse.this.queries;
        }

        boolean answersQuery(Record record) {
            if (record != null) {
                for (Message query : Browse.this.queries) {
                    for (Record question : MulticastDNSUtils.extractRecords(query, 0)) {
                        Name questionName = question.getName();
                        Name recordName = record.getName();
                        int questionType = question.getType();
                        int recordType = record.getType();
                        int questionDClass = question.getDClass();
                        int recordDClass = record.getDClass();
                        if (questionType != 255 && questionType != recordType || !questionName.equals((Object)recordName) && !questionName.subdomain(recordName) && !recordName.toString().endsWith("." + questionName.toString()) || questionDClass != 255 && (questionDClass & Short.MAX_VALUE) != (recordDClass & Short.MAX_VALUE)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        boolean matchesBrowse(Message message) {
            Record[] thatAnswers;
            for (Record thatAnswer : thatAnswers = MulticastDNSUtils.extractRecords(message, 1, 2, 3)) {
                if (!this.answersQuery(thatAnswer)) continue;
                return true;
            }
            return false;
        }

        ResolverListener registerListener(ResolverListener listener) {
            return this.listenerProcessor.registerListener(listener);
        }

        ResolverListener unregisterListener(ResolverListener listener) {
            return this.listenerProcessor.unregisterListener(listener);
        }

        public void receiveMessage(Object id, Message message) {
            Header header;
            if (message != null && ((header = message.getHeader()).getFlag(0) || header.getFlag(5)) && this.matchesBrowse(message)) {
                this.listenerProcessor.getDispatcher().receiveMessage(id, message);
            }
        }

        public void handleException(Object id, Exception e) {
            this.listenerProcessor.getDispatcher().handleException(id, e);
        }

        public void run() {
            if (logger.isLoggable(Level.FINE)) {
                long now = System.currentTimeMillis();
                logger.logp(Level.FINE, this.getClass().getName(), "run", "Broadcasting Query for Browse." + (this.lastBroadcast <= 0L ? "" : " Last broadcast was " + (double)(now - this.lastBroadcast) / 1000.0 + " seconds ago."));
                this.lastBroadcast = System.currentTimeMillis();
            }
            try {
                this.broadcastDelay = this.broadcastDelay > 0 ? Math.min(this.broadcastDelay * 2, 3600) : 1;
                Browse.this.executors.schedule(this, this.broadcastDelay, TimeUnit.SECONDS);
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, this.getClass().getName(), "run", "Broadcasting Query for Browse Operation.");
                }
                for (Message query : Browse.this.queries) {
                    Browse.this.querier.broadcast((Message)query.clone(), false);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error broadcasting query for browse - " + e.getMessage(), e);
            }
        }

        public void close() {
            try {
                this.listenerProcessor.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

