/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sqlite.core.CoreResultSet;
import org.sqlite.core.CoreStatement;
import org.sqlite.core.DB;
import org.sqlite.date.FastDateFormat;

public abstract class JDBC3ResultSet
extends CoreResultSet {
    protected static final Pattern COLUMN_TYPENAME = Pattern.compile("([^\\(]*)");
    protected static final Pattern COLUMN_TYPECAST = Pattern.compile("cast\\(.*?\\s+as\\s+(.*?)\\s*\\)");
    protected static final Pattern COLUMN_PRECISION = Pattern.compile(".*?\\((.*?)\\)");

    protected JDBC3ResultSet(CoreStatement coreStatement) {
        super(coreStatement);
    }

    public int findColumn(String string) {
        this.checkOpen();
        Integer n4 = this.findColumnIndexInCache(string);
        if (n4 != null) {
            return n4;
        }
        for (int i3 = 0; i3 < this.cols.length; ++i3) {
            if (!string.equalsIgnoreCase(this.cols[i3])) continue;
            return this.addColumnIndexInCache(string, i3 + 1);
        }
        throw new SQLException("no such column: '" + string + "'");
    }

    public boolean next() {
        if (!this.open) {
            return false;
        }
        this.lastCol = -1;
        if (this.row == 0) {
            ++this.row;
            return true;
        }
        if (this.maxRows != 0 && this.row == this.maxRows) {
            return false;
        }
        int n4 = this.getDatabase().step(this.stmt.pointer);
        switch (n4) {
            case 101: {
                this.close();
                return false;
            }
            case 100: {
                ++this.row;
                return true;
            }
        }
        this.getDatabase().throwex(n4);
        return false;
    }

    public int getType() {
        return 1003;
    }

    public int getFetchSize() {
        return this.limitRows;
    }

    public void setFetchSize(int n4) {
        if (0 > n4 || this.maxRows != 0 && n4 > this.maxRows) {
            throw new SQLException("fetch size " + n4 + " out of bounds " + this.maxRows);
        }
        this.limitRows = n4;
    }

    public int getFetchDirection() {
        this.checkOpen();
        return 1000;
    }

    public void setFetchDirection(int n4) {
        this.checkOpen();
        if (n4 != 1000) {
            throw new SQLException("only FETCH_FORWARD direction supported");
        }
    }

    public boolean isAfterLast() {
        return !this.open;
    }

    public boolean isBeforeFirst() {
        return this.open && this.row == 0;
    }

    public boolean isFirst() {
        return this.row == 1;
    }

    public boolean isLast() {
        throw new SQLException("function not yet implemented for SQLite");
    }

    protected void finalize() {
        this.close();
    }

    public int getRow() {
        return this.row;
    }

    public boolean wasNull() {
        return this.getDatabase().column_type(this.stmt.pointer, this.markCol(this.lastCol)) == 5;
    }

    public BigDecimal getBigDecimal(int n4) {
        String string = this.getString(n4);
        if (string == null) {
            return null;
        }
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("Bad value for type BigDecimal : " + string);
        }
    }

    public BigDecimal getBigDecimal(String string) {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean getBoolean(int n4) {
        return this.getInt(n4) != 0;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(this.findColumn(string));
    }

    public InputStream getBinaryStream(int n4) {
        byte[] byArray = this.getBytes(n4);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        return null;
    }

    public InputStream getBinaryStream(String string) {
        return this.getBinaryStream(this.findColumn(string));
    }

    public byte getByte(int n4) {
        return (byte)this.getInt(n4);
    }

    public byte getByte(String string) {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n4) {
        return this.getDatabase().column_blob(this.stmt.pointer, this.markCol(n4));
    }

    public byte[] getBytes(String string) {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n4) {
        String string = this.getString(n4);
        return string == null ? null : new StringReader(string);
    }

    public Reader getCharacterStream(String string) {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Date getDate(int n4) {
        DB dB = this.getDatabase();
        switch (dB.column_type(this.stmt.pointer, this.markCol(n4))) {
            case 5: {
                return null;
            }
            case 3: {
                try {
                    return new Date(this.getConnectionConfig().getDateFormat().parse(dB.column_text(this.stmt.pointer, this.markCol(n4))).getTime());
                }
                catch (Exception exception) {
                    SQLException sQLException = new SQLException("Error parsing date");
                    sQLException.initCause(exception);
                    throw sQLException;
                }
            }
            case 2: {
                return new Date(this.julianDateToCalendar(dB.column_double(this.stmt.pointer, this.markCol(n4))).getTimeInMillis());
            }
        }
        return new Date(dB.column_long(this.stmt.pointer, this.markCol(n4)) * this.getConnectionConfig().getDateMultiplier());
    }

    public Date getDate(int n4, Calendar calendar) {
        this.checkCalendar(calendar);
        DB dB = this.getDatabase();
        switch (dB.column_type(this.stmt.pointer, this.markCol(n4))) {
            case 5: {
                return null;
            }
            case 3: {
                try {
                    FastDateFormat fastDateFormat = FastDateFormat.getInstance(this.getConnectionConfig().getDateStringFormat(), calendar.getTimeZone());
                    return new Date(fastDateFormat.parse(dB.column_text(this.stmt.pointer, this.markCol(n4))).getTime());
                }
                catch (Exception exception) {
                    SQLException sQLException = new SQLException("Error parsing time stamp");
                    sQLException.initCause(exception);
                    throw sQLException;
                }
            }
            case 2: {
                return new Date(this.julianDateToCalendar(dB.column_double(this.stmt.pointer, this.markCol(n4)), calendar).getTimeInMillis());
            }
        }
        calendar.setTimeInMillis(dB.column_long(this.stmt.pointer, this.markCol(n4)) * this.getConnectionConfig().getDateMultiplier());
        return new Date(calendar.getTime().getTime());
    }

    public Date getDate(String string) {
        return this.getDate(this.findColumn(string), Calendar.getInstance());
    }

    public Date getDate(String string, Calendar calendar) {
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n4) {
        DB dB = this.getDatabase();
        if (dB.column_type(this.stmt.pointer, this.markCol(n4)) == 5) {
            return 0.0;
        }
        return dB.column_double(this.stmt.pointer, this.markCol(n4));
    }

    public double getDouble(String string) {
        return this.getDouble(this.findColumn(string));
    }

    public float getFloat(int n4) {
        DB dB = this.getDatabase();
        if (dB.column_type(this.stmt.pointer, this.markCol(n4)) == 5) {
            return 0.0f;
        }
        return (float)dB.column_double(this.stmt.pointer, this.markCol(n4));
    }

    public float getFloat(String string) {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n4) {
        DB dB = this.getDatabase();
        return dB.column_int(this.stmt.pointer, this.markCol(n4));
    }

    public int getInt(String string) {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n4) {
        DB dB = this.getDatabase();
        return dB.column_long(this.stmt.pointer, this.markCol(n4));
    }

    public long getLong(String string) {
        return this.getLong(this.findColumn(string));
    }

    public short getShort(int n4) {
        return (short)this.getInt(n4);
    }

    public short getShort(String string) {
        return this.getShort(this.findColumn(string));
    }

    public String getString(int n4) {
        DB dB = this.getDatabase();
        return dB.column_text(this.stmt.pointer, this.markCol(n4));
    }

    public String getString(String string) {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n4) {
        DB dB = this.getDatabase();
        switch (dB.column_type(this.stmt.pointer, this.markCol(n4))) {
            case 5: {
                return null;
            }
            case 3: {
                try {
                    return new Time(this.getConnectionConfig().getDateFormat().parse(dB.column_text(this.stmt.pointer, this.markCol(n4))).getTime());
                }
                catch (Exception exception) {
                    SQLException sQLException = new SQLException("Error parsing time");
                    sQLException.initCause(exception);
                    throw sQLException;
                }
            }
            case 2: {
                return new Time(this.julianDateToCalendar(dB.column_double(this.stmt.pointer, this.markCol(n4))).getTimeInMillis());
            }
        }
        return new Time(dB.column_long(this.stmt.pointer, this.markCol(n4)) * this.getConnectionConfig().getDateMultiplier());
    }

    public Time getTime(int n4, Calendar calendar) {
        this.checkCalendar(calendar);
        DB dB = this.getDatabase();
        switch (dB.column_type(this.stmt.pointer, this.markCol(n4))) {
            case 5: {
                return null;
            }
            case 3: {
                try {
                    FastDateFormat fastDateFormat = FastDateFormat.getInstance(this.getConnectionConfig().getDateStringFormat(), calendar.getTimeZone());
                    return new Time(fastDateFormat.parse(dB.column_text(this.stmt.pointer, this.markCol(n4))).getTime());
                }
                catch (Exception exception) {
                    SQLException sQLException = new SQLException("Error parsing time");
                    sQLException.initCause(exception);
                    throw sQLException;
                }
            }
            case 2: {
                return new Time(this.julianDateToCalendar(dB.column_double(this.stmt.pointer, this.markCol(n4)), calendar).getTimeInMillis());
            }
        }
        calendar.setTimeInMillis(dB.column_long(this.stmt.pointer, this.markCol(n4)) * this.getConnectionConfig().getDateMultiplier());
        return new Time(calendar.getTime().getTime());
    }

    public Time getTime(String string) {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n4) {
        DB dB = this.getDatabase();
        switch (dB.column_type(this.stmt.pointer, this.markCol(n4))) {
            case 5: {
                return null;
            }
            case 3: {
                try {
                    return new Timestamp(this.getConnectionConfig().getDateFormat().parse(dB.column_text(this.stmt.pointer, this.markCol(n4))).getTime());
                }
                catch (Exception exception) {
                    SQLException sQLException = new SQLException("Error parsing time stamp");
                    sQLException.initCause(exception);
                    throw sQLException;
                }
            }
            case 2: {
                return new Timestamp(this.julianDateToCalendar(dB.column_double(this.stmt.pointer, this.markCol(n4))).getTimeInMillis());
            }
        }
        return new Timestamp(dB.column_long(this.stmt.pointer, this.markCol(n4)) * this.getConnectionConfig().getDateMultiplier());
    }

    public Timestamp getTimestamp(int n4, Calendar calendar) {
        if (calendar == null) {
            return this.getTimestamp(n4);
        }
        DB dB = this.getDatabase();
        switch (dB.column_type(this.stmt.pointer, this.markCol(n4))) {
            case 5: {
                return null;
            }
            case 3: {
                try {
                    FastDateFormat fastDateFormat = FastDateFormat.getInstance(this.getConnectionConfig().getDateStringFormat(), calendar.getTimeZone());
                    return new Timestamp(fastDateFormat.parse(dB.column_text(this.stmt.pointer, this.markCol(n4))).getTime());
                }
                catch (Exception exception) {
                    SQLException sQLException = new SQLException("Error parsing time stamp");
                    sQLException.initCause(exception);
                    throw sQLException;
                }
            }
            case 2: {
                return new Timestamp(this.julianDateToCalendar(dB.column_double(this.stmt.pointer, this.markCol(n4)), calendar).getTimeInMillis());
            }
        }
        calendar.setTimeInMillis(dB.column_long(this.stmt.pointer, this.markCol(n4)) * this.getConnectionConfig().getDateMultiplier());
        return new Timestamp(calendar.getTime().getTime());
    }

    public Timestamp getTimestamp(String string) {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public Object getObject(int n4) {
        switch (this.getDatabase().column_type(this.stmt.pointer, this.markCol(n4))) {
            case 1: {
                long l2 = this.getLong(n4);
                if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
                    return new Long(l2);
                }
                return new Integer((int)l2);
            }
            case 2: {
                return new Double(this.getDouble(n4));
            }
            case 4: {
                return this.getBytes(n4);
            }
            case 5: {
                return null;
            }
        }
        return this.getString(n4);
    }

    public Object getObject(String string) {
        return this.getObject(this.findColumn(string));
    }

    public Statement getStatement() {
        return (Statement)((Object)this.stmt);
    }

    public String getCursorName() {
        return null;
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public ResultSetMetaData getMetaData() {
        return (ResultSetMetaData)((Object)this);
    }

    public String getCatalogName(int n4) {
        return this.getDatabase().column_table_name(this.stmt.pointer, this.checkCol(n4));
    }

    public String getColumnClassName(int n4) {
        this.checkCol(n4);
        return "java.lang.Object";
    }

    public int getColumnCount() {
        this.checkCol(1);
        return this.colsMeta.length;
    }

    public int getColumnDisplaySize(int n4) {
        return Integer.MAX_VALUE;
    }

    public String getColumnLabel(int n4) {
        return this.getColumnName(n4);
    }

    public String getColumnName(int n4) {
        return this.getDatabase().column_name(this.stmt.pointer, this.checkCol(n4));
    }

    public int getColumnType(int n4) {
        String string = this.getColumnTypeName(n4);
        int n7 = this.getDatabase().column_type(this.stmt.pointer, this.checkCol(n4));
        if (n7 == 1 || n7 == 5) {
            if ("BOOLEAN".equals(string)) {
                return 16;
            }
            if ("TINYINT".equals(string)) {
                return -6;
            }
            if ("SMALLINT".equals(string) || "INT2".equals(string)) {
                return 5;
            }
            if ("BIGINT".equals(string) || "INT8".equals(string) || "UNSIGNED BIG INT".equals(string)) {
                return -5;
            }
            if ("DATE".equals(string) || "DATETIME".equals(string)) {
                return 91;
            }
            if ("TIMESTAMP".equals(string)) {
                return 93;
            }
            if (n7 == 1 || "INT".equals(string) || "INTEGER".equals(string) || "MEDIUMINT".equals(string)) {
                return 4;
            }
        }
        if (n7 == 2 || n7 == 5) {
            if ("DECIMAL".equals(string)) {
                return 3;
            }
            if ("DOUBLE".equals(string) || "DOUBLE PRECISION".equals(string)) {
                return 8;
            }
            if ("NUMERIC".equals(string)) {
                return 2;
            }
            if ("REAL".equals(string)) {
                return 7;
            }
            if (n7 == 2 || "FLOAT".equals(string)) {
                return 6;
            }
        }
        if (n7 == 3 || n7 == 5) {
            if ("CHARACTER".equals(string) || "NCHAR".equals(string) || "NATIVE CHARACTER".equals(string) || "CHAR".equals(string)) {
                return 1;
            }
            if ("CLOB".equals(string)) {
                return 2005;
            }
            if ("DATE".equals(string) || "DATETIME".equals(string)) {
                return 91;
            }
            if (n7 == 3 || "VARCHAR".equals(string) || "VARYING CHARACTER".equals(string) || "NVARCHAR".equals(string) || "TEXT".equals(string)) {
                return 12;
            }
        }
        if (n7 == 4 || n7 == 5) {
            if ("BINARY".equals(string)) {
                return -2;
            }
            if (n7 == 4 || "BLOB".equals(string)) {
                return 2004;
            }
        }
        return 2;
    }

    public String getColumnTypeName(int n4) {
        String string = this.getColumnDeclType(n4);
        if (string != null) {
            Matcher matcher = COLUMN_TYPENAME.matcher(string);
            matcher.find();
            return matcher.group(1).toUpperCase(Locale.ENGLISH);
        }
        switch (this.getDatabase().column_type(this.stmt.pointer, this.checkCol(n4))) {
            case 1: {
                return "INTEGER";
            }
            case 2: {
                return "FLOAT";
            }
            case 4: {
                return "BLOB";
            }
            case 5: {
                return "NUMERIC";
            }
            case 3: {
                return "TEXT";
            }
        }
        return "NUMERIC";
    }

    public int getPrecision(int n4) {
        String string = this.getColumnDeclType(n4);
        if (string != null) {
            Matcher matcher = COLUMN_PRECISION.matcher(string);
            return matcher.find() ? Integer.parseInt(matcher.group(1).split(",")[0].trim()) : 0;
        }
        return 0;
    }

    private String getColumnDeclType(int n4) {
        DB dB = this.getDatabase();
        String string = dB.column_decltype(this.stmt.pointer, this.checkCol(n4));
        if (string == null) {
            Matcher matcher = COLUMN_TYPECAST.matcher(dB.column_name(this.stmt.pointer, this.checkCol(n4)));
            string = matcher.find() ? matcher.group(1) : null;
        }
        return string;
    }

    public int getScale(int n4) {
        String[] stringArray;
        Matcher matcher;
        String string = this.getColumnDeclType(n4);
        if (string != null && (matcher = COLUMN_PRECISION.matcher(string)).find() && (stringArray = matcher.group(1).split(",")).length == 2) {
            return Integer.parseInt(stringArray[1].trim());
        }
        return 0;
    }

    public String getSchemaName(int n4) {
        return "";
    }

    public String getTableName(int n4) {
        String string = this.getDatabase().column_table_name(this.stmt.pointer, this.checkCol(n4));
        if (string == null) {
            return "";
        }
        return string;
    }

    public int isNullable(int n4) {
        this.checkMeta();
        return this.meta[this.checkCol(n4)][1] ? 0 : 1;
    }

    public boolean isAutoIncrement(int n4) {
        this.checkMeta();
        return this.meta[this.checkCol(n4)][2];
    }

    public boolean isCaseSensitive(int n4) {
        return true;
    }

    public boolean isCurrency(int n4) {
        return false;
    }

    public boolean isDefinitelyWritable(int n4) {
        return true;
    }

    public boolean isReadOnly(int n4) {
        return false;
    }

    public boolean isSearchable(int n4) {
        return true;
    }

    public boolean isSigned(int n4) {
        String string = this.getColumnTypeName(n4);
        return "NUMERIC".equals(string) || "INTEGER".equals(string) || "REAL".equals(string);
    }

    public boolean isWritable(int n4) {
        return true;
    }

    public int getConcurrency() {
        return 1007;
    }

    public boolean rowDeleted() {
        return false;
    }

    public boolean rowInserted() {
        return false;
    }

    public boolean rowUpdated() {
        return false;
    }

    private Calendar julianDateToCalendar(Double d8) {
        return this.julianDateToCalendar(d8, Calendar.getInstance());
    }

    private Calendar julianDateToCalendar(Double d8, Calendar calendar) {
        int n4;
        int n7;
        if (d8 == null) {
            return null;
        }
        double d10 = d8 + 0.5;
        int n8 = (int)d10;
        double d11 = d10 - (double)n8;
        if (n8 < 2299161) {
            n7 = n8;
        } else {
            n4 = (int)(((double)n8 - 1867216.25) / 36524.25);
            n7 = n8 + 1 + n4 - (int)((double)n4 / 4.0);
        }
        n4 = n7 + 1524;
        int n10 = (int)(((double)n4 - 122.1) / 365.25);
        int n11 = (int)(365.25 * (double)n10);
        int n12 = (int)((double)(n4 - n11) / 30.6001);
        int n13 = n12 - ((double)n12 < 13.5 ? 1 : 13);
        int n14 = n10 - ((double)n13 > 2.5 ? 4716 : 4715);
        double d13 = (double)(n4 - n11 - (int)(30.6001 * (double)n12)) + d11;
        int n15 = (int)d13;
        double d14 = d13 - (double)n15;
        int n16 = (int)(24.0 * d14);
        double d15 = 24.0 * d14 - (double)n16;
        int n17 = (int)(60.0 * d15);
        double d16 = 60.0 * d15 - (double)n17;
        int n18 = (int)(60.0 * d16);
        double d18 = 60.0 * d16 - (double)n18;
        int n19 = (int)(1000.0 * d18);
        calendar.set(n14, n13 - 1, n15, n16, n17, n18);
        calendar.set(14, n19);
        if (n14 < 1) {
            calendar.set(0, 0);
            calendar.set(1, -(n14 - 1));
        }
        return calendar;
    }

    public void checkCalendar(Calendar calendar) {
        if (calendar != null) {
            return;
        }
        SQLException sQLException = new SQLException("Expected a calendar instance.");
        sQLException.initCause(new NullPointerException());
        throw sQLException;
    }
}

