/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.sqlite.SQLiteConnection;
import org.sqlite.core.CorePreparedStatement;

public abstract class JDBC3PreparedStatement
extends CorePreparedStatement {
    protected JDBC3PreparedStatement(SQLiteConnection sQLiteConnection, String string) {
        super(sQLiteConnection, string);
    }

    public void clearParameters() {
        this.checkOpen();
        this.conn.getDatabase().clear_bindings(this.pointer);
        this.paramValid.clear();
        if (this.batch != null) {
            for (int i3 = this.batchPos; i3 < this.batchPos + this.paramCount; ++i3) {
                this.batch[i3] = null;
            }
        }
    }

    public boolean execute() {
        this.checkOpen();
        this.rs.close();
        this.conn.getDatabase().reset(this.pointer);
        this.checkParameters();
        boolean bl3 = false;
        try {
            this.resultsWaiting = this.conn.getDatabase().execute(this, this.batch);
            bl3 = true;
            boolean bl4 = this.columnCount != 0;
            return bl4;
        }
        finally {
            if (!bl3 && this.pointer != 0L) {
                this.conn.getDatabase().reset(this.pointer);
            }
        }
    }

    public ResultSet executeQuery() {
        this.checkOpen();
        if (this.columnCount == 0) {
            throw new SQLException("Query does not return results");
        }
        this.rs.close();
        this.conn.getDatabase().reset(this.pointer);
        this.checkParameters();
        boolean bl3 = false;
        try {
            this.resultsWaiting = this.conn.getDatabase().execute(this, this.batch);
            bl3 = true;
        }
        finally {
            if (!bl3 && this.pointer != 0L) {
                this.conn.getDatabase().reset(this.pointer);
            }
        }
        return this.getResultSet();
    }

    public int executeUpdate() {
        this.checkOpen();
        if (this.columnCount != 0) {
            throw new SQLException("Query returns results");
        }
        this.rs.close();
        this.conn.getDatabase().reset(this.pointer);
        this.checkParameters();
        return this.conn.getDatabase().executeUpdate(this, this.batch);
    }

    public void addBatch() {
        this.checkOpen();
        this.checkParameters();
        this.batchPos += this.paramCount;
        ++this.batchQueryCount;
        if (this.batch == null) {
            this.batch = new Object[this.paramCount];
            this.paramValid.clear();
        }
        if (this.batchPos + this.paramCount > this.batch.length) {
            Object[] objectArray = new Object[this.batch.length * 2];
            System.arraycopy(this.batch, 0, objectArray, 0, this.batch.length);
            this.batch = objectArray;
        }
        System.arraycopy(this.batch, this.batchPos - this.paramCount, this.batch, this.batchPos, this.paramCount);
    }

    public ParameterMetaData getParameterMetaData() {
        return (ParameterMetaData)((Object)this);
    }

    public int getParameterCount() {
        this.checkOpen();
        return this.paramCount;
    }

    public String getParameterClassName(int n4) {
        this.checkOpen();
        return "java.lang.String";
    }

    public String getParameterTypeName(int n4) {
        return "VARCHAR";
    }

    public int getParameterType(int n4) {
        return 12;
    }

    public int getParameterMode(int n4) {
        return 1;
    }

    public int getPrecision(int n4) {
        return 0;
    }

    public int getScale(int n4) {
        return 0;
    }

    public int isNullable(int n4) {
        return 1;
    }

    public boolean isSigned(int n4) {
        return true;
    }

    public Statement getStatement() {
        return this;
    }

    public void setBigDecimal(int n4, BigDecimal bigDecimal) {
        this.batch(n4, bigDecimal == null ? null : bigDecimal.toString());
    }

    private byte[] readBytes(InputStream inputStream, int n4) {
        if (n4 < 0) {
            SQLException sQLException = new SQLException("Error reading stream. Length should be non-negative");
            throw sQLException;
        }
        byte[] byArray = new byte[n4];
        try {
            int n7;
            for (int i3 = 0; i3 < n4; i3 += n7) {
                n7 = inputStream.read(byArray, i3, n4 - i3);
                if (n7 != -1) continue;
                throw new IOException("End of stream has been reached");
            }
            return byArray;
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException("Error reading stream");
            sQLException.initCause(iOException);
            throw sQLException;
        }
    }

    public void setBinaryStream(int n4, InputStream inputStream, int n7) {
        if (inputStream == null && n7 == 0) {
            this.setBytes(n4, null);
        }
        this.setBytes(n4, this.readBytes(inputStream, n7));
    }

    public void setAsciiStream(int n4, InputStream inputStream, int n7) {
        this.setUnicodeStream(n4, inputStream, n7);
    }

    public void setUnicodeStream(int n4, InputStream inputStream, int n7) {
        if (inputStream == null && n7 == 0) {
            this.setString(n4, null);
        }
        try {
            this.setString(n4, new String(this.readBytes(inputStream, n7), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SQLException sQLException = new SQLException("UTF-8 is not supported");
            sQLException.initCause(unsupportedEncodingException);
            throw sQLException;
        }
    }

    public void setBoolean(int n4, boolean bl3) {
        this.setInt(n4, bl3 ? 1 : 0);
    }

    public void setByte(int n4, byte by2) {
        this.setInt(n4, by2);
    }

    public void setBytes(int n4, byte[] byArray) {
        this.batch(n4, byArray);
    }

    public void setDouble(int n4, double d8) {
        this.batch(n4, new Double(d8));
    }

    public void setFloat(int n4, float f8) {
        this.batch(n4, new Float(f8));
    }

    public void setInt(int n4, int n7) {
        this.batch(n4, new Integer(n7));
    }

    public void setLong(int n4, long l2) {
        this.batch(n4, new Long(l2));
    }

    public void setNull(int n4, int n7) {
        this.setNull(n4, n7, null);
    }

    public void setNull(int n4, int n7, String string) {
        this.batch(n4, null);
    }

    public void setObject(int n4, Object object) {
        if (object == null) {
            this.batch(n4, null);
        } else if (object instanceof java.util.Date) {
            this.setDateByMilliseconds(n4, ((java.util.Date)object).getTime(), Calendar.getInstance());
        } else if (object instanceof Long) {
            this.batch(n4, object);
        } else if (object instanceof Integer) {
            this.batch(n4, object);
        } else if (object instanceof Short) {
            this.batch(n4, new Integer(((Short)object).intValue()));
        } else if (object instanceof Float) {
            this.batch(n4, object);
        } else if (object instanceof Double) {
            this.batch(n4, object);
        } else if (object instanceof Boolean) {
            this.setBoolean(n4, (Boolean)object);
        } else if (object instanceof byte[]) {
            this.batch(n4, object);
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n4, (BigDecimal)object);
        } else {
            this.batch(n4, object.toString());
        }
    }

    public void setObject(int n4, Object object, int n7) {
        this.setObject(n4, object);
    }

    public void setObject(int n4, Object object, int n7, int n8) {
        this.setObject(n4, object);
    }

    public void setShort(int n4, short s11) {
        this.setInt(n4, s11);
    }

    public void setString(int n4, String string) {
        this.batch(n4, string);
    }

    public void setCharacterStream(int n4, Reader reader, int n7) {
        try {
            int n8;
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[8192];
            while ((n8 = reader.read(cArray)) > 0) {
                stringBuffer.append(cArray, 0, n8);
            }
            this.setString(n4, stringBuffer.toString());
        }
        catch (IOException iOException) {
            throw new SQLException("Cannot read from character stream, exception message: " + iOException.getMessage());
        }
    }

    public void setDate(int n4, Date date) {
        this.setDate(n4, date, Calendar.getInstance());
    }

    public void setDate(int n4, Date date, Calendar calendar) {
        if (date == null) {
            this.setObject(n4, null);
        } else {
            this.setDateByMilliseconds(n4, date.getTime(), calendar);
        }
    }

    public void setTime(int n4, Time time) {
        this.setTime(n4, time, Calendar.getInstance());
    }

    public void setTime(int n4, Time time, Calendar calendar) {
        if (time == null) {
            this.setObject(n4, null);
        } else {
            this.setDateByMilliseconds(n4, time.getTime(), calendar);
        }
    }

    public void setTimestamp(int n4, Timestamp timestamp) {
        this.setTimestamp(n4, timestamp, Calendar.getInstance());
    }

    public void setTimestamp(int n4, Timestamp timestamp, Calendar calendar) {
        if (timestamp == null) {
            this.setObject(n4, null);
        } else {
            this.setDateByMilliseconds(n4, timestamp.getTime(), calendar);
        }
    }

    public ResultSetMetaData getMetaData() {
        this.checkOpen();
        return (ResultSetMetaData)((Object)this.rs);
    }

    @Override
    protected SQLException unused() {
        return new SQLException("not implemented by SQLite JDBC driver");
    }

    public void setArray(int n4, Array array) {
        throw this.unused();
    }

    public void setBlob(int n4, Blob blob) {
        throw this.unused();
    }

    public void setClob(int n4, Clob clob) {
        throw this.unused();
    }

    public void setRef(int n4, Ref ref) {
        throw this.unused();
    }

    public void setURL(int n4, URL uRL) {
        throw this.unused();
    }

    @Override
    public boolean execute(String string) {
        throw this.unused();
    }

    @Override
    public int executeUpdate(String string) {
        throw this.unused();
    }

    @Override
    public ResultSet executeQuery(String string) {
        throw this.unused();
    }

    @Override
    public void addBatch(String string) {
        throw this.unused();
    }
}

