/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.date;

import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.sqlite.date.DatePrinter;
import org.sqlite.date.FastDatePrinter$CharacterLiteral;
import org.sqlite.date.FastDatePrinter$Iso8601_Rule;
import org.sqlite.date.FastDatePrinter$NumberRule;
import org.sqlite.date.FastDatePrinter$PaddedNumberField;
import org.sqlite.date.FastDatePrinter$Rule;
import org.sqlite.date.FastDatePrinter$StringLiteral;
import org.sqlite.date.FastDatePrinter$TextField;
import org.sqlite.date.FastDatePrinter$TimeZoneDisplayKey;
import org.sqlite.date.FastDatePrinter$TimeZoneNameRule;
import org.sqlite.date.FastDatePrinter$TimeZoneNumberRule;
import org.sqlite.date.FastDatePrinter$TwelveHourField;
import org.sqlite.date.FastDatePrinter$TwentyFourHourField;
import org.sqlite.date.FastDatePrinter$TwoDigitMonthField;
import org.sqlite.date.FastDatePrinter$TwoDigitNumberField;
import org.sqlite.date.FastDatePrinter$TwoDigitYearField;
import org.sqlite.date.FastDatePrinter$UnpaddedMonthField;
import org.sqlite.date.FastDatePrinter$UnpaddedNumberField;

public class FastDatePrinter
implements Serializable,
DatePrinter {
    private static final long serialVersionUID = 1L;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    private final String mPattern;
    private final TimeZone mTimeZone;
    private final Locale mLocale;
    private transient FastDatePrinter$Rule[] mRules;
    private transient int mMaxLengthEstimate;
    private static final ConcurrentMap<FastDatePrinter$TimeZoneDisplayKey, String> cTimeZoneDisplayCache = new ConcurrentHashMap<FastDatePrinter$TimeZoneDisplayKey, String>(7);

    protected FastDatePrinter(String string, TimeZone timeZone, Locale locale) {
        this.mPattern = string;
        this.mTimeZone = timeZone;
        this.mLocale = locale;
        this.init();
    }

    private void init() {
        List<FastDatePrinter$Rule> list = this.parsePattern();
        this.mRules = list.toArray(new FastDatePrinter$Rule[list.size()]);
        int n4 = 0;
        int n7 = this.mRules.length;
        while (--n7 >= 0) {
            n4 += this.mRules[n7].estimateLength();
        }
        this.mMaxLengthEstimate = n4;
    }

    protected List<FastDatePrinter$Rule> parsePattern() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.mLocale);
        ArrayList<FastDatePrinter$Rule> arrayList = new ArrayList<FastDatePrinter$Rule>();
        String[] stringArray = dateFormatSymbols.getEras();
        String[] stringArray2 = dateFormatSymbols.getMonths();
        String[] stringArray3 = dateFormatSymbols.getShortMonths();
        String[] stringArray4 = dateFormatSymbols.getWeekdays();
        String[] stringArray5 = dateFormatSymbols.getShortWeekdays();
        String[] stringArray6 = dateFormatSymbols.getAmPmStrings();
        int n4 = this.mPattern.length();
        int[] nArray = new int[1];
        for (int i3 = 0; i3 < n4; ++i3) {
            FastDatePrinter$Rule fastDatePrinter$Rule;
            nArray[0] = i3;
            String string = this.parseToken(this.mPattern, nArray);
            i3 = nArray[0];
            int n7 = string.length();
            if (n7 == 0) break;
            char c10 = string.charAt(0);
            switch (c10) {
                case 'G': {
                    fastDatePrinter$Rule = new FastDatePrinter$TextField(0, stringArray);
                    break;
                }
                case 'y': {
                    if (n7 == 2) {
                        fastDatePrinter$Rule = FastDatePrinter$TwoDigitYearField.INSTANCE;
                        break;
                    }
                    fastDatePrinter$Rule = this.selectNumberRule(1, n7 < 4 ? 4 : n7);
                    break;
                }
                case 'M': {
                    if (n7 >= 4) {
                        fastDatePrinter$Rule = new FastDatePrinter$TextField(2, stringArray2);
                        break;
                    }
                    if (n7 == 3) {
                        fastDatePrinter$Rule = new FastDatePrinter$TextField(2, stringArray3);
                        break;
                    }
                    if (n7 == 2) {
                        fastDatePrinter$Rule = FastDatePrinter$TwoDigitMonthField.INSTANCE;
                        break;
                    }
                    fastDatePrinter$Rule = FastDatePrinter$UnpaddedMonthField.INSTANCE;
                    break;
                }
                case 'd': {
                    fastDatePrinter$Rule = this.selectNumberRule(5, n7);
                    break;
                }
                case 'h': {
                    fastDatePrinter$Rule = new FastDatePrinter$TwelveHourField(this.selectNumberRule(10, n7));
                    break;
                }
                case 'H': {
                    fastDatePrinter$Rule = this.selectNumberRule(11, n7);
                    break;
                }
                case 'm': {
                    fastDatePrinter$Rule = this.selectNumberRule(12, n7);
                    break;
                }
                case 's': {
                    fastDatePrinter$Rule = this.selectNumberRule(13, n7);
                    break;
                }
                case 'S': {
                    fastDatePrinter$Rule = this.selectNumberRule(14, n7);
                    break;
                }
                case 'E': {
                    fastDatePrinter$Rule = new FastDatePrinter$TextField(7, n7 < 4 ? stringArray5 : stringArray4);
                    break;
                }
                case 'D': {
                    fastDatePrinter$Rule = this.selectNumberRule(6, n7);
                    break;
                }
                case 'F': {
                    fastDatePrinter$Rule = this.selectNumberRule(8, n7);
                    break;
                }
                case 'w': {
                    fastDatePrinter$Rule = this.selectNumberRule(3, n7);
                    break;
                }
                case 'W': {
                    fastDatePrinter$Rule = this.selectNumberRule(4, n7);
                    break;
                }
                case 'a': {
                    fastDatePrinter$Rule = new FastDatePrinter$TextField(9, stringArray6);
                    break;
                }
                case 'k': {
                    fastDatePrinter$Rule = new FastDatePrinter$TwentyFourHourField(this.selectNumberRule(11, n7));
                    break;
                }
                case 'K': {
                    fastDatePrinter$Rule = this.selectNumberRule(10, n7);
                    break;
                }
                case 'X': {
                    fastDatePrinter$Rule = FastDatePrinter$Iso8601_Rule.getRule(n7);
                    break;
                }
                case 'z': {
                    if (n7 >= 4) {
                        fastDatePrinter$Rule = new FastDatePrinter$TimeZoneNameRule(this.mTimeZone, this.mLocale, 1);
                        break;
                    }
                    fastDatePrinter$Rule = new FastDatePrinter$TimeZoneNameRule(this.mTimeZone, this.mLocale, 0);
                    break;
                }
                case 'Z': {
                    if (n7 == 1) {
                        fastDatePrinter$Rule = FastDatePrinter$TimeZoneNumberRule.INSTANCE_NO_COLON;
                        break;
                    }
                    if (n7 == 2) {
                        fastDatePrinter$Rule = FastDatePrinter$TimeZoneNumberRule.INSTANCE_ISO_8601;
                        break;
                    }
                    fastDatePrinter$Rule = FastDatePrinter$TimeZoneNumberRule.INSTANCE_COLON;
                    break;
                }
                case '\'': {
                    String string2 = string.substring(1);
                    if (string2.length() == 1) {
                        fastDatePrinter$Rule = new FastDatePrinter$CharacterLiteral(string2.charAt(0));
                        break;
                    }
                    fastDatePrinter$Rule = new FastDatePrinter$StringLiteral(string2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + string);
                }
            }
            arrayList.add(fastDatePrinter$Rule);
        }
        return arrayList;
    }

    protected String parseToken(String string, int[] nArray) {
        int n4;
        StringBuilder stringBuilder = new StringBuilder();
        int n7 = string.length();
        char c10 = string.charAt(n4);
        if (c10 >= 'A' && c10 <= 'Z' || c10 >= 'a' && c10 <= 'z') {
            char c11;
            stringBuilder.append(c10);
            while (n4 + 1 < n7 && (c11 = string.charAt(n4 + 1)) == c10) {
                stringBuilder.append(c10);
                ++n4;
            }
        } else {
            stringBuilder.append('\'');
            boolean bl3 = false;
            for (n4 = nArray[0]; n4 < n7; ++n4) {
                c10 = string.charAt(n4);
                if (c10 == '\'') {
                    if (n4 + 1 < n7 && string.charAt(n4 + 1) == '\'') {
                        ++n4;
                        stringBuilder.append(c10);
                        continue;
                    }
                    bl3 = !bl3;
                    continue;
                }
                if (bl3 || (c10 < 'A' || c10 > 'Z') && (c10 < 'a' || c10 > 'z')) {
                    stringBuilder.append(c10);
                    continue;
                }
                break;
            }
        }
        nArray[0] = --n4;
        return stringBuilder.toString();
    }

    protected FastDatePrinter$NumberRule selectNumberRule(int n4, int n7) {
        switch (n7) {
            case 1: {
                return new FastDatePrinter$UnpaddedNumberField(n4);
            }
            case 2: {
                return new FastDatePrinter$TwoDigitNumberField(n4);
            }
        }
        return new FastDatePrinter$PaddedNumberField(n4, n7);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Date) {
            return this.format((Date)object, stringBuffer);
        }
        if (object instanceof Calendar) {
            return this.format((Calendar)object, stringBuffer);
        }
        if (object instanceof Long) {
            return this.format((Long)object, stringBuffer);
        }
        throw new IllegalArgumentException("Unknown class: " + (object == null ? "<null>" : object.getClass().getName()));
    }

    @Override
    public String format(long l2) {
        GregorianCalendar gregorianCalendar = this.newCalendar();
        gregorianCalendar.setTimeInMillis(l2);
        return this.applyRulesToString(gregorianCalendar);
    }

    private String applyRulesToString(Calendar calendar) {
        return this.applyRules(calendar, new StringBuffer(this.mMaxLengthEstimate)).toString();
    }

    private GregorianCalendar newCalendar() {
        return new GregorianCalendar(this.mTimeZone, this.mLocale);
    }

    @Override
    public String format(Date date) {
        GregorianCalendar gregorianCalendar = this.newCalendar();
        gregorianCalendar.setTime(date);
        return this.applyRulesToString(gregorianCalendar);
    }

    @Override
    public String format(Calendar calendar) {
        return this.format(calendar, new StringBuffer(this.mMaxLengthEstimate)).toString();
    }

    @Override
    public StringBuffer format(long l2, StringBuffer stringBuffer) {
        return this.format(new Date(l2), stringBuffer);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer) {
        GregorianCalendar gregorianCalendar = this.newCalendar();
        gregorianCalendar.setTime(date);
        return this.applyRules(gregorianCalendar, stringBuffer);
    }

    @Override
    public StringBuffer format(Calendar calendar, StringBuffer stringBuffer) {
        return this.applyRules(calendar, stringBuffer);
    }

    protected StringBuffer applyRules(Calendar calendar, StringBuffer stringBuffer) {
        for (FastDatePrinter$Rule fastDatePrinter$Rule : this.mRules) {
            fastDatePrinter$Rule.appendTo(stringBuffer, calendar);
        }
        return stringBuffer;
    }

    @Override
    public String getPattern() {
        return this.mPattern;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.mTimeZone;
    }

    @Override
    public Locale getLocale() {
        return this.mLocale;
    }

    public int getMaxLengthEstimate() {
        return this.mMaxLengthEstimate;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FastDatePrinter)) {
            return false;
        }
        FastDatePrinter fastDatePrinter = (FastDatePrinter)object;
        return this.mPattern.equals(fastDatePrinter.mPattern) && this.mTimeZone.equals(fastDatePrinter.mTimeZone) && this.mLocale.equals(fastDatePrinter.mLocale);
    }

    public int hashCode() {
        return this.mPattern.hashCode() + 13 * (this.mTimeZone.hashCode() + 13 * this.mLocale.hashCode());
    }

    public String toString() {
        return "FastDatePrinter[" + this.mPattern + "," + this.mLocale + "," + this.mTimeZone.getID() + "]";
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.init();
    }

    private static void appendDigits(StringBuffer stringBuffer, int n4) {
        stringBuffer.append((char)(n4 / 10 + 48));
        stringBuffer.append((char)(n4 % 10 + 48));
    }

    static String getTimeZoneDisplay(TimeZone timeZone, boolean bl3, int n4, Locale locale) {
        String string;
        FastDatePrinter$TimeZoneDisplayKey fastDatePrinter$TimeZoneDisplayKey = new FastDatePrinter$TimeZoneDisplayKey(timeZone, bl3, n4, locale);
        String string2 = (String)cTimeZoneDisplayCache.get(fastDatePrinter$TimeZoneDisplayKey);
        if (string2 == null && (string = cTimeZoneDisplayCache.putIfAbsent(fastDatePrinter$TimeZoneDisplayKey, string2 = timeZone.getDisplayName(bl3, n4, locale))) != null) {
            string2 = string;
        }
        return string2;
    }

    static /* synthetic */ void access$000(StringBuffer stringBuffer, int n4) {
        FastDatePrinter.appendDigits(stringBuffer, n4);
    }
}

