/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.date;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import org.sqlite.date.FastDateParser;
import org.sqlite.date.FastDateParser$Strategy;

class FastDateParser$TimeZoneStrategy
extends FastDateParser$Strategy {
    private final String validTimeZoneChars;
    private final SortedMap<String, TimeZone> tzNames = new TreeMap<String, TimeZone>(String.CASE_INSENSITIVE_ORDER);
    private static final int ID = 0;
    private static final int LONG_STD = 1;
    private static final int SHORT_STD = 2;
    private static final int LONG_DST = 3;
    private static final int SHORT_DST = 4;

    FastDateParser$TimeZoneStrategy(Locale locale) {
        super(null);
        String[][] stringArray = DateFormatSymbols.getInstance(locale).getZoneStrings();
        for (String[] stringArray2 : stringArray) {
            if (stringArray2[0].startsWith("GMT")) continue;
            TimeZone timeZone = TimeZone.getTimeZone(stringArray2[0]);
            if (!this.tzNames.containsKey(stringArray2[1])) {
                this.tzNames.put(stringArray2[1], timeZone);
            }
            if (!this.tzNames.containsKey(stringArray2[2])) {
                this.tzNames.put(stringArray2[2], timeZone);
            }
            if (!timeZone.useDaylightTime()) continue;
            if (!this.tzNames.containsKey(stringArray2[3])) {
                this.tzNames.put(stringArray2[3], timeZone);
            }
            if (this.tzNames.containsKey(stringArray2[4])) continue;
            this.tzNames.put(stringArray2[4], timeZone);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(GMT[+-]\\d{1,2}:\\d{2}").append('|');
        stringBuilder.append("[+-]\\d{4}").append('|');
        for (String string : this.tzNames.keySet()) {
            FastDateParser.access$100(stringBuilder, string, false).append('|');
        }
        stringBuilder.setCharAt(stringBuilder.length() - 1, ')');
        this.validTimeZoneChars = stringBuilder.toString();
    }

    @Override
    boolean addRegex(FastDateParser fastDateParser, StringBuilder stringBuilder) {
        stringBuilder.append(this.validTimeZoneChars);
        return true;
    }

    @Override
    void setCalendar(FastDateParser fastDateParser, Calendar calendar, String string) {
        TimeZone timeZone;
        if (string.charAt(0) == '+' || string.charAt(0) == '-') {
            timeZone = TimeZone.getTimeZone("GMT" + string);
        } else if (string.startsWith("GMT")) {
            timeZone = TimeZone.getTimeZone(string);
        } else {
            timeZone = (TimeZone)this.tzNames.get(string);
            if (timeZone == null) {
                throw new IllegalArgumentException(string + " is not a supported timezone name");
            }
        }
        calendar.setTimeZone(timeZone);
    }
}

