/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import org.sqlite.BusyHandler;
import org.sqlite.Function;
import org.sqlite.ProgressHandler;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteJDBCLoader;
import org.sqlite.core.DB;
import org.sqlite.core.DB$ProgressObserver;

public final class NativeDB
extends DB {
    long pointer = 0L;
    private static boolean isLoaded;
    private static boolean loadSucceeded;
    private final long udfdatalist = 0L;

    public NativeDB(String string, String string2, SQLiteConfig sQLiteConfig) {
        super(string, string2, sQLiteConfig);
    }

    public static boolean load() {
        if (isLoaded) {
            return loadSucceeded;
        }
        loadSucceeded = SQLiteJDBCLoader.initialize();
        isLoaded = true;
        return loadSucceeded;
    }

    @Override
    protected synchronized void _open(String string, int n4) {
        this._open_utf8(NativeDB.stringToUtf8ByteArray(string), n4);
    }

    synchronized native void _open_utf8(byte[] var1, int var2);

    @Override
    protected synchronized native void _close();

    @Override
    public synchronized int _exec(String string) {
        return this._exec_utf8(NativeDB.stringToUtf8ByteArray(string));
    }

    synchronized native int _exec_utf8(byte[] var1);

    @Override
    public synchronized native int shared_cache(boolean var1);

    @Override
    public synchronized native int enable_load_extension(boolean var1);

    @Override
    public native void interrupt();

    @Override
    public synchronized native void busy_timeout(int var1);

    @Override
    public synchronized native void busy_handler(BusyHandler var1);

    @Override
    protected synchronized long prepare(String string) {
        return this.prepare_utf8(NativeDB.stringToUtf8ByteArray(string));
    }

    synchronized native long prepare_utf8(byte[] var1);

    @Override
    synchronized String errmsg() {
        return NativeDB.utf8ByteArrayToString(this.errmsg_utf8());
    }

    synchronized native byte[] errmsg_utf8();

    @Override
    public synchronized String libversion() {
        return NativeDB.utf8ByteArrayToString(this.libversion_utf8());
    }

    native byte[] libversion_utf8();

    @Override
    public synchronized native int changes();

    @Override
    public synchronized native int total_changes();

    @Override
    protected synchronized native int finalize(long var1);

    @Override
    public synchronized native int step(long var1);

    @Override
    public synchronized native int reset(long var1);

    @Override
    public synchronized native int clear_bindings(long var1);

    @Override
    synchronized native int bind_parameter_count(long var1);

    @Override
    public synchronized native int column_count(long var1);

    @Override
    public synchronized native int column_type(long var1, int var3);

    @Override
    public synchronized String column_decltype(long l2, int n4) {
        return NativeDB.utf8ByteArrayToString(this.column_decltype_utf8(l2, n4));
    }

    synchronized native byte[] column_decltype_utf8(long var1, int var3);

    @Override
    public synchronized String column_table_name(long l2, int n4) {
        return NativeDB.utf8ByteArrayToString(this.column_table_name_utf8(l2, n4));
    }

    synchronized native byte[] column_table_name_utf8(long var1, int var3);

    @Override
    public synchronized String column_name(long l2, int n4) {
        return NativeDB.utf8ByteArrayToString(this.column_name_utf8(l2, n4));
    }

    synchronized native byte[] column_name_utf8(long var1, int var3);

    @Override
    public synchronized String column_text(long l2, int n4) {
        return NativeDB.utf8ByteArrayToString(this.column_text_utf8(l2, n4));
    }

    synchronized native byte[] column_text_utf8(long var1, int var3);

    @Override
    public synchronized native byte[] column_blob(long var1, int var3);

    @Override
    public synchronized native double column_double(long var1, int var3);

    @Override
    public synchronized native long column_long(long var1, int var3);

    @Override
    public synchronized native int column_int(long var1, int var3);

    @Override
    synchronized native int bind_null(long var1, int var3);

    @Override
    synchronized native int bind_int(long var1, int var3, int var4);

    @Override
    synchronized native int bind_long(long var1, int var3, long var4);

    @Override
    synchronized native int bind_double(long var1, int var3, double var4);

    @Override
    synchronized int bind_text(long l2, int n4, String string) {
        return this.bind_text_utf8(l2, n4, NativeDB.stringToUtf8ByteArray(string));
    }

    synchronized native int bind_text_utf8(long var1, int var3, byte[] var4);

    @Override
    synchronized native int bind_blob(long var1, int var3, byte[] var4);

    @Override
    public synchronized native void result_null(long var1);

    @Override
    public synchronized void result_text(long l2, String string) {
        this.result_text_utf8(l2, NativeDB.stringToUtf8ByteArray(string));
    }

    synchronized native void result_text_utf8(long var1, byte[] var3);

    @Override
    public synchronized native void result_blob(long var1, byte[] var3);

    @Override
    public synchronized native void result_double(long var1, double var3);

    @Override
    public synchronized native void result_long(long var1, long var3);

    @Override
    public synchronized native void result_int(long var1, int var3);

    @Override
    public synchronized void result_error(long l2, String string) {
        this.result_error_utf8(l2, NativeDB.stringToUtf8ByteArray(string));
    }

    synchronized native void result_error_utf8(long var1, byte[] var3);

    @Override
    public synchronized String value_text(Function function, int n4) {
        return NativeDB.utf8ByteArrayToString(this.value_text_utf8(function, n4));
    }

    synchronized native byte[] value_text_utf8(Function var1, int var2);

    @Override
    public synchronized native byte[] value_blob(Function var1, int var2);

    @Override
    public synchronized native double value_double(Function var1, int var2);

    @Override
    public synchronized native long value_long(Function var1, int var2);

    @Override
    public synchronized native int value_int(Function var1, int var2);

    @Override
    public synchronized native int value_type(Function var1, int var2);

    @Override
    public synchronized int create_function(String string, Function function, int n4) {
        return this.create_function_utf8(NativeDB.stringToUtf8ByteArray(string), function, n4);
    }

    synchronized native int create_function_utf8(byte[] var1, Function var2, int var3);

    @Override
    public synchronized int destroy_function(String string) {
        return this.destroy_function_utf8(NativeDB.stringToUtf8ByteArray(string));
    }

    synchronized native int destroy_function_utf8(byte[] var1);

    @Override
    synchronized native void free_functions();

    @Override
    public int backup(String string, String string2, DB$ProgressObserver dB$ProgressObserver) {
        return this.backup(NativeDB.stringToUtf8ByteArray(string), NativeDB.stringToUtf8ByteArray(string2), dB$ProgressObserver);
    }

    synchronized native int backup(byte[] var1, byte[] var2, DB$ProgressObserver var3);

    @Override
    public synchronized int restore(String string, String string2, DB$ProgressObserver dB$ProgressObserver) {
        return this.restore(NativeDB.stringToUtf8ByteArray(string), NativeDB.stringToUtf8ByteArray(string2), dB$ProgressObserver);
    }

    synchronized native int restore(byte[] var1, byte[] var2, DB$ProgressObserver var3);

    @Override
    synchronized native boolean[][] column_metadata(long var1);

    static void throwex(String string) {
        throw new SQLException(string);
    }

    static byte[] stringToUtf8ByteArray(String string) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 is not supported", unsupportedEncodingException);
        }
    }

    static String utf8ByteArrayToString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 is not supported", unsupportedEncodingException);
        }
    }

    @Override
    public synchronized native void register_progress_handler(int var1, ProgressHandler var2);

    @Override
    public synchronized native void clear_progress_handler();

    static {
        if ("The Android Project".equals(System.getProperty("java.vm.vendor"))) {
            System.loadLibrary("sqlitejdbc");
            isLoaded = true;
            loadSucceeded = true;
        } else {
            isLoaded = false;
            loadSucceeded = false;
        }
    }
}

