/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.core;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.sqlite.SQLiteConnectionConfig;
import org.sqlite.core.Codes;
import org.sqlite.core.CoreStatement;
import org.sqlite.core.DB;

public abstract class CoreResultSet
implements Codes {
    protected final CoreStatement stmt;
    public boolean open = false;
    public int maxRows;
    public String[] cols = null;
    public String[] colsMeta = null;
    protected boolean[][] meta = null;
    protected int limitRows;
    protected int row = 0;
    protected int lastCol;
    public boolean closeStmt;
    protected Map<String, Integer> columnNameToIndex = null;

    protected CoreResultSet(CoreStatement coreStatement) {
        this.stmt = coreStatement;
    }

    protected DB getDatabase() {
        return this.stmt.getDatbase();
    }

    protected SQLiteConnectionConfig getConnectionConfig() {
        return this.stmt.getConnectionConfig();
    }

    public boolean isOpen() {
        return this.open;
    }

    protected void checkOpen() {
        if (!this.open) {
            throw new SQLException("ResultSet closed");
        }
    }

    public int checkCol(int n4) {
        if (this.colsMeta == null) {
            throw new IllegalStateException("SQLite JDBC: inconsistent internal state");
        }
        if (n4 < 1 || n4 > this.colsMeta.length) {
            throw new SQLException("column " + n4 + " out of bounds [1," + this.colsMeta.length + "]");
        }
        return --n4;
    }

    protected int markCol(int n4) {
        this.checkOpen();
        this.checkCol(n4);
        this.lastCol = n4--;
        return n4;
    }

    public void checkMeta() {
        this.checkCol(1);
        if (this.meta == null) {
            this.meta = this.stmt.getDatbase().column_metadata(this.stmt.pointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DB dB;
        this.cols = null;
        this.colsMeta = null;
        this.meta = null;
        this.limitRows = 0;
        this.row = 0;
        this.lastCol = -1;
        this.columnNameToIndex = null;
        if (!this.open) {
            return;
        }
        DB dB2 = dB = this.stmt.getDatbase();
        synchronized (dB2) {
            if (this.stmt.pointer != 0L) {
                dB.reset(this.stmt.pointer);
                if (this.closeStmt) {
                    this.closeStmt = false;
                    ((Statement)((Object)this.stmt)).close();
                }
            }
        }
        this.open = false;
    }

    protected Integer findColumnIndexInCache(String string) {
        if (this.columnNameToIndex == null) {
            return null;
        }
        return this.columnNameToIndex.get(string);
    }

    protected int addColumnIndexInCache(String string, int n4) {
        if (this.columnNameToIndex == null) {
            this.columnNameToIndex = new HashMap<String, Integer>(this.cols.length);
        }
        this.columnNameToIndex.put(string, n4);
        return n4;
    }
}

