/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Properties;
import java.util.UUID;
import org.sqlite.SQLiteJDBCLoader$1;
import org.sqlite.util.OSInfo;

public class SQLiteJDBCLoader {
    private static boolean extracted = false;

    public static synchronized boolean initialize() {
        if (!extracted) {
            SQLiteJDBCLoader.cleanup();
        }
        SQLiteJDBCLoader.loadSQLiteNativeLibrary();
        return extracted;
    }

    private static File getTempDir() {
        return new File(System.getProperty("org.sqlite.tmpdir", System.getProperty("java.io.tmpdir")));
    }

    static void cleanup() {
        String string = SQLiteJDBCLoader.getTempDir().getAbsolutePath();
        File file = new File(string);
        File[] fileArray = file.listFiles(new SQLiteJDBCLoader$1());
        if (fileArray != null) {
            for (File file2 : fileArray) {
                File file3 = new File(file2.getAbsolutePath() + ".lck");
                if (file3.exists()) continue;
                try {
                    file2.delete();
                }
                catch (SecurityException securityException) {
                    System.err.println("Failed to delete old native lib" + securityException.getMessage());
                }
            }
        }
    }

    static boolean getPureJavaFlag() {
        return Boolean.parseBoolean(System.getProperty("sqlite.purejava", "false"));
    }

    public static boolean isPureJavaMode() {
        return false;
    }

    public static boolean isNativeMode() {
        SQLiteJDBCLoader.initialize();
        return extracted;
    }

    static String md5sum(InputStream inputStream) {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(bufferedInputStream, messageDigest);
            while (digestInputStream.read() >= 0) {
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(messageDigest.digest());
            String string = byteArrayOutputStream.toString();
            return string;
        }
    }

    private static boolean contentsEquals(InputStream inputStream, InputStream inputStream2) {
        int n4;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(inputStream2 instanceof BufferedInputStream)) {
            inputStream2 = new BufferedInputStream(inputStream2);
        }
        int n7 = inputStream.read();
        while (n7 != -1) {
            n4 = inputStream2.read();
            if (n7 != n4) {
                return false;
            }
            n7 = inputStream.read();
        }
        n4 = inputStream2.read();
        return n4 == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean extractAndLoadLibraryFile(String string, String string2, String string3) {
        String string4 = string + "/" + string2;
        String string5 = UUID.randomUUID().toString();
        String string6 = String.format("sqlite-%s-%s-%s", SQLiteJDBCLoader.getVersion(), string5, string2);
        String string7 = string6 + ".lck";
        File file = new File(string3, string6);
        File file2 = new File(string3, string7);
        try {
            Object object;
            InputStream inputStream = SQLiteJDBCLoader.class.getResourceAsStream(string4);
            if (!file2.exists()) {
                new FileOutputStream(file2).close();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                object = new byte[8192];
                int n4 = 0;
                while ((n4 = inputStream.read((byte[])object)) != -1) {
                    fileOutputStream.write((byte[])object, 0, n4);
                }
            }
            finally {
                file.deleteOnExit();
                file2.deleteOnExit();
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            file.setReadable(true);
            file.setWritable(true, true);
            file.setExecutable(true);
            object = SQLiteJDBCLoader.class.getResourceAsStream(string4);
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                if (!SQLiteJDBCLoader.contentsEquals((InputStream)object, fileInputStream)) {
                    throw new RuntimeException(String.format("Failed to write a native library file at %s", file));
                }
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            return SQLiteJDBCLoader.loadNativeLibrary(string3, string6);
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            return false;
        }
    }

    private static boolean loadNativeLibrary(String string, String string2) {
        File file = new File(string, string2);
        if (file.exists()) {
            try {
                System.load(new File(string, string2).getAbsolutePath());
                return true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.err.println("Failed to load native library:" + string2 + ". osinfo: " + OSInfo.getNativeLibFolderPathForCurrentOS());
                System.err.println(unsatisfiedLinkError);
                return false;
            }
        }
        return false;
    }

    private static void loadSQLiteNativeLibrary() {
        String string;
        if (extracted) {
            return;
        }
        String string2 = System.getProperty("org.sqlite.lib.path");
        String string3 = System.getProperty("org.sqlite.lib.name");
        if (string3 == null && (string3 = System.mapLibraryName("sqlitejdbc")) != null && string3.endsWith(".dylib")) {
            string3 = string3.replace(".dylib", ".jnilib");
        }
        if (string2 != null && SQLiteJDBCLoader.loadNativeLibrary(string2, string3)) {
            extracted = true;
            return;
        }
        String string4 = SQLiteJDBCLoader.class.getPackage().getName().replaceAll("\\.", "/");
        string2 = String.format("/%s/native/%s", string4, OSInfo.getNativeLibFolderPathForCurrentOS());
        boolean bl3 = SQLiteJDBCLoader.hasResource(string2 + "/" + string3);
        if (!bl3 && OSInfo.getOSName().equals("Mac")) {
            string = "libsqlitejdbc.jnilib";
            if (SQLiteJDBCLoader.hasResource(string2 + "/" + string)) {
                string3 = string;
                bl3 = true;
            }
        }
        if (!bl3) {
            extracted = false;
            throw new Exception(String.format("No native library is found for os.name=%s and os.arch=%s. path=%s", OSInfo.getOSName(), OSInfo.getArchName(), string2));
        }
        string = SQLiteJDBCLoader.getTempDir().getAbsolutePath();
        if (SQLiteJDBCLoader.extractAndLoadLibraryFile(string2, string3, string)) {
            extracted = true;
            return;
        }
        extracted = false;
    }

    private static boolean hasResource(String string) {
        return SQLiteJDBCLoader.class.getResource(string) != null;
    }

    private static void getNativeLibraryFolderForTheCurrentOS() {
        String string = OSInfo.getOSName();
        String string2 = OSInfo.getArchName();
    }

    public static int getMajorVersion() {
        String[] stringArray = SQLiteJDBCLoader.getVersion().split("\\.");
        return stringArray.length > 0 ? Integer.parseInt(stringArray[0]) : 1;
    }

    public static int getMinorVersion() {
        String[] stringArray = SQLiteJDBCLoader.getVersion().split("\\.");
        return stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : 0;
    }

    public static String getVersion() {
        URL uRL = SQLiteJDBCLoader.class.getResource("/META-INF/maven/org.xerial/sqlite-jdbc/pom.properties");
        if (uRL == null) {
            uRL = SQLiteJDBCLoader.class.getResource("/META-INF/maven/org.xerial/sqlite-jdbc/VERSION");
        }
        String string = "unknown";
        try {
            if (uRL != null) {
                Properties properties = new Properties();
                properties.load(uRL.openStream());
                string = properties.getProperty("version", string);
                string = string.trim().replaceAll("[^0-9\\.]", "");
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return string;
    }
}

