/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.sqlite.JDBC;
import org.sqlite.SQLiteConfig;
import org.sqlite.SQLiteConfig$Encoding;
import org.sqlite.SQLiteConfig$JournalMode;
import org.sqlite.SQLiteConfig$LockingMode;
import org.sqlite.SQLiteConfig$SynchronousMode;
import org.sqlite.SQLiteConfig$TempStore;
import org.sqlite.SQLiteConnection;

public class SQLiteDataSource
implements DataSource {
    private SQLiteConfig config;
    private transient PrintWriter logger;
    private int loginTimeout = 1;
    private String url = "jdbc:sqlite:";
    private String databaseName = "";

    public SQLiteDataSource() {
        this.config = new SQLiteConfig();
    }

    public SQLiteDataSource(SQLiteConfig sQLiteConfig) {
        this.config = sQLiteConfig;
    }

    public void setConfig(SQLiteConfig sQLiteConfig) {
        this.config = sQLiteConfig;
    }

    public SQLiteConfig getConfig() {
        return this.config;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setDatabaseName(String string) {
        this.databaseName = string;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setSharedCache(boolean bl3) {
        this.config.setSharedCache(bl3);
    }

    public void setLoadExtension(boolean bl3) {
        this.config.enableLoadExtension(bl3);
    }

    public void setReadOnly(boolean bl3) {
        this.config.setReadOnly(bl3);
    }

    public void setCacheSize(int n4) {
        this.config.setCacheSize(n4);
    }

    public void setCaseSensitiveLike(boolean bl3) {
        this.config.enableCaseSensitiveLike(bl3);
    }

    public void setCountChanges(boolean bl3) {
        this.config.enableCountChanges(bl3);
    }

    public void setDefaultCacheSize(int n4) {
        this.config.setDefaultCacheSize(n4);
    }

    public void setEncoding(String string) {
        this.config.setEncoding(SQLiteConfig$Encoding.getEncoding(string));
    }

    public void setEnforceForeignKeys(boolean bl3) {
        this.config.enforceForeignKeys(bl3);
    }

    public void setFullColumnNames(boolean bl3) {
        this.config.enableFullColumnNames(bl3);
    }

    public void setFullSync(boolean bl3) {
        this.config.enableFullSync(bl3);
    }

    public void setIncrementalVacuum(int n4) {
        this.config.incrementalVacuum(n4);
    }

    public void setJournalMode(String string) {
        this.config.setJournalMode(SQLiteConfig$JournalMode.valueOf(string));
    }

    public void setJournalSizeLimit(int n4) {
        this.config.setJounalSizeLimit(n4);
    }

    public void setLegacyFileFormat(boolean bl3) {
        this.config.useLegacyFileFormat(bl3);
    }

    public void setLockingMode(String string) {
        this.config.setLockingMode(SQLiteConfig$LockingMode.valueOf(string));
    }

    public void setPageSize(int n4) {
        this.config.setPageSize(n4);
    }

    public void setMaxPageCount(int n4) {
        this.config.setMaxPageCount(n4);
    }

    public void setReadUncommited(boolean bl3) {
        this.config.setReadUncommited(bl3);
    }

    public void setRecursiveTriggers(boolean bl3) {
        this.config.enableRecursiveTriggers(bl3);
    }

    public void setReverseUnorderedSelects(boolean bl3) {
        this.config.enableReverseUnorderedSelects(bl3);
    }

    public void setShortColumnNames(boolean bl3) {
        this.config.enableShortColumnNames(bl3);
    }

    public void setSynchronous(String string) {
        this.config.setSynchronous(SQLiteConfig$SynchronousMode.valueOf(string));
    }

    public void setTempStore(String string) {
        this.config.setTempStore(SQLiteConfig$TempStore.valueOf(string));
    }

    public void setTempStoreDirectory(String string) {
        this.config.setTempStoreDirectory(string);
    }

    public void setTransactionMode(String string) {
        this.config.setTransactionMode(string);
    }

    public void setUserVersion(int n4) {
        this.config.setUserVersion(n4);
    }

    @Override
    public Connection getConnection() {
        return this.getConnection(null, null);
    }

    @Override
    public SQLiteConnection getConnection(String string, String string2) {
        Properties properties = this.config.toProperties();
        if (string != null) {
            properties.put("user", string);
        }
        if (string2 != null) {
            properties.put("pass", string2);
        }
        return JDBC.createConnection(this.url, properties);
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logger;
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public Logger getParentLogger() {
        throw new SQLFeatureNotSupportedException("getParentLogger");
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        this.logger = printWriter;
    }

    @Override
    public void setLoginTimeout(int n4) {
        this.loginTimeout = n4;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return (T)this;
    }
}

