/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;
import org.sqlite.SQLiteConfig$DateClass;
import org.sqlite.SQLiteConfig$DatePrecision;
import org.sqlite.SQLiteConfig$Pragma;
import org.sqlite.SQLiteConfig$TransactionMode;
import org.sqlite.date.FastDateFormat;

public class SQLiteConnectionConfig
implements Cloneable {
    private SQLiteConfig$DateClass dateClass = SQLiteConfig$DateClass.INTEGER;
    private SQLiteConfig$DatePrecision datePrecision = SQLiteConfig$DatePrecision.MILLISECONDS;
    private String dateStringFormat = "yyyy-MM-dd HH:mm:ss.SSS";
    private FastDateFormat dateFormat = FastDateFormat.getInstance(this.dateStringFormat);
    private int transactionIsolation = 8;
    private SQLiteConfig$TransactionMode transactionMode = SQLiteConfig$TransactionMode.DEFERRED;
    private boolean autoCommit = true;
    private static final Map<SQLiteConfig$TransactionMode, String> beginCommandMap = new EnumMap<SQLiteConfig$TransactionMode, String>(SQLiteConfig$TransactionMode.class);

    public static SQLiteConnectionConfig fromPragmaTable(Properties properties) {
        return new SQLiteConnectionConfig(SQLiteConfig$DateClass.getDateClass(properties.getProperty(SQLiteConfig$Pragma.DATE_CLASS.pragmaName, SQLiteConfig$DateClass.INTEGER.name())), SQLiteConfig$DatePrecision.getPrecision(properties.getProperty(SQLiteConfig$Pragma.DATE_PRECISION.pragmaName, SQLiteConfig$DatePrecision.MILLISECONDS.name())), properties.getProperty(SQLiteConfig$Pragma.DATE_STRING_FORMAT.pragmaName, "yyyy-MM-dd HH:mm:ss.SSS"), 8, SQLiteConfig$TransactionMode.getMode(properties.getProperty(SQLiteConfig$Pragma.TRANSACTION_MODE.pragmaName, SQLiteConfig$TransactionMode.DEFERRED.name())), true);
    }

    public SQLiteConnectionConfig(SQLiteConfig$DateClass sQLiteConfig$DateClass, SQLiteConfig$DatePrecision sQLiteConfig$DatePrecision, String string, int n4, SQLiteConfig$TransactionMode sQLiteConfig$TransactionMode, boolean bl3) {
        this.setDateClass(sQLiteConfig$DateClass);
        this.setDatePrecision(sQLiteConfig$DatePrecision);
        this.setDateStringFormat(string);
        this.setTransactionIsolation(n4);
        this.setTransactionMode(sQLiteConfig$TransactionMode);
        this.setAutoCommit(bl3);
    }

    public SQLiteConnectionConfig copyConfig() {
        return new SQLiteConnectionConfig(this.dateClass, this.datePrecision, this.dateStringFormat, this.transactionIsolation, this.transactionMode, this.autoCommit);
    }

    public long getDateMultiplier() {
        return this.datePrecision == SQLiteConfig$DatePrecision.MILLISECONDS ? 1L : 1000L;
    }

    public SQLiteConfig$DateClass getDateClass() {
        return this.dateClass;
    }

    public void setDateClass(SQLiteConfig$DateClass sQLiteConfig$DateClass) {
        this.dateClass = sQLiteConfig$DateClass;
    }

    public SQLiteConfig$DatePrecision getDatePrecision() {
        return this.datePrecision;
    }

    public void setDatePrecision(SQLiteConfig$DatePrecision sQLiteConfig$DatePrecision) {
        this.datePrecision = sQLiteConfig$DatePrecision;
    }

    public String getDateStringFormat() {
        return this.dateStringFormat;
    }

    public void setDateStringFormat(String string) {
        this.dateStringFormat = string;
        this.dateFormat = FastDateFormat.getInstance(string);
    }

    public FastDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean bl3) {
        this.autoCommit = bl3;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public void setTransactionIsolation(int n4) {
        this.transactionIsolation = n4;
    }

    public SQLiteConfig$TransactionMode getTransactionMode() {
        return this.transactionMode;
    }

    public void setTransactionMode(SQLiteConfig$TransactionMode sQLiteConfig$TransactionMode) {
        if (sQLiteConfig$TransactionMode == SQLiteConfig$TransactionMode.DEFFERED) {
            sQLiteConfig$TransactionMode = SQLiteConfig$TransactionMode.DEFERRED;
        }
        this.transactionMode = sQLiteConfig$TransactionMode;
    }

    String transactionPrefix() {
        return beginCommandMap.get(this.transactionMode);
    }

    static {
        beginCommandMap.put(SQLiteConfig$TransactionMode.DEFERRED, "begin;");
        beginCommandMap.put(SQLiteConfig$TransactionMode.IMMEDIATE, "begin immediate;");
        beginCommandMap.put(SQLiteConfig$TransactionMode.EXCLUSIVE, "begin exclusive;");
    }
}

