/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.sqlite.JDBC;
import org.sqlite.SQLiteConfig$DateClass;
import org.sqlite.SQLiteConfig$DatePrecision;
import org.sqlite.SQLiteConfig$Encoding;
import org.sqlite.SQLiteConfig$HexKeyMode;
import org.sqlite.SQLiteConfig$JournalMode;
import org.sqlite.SQLiteConfig$LockingMode;
import org.sqlite.SQLiteConfig$Pragma;
import org.sqlite.SQLiteConfig$PragmaValue;
import org.sqlite.SQLiteConfig$SynchronousMode;
import org.sqlite.SQLiteConfig$TempStore;
import org.sqlite.SQLiteConfig$TransactionMode;
import org.sqlite.SQLiteConnectionConfig;
import org.sqlite.SQLiteOpenMode;

public class SQLiteConfig {
    public static final String DEFAULT_DATE_STRING_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private final Properties pragmaTable;
    private int openModeFlag = 0;
    private final int busyTimeout;
    private final SQLiteConnectionConfig defaultConnectionConfig;
    private static final String[] OnOff = new String[]{"true", "false"};
    static final Set<String> pragmaSet = new TreeSet<String>();

    public SQLiteConfig() {
        this(new Properties());
    }

    public SQLiteConfig(Properties properties) {
        this.pragmaTable = properties;
        String string = this.pragmaTable.getProperty(SQLiteConfig$Pragma.OPEN_MODE.pragmaName);
        if (string != null) {
            this.openModeFlag = Integer.parseInt(string);
        } else {
            this.setOpenMode(SQLiteOpenMode.READWRITE);
            this.setOpenMode(SQLiteOpenMode.CREATE);
        }
        this.setSharedCache(Boolean.parseBoolean(this.pragmaTable.getProperty(SQLiteConfig$Pragma.SHARED_CACHE.pragmaName, "false")));
        this.setOpenMode(SQLiteOpenMode.OPEN_URI);
        this.busyTimeout = Integer.parseInt(this.pragmaTable.getProperty(SQLiteConfig$Pragma.BUSY_TIMEOUT.pragmaName, "3000"));
        this.defaultConnectionConfig = SQLiteConnectionConfig.fromPragmaTable(this.pragmaTable);
    }

    public SQLiteConnectionConfig newConnectionConfig() {
        return this.defaultConnectionConfig.copyConfig();
    }

    public Connection createConnection(String string) {
        return JDBC.createConnection(string, this.toProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Connection connection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : SQLiteConfig$Pragma.values()) {
            hashSet.add(object.pragmaName);
        }
        hashSet.remove(SQLiteConfig$Pragma.OPEN_MODE.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.SHARED_CACHE.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.LOAD_EXTENSION.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.DATE_PRECISION.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.DATE_CLASS.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.DATE_STRING_FORMAT.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.PASSWORD.pragmaName);
        hashSet.remove(SQLiteConfig$Pragma.HEXKEY_MODE.pragmaName);
        try (Statement statement = connection.createStatement();){
            String string;
            Object object;
            if (this.pragmaTable.containsKey(SQLiteConfig$Pragma.PASSWORD.pragmaName) && (string = this.pragmaTable.getProperty(SQLiteConfig$Pragma.PASSWORD.pragmaName)) != null && !string.isEmpty()) {
                String string2 = this.pragmaTable.getProperty(SQLiteConfig$Pragma.HEXKEY_MODE.pragmaName);
                object = SQLiteConfig$HexKeyMode.SSE.name().equalsIgnoreCase(string2) ? "pragma hexkey = '%s'" : (SQLiteConfig$HexKeyMode.SQLCIPHER.name().equalsIgnoreCase(string2) ? "pragma key = \"x'%s'\"" : "pragma key = '%s'");
                statement.execute(String.format((String)object, string.replace("'", "''")));
                statement.execute("select 1 from sqlite_master");
            }
            for (Object object2 : this.pragmaTable.keySet()) {
                String string3;
                object = object2.toString();
                if (!hashSet.contains(object) || (string3 = this.pragmaTable.getProperty((String)object)) == null) continue;
                statement.execute(String.format("pragma %s=%s", object, string3));
            }
        }
    }

    private void set(SQLiteConfig$Pragma sQLiteConfig$Pragma, boolean bl3) {
        this.setPragma(sQLiteConfig$Pragma, Boolean.toString(bl3));
    }

    private void set(SQLiteConfig$Pragma sQLiteConfig$Pragma, int n4) {
        this.setPragma(sQLiteConfig$Pragma, Integer.toString(n4));
    }

    private boolean getBoolean(SQLiteConfig$Pragma sQLiteConfig$Pragma, String string) {
        return Boolean.parseBoolean(this.pragmaTable.getProperty(sQLiteConfig$Pragma.pragmaName, string));
    }

    public boolean isEnabledSharedCache() {
        return this.getBoolean(SQLiteConfig$Pragma.SHARED_CACHE, "false");
    }

    public boolean isEnabledLoadExtension() {
        return this.getBoolean(SQLiteConfig$Pragma.LOAD_EXTENSION, "false");
    }

    public int getOpenModeFlags() {
        return this.openModeFlag;
    }

    public void setPragma(SQLiteConfig$Pragma sQLiteConfig$Pragma, String string) {
        this.pragmaTable.put(sQLiteConfig$Pragma.pragmaName, string);
    }

    public Properties toProperties() {
        this.pragmaTable.setProperty(SQLiteConfig$Pragma.OPEN_MODE.pragmaName, Integer.toString(this.openModeFlag));
        this.pragmaTable.setProperty(SQLiteConfig$Pragma.TRANSACTION_MODE.pragmaName, this.defaultConnectionConfig.getTransactionMode().getValue());
        this.pragmaTable.setProperty(SQLiteConfig$Pragma.DATE_CLASS.pragmaName, this.defaultConnectionConfig.getDateClass().getValue());
        this.pragmaTable.setProperty(SQLiteConfig$Pragma.DATE_PRECISION.pragmaName, this.defaultConnectionConfig.getDatePrecision().getValue());
        this.pragmaTable.setProperty(SQLiteConfig$Pragma.DATE_STRING_FORMAT.pragmaName, this.defaultConnectionConfig.getDateStringFormat());
        return this.pragmaTable;
    }

    static DriverPropertyInfo[] getDriverPropertyInfo() {
        SQLiteConfig$Pragma[] sQLiteConfig$PragmaArray = SQLiteConfig$Pragma.values();
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[sQLiteConfig$PragmaArray.length];
        int n4 = 0;
        for (SQLiteConfig$Pragma sQLiteConfig$Pragma : SQLiteConfig$Pragma.values()) {
            DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(sQLiteConfig$Pragma.pragmaName, null);
            driverPropertyInfo.choices = sQLiteConfig$Pragma.choices;
            driverPropertyInfo.description = sQLiteConfig$Pragma.description;
            driverPropertyInfo.required = false;
            driverPropertyInfoArray[n4++] = driverPropertyInfo;
        }
        return driverPropertyInfoArray;
    }

    public void setOpenMode(SQLiteOpenMode sQLiteOpenMode) {
        this.openModeFlag |= sQLiteOpenMode.flag;
    }

    public void resetOpenMode(SQLiteOpenMode sQLiteOpenMode) {
        this.openModeFlag &= ~sQLiteOpenMode.flag;
    }

    public void setSharedCache(boolean bl3) {
        this.set(SQLiteConfig$Pragma.SHARED_CACHE, bl3);
    }

    public void enableLoadExtension(boolean bl3) {
        this.set(SQLiteConfig$Pragma.LOAD_EXTENSION, bl3);
    }

    public void setReadOnly(boolean bl3) {
        if (bl3) {
            this.setOpenMode(SQLiteOpenMode.READONLY);
            this.resetOpenMode(SQLiteOpenMode.CREATE);
            this.resetOpenMode(SQLiteOpenMode.READWRITE);
        } else {
            this.setOpenMode(SQLiteOpenMode.READWRITE);
            this.setOpenMode(SQLiteOpenMode.CREATE);
            this.resetOpenMode(SQLiteOpenMode.READONLY);
        }
    }

    public void setCacheSize(int n4) {
        this.set(SQLiteConfig$Pragma.CACHE_SIZE, n4);
    }

    public void enableCaseSensitiveLike(boolean bl3) {
        this.set(SQLiteConfig$Pragma.CASE_SENSITIVE_LIKE, bl3);
    }

    public void enableCountChanges(boolean bl3) {
        this.set(SQLiteConfig$Pragma.COUNT_CHANGES, bl3);
    }

    public void setDefaultCacheSize(int n4) {
        this.set(SQLiteConfig$Pragma.DEFAULT_CACHE_SIZE, n4);
    }

    public void enableEmptyResultCallBacks(boolean bl3) {
        this.set(SQLiteConfig$Pragma.EMPTY_RESULT_CALLBACKS, bl3);
    }

    private static String[] toStringArray(SQLiteConfig$PragmaValue[] sQLiteConfig$PragmaValueArray) {
        String[] stringArray = new String[sQLiteConfig$PragmaValueArray.length];
        for (int i3 = 0; i3 < sQLiteConfig$PragmaValueArray.length; ++i3) {
            stringArray[i3] = sQLiteConfig$PragmaValueArray[i3].getValue();
        }
        return stringArray;
    }

    public void setEncoding(SQLiteConfig$Encoding sQLiteConfig$Encoding) {
        this.setPragma(SQLiteConfig$Pragma.ENCODING, sQLiteConfig$Encoding.typeName);
    }

    public void enforceForeignKeys(boolean bl3) {
        this.set(SQLiteConfig$Pragma.FOREIGN_KEYS, bl3);
    }

    public void enableFullColumnNames(boolean bl3) {
        this.set(SQLiteConfig$Pragma.FULL_COLUMN_NAMES, bl3);
    }

    public void enableFullSync(boolean bl3) {
        this.set(SQLiteConfig$Pragma.FULL_SYNC, bl3);
    }

    public void incrementalVacuum(int n4) {
        this.set(SQLiteConfig$Pragma.INCREMENTAL_VACUUM, n4);
    }

    public void setJournalMode(SQLiteConfig$JournalMode sQLiteConfig$JournalMode) {
        this.setPragma(SQLiteConfig$Pragma.JOURNAL_MODE, sQLiteConfig$JournalMode.name());
    }

    public void setJounalSizeLimit(int n4) {
        this.set(SQLiteConfig$Pragma.JOURNAL_SIZE_LIMIT, n4);
    }

    public void useLegacyFileFormat(boolean bl3) {
        this.set(SQLiteConfig$Pragma.LEGACY_FILE_FORMAT, bl3);
    }

    public void setLockingMode(SQLiteConfig$LockingMode sQLiteConfig$LockingMode) {
        this.setPragma(SQLiteConfig$Pragma.LOCKING_MODE, sQLiteConfig$LockingMode.name());
    }

    public void setPageSize(int n4) {
        this.set(SQLiteConfig$Pragma.PAGE_SIZE, n4);
    }

    public void setMaxPageCount(int n4) {
        this.set(SQLiteConfig$Pragma.MAX_PAGE_COUNT, n4);
    }

    public void setReadUncommited(boolean bl3) {
        this.set(SQLiteConfig$Pragma.READ_UNCOMMITED, bl3);
    }

    public void enableRecursiveTriggers(boolean bl3) {
        this.set(SQLiteConfig$Pragma.RECURSIVE_TRIGGERS, bl3);
    }

    public void enableReverseUnorderedSelects(boolean bl3) {
        this.set(SQLiteConfig$Pragma.REVERSE_UNORDERED_SELECTS, bl3);
    }

    public void enableShortColumnNames(boolean bl3) {
        this.set(SQLiteConfig$Pragma.SHORT_COLUMN_NAMES, bl3);
    }

    public void setSynchronous(SQLiteConfig$SynchronousMode sQLiteConfig$SynchronousMode) {
        this.setPragma(SQLiteConfig$Pragma.SYNCHRONOUS, sQLiteConfig$SynchronousMode.name());
    }

    public void setHexKeyMode(SQLiteConfig$HexKeyMode sQLiteConfig$HexKeyMode) {
        this.setPragma(SQLiteConfig$Pragma.HEXKEY_MODE, sQLiteConfig$HexKeyMode.name());
    }

    public void setTempStore(SQLiteConfig$TempStore sQLiteConfig$TempStore) {
        this.setPragma(SQLiteConfig$Pragma.TEMP_STORE, sQLiteConfig$TempStore.name());
    }

    public void setTempStoreDirectory(String string) {
        this.setPragma(SQLiteConfig$Pragma.TEMP_STORE_DIRECTORY, String.format("'%s'", string));
    }

    public void setUserVersion(int n4) {
        this.set(SQLiteConfig$Pragma.USER_VERSION, n4);
    }

    public void setApplicationId(int n4) {
        this.set(SQLiteConfig$Pragma.APPLICATION_ID, n4);
    }

    public void setTransactionMode(SQLiteConfig$TransactionMode sQLiteConfig$TransactionMode) {
        this.defaultConnectionConfig.setTransactionMode(sQLiteConfig$TransactionMode);
    }

    public void setTransactionMode(String string) {
        this.setTransactionMode(SQLiteConfig$TransactionMode.getMode(string));
    }

    public SQLiteConfig$TransactionMode getTransactionMode() {
        return this.defaultConnectionConfig.getTransactionMode();
    }

    public void setDatePrecision(String string) {
        this.defaultConnectionConfig.setDatePrecision(SQLiteConfig$DatePrecision.getPrecision(string));
    }

    public void setDateClass(String string) {
        this.defaultConnectionConfig.setDateClass(SQLiteConfig$DateClass.getDateClass(string));
    }

    public void setDateStringFormat(String string) {
        this.defaultConnectionConfig.setDateStringFormat(string);
    }

    public void setBusyTimeout(int n4) {
        this.setPragma(SQLiteConfig$Pragma.BUSY_TIMEOUT, Integer.toString(n4));
    }

    public int getBusyTimeout() {
        return this.busyTimeout;
    }

    static /* synthetic */ String[] access$000() {
        return OnOff;
    }

    static /* synthetic */ String[] access$100(SQLiteConfig$PragmaValue[] sQLiteConfig$PragmaValueArray) {
        return SQLiteConfig.toStringArray(sQLiteConfig$PragmaValueArray);
    }

    static {
        for (SQLiteConfig$Pragma sQLiteConfig$Pragma : SQLiteConfig$Pragma.values()) {
            pragmaSet.add(sQLiteConfig$Pragma.pragmaName);
        }
    }
}

