/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.util;

public final class Pow2 {
    public static final int MAX_POW2 = 0x40000000;

    public static int roundToPowerOfTwo(int n4) {
        if (n4 > 0x40000000) {
            throw new IllegalArgumentException("There is no larger power of 2 int for value:" + n4 + " since it exceeds 2^31.");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("Given value:" + n4 + ". Expecting value >= 0.");
        }
        int n7 = 1 << 32 - Integer.numberOfLeadingZeros(n4 - 1);
        return n7;
    }

    public static boolean isPowerOfTwo(int n4) {
        return (n4 & n4 - 1) == 0;
    }

    public static long align(long l2, int n4) {
        if (!Pow2.isPowerOfTwo(n4)) {
            throw new IllegalArgumentException("alignment must be a power of 2:" + n4);
        }
        return l2 + (long)(n4 - 1) & (long)(~(n4 - 1));
    }
}

