/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.atomic;

import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.atomic.LinkedAtomicArrayQueueUtil;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscChunkedAtomicArrayQueue;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.util.Pow2;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class MpscGrowableAtomicArrayQueue<E>
extends MpscChunkedAtomicArrayQueue<E> {
    public MpscGrowableAtomicArrayQueue(int n4) {
        super(Math.max(2, Pow2.roundToPowerOfTwo(n4 / 8)), n4);
    }

    public MpscGrowableAtomicArrayQueue(int n4, int n7) {
        super(n4, n7);
    }

    @Override
    protected int getNextBufferSize(AtomicReferenceArray<E> atomicReferenceArray) {
        long l2 = this.maxQueueCapacity / 2L;
        RangeUtil.checkLessThanOrEqual(LinkedAtomicArrayQueueUtil.length(atomicReferenceArray), l2, "buffer.length");
        int n4 = 2 * (LinkedAtomicArrayQueueUtil.length(atomicReferenceArray) - 1);
        return n4 + 1;
    }

    @Override
    protected long getCurrentBufferCapacity(long l2) {
        return l2 + 2L == this.maxQueueCapacity ? this.maxQueueCapacity : l2;
    }
}

