/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.atomic;

import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Consumer;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$ExitCondition;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Supplier;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$WaitStrategy;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.atomic.BaseMpscLinkedAtomicArrayQueueColdProducerFields;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.atomic.LinkedAtomicArrayQueueUtil;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.util.PortableJvmInfo;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.util.Pow2;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceArray;

public abstract class BaseMpscLinkedAtomicArrayQueue<E>
extends BaseMpscLinkedAtomicArrayQueueColdProducerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    private static final Object JUMP = new Object();

    public BaseMpscLinkedAtomicArrayQueue(int n4) {
        AtomicReferenceArray atomicReferenceArray;
        RangeUtil.checkGreaterThanOrEqual(n4, 2, "initialCapacity");
        int n7 = Pow2.roundToPowerOfTwo(n4);
        long l2 = n7 - 1 << 1;
        this.producerBuffer = atomicReferenceArray = LinkedAtomicArrayQueueUtil.allocate(n7 + 1);
        this.producerMask = l2;
        this.consumerBuffer = atomicReferenceArray;
        this.consumerMask = l2;
        this.soProducerLimit(l2);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        long l2;
        long l10;
        long l11 = this.lvConsumerIndex();
        do {
            l10 = l11;
            l2 = this.lvProducerIndex();
        } while (l10 != (l11 = this.lvConsumerIndex()));
        long l12 = l2 - l11 >> 1;
        if (l12 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l12;
    }

    @Override
    public final boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean offer(E e10) {
        AtomicReferenceArray atomicReferenceArray;
        long l2;
        long l10;
        if (null == e10) {
            throw new NullPointerException();
        }
        block6: while (true) {
            long l11 = this.lvProducerLimit();
            l10 = this.lvProducerIndex();
            if ((l10 & 1L) == 1L) continue;
            l2 = this.producerMask;
            atomicReferenceArray = this.producerBuffer;
            if (l11 <= l10) {
                int n4 = this.offerSlowPath(l2, l10, l11);
                switch (n4) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(l2, atomicReferenceArray, l10, e10);
                        return true;
                    }
                }
            }
            if (this.casProducerIndex(l10, l10 + 2L)) break;
        }
        int n7 = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l10, l2);
        LinkedAtomicArrayQueueUtil.soElement(atomicReferenceArray, n7, e10);
        return true;
    }

    @Override
    public E poll() {
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l10 = this.consumerMask;
        int n4 = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l2, l10);
        Object e10 = LinkedAtomicArrayQueueUtil.lvElement(atomicReferenceArray, n4);
        if (e10 == null) {
            if (l2 != this.lvProducerIndex()) {
                while ((e10 = LinkedAtomicArrayQueueUtil.lvElement(atomicReferenceArray, n4)) == null) {
                }
            } else {
                return null;
            }
        }
        if (e10 == JUMP) {
            AtomicReferenceArray<E> atomicReferenceArray2 = this.getNextBuffer(atomicReferenceArray, l10);
            return this.newBufferPoll(atomicReferenceArray2, l2);
        }
        LinkedAtomicArrayQueueUtil.soElement(atomicReferenceArray, n4, null);
        this.soConsumerIndex(l2 + 2L);
        return e10;
    }

    @Override
    public E peek() {
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l10 = this.consumerMask;
        int n4 = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l2, l10);
        Object e10 = LinkedAtomicArrayQueueUtil.lvElement(atomicReferenceArray, n4);
        if (e10 == null && l2 != this.lvProducerIndex()) {
            while ((e10 = LinkedAtomicArrayQueueUtil.lvElement(atomicReferenceArray, n4)) == null) {
            }
        }
        if (e10 == JUMP) {
            return this.newBufferPeek(this.getNextBuffer(atomicReferenceArray, l10), l2);
        }
        return e10;
    }

    private int offerSlowPath(long l2, long l10, long l11) {
        long l12 = this.lvConsumerIndex();
        long l13 = this.getCurrentBufferCapacity(l2);
        int n4 = 0;
        if (l12 + l13 > l10) {
            if (!this.casProducerLimit(l11, l12 + l13)) {
                n4 = 1;
            }
        } else {
            n4 = this.availableInQueue(l10, l12) <= 0L ? 2 : (this.casProducerIndex(l10, l10 + 1L) ? 3 : 1);
        }
        return n4;
    }

    protected abstract long availableInQueue(long var1, long var3);

    private AtomicReferenceArray<E> getNextBuffer(AtomicReferenceArray<E> atomicReferenceArray, long l2) {
        int n4 = this.nextArrayOffset(l2);
        AtomicReferenceArray atomicReferenceArray2 = (AtomicReferenceArray)LinkedAtomicArrayQueueUtil.lvElement(atomicReferenceArray, n4);
        LinkedAtomicArrayQueueUtil.soElement(atomicReferenceArray, n4, null);
        return atomicReferenceArray2;
    }

    private int nextArrayOffset(long l2) {
        return LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l2 + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(AtomicReferenceArray<E> atomicReferenceArray, long l2) {
        int n4 = this.newBufferAndOffset(atomicReferenceArray, l2);
        E e10 = LinkedAtomicArrayQueueUtil.lvElement(atomicReferenceArray, n4);
        if (e10 == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        LinkedAtomicArrayQueueUtil.soElement(atomicReferenceArray, n4, null);
        this.soConsumerIndex(l2 + 2L);
        return e10;
    }

    private E newBufferPeek(AtomicReferenceArray<E> atomicReferenceArray, long l2) {
        int n4 = this.newBufferAndOffset(atomicReferenceArray, l2);
        E e10 = LinkedAtomicArrayQueueUtil.lvElement(atomicReferenceArray, n4);
        if (null == e10) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return e10;
    }

    private int newBufferAndOffset(AtomicReferenceArray<E> atomicReferenceArray, long l2) {
        this.consumerBuffer = atomicReferenceArray;
        this.consumerMask = LinkedAtomicArrayQueueUtil.length(atomicReferenceArray) - 2 << 1;
        int n4 = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l2, this.consumerMask);
        return n4;
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex() / 2L;
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex() / 2L;
    }

    @Override
    public abstract int capacity();

    @Override
    public boolean relaxedOffer(E e10) {
        return this.offer(e10);
    }

    @Override
    public E relaxedPoll() {
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l10 = this.consumerMask;
        int n4 = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l2, l10);
        Object e10 = LinkedAtomicArrayQueueUtil.lvElement(atomicReferenceArray, n4);
        if (e10 == null) {
            return null;
        }
        if (e10 == JUMP) {
            AtomicReferenceArray<E> atomicReferenceArray2 = this.getNextBuffer(atomicReferenceArray, l10);
            return this.newBufferPoll(atomicReferenceArray2, l2);
        }
        LinkedAtomicArrayQueueUtil.soElement(atomicReferenceArray, n4, null);
        this.soConsumerIndex(l2 + 2L);
        return e10;
    }

    @Override
    public E relaxedPeek() {
        AtomicReferenceArray atomicReferenceArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l10 = this.consumerMask;
        int n4 = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l2, l10);
        Object e10 = LinkedAtomicArrayQueueUtil.lvElement(atomicReferenceArray, n4);
        if (e10 == JUMP) {
            return this.newBufferPeek(this.getNextBuffer(atomicReferenceArray, l10), l2);
        }
        return e10;
    }

    @Override
    public int fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier) {
        int n4;
        long l2 = 0L;
        int n7 = this.capacity();
        do {
            if ((n4 = this.fill(messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)l2;
        } while ((l2 += (long)n4) <= (long)n7);
        return (int)l2;
    }

    @Override
    public int fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier, int n4) {
        long l2;
        AtomicReferenceArray atomicReferenceArray;
        long l10;
        long l11;
        block5: while (true) {
            long l12 = this.lvProducerLimit();
            l11 = this.lvProducerIndex();
            if ((l11 & 1L) == 1L) continue;
            l10 = this.producerMask;
            atomicReferenceArray = this.producerBuffer;
            l2 = Math.min(l12, l11 + (long)(2 * n4));
            if (l11 == l12 || l12 < l2) {
                int n7 = this.offerSlowPath(l10, l11, l12);
                switch (n7) {
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        this.resize(l10, atomicReferenceArray, l11, messagePassingQueue$Supplier.get());
                        return 1;
                    }
                }
            }
            if (this.casProducerIndex(l11, l2)) break;
        }
        int n8 = (int)((l2 - l11) / 2L);
        int n10 = 0;
        for (n10 = 0; n10 < n8; ++n10) {
            int n11 = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l11 + (long)(2 * n10), l10);
            LinkedAtomicArrayQueueUtil.soElement(atomicReferenceArray, n11, messagePassingQueue$Supplier.get());
        }
        return n8;
    }

    @Override
    public void fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier, MessagePassingQueue$WaitStrategy messagePassingQueue$WaitStrategy, MessagePassingQueue$ExitCondition messagePassingQueue$ExitCondition) {
        while (messagePassingQueue$ExitCondition.keepRunning()) {
            while (this.fill(messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH) != 0 && messagePassingQueue$ExitCondition.keepRunning()) {
            }
            int n4 = 0;
            while (messagePassingQueue$ExitCondition.keepRunning() && this.fill(messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH) == 0) {
                n4 = messagePassingQueue$WaitStrategy.idle(n4);
            }
        }
    }

    @Override
    public int drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer) {
        return this.drain(messagePassingQueue$Consumer, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer, int n4) {
        E e10;
        int n7;
        for (n7 = 0; n7 < n4 && (e10 = this.relaxedPoll()) != null; ++n7) {
            messagePassingQueue$Consumer.accept(e10);
        }
        return n7;
    }

    @Override
    public void drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer, MessagePassingQueue$WaitStrategy messagePassingQueue$WaitStrategy, MessagePassingQueue$ExitCondition messagePassingQueue$ExitCondition) {
        int n4 = 0;
        while (messagePassingQueue$ExitCondition.keepRunning()) {
            E e10 = this.relaxedPoll();
            if (e10 == null) {
                n4 = messagePassingQueue$WaitStrategy.idle(n4);
                continue;
            }
            n4 = 0;
            messagePassingQueue$Consumer.accept(e10);
        }
    }

    private void resize(long l2, AtomicReferenceArray<E> atomicReferenceArray, long l10, E e10) {
        AtomicReferenceArray atomicReferenceArray2;
        int n4 = this.getNextBufferSize(atomicReferenceArray);
        this.producerBuffer = atomicReferenceArray2 = LinkedAtomicArrayQueueUtil.allocate(n4);
        int n7 = n4 - 2 << 1;
        this.producerMask = n7;
        int n8 = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l10, l2);
        int n10 = LinkedAtomicArrayQueueUtil.modifiedCalcElementOffset(l10, n7);
        LinkedAtomicArrayQueueUtil.soElement(atomicReferenceArray2, n10, e10);
        LinkedAtomicArrayQueueUtil.soElement(atomicReferenceArray, this.nextArrayOffset(l2), atomicReferenceArray2);
        long l11 = this.lvConsumerIndex();
        long l12 = this.availableInQueue(l10, l11);
        RangeUtil.checkPositive(l12, "availableInQueue");
        this.soProducerLimit(l10 + Math.min((long)n7, l12));
        this.soProducerIndex(l10 + 2L);
        LinkedAtomicArrayQueueUtil.soElement(atomicReferenceArray, n8, JUMP);
    }

    protected abstract int getNextBufferSize(AtomicReferenceArray<E> var1);

    protected abstract long getCurrentBufferCapacity(long var1);
}

