/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues;

import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.BaseMpscLinkedArrayQueueColdProducerFields;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.CircularArrayOffsetCalculator;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.LinkedArrayQueueUtil;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Consumer;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$ExitCondition;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$Supplier;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue$WaitStrategy;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.QueueProgressIndicators;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.util.PortableJvmInfo;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.util.Pow2;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.util.RangeUtil;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.util.UnsafeRefArrayAccess;
import java.util.Iterator;

public abstract class BaseMpscLinkedArrayQueue<E>
extends BaseMpscLinkedArrayQueueColdProducerFields<E>
implements MessagePassingQueue<E>,
QueueProgressIndicators {
    private static final Object JUMP = new Object();
    private static final int CONTINUE_TO_P_INDEX_CAS = 0;
    private static final int RETRY = 1;
    private static final int QUEUE_FULL = 2;
    private static final int QUEUE_RESIZE = 3;

    public BaseMpscLinkedArrayQueue(int n4) {
        RangeUtil.checkGreaterThanOrEqual(n4, 2, "initialCapacity");
        int n7 = Pow2.roundToPowerOfTwo(n4);
        long l2 = n7 - 1 << 1;
        E[] EArray = CircularArrayOffsetCalculator.allocate(n7 + 1);
        this.producerBuffer = EArray;
        this.producerMask = l2;
        this.consumerBuffer = EArray;
        this.consumerMask = l2;
        this.soProducerLimit(l2);
    }

    @Override
    public final Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int size() {
        long l2;
        long l10;
        long l11 = this.lvConsumerIndex();
        do {
            l10 = l11;
            l2 = this.lvProducerIndex();
        } while (l10 != (l11 = this.lvConsumerIndex()));
        long l12 = l2 - l11 >> 1;
        if (l12 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l12;
    }

    @Override
    public final boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean offer(E e10) {
        Object[] objectArray;
        long l2;
        long l10;
        long l11;
        if (null == e10) {
            throw new NullPointerException();
        }
        block6: while (true) {
            l11 = this.lvProducerLimit();
            l10 = this.lvProducerIndex();
            if ((l10 & 1L) == 1L) continue;
            l2 = this.producerMask;
            objectArray = this.producerBuffer;
            if (l11 <= l10) {
                int n4 = this.offerSlowPath(l2, l10, l11);
                switch (n4) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        continue block6;
                    }
                    case 2: {
                        return false;
                    }
                    case 3: {
                        this.resize(l2, objectArray, l10, e10);
                        return true;
                    }
                }
            }
            if (this.casProducerIndex(l10, l10 + 2L)) break;
        }
        l11 = LinkedArrayQueueUtil.modifiedCalcElementOffset(l10, l2);
        UnsafeRefArrayAccess.soElement(objectArray, l11, e10);
        return true;
    }

    @Override
    public E poll() {
        Object[] objectArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l10 = this.consumerMask;
        long l11 = LinkedArrayQueueUtil.modifiedCalcElementOffset(l2, l10);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l11);
        if (object == null) {
            if (l2 != this.lvProducerIndex()) {
                while ((object = UnsafeRefArrayAccess.lvElement(objectArray, l11)) == null) {
                }
            } else {
                return null;
            }
        }
        if (object == JUMP) {
            Object[] objectArray2 = this.getNextBuffer(objectArray, l10);
            return (E)this.newBufferPoll(objectArray2, l2);
        }
        UnsafeRefArrayAccess.soElement(objectArray, l11, null);
        this.soConsumerIndex(l2 + 2L);
        return (E)object;
    }

    @Override
    public E peek() {
        Object[] objectArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l10 = this.consumerMask;
        long l11 = LinkedArrayQueueUtil.modifiedCalcElementOffset(l2, l10);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l11);
        if (object == null && l2 != this.lvProducerIndex()) {
            while ((object = UnsafeRefArrayAccess.lvElement(objectArray, l11)) == null) {
            }
        }
        if (object == JUMP) {
            return (E)this.newBufferPeek(this.getNextBuffer(objectArray, l10), l2);
        }
        return (E)object;
    }

    private int offerSlowPath(long l2, long l10, long l11) {
        long l12;
        long l13 = this.lvConsumerIndex();
        if (l13 + (l12 = this.getCurrentBufferCapacity(l2)) > l10) {
            if (!this.casProducerLimit(l11, l13 + l12)) {
                return 1;
            }
            return 0;
        }
        if (this.availableInQueue(l10, l13) <= 0L) {
            return 2;
        }
        if (this.casProducerIndex(l10, l10 + 1L)) {
            return 3;
        }
        return 1;
    }

    protected abstract long availableInQueue(long var1, long var3);

    private E[] getNextBuffer(E[] EArray, long l2) {
        long l10 = this.nextArrayOffset(l2);
        Object[] objectArray = (Object[])UnsafeRefArrayAccess.lvElement(EArray, l10);
        UnsafeRefArrayAccess.soElement(EArray, l10, null);
        return objectArray;
    }

    private long nextArrayOffset(long l2) {
        return LinkedArrayQueueUtil.modifiedCalcElementOffset(l2 + 2L, Long.MAX_VALUE);
    }

    private E newBufferPoll(E[] EArray, long l2) {
        long l10 = this.newBufferAndOffset(EArray, l2);
        E e10 = UnsafeRefArrayAccess.lvElement(EArray, l10);
        if (e10 == null) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        UnsafeRefArrayAccess.soElement(EArray, l10, null);
        this.soConsumerIndex(l2 + 2L);
        return e10;
    }

    private E newBufferPeek(E[] EArray, long l2) {
        long l10 = this.newBufferAndOffset(EArray, l2);
        E e10 = UnsafeRefArrayAccess.lvElement(EArray, l10);
        if (null == e10) {
            throw new IllegalStateException("new buffer must have at least one element");
        }
        return e10;
    }

    private long newBufferAndOffset(E[] EArray, long l2) {
        this.consumerBuffer = EArray;
        this.consumerMask = LinkedArrayQueueUtil.length(EArray) - 2 << 1;
        return LinkedArrayQueueUtil.modifiedCalcElementOffset(l2, this.consumerMask);
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex() / 2L;
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex() / 2L;
    }

    @Override
    public abstract int capacity();

    @Override
    public boolean relaxedOffer(E e10) {
        return this.offer(e10);
    }

    @Override
    public E relaxedPoll() {
        Object[] objectArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l10 = this.consumerMask;
        long l11 = LinkedArrayQueueUtil.modifiedCalcElementOffset(l2, l10);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l11);
        if (object == null) {
            return null;
        }
        if (object == JUMP) {
            Object[] objectArray2 = this.getNextBuffer(objectArray, l10);
            return (E)this.newBufferPoll(objectArray2, l2);
        }
        UnsafeRefArrayAccess.soElement(objectArray, l11, null);
        this.soConsumerIndex(l2 + 2L);
        return (E)object;
    }

    @Override
    public E relaxedPeek() {
        Object[] objectArray = this.consumerBuffer;
        long l2 = this.consumerIndex;
        long l10 = this.consumerMask;
        long l11 = LinkedArrayQueueUtil.modifiedCalcElementOffset(l2, l10);
        Object object = UnsafeRefArrayAccess.lvElement(objectArray, l11);
        if (object == JUMP) {
            return (E)this.newBufferPeek(this.getNextBuffer(objectArray, l10), l2);
        }
        return (E)object;
    }

    @Override
    public int fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier) {
        int n4;
        long l2 = 0L;
        int n7 = this.capacity();
        do {
            if ((n4 = this.fill(messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH)) != 0) continue;
            return (int)l2;
        } while ((l2 += (long)n4) <= (long)n7);
        return (int)l2;
    }

    @Override
    public int fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier, int n4) {
        long l2;
        Object[] objectArray;
        long l10;
        long l11;
        block5: while (true) {
            long l12 = this.lvProducerLimit();
            l11 = this.lvProducerIndex();
            if ((l11 & 1L) == 1L) continue;
            l10 = this.producerMask;
            objectArray = this.producerBuffer;
            l2 = Math.min(l12, l11 + (long)(2 * n4));
            if (l11 >= l12 || l12 < l2) {
                int n7 = this.offerSlowPath(l10, l11, l12);
                switch (n7) {
                    case 0: 
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        this.resize(l10, objectArray, l11, messagePassingQueue$Supplier.get());
                        return 1;
                    }
                }
            }
            if (this.casProducerIndex(l11, l2)) break;
        }
        int n8 = (int)((l2 - l11) / 2L);
        for (int i3 = 0; i3 < n8; ++i3) {
            long l13 = LinkedArrayQueueUtil.modifiedCalcElementOffset(l11 + (long)(2 * i3), l10);
            UnsafeRefArrayAccess.soElement(objectArray, l13, messagePassingQueue$Supplier.get());
        }
        return n8;
    }

    @Override
    public void fill(MessagePassingQueue$Supplier<E> messagePassingQueue$Supplier, MessagePassingQueue$WaitStrategy messagePassingQueue$WaitStrategy, MessagePassingQueue$ExitCondition messagePassingQueue$ExitCondition) {
        while (messagePassingQueue$ExitCondition.keepRunning()) {
            if (this.fill(messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH) != 0) continue;
            int n4 = 0;
            while (messagePassingQueue$ExitCondition.keepRunning() && this.fill(messagePassingQueue$Supplier, PortableJvmInfo.RECOMENDED_OFFER_BATCH) == 0) {
                n4 = messagePassingQueue$WaitStrategy.idle(n4);
            }
        }
    }

    @Override
    public int drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer) {
        return this.drain(messagePassingQueue$Consumer, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer, int n4) {
        E e10;
        int n7;
        for (n7 = 0; n7 < n4 && (e10 = this.relaxedPoll()) != null; ++n7) {
            messagePassingQueue$Consumer.accept(e10);
        }
        return n7;
    }

    @Override
    public void drain(MessagePassingQueue$Consumer<E> messagePassingQueue$Consumer, MessagePassingQueue$WaitStrategy messagePassingQueue$WaitStrategy, MessagePassingQueue$ExitCondition messagePassingQueue$ExitCondition) {
        int n4 = 0;
        while (messagePassingQueue$ExitCondition.keepRunning()) {
            E e10 = this.relaxedPoll();
            if (e10 == null) {
                n4 = messagePassingQueue$WaitStrategy.idle(n4);
                continue;
            }
            n4 = 0;
            messagePassingQueue$Consumer.accept(e10);
        }
    }

    private void resize(long l2, E[] EArray, long l10, E e10) {
        int n4 = this.getNextBufferSize(EArray);
        E[] EArray2 = CircularArrayOffsetCalculator.allocate(n4);
        this.producerBuffer = EArray2;
        int n7 = n4 - 2 << 1;
        this.producerMask = n7;
        long l11 = LinkedArrayQueueUtil.modifiedCalcElementOffset(l10, l2);
        long l12 = LinkedArrayQueueUtil.modifiedCalcElementOffset(l10, n7);
        UnsafeRefArrayAccess.soElement(EArray2, l12, e10);
        UnsafeRefArrayAccess.soElement(EArray, this.nextArrayOffset(l2), EArray2);
        long l13 = this.lvConsumerIndex();
        long l14 = this.availableInQueue(l10, l13);
        RangeUtil.checkPositive(l14, "availableInQueue");
        this.soProducerLimit(l10 + Math.min((long)n7, l14));
        this.soProducerIndex(l10 + 2L);
        UnsafeRefArrayAccess.soElement(EArray, l11, JUMP);
    }

    protected abstract int getNextBufferSize(E[] var1);

    protected abstract long getCurrentBufferCapacity(long var1);
}

