/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal;

import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil$1;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.AccessController;

public final class SystemPropertyUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SystemPropertyUtil.class);

    public static boolean contains(String string) {
        return SystemPropertyUtil.get(string) != null;
    }

    public static String get(String string) {
        return SystemPropertyUtil.get(string, null);
    }

    public static String get(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("key");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("key must not be empty.");
        }
        String string3 = null;
        try {
            string3 = System.getSecurityManager() == null ? System.getProperty(string) : AccessController.doPrivileged(new SystemPropertyUtil$1(string));
        }
        catch (SecurityException securityException) {
            logger.warn("Unable to retrieve a system property '{}'; default values will be used.", (Object)string, (Object)securityException);
        }
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public static boolean getBoolean(String string, boolean bl3) {
        String string2 = SystemPropertyUtil.get(string);
        if (string2 == null) {
            return bl3;
        }
        if ((string2 = string2.trim().toLowerCase()).isEmpty()) {
            return bl3;
        }
        if ("true".equals(string2) || "yes".equals(string2) || "1".equals(string2)) {
            return true;
        }
        if ("false".equals(string2) || "no".equals(string2) || "0".equals(string2)) {
            return false;
        }
        logger.warn("Unable to parse the boolean system property '{}':{} - using the default value: {}", string, string2, bl3);
        return bl3;
    }

    public static int getInt(String string, int n4) {
        String string2 = SystemPropertyUtil.get(string);
        if (string2 == null) {
            return n4;
        }
        string2 = string2.trim();
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            logger.warn("Unable to parse the integer system property '{}':{} - using the default value: {}", string, string2, n4);
            return n4;
        }
    }

    public static long getLong(String string, long l2) {
        String string2 = SystemPropertyUtil.get(string);
        if (string2 == null) {
            return l2;
        }
        string2 = string2.trim();
        try {
            return Long.parseLong(string2);
        }
        catch (Exception exception) {
            logger.warn("Unable to parse the long integer system property '{}':{} - using the default value: {}", string, string2, l2);
            return l2;
        }
    }

    private SystemPropertyUtil() {
    }
}

