/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal;

import io.grpc.netty.shaded.io.netty.util.internal.EmptyArrays;
import io.grpc.netty.shaded.io.netty.util.internal.InternalThreadLocalMap;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class StringUtil {
    public static final String EMPTY_STRING = "";
    public static final String NEWLINE = SystemPropertyUtil.get("line.separator", "\n");
    public static final char DOUBLE_QUOTE = '\"';
    public static final char COMMA = ',';
    public static final char LINE_FEED = '\n';
    public static final char CARRIAGE_RETURN = '\r';
    public static final char TAB = '\t';
    public static final char SPACE = ' ';
    private static final String[] BYTE2HEX_PAD = new String[256];
    private static final String[] BYTE2HEX_NOPAD = new String[256];
    private static final int CSV_NUMBER_ESCAPE_CHARACTERS = 7;
    private static final char PACKAGE_SEPARATOR_CHAR = '.';

    private StringUtil() {
    }

    public static String substringAfter(String string, char c10) {
        int n4 = string.indexOf(c10);
        if (n4 >= 0) {
            return string.substring(n4 + 1);
        }
        return null;
    }

    public static boolean commonSuffixOfLength(String string, String string2, int n4) {
        return string != null && string2 != null && n4 >= 0 && string.regionMatches(string.length() - n4, string2, string2.length() - n4, n4);
    }

    public static String byteToHexStringPadded(int n4) {
        return BYTE2HEX_PAD[n4 & 0xFF];
    }

    public static <T extends Appendable> T byteToHexStringPadded(T t3, int n4) {
        try {
            t3.append(StringUtil.byteToHexStringPadded(n4));
        }
        catch (IOException iOException) {
            PlatformDependent.throwException(iOException);
        }
        return t3;
    }

    public static String toHexStringPadded(byte[] byArray) {
        return StringUtil.toHexStringPadded(byArray, 0, byArray.length);
    }

    public static String toHexStringPadded(byte[] byArray, int n4, int n7) {
        return StringUtil.toHexStringPadded(new StringBuilder(n7 << 1), byArray, n4, n7).toString();
    }

    public static <T extends Appendable> T toHexStringPadded(T t3, byte[] byArray) {
        return StringUtil.toHexStringPadded(t3, byArray, 0, byArray.length);
    }

    public static <T extends Appendable> T toHexStringPadded(T t3, byte[] byArray, int n4, int n7) {
        int n8 = n4 + n7;
        for (int i3 = n4; i3 < n8; ++i3) {
            StringUtil.byteToHexStringPadded(t3, byArray[i3]);
        }
        return t3;
    }

    public static String byteToHexString(int n4) {
        return BYTE2HEX_NOPAD[n4 & 0xFF];
    }

    public static <T extends Appendable> T byteToHexString(T t3, int n4) {
        try {
            t3.append(StringUtil.byteToHexString(n4));
        }
        catch (IOException iOException) {
            PlatformDependent.throwException(iOException);
        }
        return t3;
    }

    public static String toHexString(byte[] byArray) {
        return StringUtil.toHexString(byArray, 0, byArray.length);
    }

    public static String toHexString(byte[] byArray, int n4, int n7) {
        return StringUtil.toHexString(new StringBuilder(n7 << 1), byArray, n4, n7).toString();
    }

    public static <T extends Appendable> T toHexString(T t3, byte[] byArray) {
        return StringUtil.toHexString(t3, byArray, 0, byArray.length);
    }

    public static <T extends Appendable> T toHexString(T t3, byte[] byArray, int n4, int n7) {
        int n8;
        assert (n7 >= 0);
        if (n7 == 0) {
            return t3;
        }
        int n10 = n4 + n7;
        int n11 = n10 - 1;
        for (n8 = n4; n8 < n11 && byArray[n8] == 0; ++n8) {
        }
        StringUtil.byteToHexString(t3, byArray[n8++]);
        int n12 = n10 - n8;
        StringUtil.toHexStringPadded(t3, byArray, n8, n12);
        return t3;
    }

    public static int decodeHexNibble(char c10) {
        if (c10 >= '0' && c10 <= '9') {
            return c10 - 48;
        }
        if (c10 >= 'A' && c10 <= 'F') {
            return c10 - 55;
        }
        if (c10 >= 'a' && c10 <= 'f') {
            return c10 - 87;
        }
        return -1;
    }

    public static byte decodeHexByte(CharSequence charSequence, int n4) {
        int n7 = StringUtil.decodeHexNibble(charSequence.charAt(n4));
        int n8 = StringUtil.decodeHexNibble(charSequence.charAt(n4 + 1));
        if (n7 == -1 || n8 == -1) {
            throw new IllegalArgumentException(String.format("invalid hex byte '%s' at index %d of '%s'", charSequence.subSequence(n4, n4 + 2), n4, charSequence));
        }
        return (byte)((n7 << 4) + n8);
    }

    public static byte[] decodeHexDump(CharSequence charSequence, int n4, int n7) {
        if (n7 < 0 || (n7 & 1) != 0) {
            throw new IllegalArgumentException("length: " + n7);
        }
        if (n7 == 0) {
            return EmptyArrays.EMPTY_BYTES;
        }
        byte[] byArray = new byte[n7 >>> 1];
        for (int i3 = 0; i3 < n7; i3 += 2) {
            byArray[i3 >>> 1] = StringUtil.decodeHexByte(charSequence, n4 + i3);
        }
        return byArray;
    }

    public static byte[] decodeHexDump(CharSequence charSequence) {
        return StringUtil.decodeHexDump(charSequence, 0, charSequence.length());
    }

    public static String simpleClassName(Object object) {
        if (object == null) {
            return "null_object";
        }
        return StringUtil.simpleClassName(object.getClass());
    }

    public static String simpleClassName(Class<?> clazz) {
        String string = ObjectUtil.checkNotNull(clazz, "clazz").getName();
        int n4 = string.lastIndexOf(46);
        if (n4 > -1) {
            return string.substring(n4 + 1);
        }
        return string;
    }

    public static CharSequence escapeCsv(CharSequence charSequence) {
        return StringUtil.escapeCsv(charSequence, false);
    }

    public static CharSequence escapeCsv(CharSequence charSequence, boolean bl3) {
        int n4;
        int n7;
        int n8;
        int n10 = ObjectUtil.checkNotNull(charSequence, "value").length();
        if (bl3) {
            n8 = StringUtil.indexOfFirstNonOwsChar(charSequence, n10);
            n7 = StringUtil.indexOfLastNonOwsChar(charSequence, n8, n10);
        } else {
            n8 = 0;
            n7 = n10 - 1;
        }
        if (n8 > n7) {
            return EMPTY_STRING;
        }
        int n11 = -1;
        boolean bl4 = false;
        if (StringUtil.isDoubleQuote(charSequence.charAt(n8))) {
            boolean bl5 = bl4 = StringUtil.isDoubleQuote(charSequence.charAt(n7)) && n7 > n8;
            if (bl4) {
                ++n8;
                --n7;
            } else {
                n11 = n8;
            }
        }
        if (n11 < 0) {
            int n12;
            if (bl4) {
                for (n12 = n8; n12 <= n7; ++n12) {
                    if (!StringUtil.isDoubleQuote(charSequence.charAt(n12))) continue;
                    if (n12 == n7 || !StringUtil.isDoubleQuote(charSequence.charAt(n12 + 1))) {
                        n11 = n12;
                        break;
                    }
                    ++n12;
                }
            } else {
                for (n12 = n8; n12 <= n7; ++n12) {
                    n4 = charSequence.charAt(n12);
                    if (n4 == 10 || n4 == 13 || n4 == 44) {
                        n11 = n12;
                        break;
                    }
                    if (!StringUtil.isDoubleQuote((char)n4)) continue;
                    if (n12 == n7 || !StringUtil.isDoubleQuote(charSequence.charAt(n12 + 1))) {
                        n11 = n12;
                        break;
                    }
                    ++n12;
                }
            }
            if (n11 < 0) {
                return bl4 ? charSequence.subSequence(n8 - 1, n7 + 2) : charSequence.subSequence(n8, n7 + 1);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(n7 - n8 + 1 + 7);
        stringBuilder.append('\"').append(charSequence, n8, n11);
        for (n4 = n11; n4 <= n7; ++n4) {
            char c10 = charSequence.charAt(n4);
            if (StringUtil.isDoubleQuote(c10)) {
                stringBuilder.append('\"');
                if (n4 < n7 && StringUtil.isDoubleQuote(charSequence.charAt(n4 + 1))) {
                    ++n4;
                }
            }
            stringBuilder.append(c10);
        }
        return stringBuilder.append('\"');
    }

    public static CharSequence unescapeCsv(CharSequence charSequence) {
        boolean bl3;
        int n4 = ObjectUtil.checkNotNull(charSequence, "value").length();
        if (n4 == 0) {
            return charSequence;
        }
        int n7 = n4 - 1;
        boolean bl4 = bl3 = StringUtil.isDoubleQuote(charSequence.charAt(0)) && StringUtil.isDoubleQuote(charSequence.charAt(n7)) && n4 != 1;
        if (!bl3) {
            StringUtil.validateCsvFormat(charSequence);
            return charSequence;
        }
        StringBuilder stringBuilder = InternalThreadLocalMap.get().stringBuilder();
        for (int i3 = 1; i3 < n7; ++i3) {
            char c10 = charSequence.charAt(i3);
            if (c10 == '\"') {
                if (StringUtil.isDoubleQuote(charSequence.charAt(i3 + 1)) && i3 + 1 != n7) {
                    ++i3;
                } else {
                    throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, i3);
                }
            }
            stringBuilder.append(c10);
        }
        return stringBuilder.toString();
    }

    public static List<CharSequence> unescapeCsvFields(CharSequence charSequence) {
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(2);
        StringBuilder stringBuilder = InternalThreadLocalMap.get().stringBuilder();
        boolean bl3 = false;
        int n4 = charSequence.length() - 1;
        block8: for (int i3 = 0; i3 <= n4; ++i3) {
            char c10 = charSequence.charAt(i3);
            if (bl3) {
                switch (c10) {
                    case '\"': {
                        char c11;
                        if (i3 == n4) {
                            arrayList.add(stringBuilder.toString());
                            return arrayList;
                        }
                        if ((c11 = charSequence.charAt(++i3)) == '\"') {
                            stringBuilder.append('\"');
                            break;
                        }
                        if (c11 == ',') {
                            bl3 = false;
                            arrayList.add(stringBuilder.toString());
                            stringBuilder.setLength(0);
                            break;
                        }
                        throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, i3 - 1);
                    }
                    default: {
                        stringBuilder.append(c10);
                        break;
                    }
                }
                continue;
            }
            switch (c10) {
                case ',': {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue block8;
                }
                case '\"': {
                    if (stringBuilder.length() == 0) {
                        bl3 = true;
                        continue block8;
                    }
                }
                case '\n': 
                case '\r': {
                    throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, i3);
                }
                default: {
                    stringBuilder.append(c10);
                }
            }
        }
        if (bl3) {
            throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, n4);
        }
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    private static void validateCsvFormat(CharSequence charSequence) {
        int n4 = charSequence.length();
        for (int i3 = 0; i3 < n4; ++i3) {
            switch (charSequence.charAt(i3)) {
                case '\n': 
                case '\r': 
                case '\"': 
                case ',': {
                    throw StringUtil.newInvalidEscapedCsvFieldException(charSequence, i3);
                }
            }
        }
    }

    private static IllegalArgumentException newInvalidEscapedCsvFieldException(CharSequence charSequence, int n4) {
        return new IllegalArgumentException("invalid escaped CSV field: " + charSequence + " index: " + n4);
    }

    public static int length(String string) {
        return string == null ? 0 : string.length();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static int indexOfNonWhiteSpace(CharSequence charSequence, int n4) {
        while (n4 < charSequence.length()) {
            if (!Character.isWhitespace(charSequence.charAt(n4))) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public static boolean isSurrogate(char c10) {
        return c10 >= '\ud800' && c10 <= '\udfff';
    }

    private static boolean isDoubleQuote(char c10) {
        return c10 == '\"';
    }

    public static boolean endsWith(CharSequence charSequence, char c10) {
        int n4 = charSequence.length();
        return n4 > 0 && charSequence.charAt(n4 - 1) == c10;
    }

    public static CharSequence trimOws(CharSequence charSequence) {
        int n4 = charSequence.length();
        if (n4 == 0) {
            return charSequence;
        }
        int n7 = StringUtil.indexOfFirstNonOwsChar(charSequence, n4);
        int n8 = StringUtil.indexOfLastNonOwsChar(charSequence, n7, n4);
        return n7 == 0 && n8 == n4 - 1 ? charSequence : charSequence.subSequence(n7, n8 + 1);
    }

    private static int indexOfFirstNonOwsChar(CharSequence charSequence, int n4) {
        int n7;
        for (n7 = 0; n7 < n4 && StringUtil.isOws(charSequence.charAt(n7)); ++n7) {
        }
        return n7;
    }

    private static int indexOfLastNonOwsChar(CharSequence charSequence, int n4, int n7) {
        int n8;
        for (n8 = n7 - 1; n8 > n4 && StringUtil.isOws(charSequence.charAt(n8)); --n8) {
        }
        return n8;
    }

    private static boolean isOws(char c10) {
        return c10 == ' ' || c10 == '\t';
    }

    static {
        for (int i3 = 0; i3 < BYTE2HEX_PAD.length; ++i3) {
            String string = Integer.toHexString(i3);
            StringUtil.BYTE2HEX_PAD[i3] = i3 > 15 ? string : '0' + string;
            StringUtil.BYTE2HEX_NOPAD[i3] = string;
        }
    }
}

