/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal;

import io.grpc.netty.shaded.io.netty.util.internal.SocketUtils$1;
import io.grpc.netty.shaded.io.netty.util.internal.SocketUtils$10;
import io.grpc.netty.shaded.io.netty.util.internal.SocketUtils$11;
import io.grpc.netty.shaded.io.netty.util.internal.SocketUtils$12;
import io.grpc.netty.shaded.io.netty.util.internal.SocketUtils$13;
import io.grpc.netty.shaded.io.netty.util.internal.SocketUtils$2;
import io.grpc.netty.shaded.io.netty.util.internal.SocketUtils$3;
import io.grpc.netty.shaded.io.netty.util.internal.SocketUtils$4;
import io.grpc.netty.shaded.io.netty.util.internal.SocketUtils$5;
import io.grpc.netty.shaded.io.netty.util.internal.SocketUtils$6;
import io.grpc.netty.shaded.io.netty.util.internal.SocketUtils$7;
import io.grpc.netty.shaded.io.netty.util.internal.SocketUtils$8;
import io.grpc.netty.shaded.io.netty.util.internal.SocketUtils$9;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;

public final class SocketUtils {
    private SocketUtils() {
    }

    public static void connect(Socket socket, SocketAddress socketAddress, int n4) {
        try {
            AccessController.doPrivileged(new SocketUtils$1(socket, socketAddress, n4));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static void bind(Socket socket, SocketAddress socketAddress) {
        try {
            AccessController.doPrivileged(new SocketUtils$2(socket, socketAddress));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static boolean connect(SocketChannel socketChannel, SocketAddress socketAddress) {
        try {
            return AccessController.doPrivileged(new SocketUtils$3(socketChannel, socketAddress));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static void bind(SocketChannel socketChannel, SocketAddress socketAddress) {
        try {
            AccessController.doPrivileged(new SocketUtils$4(socketChannel, socketAddress));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static SocketChannel accept(ServerSocketChannel serverSocketChannel) {
        try {
            return AccessController.doPrivileged(new SocketUtils$5(serverSocketChannel));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static void bind(DatagramChannel datagramChannel, SocketAddress socketAddress) {
        try {
            AccessController.doPrivileged(new SocketUtils$6(datagramChannel, socketAddress));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    public static SocketAddress localSocketAddress(ServerSocket serverSocket) {
        return AccessController.doPrivileged(new SocketUtils$7(serverSocket));
    }

    public static InetAddress addressByName(String string) {
        try {
            return AccessController.doPrivileged(new SocketUtils$8(string));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (UnknownHostException)privilegedActionException.getCause();
        }
    }

    public static InetAddress[] allAddressesByName(String string) {
        try {
            return AccessController.doPrivileged(new SocketUtils$9(string));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (UnknownHostException)privilegedActionException.getCause();
        }
    }

    public static InetSocketAddress socketAddress(String string, int n4) {
        return AccessController.doPrivileged(new SocketUtils$10(string, n4));
    }

    public static Enumeration<InetAddress> addressesFromNetworkInterface(NetworkInterface networkInterface) {
        return AccessController.doPrivileged(new SocketUtils$11(networkInterface));
    }

    public static InetAddress loopbackAddress() {
        return AccessController.doPrivileged(new SocketUtils$12());
    }

    public static byte[] hardwareAddressFromNetworkInterface(NetworkInterface networkInterface) {
        try {
            return AccessController.doPrivileged(new SocketUtils$13(networkInterface));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (SocketException)privilegedActionException.getCause();
        }
    }
}

