/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal;

import io.grpc.netty.shaded.io.netty.util.IllegalReferenceCountException;
import io.grpc.netty.shaded.io.netty.util.ReferenceCounted;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class ReferenceCountUpdater<T extends ReferenceCounted> {
    protected ReferenceCountUpdater() {
    }

    public static long getUnsafeOffset(Class<? extends ReferenceCounted> clazz, String string) {
        try {
            if (PlatformDependent.hasUnsafe()) {
                return PlatformDependent.objectFieldOffset(clazz.getDeclaredField(string));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1L;
    }

    protected abstract AtomicIntegerFieldUpdater<T> updater();

    protected abstract long unsafeOffset();

    public final int initialValue() {
        return 2;
    }

    private static int realRefCnt(int n4) {
        return n4 != 2 && n4 != 4 && (n4 & 1) != 0 ? 0 : n4 >>> 1;
    }

    private static int toLiveRealRefCnt(int n4, int n7) {
        if (n4 == 2 || n4 == 4 || (n4 & 1) == 0) {
            return n4 >>> 1;
        }
        throw new IllegalReferenceCountException(0, -n7);
    }

    private int nonVolatileRawCnt(T t3) {
        long l2 = this.unsafeOffset();
        return l2 != -1L ? PlatformDependent.getInt(t3, l2) : this.updater().get(t3);
    }

    public final int refCnt(T t3) {
        return ReferenceCountUpdater.realRefCnt(this.updater().get(t3));
    }

    public final boolean isLiveNonVolatile(T t3) {
        long l2 = this.unsafeOffset();
        int n4 = l2 != -1L ? PlatformDependent.getInt(t3, l2) : this.updater().get(t3);
        return n4 == 2 || n4 == 4 || n4 == 6 || n4 == 8 || (n4 & 1) == 0;
    }

    public final void setRefCnt(T t3, int n4) {
        this.updater().set(t3, n4 > 0 ? n4 << 1 : 1);
    }

    public final void resetRefCnt(T t3) {
        this.updater().set(t3, this.initialValue());
    }

    public final T retain(T t3) {
        return this.retain0(t3, 1, 2);
    }

    public final T retain(T t3, int n4) {
        int n7 = ObjectUtil.checkPositive(n4, "increment") << 1;
        return this.retain0(t3, n4, n7);
    }

    private T retain0(T t3, int n4, int n7) {
        int n8 = this.updater().getAndAdd(t3, n7);
        if (n8 != 2 && n8 != 4 && (n8 & 1) != 0) {
            throw new IllegalReferenceCountException(0, n4);
        }
        if (n8 <= 0 && n8 + n7 >= 0 || n8 >= 0 && n8 + n7 < n8) {
            this.updater().getAndAdd(t3, -n7);
            throw new IllegalReferenceCountException(ReferenceCountUpdater.realRefCnt(n8), n4);
        }
        return t3;
    }

    public final boolean release(T t3) {
        int n4 = this.nonVolatileRawCnt(t3);
        return n4 == 2 ? this.tryFinalRelease0(t3, 2) || this.retryRelease0(t3, 1) : this.nonFinalRelease0(t3, 1, n4, ReferenceCountUpdater.toLiveRealRefCnt(n4, 1));
    }

    public final boolean release(T t3, int n4) {
        int n7 = this.nonVolatileRawCnt(t3);
        int n8 = ReferenceCountUpdater.toLiveRealRefCnt(n7, ObjectUtil.checkPositive(n4, "decrement"));
        return n4 == n8 ? this.tryFinalRelease0(t3, n7) || this.retryRelease0(t3, n4) : this.nonFinalRelease0(t3, n4, n7, n8);
    }

    private boolean tryFinalRelease0(T t3, int n4) {
        return this.updater().compareAndSet(t3, n4, 1);
    }

    private boolean nonFinalRelease0(T t3, int n4, int n7, int n8) {
        if (n4 < n8 && this.updater().compareAndSet(t3, n7, n7 - (n4 << 1))) {
            return false;
        }
        return this.retryRelease0(t3, n4);
    }

    private boolean retryRelease0(T t3, int n4) {
        while (true) {
            int n7;
            int n8;
            if (n4 == (n8 = ReferenceCountUpdater.toLiveRealRefCnt(n7 = this.updater().get(t3), n4))) {
                if (this.tryFinalRelease0(t3, n7)) {
                    return true;
                }
            } else if (n4 < n8) {
                if (this.updater().compareAndSet(t3, n7, n7 - (n4 << 1))) {
                    return false;
                }
            } else {
                throw new IllegalReferenceCountException(n8, -n4);
            }
            Thread.yield();
        }
    }
}

