/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal;

import io.grpc.netty.shaded.io.netty.util.Recycler;
import io.grpc.netty.shaded.io.netty.util.Recycler$Handle;
import io.grpc.netty.shaded.io.netty.util.internal.RecyclableArrayList$1;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public final class RecyclableArrayList
extends ArrayList<Object> {
    private static final long serialVersionUID = -8605125654176467947L;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final Recycler<RecyclableArrayList> RECYCLER = new RecyclableArrayList$1();
    private boolean insertSinceRecycled;
    private final Recycler$Handle<RecyclableArrayList> handle;

    public static RecyclableArrayList newInstance() {
        return RecyclableArrayList.newInstance(8);
    }

    public static RecyclableArrayList newInstance(int n4) {
        RecyclableArrayList recyclableArrayList = RECYCLER.get();
        recyclableArrayList.ensureCapacity(n4);
        return recyclableArrayList;
    }

    private RecyclableArrayList(Recycler$Handle<RecyclableArrayList> recycler$Handle) {
        this(recycler$Handle, 8);
    }

    private RecyclableArrayList(Recycler$Handle<RecyclableArrayList> recycler$Handle, int n4) {
        super(n4);
        this.handle = recycler$Handle;
    }

    @Override
    public boolean addAll(Collection<?> collection) {
        RecyclableArrayList.checkNullElements(collection);
        if (super.addAll(collection)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int n4, Collection<?> collection) {
        RecyclableArrayList.checkNullElements(collection);
        if (super.addAll(n4, collection)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    private static void checkNullElements(Collection<?> collection) {
        if (collection instanceof RandomAccess && collection instanceof List) {
            List list = (List)collection;
            int n4 = list.size();
            for (int i3 = 0; i3 < n4; ++i3) {
                if (list.get(i3) != null) continue;
                throw new IllegalArgumentException("c contains null values");
            }
        } else {
            for (Object obj : collection) {
                if (obj != null) continue;
                throw new IllegalArgumentException("c contains null values");
            }
        }
    }

    @Override
    public boolean add(Object object) {
        if (object == null) {
            throw new NullPointerException("element");
        }
        if (super.add(object)) {
            this.insertSinceRecycled = true;
            return true;
        }
        return false;
    }

    @Override
    public void add(int n4, Object object) {
        if (object == null) {
            throw new NullPointerException("element");
        }
        super.add(n4, object);
        this.insertSinceRecycled = true;
    }

    @Override
    public Object set(int n4, Object object) {
        if (object == null) {
            throw new NullPointerException("element");
        }
        Object object2 = super.set(n4, object);
        this.insertSinceRecycled = true;
        return object2;
    }

    public boolean insertSinceRecycled() {
        return this.insertSinceRecycled;
    }

    public boolean recycle() {
        this.clear();
        this.insertSinceRecycled = false;
        this.handle.recycle(this);
        return true;
    }

    /* synthetic */ RecyclableArrayList(Recycler$Handle recycler$Handle, RecyclableArrayList$1 recyclableArrayList$1) {
        this(recycler$Handle);
    }
}

