/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal;

import io.grpc.netty.shaded.io.netty.util.internal.ConstantTimeUtils;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent0$1;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent0$10;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent0$2;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent0$3;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent0$4;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent0$5;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent0$6;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent0$7;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent0$8;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent0$9;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import sun.misc.Unsafe;

final class PlatformDependent0 {
    private static final InternalLogger logger;
    private static final long ADDRESS_FIELD_OFFSET;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final Constructor<?> DIRECT_BUFFER_CONSTRUCTOR;
    private static final Throwable EXPLICIT_NO_UNSAFE_CAUSE;
    private static final Method ALLOCATE_ARRAY_METHOD;
    private static final int JAVA_VERSION;
    private static final boolean IS_ANDROID;
    private static final Throwable UNSAFE_UNAVAILABILITY_CAUSE;
    private static final Object INTERNAL_UNSAFE;
    private static final boolean IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE;
    static final Unsafe UNSAFE;
    static final int HASH_CODE_ASCII_SEED = -1028477387;
    static final int HASH_CODE_C1 = -862048943;
    static final int HASH_CODE_C2 = 461845907;
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    private static final boolean UNALIGNED;

    static boolean isExplicitNoUnsafe() {
        return EXPLICIT_NO_UNSAFE_CAUSE != null;
    }

    private static Throwable explicitNoUnsafeCause0() {
        boolean bl3 = SystemPropertyUtil.getBoolean("io.grpc.netty.shaded.io.netty.noUnsafe", false);
        logger.debug("-Dio.netty.noUnsafe: {}", (Object)bl3);
        if (bl3) {
            logger.debug("sun.misc.Unsafe: unavailable (io.netty.noUnsafe)");
            return new UnsupportedOperationException("sun.misc.Unsafe: unavailable (io.netty.noUnsafe)");
        }
        String string = SystemPropertyUtil.contains("io.grpc.netty.shaded.io.netty.tryUnsafe") ? "io.grpc.netty.shaded.io.netty.tryUnsafe" : "org.jboss.netty.tryUnsafe";
        if (!SystemPropertyUtil.getBoolean(string, true)) {
            String string2 = "sun.misc.Unsafe: unavailable (" + string + ")";
            logger.debug(string2);
            return new UnsupportedOperationException(string2);
        }
        return null;
    }

    static boolean isUnaligned() {
        return UNALIGNED;
    }

    static boolean hasUnsafe() {
        return UNSAFE != null;
    }

    static Throwable getUnsafeUnavailabilityCause() {
        return UNSAFE_UNAVAILABILITY_CAUSE;
    }

    static boolean unalignedAccess() {
        return UNALIGNED;
    }

    static void throwException(Throwable throwable) {
        UNSAFE.throwException(ObjectUtil.checkNotNull(throwable, "cause"));
    }

    static boolean hasDirectBufferNoCleanerConstructor() {
        return DIRECT_BUFFER_CONSTRUCTOR != null;
    }

    static ByteBuffer reallocateDirectNoCleaner(ByteBuffer byteBuffer, int n4) {
        return PlatformDependent0.newDirectBuffer(UNSAFE.reallocateMemory(PlatformDependent0.directBufferAddress(byteBuffer), n4), n4);
    }

    static ByteBuffer allocateDirectNoCleaner(int n4) {
        return PlatformDependent0.newDirectBuffer(UNSAFE.allocateMemory(Math.max(1, n4)), n4);
    }

    static boolean hasAllocateArrayMethod() {
        return ALLOCATE_ARRAY_METHOD != null;
    }

    static byte[] allocateUninitializedArray(int n4) {
        try {
            return (byte[])ALLOCATE_ARRAY_METHOD.invoke(INTERNAL_UNSAFE, Byte.TYPE, n4);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Error(invocationTargetException);
        }
    }

    static ByteBuffer newDirectBuffer(long l2, int n4) {
        ObjectUtil.checkPositiveOrZero(n4, "capacity");
        try {
            return (ByteBuffer)DIRECT_BUFFER_CONSTRUCTOR.newInstance(l2, n4);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error(throwable);
        }
    }

    static long directBufferAddress(ByteBuffer byteBuffer) {
        return PlatformDependent0.getLong(byteBuffer, ADDRESS_FIELD_OFFSET);
    }

    static long byteArrayBaseOffset() {
        return BYTE_ARRAY_BASE_OFFSET;
    }

    static Object getObject(Object object, long l2) {
        return UNSAFE.getObject(object, l2);
    }

    static int getInt(Object object, long l2) {
        return UNSAFE.getInt(object, l2);
    }

    private static long getLong(Object object, long l2) {
        return UNSAFE.getLong(object, l2);
    }

    static long objectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    static byte getByte(long l2) {
        return UNSAFE.getByte(l2);
    }

    static short getShort(long l2) {
        return UNSAFE.getShort(l2);
    }

    static int getInt(long l2) {
        return UNSAFE.getInt(l2);
    }

    static long getLong(long l2) {
        return UNSAFE.getLong(l2);
    }

    static byte getByte(byte[] byArray, int n4) {
        return UNSAFE.getByte(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n4);
    }

    static short getShort(byte[] byArray, int n4) {
        return UNSAFE.getShort(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n4);
    }

    static int getInt(byte[] byArray, int n4) {
        return UNSAFE.getInt(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n4);
    }

    static long getLong(byte[] byArray, int n4) {
        return UNSAFE.getLong(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n4);
    }

    static void putByte(long l2, byte by2) {
        UNSAFE.putByte(l2, by2);
    }

    static void putShort(long l2, short s11) {
        UNSAFE.putShort(l2, s11);
    }

    static void putInt(long l2, int n4) {
        UNSAFE.putInt(l2, n4);
    }

    static void putLong(long l2, long l10) {
        UNSAFE.putLong(l2, l10);
    }

    static void putByte(byte[] byArray, int n4, byte by2) {
        UNSAFE.putByte(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n4, by2);
    }

    static void putShort(byte[] byArray, int n4, short s11) {
        UNSAFE.putShort(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n4, s11);
    }

    static void putInt(byte[] byArray, int n4, int n7) {
        UNSAFE.putInt(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n4, n7);
    }

    static void putLong(byte[] byArray, int n4, long l2) {
        UNSAFE.putLong(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n4, l2);
    }

    static void putObject(Object object, long l2, Object object2) {
        UNSAFE.putObject(object, l2, object2);
    }

    static void copyMemory(long l2, long l10, long l11) {
        if (PlatformDependent0.javaVersion() <= 8) {
            PlatformDependent0.copyMemoryWithSafePointPolling(l2, l10, l11);
        } else {
            UNSAFE.copyMemory(l2, l10, l11);
        }
    }

    private static void copyMemoryWithSafePointPolling(long l2, long l10, long l11) {
        while (l11 > 0L) {
            long l12 = Math.min(l11, 0x100000L);
            UNSAFE.copyMemory(l2, l10, l12);
            l11 -= l12;
            l2 += l12;
            l10 += l12;
        }
    }

    static void copyMemory(Object object, long l2, Object object2, long l10, long l11) {
        if (PlatformDependent0.javaVersion() <= 8) {
            PlatformDependent0.copyMemoryWithSafePointPolling(object, l2, object2, l10, l11);
        } else {
            UNSAFE.copyMemory(object, l2, object2, l10, l11);
        }
    }

    private static void copyMemoryWithSafePointPolling(Object object, long l2, Object object2, long l10, long l11) {
        while (l11 > 0L) {
            long l12 = Math.min(l11, 0x100000L);
            UNSAFE.copyMemory(object, l2, object2, l10, l12);
            l11 -= l12;
            l2 += l12;
            l10 += l12;
        }
    }

    static void setMemory(long l2, long l10, byte by2) {
        UNSAFE.setMemory(l2, l10, by2);
    }

    static void setMemory(Object object, long l2, long l10, byte by2) {
        UNSAFE.setMemory(object, l2, l10, by2);
    }

    static boolean equals(byte[] byArray, int n4, byte[] byArray2, int n7, int n8) {
        long l2;
        int n10 = n8 & 7;
        long l10 = BYTE_ARRAY_BASE_OFFSET + (long)n4;
        long l11 = n7 - n4;
        if (n8 >= 8) {
            l2 = l10 + (long)n10;
            for (long i3 = l10 - 8L + (long)n8; i3 >= l2; i3 -= 8L) {
                if (UNSAFE.getLong(byArray, i3) == UNSAFE.getLong(byArray2, i3 + l11)) continue;
                return false;
            }
        }
        if (n10 >= 4 && UNSAFE.getInt(byArray, l2 = l10 + (long)(n10 -= 4)) != UNSAFE.getInt(byArray2, l2 + l11)) {
            return false;
        }
        l2 = l10 + l11;
        if (n10 >= 2) {
            return UNSAFE.getChar(byArray, l10) == UNSAFE.getChar(byArray2, l2) && (n10 == 2 || UNSAFE.getByte(byArray, l10 + 2L) == UNSAFE.getByte(byArray2, l2 + 2L));
        }
        return n10 == 0 || UNSAFE.getByte(byArray, l10) == UNSAFE.getByte(byArray2, l2);
    }

    static int equalsConstantTime(byte[] byArray, int n4, byte[] byArray2, int n7, int n8) {
        long l2;
        long l10 = 0L;
        long l11 = n8 & 7;
        long l12 = BYTE_ARRAY_BASE_OFFSET + (long)n4;
        long l13 = l12 + l11;
        long l14 = n7 - n4;
        for (l2 = l12 - 8L + (long)n8; l2 >= l13; l2 -= 8L) {
            l10 |= UNSAFE.getLong(byArray, l2) ^ UNSAFE.getLong(byArray2, l2 + l14);
        }
        if (l11 >= 4L) {
            l10 |= (long)(UNSAFE.getInt(byArray, l12) ^ UNSAFE.getInt(byArray2, l12 + l14));
            l11 -= 4L;
        }
        if (l11 >= 2L) {
            l2 = l13 - l11;
            l10 |= (long)(UNSAFE.getChar(byArray, l2) ^ UNSAFE.getChar(byArray2, l2 + l14));
            l11 -= 2L;
        }
        if (l11 == 1L) {
            l2 = l13 - 1L;
            l10 |= (long)(UNSAFE.getByte(byArray, l2) ^ UNSAFE.getByte(byArray2, l2 + l14));
        }
        return ConstantTimeUtils.equalsConstantTime(l10, 0L);
    }

    static boolean isZero(byte[] byArray, int n4, int n7) {
        if (n7 <= 0) {
            return true;
        }
        long l2 = BYTE_ARRAY_BASE_OFFSET + (long)n4;
        int n8 = n7 & 7;
        long l10 = l2 + (long)n8;
        for (long i3 = l2 - 8L + (long)n7; i3 >= l10; i3 -= 8L) {
            if (UNSAFE.getLong(byArray, i3) == 0L) continue;
            return false;
        }
        if (n8 >= 4 && UNSAFE.getInt(byArray, l2 + (long)(n8 -= 4)) != 0) {
            return false;
        }
        if (n8 >= 2) {
            return UNSAFE.getChar(byArray, l2) == '\u0000' && (n8 == 2 || byArray[n4 + 2] == 0);
        }
        return byArray[n4] == 0;
    }

    static int hashCodeAscii(byte[] byArray, int n4, int n7) {
        int n8 = -1028477387;
        long l2 = BYTE_ARRAY_BASE_OFFSET + (long)n4;
        int n10 = n7 & 7;
        long l10 = l2 + (long)n10;
        for (long i3 = l2 - 8L + (long)n7; i3 >= l10; i3 -= 8L) {
            n8 = PlatformDependent0.hashCodeAsciiCompute(UNSAFE.getLong(byArray, i3), n8);
        }
        if (n10 == 0) {
            return n8;
        }
        int n11 = -862048943;
        if (n10 != 2 & n10 != 4 & n10 != 6) {
            n8 = n8 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getByte(byArray, l2));
            n11 = 461845907;
            ++l2;
        }
        if (n10 != 1 & n10 != 4 & n10 != 5) {
            n8 = n8 * n11 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getShort(byArray, l2));
            n11 = n11 == -862048943 ? 461845907 : -862048943;
            l2 += 2L;
        }
        if (n10 >= 4) {
            return n8 * n11 + PlatformDependent0.hashCodeAsciiSanitize(UNSAFE.getInt(byArray, l2));
        }
        return n8;
    }

    static int hashCodeAsciiCompute(long l2, int n4) {
        return n4 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize((int)l2) * 461845907 + (int)((l2 & 0x1F1F1F1F00000000L) >>> 32);
    }

    static int hashCodeAsciiSanitize(int n4) {
        return n4 & 0x1F1F1F1F;
    }

    static int hashCodeAsciiSanitize(short s11) {
        return s11 & 0x1F1F;
    }

    static int hashCodeAsciiSanitize(byte by2) {
        return by2 & 0x1F;
    }

    static ClassLoader getClassLoader(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PlatformDependent0$8(clazz));
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PlatformDependent0$9());
    }

    static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PlatformDependent0$10());
    }

    static int addressSize() {
        return UNSAFE.addressSize();
    }

    static long allocateMemory(long l2) {
        return UNSAFE.allocateMemory(l2);
    }

    static void freeMemory(long l2) {
        UNSAFE.freeMemory(l2);
    }

    static long reallocateMemory(long l2, long l10) {
        return UNSAFE.reallocateMemory(l2, l10);
    }

    static boolean isAndroid() {
        return IS_ANDROID;
    }

    private static boolean isAndroid0() {
        String string = SystemPropertyUtil.get("java.vm.name");
        boolean bl3 = "Dalvik".equals(string);
        if (bl3) {
            logger.debug("Platform: Android");
        }
        return bl3;
    }

    private static boolean explicitTryReflectionSetAccessible0() {
        return SystemPropertyUtil.getBoolean("io.grpc.netty.shaded.io.netty.tryReflectionSetAccessible", PlatformDependent0.javaVersion() < 9);
    }

    static boolean isExplicitTryReflectionSetAccessible() {
        return IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE;
    }

    static int javaVersion() {
        return JAVA_VERSION;
    }

    private static int javaVersion0() {
        int n4 = PlatformDependent0.isAndroid0() ? 6 : PlatformDependent0.majorVersionFromJavaSpecificationVersion();
        logger.debug("Java version: {}", (Object)n4);
        return n4;
    }

    static int majorVersionFromJavaSpecificationVersion() {
        return PlatformDependent0.majorVersion(SystemPropertyUtil.get("java.specification.version", "1.6"));
    }

    static int majorVersion(String string) {
        String[] stringArray = string.split("\\.");
        int[] nArray = new int[stringArray.length];
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            nArray[i3] = Integer.parseInt(stringArray[i3]);
        }
        if (nArray[0] == 1) {
            assert (nArray[1] >= 6);
            return nArray[1];
        }
        return nArray[0];
    }

    private PlatformDependent0() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object;
        Unsafe unsafe;
        ByteBuffer byteBuffer;
        logger = InternalLoggerFactory.getInstance(PlatformDependent0.class);
        EXPLICIT_NO_UNSAFE_CAUSE = PlatformDependent0.explicitNoUnsafeCause0();
        JAVA_VERSION = PlatformDependent0.javaVersion0();
        IS_ANDROID = PlatformDependent0.isAndroid0();
        IS_EXPLICIT_TRY_REFLECTION_SET_ACCESSIBLE = PlatformDependent0.explicitTryReflectionSetAccessible0();
        Field field = null;
        Method method = null;
        Throwable throwable = null;
        Object object2 = null;
        throwable = EXPLICIT_NO_UNSAFE_CAUSE;
        if (throwable != null) {
            byteBuffer = null;
            field = null;
            unsafe = null;
            object2 = null;
        } else {
            long l2;
            Object object3;
            Unsafe unsafe2;
            byteBuffer = ByteBuffer.allocateDirect(1);
            object = AccessController.doPrivileged(new PlatformDependent0$1());
            if (object instanceof Throwable) {
                unsafe = null;
                throwable = (Throwable)object;
                logger.debug("sun.misc.Unsafe.theUnsafe: unavailable", (Throwable)object);
            } else {
                unsafe = (Unsafe)object;
                logger.debug("sun.misc.Unsafe.theUnsafe: available");
            }
            if (unsafe != null) {
                unsafe2 = unsafe;
                object3 = AccessController.doPrivileged(new PlatformDependent0$2(unsafe2));
                if (object3 == null) {
                    logger.debug("sun.misc.Unsafe.copyMemory: available");
                } else {
                    unsafe = null;
                    throwable = (Throwable)object3;
                    logger.debug("sun.misc.Unsafe.copyMemory: unavailable", (Throwable)object3);
                }
            }
            if (unsafe != null) {
                unsafe2 = unsafe;
                object3 = AccessController.doPrivileged(new PlatformDependent0$3(unsafe2, byteBuffer));
                if (object3 instanceof Field) {
                    field = (Field)object3;
                    logger.debug("java.nio.Buffer.address: available");
                } else {
                    throwable = (Throwable)object3;
                    logger.debug("java.nio.Buffer.address: unavailable", (Throwable)object3);
                    unsafe = null;
                }
            }
            if (unsafe != null && (l2 = (long)unsafe.arrayIndexScale(byte[].class)) != 1L) {
                logger.debug("unsafe.arrayIndexScale is {} (expected: 1). Not using unsafe.", (Object)l2);
                throwable = new UnsupportedOperationException("Unexpected unsafe.arrayIndexScale");
                unsafe = null;
            }
        }
        UNSAFE_UNAVAILABILITY_CAUSE = throwable;
        UNSAFE = unsafe;
        if (unsafe == null) {
            ADDRESS_FIELD_OFFSET = -1L;
            BYTE_ARRAY_BASE_OFFSET = -1L;
            UNALIGNED = false;
            DIRECT_BUFFER_CONSTRUCTOR = null;
            ALLOCATE_ARRAY_METHOD = null;
        } else {
            Object object4;
            Object object5;
            boolean bl3;
            long l10 = -1L;
            try {
                Object object6 = AccessController.doPrivileged(new PlatformDependent0$4(byteBuffer));
                if (object6 instanceof Constructor) {
                    l10 = UNSAFE.allocateMemory(1L);
                    try {
                        ((Constructor)object6).newInstance(l10, 1);
                        object = (Constructor)object6;
                        logger.debug("direct buffer constructor: available");
                    }
                    catch (InstantiationException instantiationException) {
                        object = null;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        object = null;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        object = null;
                    }
                } else {
                    logger.debug("direct buffer constructor: unavailable", (Throwable)object6);
                    object = null;
                }
            }
            finally {
                if (l10 != -1L) {
                    UNSAFE.freeMemory(l10);
                }
            }
            DIRECT_BUFFER_CONSTRUCTOR = object;
            ADDRESS_FIELD_OFFSET = PlatformDependent0.objectFieldOffset(field);
            BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            Object object7 = AccessController.doPrivileged(new PlatformDependent0$5());
            if (object7 instanceof Boolean) {
                bl3 = (Boolean)object7;
                logger.debug("java.nio.Bits.unaligned: available, {}", (Object)bl3);
            } else {
                object5 = SystemPropertyUtil.get("os.arch", "");
                bl3 = ((String)object5).matches("^(i[3-6]86|x86(_64)?|x64|amd64)$");
                object4 = (Throwable)object7;
                logger.debug("java.nio.Bits.unaligned: unavailable {}", (Object)bl3, object4);
            }
            UNALIGNED = bl3;
            if (PlatformDependent0.javaVersion() >= 9) {
                object5 = AccessController.doPrivileged(new PlatformDependent0$6());
                if (!(object5 instanceof Throwable) && (object5 = AccessController.doPrivileged(new PlatformDependent0$7(object4 = (object2 = object5)))) instanceof Method) {
                    try {
                        Method method2 = (Method)object5;
                        byte[] byArray = (byte[])method2.invoke(object4, Byte.TYPE, 8);
                        assert (byArray.length == 8);
                        method = method2;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        object5 = illegalAccessException;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        object5 = invocationTargetException;
                    }
                }
                if (object5 instanceof Throwable) {
                    logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): unavailable", (Throwable)object5);
                } else {
                    logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): available");
                }
            } else {
                logger.debug("jdk.internal.misc.Unsafe.allocateUninitializedArray(int): unavailable prior to Java9");
            }
            ALLOCATE_ARRAY_METHOD = method;
        }
        INTERNAL_UNSAFE = object2;
        logger.debug("java.nio.DirectByteBuffer.<init>(long, int): {}", (Object)(DIRECT_BUFFER_CONSTRUCTOR != null ? "available" : "unavailable"));
    }
}

