/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal;

import io.grpc.netty.shaded.io.netty.util.internal.Cleaner;
import io.grpc.netty.shaded.io.netty.util.internal.CleanerJava6;
import io.grpc.netty.shaded.io.netty.util.internal.CleanerJava9;
import io.grpc.netty.shaded.io.netty.util.internal.ConstantTimeUtils;
import io.grpc.netty.shaded.io.netty.util.internal.LongAdderCounter;
import io.grpc.netty.shaded.io.netty.util.internal.LongCounter;
import io.grpc.netty.shaded.io.netty.util.internal.OutOfDirectMemoryError;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent$1;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent$2;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent$3;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent$AtomicLongCounter;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent$Mpsc;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent$ThreadLocalRandomProvider;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent0;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.MpscArrayQueue;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.SpscLinkedQueue;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.atomic.MpscAtomicArrayQueue;
import io.grpc.netty.shaded.io.netty.util.internal.shaded.org.jctools.queues.atomic.SpscLinkedAtomicQueue;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PlatformDependent {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PlatformDependent.class);
    private static final Pattern MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN = Pattern.compile("\\s*-XX:MaxDirectMemorySize\\s*=\\s*([0-9]+)\\s*([kKmMgG]?)\\s*$");
    private static final boolean IS_WINDOWS = PlatformDependent.isWindows0();
    private static final boolean IS_OSX = PlatformDependent.isOsx0();
    private static final boolean IS_J9_JVM = PlatformDependent.isJ9Jvm0();
    private static final boolean IS_IVKVM_DOT_NET = PlatformDependent.isIkvmDotNet0();
    private static final boolean MAYBE_SUPER_USER;
    private static final boolean CAN_ENABLE_TCP_NODELAY_BY_DEFAULT;
    private static final Throwable UNSAFE_UNAVAILABILITY_CAUSE;
    private static final boolean DIRECT_BUFFER_PREFERRED;
    private static final long MAX_DIRECT_MEMORY;
    private static final int MPSC_CHUNK_SIZE = 1024;
    private static final int MIN_MAX_MPSC_CAPACITY = 2048;
    private static final int MAX_ALLOWED_MPSC_CAPACITY = 0x40000000;
    private static final long BYTE_ARRAY_BASE_OFFSET;
    private static final File TMPDIR;
    private static final int BIT_MODE;
    private static final String NORMALIZED_ARCH;
    private static final String NORMALIZED_OS;
    private static final int ADDRESS_SIZE;
    private static final boolean USE_DIRECT_BUFFER_NO_CLEANER;
    private static final AtomicLong DIRECT_MEMORY_COUNTER;
    private static final long DIRECT_MEMORY_LIMIT;
    private static final PlatformDependent$ThreadLocalRandomProvider RANDOM_PROVIDER;
    private static final Cleaner CLEANER;
    private static final int UNINITIALIZED_ARRAY_ALLOCATION_THRESHOLD;
    public static final boolean BIG_ENDIAN_NATIVE_ORDER;
    private static final Cleaner NOOP;

    public static boolean hasDirectBufferNoCleanerConstructor() {
        return PlatformDependent0.hasDirectBufferNoCleanerConstructor();
    }

    public static byte[] allocateUninitializedArray(int n4) {
        return UNINITIALIZED_ARRAY_ALLOCATION_THRESHOLD < 0 || UNINITIALIZED_ARRAY_ALLOCATION_THRESHOLD > n4 ? new byte[n4] : PlatformDependent0.allocateUninitializedArray(n4);
    }

    public static boolean isAndroid() {
        return PlatformDependent0.isAndroid();
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isOsx() {
        return IS_OSX;
    }

    public static boolean maybeSuperUser() {
        return MAYBE_SUPER_USER;
    }

    public static int javaVersion() {
        return PlatformDependent0.javaVersion();
    }

    public static boolean canEnableTcpNoDelayByDefault() {
        return CAN_ENABLE_TCP_NODELAY_BY_DEFAULT;
    }

    public static boolean hasUnsafe() {
        return UNSAFE_UNAVAILABILITY_CAUSE == null;
    }

    public static Throwable getUnsafeUnavailabilityCause() {
        return UNSAFE_UNAVAILABILITY_CAUSE;
    }

    public static boolean isUnaligned() {
        return PlatformDependent0.isUnaligned();
    }

    public static boolean directBufferPreferred() {
        return DIRECT_BUFFER_PREFERRED;
    }

    public static long maxDirectMemory() {
        return DIRECT_MEMORY_LIMIT;
    }

    public static long usedDirectMemory() {
        return DIRECT_MEMORY_COUNTER != null ? DIRECT_MEMORY_COUNTER.get() : -1L;
    }

    public static File tmpdir() {
        return TMPDIR;
    }

    public static int bitMode() {
        return BIT_MODE;
    }

    public static int addressSize() {
        return ADDRESS_SIZE;
    }

    public static long allocateMemory(long l2) {
        return PlatformDependent0.allocateMemory(l2);
    }

    public static void freeMemory(long l2) {
        PlatformDependent0.freeMemory(l2);
    }

    public static long reallocateMemory(long l2, long l10) {
        return PlatformDependent0.reallocateMemory(l2, l10);
    }

    public static void throwException(Throwable throwable) {
        if (PlatformDependent.hasUnsafe()) {
            PlatformDependent0.throwException(throwable);
        } else {
            PlatformDependent.throwException0(throwable);
        }
    }

    private static <E extends Throwable> void throwException0(Throwable throwable) {
        throw throwable;
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static LongCounter newLongCounter() {
        if (PlatformDependent.javaVersion() >= 8) {
            return new LongAdderCounter();
        }
        return new PlatformDependent$AtomicLongCounter(null);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(int n4) {
        return new ConcurrentHashMap(n4);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(int n4, float f8) {
        return new ConcurrentHashMap(n4, f8);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(int n4, float f8, int n7) {
        return new ConcurrentHashMap(n4, f8, n7);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentHashMap(Map<? extends K, ? extends V> map) {
        return new ConcurrentHashMap<K, V>(map);
    }

    public static void freeDirectBuffer(ByteBuffer byteBuffer) {
        CLEANER.freeDirectBuffer(byteBuffer);
    }

    public static long directBufferAddress(ByteBuffer byteBuffer) {
        return PlatformDependent0.directBufferAddress(byteBuffer);
    }

    public static ByteBuffer directBuffer(long l2, int n4) {
        if (PlatformDependent0.hasDirectBufferNoCleanerConstructor()) {
            return PlatformDependent0.newDirectBuffer(l2, n4);
        }
        throw new UnsupportedOperationException("sun.misc.Unsafe or java.nio.DirectByteBuffer.<init>(long, int) not available");
    }

    public static Object getObject(Object object, long l2) {
        return PlatformDependent0.getObject(object, l2);
    }

    public static int getInt(Object object, long l2) {
        return PlatformDependent0.getInt(object, l2);
    }

    public static byte getByte(long l2) {
        return PlatformDependent0.getByte(l2);
    }

    public static short getShort(long l2) {
        return PlatformDependent0.getShort(l2);
    }

    public static int getInt(long l2) {
        return PlatformDependent0.getInt(l2);
    }

    public static long getLong(long l2) {
        return PlatformDependent0.getLong(l2);
    }

    public static byte getByte(byte[] byArray, int n4) {
        return PlatformDependent0.getByte(byArray, n4);
    }

    public static short getShort(byte[] byArray, int n4) {
        return PlatformDependent0.getShort(byArray, n4);
    }

    public static int getInt(byte[] byArray, int n4) {
        return PlatformDependent0.getInt(byArray, n4);
    }

    public static long getLong(byte[] byArray, int n4) {
        return PlatformDependent0.getLong(byArray, n4);
    }

    private static long getLongSafe(byte[] byArray, int n4) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return (long)byArray[n4] << 56 | ((long)byArray[n4 + 1] & 0xFFL) << 48 | ((long)byArray[n4 + 2] & 0xFFL) << 40 | ((long)byArray[n4 + 3] & 0xFFL) << 32 | ((long)byArray[n4 + 4] & 0xFFL) << 24 | ((long)byArray[n4 + 5] & 0xFFL) << 16 | ((long)byArray[n4 + 6] & 0xFFL) << 8 | (long)byArray[n4 + 7] & 0xFFL;
        }
        return (long)byArray[n4] & 0xFFL | ((long)byArray[n4 + 1] & 0xFFL) << 8 | ((long)byArray[n4 + 2] & 0xFFL) << 16 | ((long)byArray[n4 + 3] & 0xFFL) << 24 | ((long)byArray[n4 + 4] & 0xFFL) << 32 | ((long)byArray[n4 + 5] & 0xFFL) << 40 | ((long)byArray[n4 + 6] & 0xFFL) << 48 | (long)byArray[n4 + 7] << 56;
    }

    private static int getIntSafe(byte[] byArray, int n4) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return byArray[n4] << 24 | (byArray[n4 + 1] & 0xFF) << 16 | (byArray[n4 + 2] & 0xFF) << 8 | byArray[n4 + 3] & 0xFF;
        }
        return byArray[n4] & 0xFF | (byArray[n4 + 1] & 0xFF) << 8 | (byArray[n4 + 2] & 0xFF) << 16 | byArray[n4 + 3] << 24;
    }

    private static short getShortSafe(byte[] byArray, int n4) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return (short)(byArray[n4] << 8 | byArray[n4 + 1] & 0xFF);
        }
        return (short)(byArray[n4] & 0xFF | byArray[n4 + 1] << 8);
    }

    private static int hashCodeAsciiCompute(CharSequence charSequence, int n4, int n7) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return n7 * -862048943 + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, n4 + 4) * 461845907 + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, n4);
        }
        return n7 * -862048943 + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, n4) * 461845907 + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, n4 + 4);
    }

    private static int hashCodeAsciiSanitizeInt(CharSequence charSequence, int n4) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return charSequence.charAt(n4 + 3) & 0x1F | (charSequence.charAt(n4 + 2) & 0x1F) << 8 | (charSequence.charAt(n4 + 1) & 0x1F) << 16 | (charSequence.charAt(n4) & 0x1F) << 24;
        }
        return (charSequence.charAt(n4 + 3) & 0x1F) << 24 | (charSequence.charAt(n4 + 2) & 0x1F) << 16 | (charSequence.charAt(n4 + 1) & 0x1F) << 8 | charSequence.charAt(n4) & 0x1F;
    }

    private static int hashCodeAsciiSanitizeShort(CharSequence charSequence, int n4) {
        if (BIG_ENDIAN_NATIVE_ORDER) {
            return charSequence.charAt(n4 + 1) & 0x1F | (charSequence.charAt(n4) & 0x1F) << 8;
        }
        return (charSequence.charAt(n4 + 1) & 0x1F) << 8 | charSequence.charAt(n4) & 0x1F;
    }

    private static int hashCodeAsciiSanitizeByte(char c10) {
        return c10 & 0x1F;
    }

    public static void putByte(long l2, byte by2) {
        PlatformDependent0.putByte(l2, by2);
    }

    public static void putShort(long l2, short s11) {
        PlatformDependent0.putShort(l2, s11);
    }

    public static void putInt(long l2, int n4) {
        PlatformDependent0.putInt(l2, n4);
    }

    public static void putLong(long l2, long l10) {
        PlatformDependent0.putLong(l2, l10);
    }

    public static void putByte(byte[] byArray, int n4, byte by2) {
        PlatformDependent0.putByte(byArray, n4, by2);
    }

    public static void putShort(byte[] byArray, int n4, short s11) {
        PlatformDependent0.putShort(byArray, n4, s11);
    }

    public static void putInt(byte[] byArray, int n4, int n7) {
        PlatformDependent0.putInt(byArray, n4, n7);
    }

    public static void putLong(byte[] byArray, int n4, long l2) {
        PlatformDependent0.putLong(byArray, n4, l2);
    }

    public static void putObject(Object object, long l2, Object object2) {
        PlatformDependent0.putObject(object, l2, object2);
    }

    public static long objectFieldOffset(Field field) {
        return PlatformDependent0.objectFieldOffset(field);
    }

    public static void copyMemory(long l2, long l10, long l11) {
        PlatformDependent0.copyMemory(l2, l10, l11);
    }

    public static void copyMemory(byte[] byArray, int n4, long l2, long l10) {
        PlatformDependent0.copyMemory(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n4, null, l2, l10);
    }

    public static void copyMemory(long l2, byte[] byArray, int n4, long l10) {
        PlatformDependent0.copyMemory(null, l2, byArray, BYTE_ARRAY_BASE_OFFSET + (long)n4, l10);
    }

    public static void setMemory(byte[] byArray, int n4, long l2, byte by2) {
        PlatformDependent0.setMemory(byArray, BYTE_ARRAY_BASE_OFFSET + (long)n4, l2, by2);
    }

    public static void setMemory(long l2, long l10, byte by2) {
        PlatformDependent0.setMemory(l2, l10, by2);
    }

    public static ByteBuffer allocateDirectNoCleaner(int n4) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        PlatformDependent.incrementMemoryCounter(n4);
        try {
            return PlatformDependent0.allocateDirectNoCleaner(n4);
        }
        catch (Throwable throwable) {
            PlatformDependent.decrementMemoryCounter(n4);
            PlatformDependent.throwException(throwable);
            return null;
        }
    }

    public static ByteBuffer reallocateDirectNoCleaner(ByteBuffer byteBuffer, int n4) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        int n7 = n4 - byteBuffer.capacity();
        PlatformDependent.incrementMemoryCounter(n7);
        try {
            return PlatformDependent0.reallocateDirectNoCleaner(byteBuffer, n4);
        }
        catch (Throwable throwable) {
            PlatformDependent.decrementMemoryCounter(n7);
            PlatformDependent.throwException(throwable);
            return null;
        }
    }

    public static void freeDirectNoCleaner(ByteBuffer byteBuffer) {
        assert (USE_DIRECT_BUFFER_NO_CLEANER);
        int n4 = byteBuffer.capacity();
        PlatformDependent0.freeMemory(PlatformDependent0.directBufferAddress(byteBuffer));
        PlatformDependent.decrementMemoryCounter(n4);
    }

    private static void incrementMemoryCounter(int n4) {
        long l2;
        if (DIRECT_MEMORY_COUNTER != null && (l2 = DIRECT_MEMORY_COUNTER.addAndGet(n4)) > DIRECT_MEMORY_LIMIT) {
            DIRECT_MEMORY_COUNTER.addAndGet(-n4);
            throw new OutOfDirectMemoryError("failed to allocate " + n4 + " byte(s) of direct memory (used: " + (l2 - (long)n4) + ", max: " + DIRECT_MEMORY_LIMIT + ')');
        }
    }

    private static void decrementMemoryCounter(int n4) {
        if (DIRECT_MEMORY_COUNTER != null) {
            long l2 = DIRECT_MEMORY_COUNTER.addAndGet(-n4);
            assert (l2 >= 0L);
        }
    }

    public static boolean useDirectBufferNoCleaner() {
        return USE_DIRECT_BUFFER_NO_CLEANER;
    }

    public static boolean equals(byte[] byArray, int n4, byte[] byArray2, int n7, int n8) {
        return !PlatformDependent.hasUnsafe() || !PlatformDependent0.unalignedAccess() ? PlatformDependent.equalsSafe(byArray, n4, byArray2, n7, n8) : PlatformDependent0.equals(byArray, n4, byArray2, n7, n8);
    }

    public static boolean isZero(byte[] byArray, int n4, int n7) {
        return !PlatformDependent.hasUnsafe() || !PlatformDependent0.unalignedAccess() ? PlatformDependent.isZeroSafe(byArray, n4, n7) : PlatformDependent0.isZero(byArray, n4, n7);
    }

    public static int equalsConstantTime(byte[] byArray, int n4, byte[] byArray2, int n7, int n8) {
        return !PlatformDependent.hasUnsafe() || !PlatformDependent0.unalignedAccess() ? ConstantTimeUtils.equalsConstantTime(byArray, n4, byArray2, n7, n8) : PlatformDependent0.equalsConstantTime(byArray, n4, byArray2, n7, n8);
    }

    public static int hashCodeAscii(byte[] byArray, int n4, int n7) {
        return !PlatformDependent.hasUnsafe() || !PlatformDependent0.unalignedAccess() ? PlatformDependent.hashCodeAsciiSafe(byArray, n4, n7) : PlatformDependent0.hashCodeAscii(byArray, n4, n7);
    }

    public static int hashCodeAscii(CharSequence charSequence) {
        int n4;
        int n7 = charSequence.length();
        int n8 = n7 & 7;
        int n10 = -1028477387;
        if (n7 >= 32) {
            for (n4 = n7 - 8; n4 >= n8; n4 -= 8) {
                n10 = PlatformDependent.hashCodeAsciiCompute(charSequence, n4, n10);
            }
        } else if (n7 >= 8) {
            n10 = PlatformDependent.hashCodeAsciiCompute(charSequence, n7 - 8, n10);
            if (n7 >= 16) {
                n10 = PlatformDependent.hashCodeAsciiCompute(charSequence, n7 - 16, n10);
                if (n7 >= 24) {
                    n10 = PlatformDependent.hashCodeAsciiCompute(charSequence, n7 - 24, n10);
                }
            }
        }
        if (n8 == 0) {
            return n10;
        }
        n4 = 0;
        if (n8 != 2 & n8 != 4 & n8 != 6) {
            n10 = n10 * -862048943 + PlatformDependent.hashCodeAsciiSanitizeByte(charSequence.charAt(0));
            n4 = 1;
        }
        if (n8 != 1 & n8 != 4 & n8 != 5) {
            n10 = n10 * (n4 == 0 ? -862048943 : 461845907) + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.hashCodeAsciiSanitizeShort(charSequence, n4));
            n4 += 2;
        }
        if (n8 >= 4) {
            return n10 * (n4 == 0 | n4 == 3 ? -862048943 : 461845907) + PlatformDependent.hashCodeAsciiSanitizeInt(charSequence, n4);
        }
        return n10;
    }

    public static <T> Queue<T> newMpscQueue() {
        return PlatformDependent$Mpsc.newMpscQueue();
    }

    public static <T> Queue<T> newMpscQueue(int n4) {
        return PlatformDependent$Mpsc.newMpscQueue(n4);
    }

    public static <T> Queue<T> newSpscQueue() {
        return PlatformDependent.hasUnsafe() ? new SpscLinkedQueue() : new SpscLinkedAtomicQueue();
    }

    public static <T> Queue<T> newFixedMpscQueue(int n4) {
        return PlatformDependent.hasUnsafe() ? new MpscArrayQueue(n4) : new MpscAtomicArrayQueue(n4);
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        return PlatformDependent0.getClassLoader(clazz);
    }

    public static ClassLoader getContextClassLoader() {
        return PlatformDependent0.getContextClassLoader();
    }

    public static ClassLoader getSystemClassLoader() {
        return PlatformDependent0.getSystemClassLoader();
    }

    public static <C> Deque<C> newConcurrentDeque() {
        if (PlatformDependent.javaVersion() < 7) {
            return new LinkedBlockingDeque();
        }
        return new ConcurrentLinkedDeque();
    }

    public static Random threadLocalRandom() {
        return RANDOM_PROVIDER.current();
    }

    private static boolean isWindows0() {
        boolean bl3 = SystemPropertyUtil.get("os.name", "").toLowerCase(Locale.US).contains("win");
        if (bl3) {
            logger.debug("Platform: Windows");
        }
        return bl3;
    }

    private static boolean isOsx0() {
        boolean bl3;
        String string = SystemPropertyUtil.get("os.name", "").toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
        boolean bl4 = bl3 = string.startsWith("macosx") || string.startsWith("osx");
        if (bl3) {
            logger.debug("Platform: MacOS");
        }
        return bl3;
    }

    private static boolean maybeSuperUser0() {
        String string = SystemPropertyUtil.get("user.name");
        if (PlatformDependent.isWindows()) {
            return "Administrator".equals(string);
        }
        return "root".equals(string) || "toor".equals(string);
    }

    private static Throwable unsafeUnavailabilityCause0() {
        if (PlatformDependent.isAndroid()) {
            logger.debug("sun.misc.Unsafe: unavailable (Android)");
            return new UnsupportedOperationException("sun.misc.Unsafe: unavailable (Android)");
        }
        if (PlatformDependent.isIkvmDotNet()) {
            logger.debug("sun.misc.Unsafe: unavailable (IKVM.NET)");
            return new UnsupportedOperationException("sun.misc.Unsafe: unavailable (IKVM.NET)");
        }
        Throwable throwable = PlatformDependent0.getUnsafeUnavailabilityCause();
        if (throwable != null) {
            return throwable;
        }
        try {
            boolean bl3 = PlatformDependent0.hasUnsafe();
            logger.debug("sun.misc.Unsafe: {}", (Object)(bl3 ? "available" : "unavailable"));
            return bl3 ? null : PlatformDependent0.getUnsafeUnavailabilityCause();
        }
        catch (Throwable throwable2) {
            logger.trace("Could not determine if Unsafe is available", throwable2);
            return new UnsupportedOperationException("Could not determine if Unsafe is available", throwable2);
        }
    }

    public static boolean isJ9Jvm() {
        return IS_J9_JVM;
    }

    private static boolean isJ9Jvm0() {
        String string = SystemPropertyUtil.get("java.vm.name", "").toLowerCase();
        return string.startsWith("ibm j9") || string.startsWith("eclipse openj9");
    }

    public static boolean isIkvmDotNet() {
        return IS_IVKVM_DOT_NET;
    }

    private static boolean isIkvmDotNet0() {
        String string = SystemPropertyUtil.get("java.vm.name", "").toUpperCase(Locale.US);
        return string.equals("IKVM.NET");
    }

    private static long maxDirectMemory0() {
        Object object;
        Class<?> clazz;
        Object object2;
        long l2 = 0L;
        ClassLoader classLoader = null;
        try {
            classLoader = PlatformDependent.getSystemClassLoader();
            object2 = SystemPropertyUtil.get("java.vm.name", "").toLowerCase();
            if (!((String)object2).startsWith("ibm j9") && !((String)object2).startsWith("eclipse openj9")) {
                clazz = Class.forName("sun.misc.VM", true, classLoader);
                object = clazz.getDeclaredMethod("maxDirectMemory", new Class[0]);
                l2 = ((Number)((Method)object).invoke(null, new Object[0])).longValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (l2 > 0L) {
            return l2;
        }
        try {
            object2 = Class.forName("java.lang.management.ManagementFactory", true, classLoader);
            clazz = Class.forName("java.lang.management.RuntimeMXBean", true, classLoader);
            object = ((Class)object2).getDeclaredMethod("getRuntimeMXBean", new Class[0]).invoke(null, new Object[0]);
            List list = (List)clazz.getDeclaredMethod("getInputArguments", new Class[0]).invoke(object, new Object[0]);
            for (int i3 = list.size() - 1; i3 >= 0; --i3) {
                Matcher matcher = MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN.matcher((CharSequence)list.get(i3));
                if (!matcher.matches()) continue;
                l2 = Long.parseLong(matcher.group(1));
                switch (matcher.group(2).charAt(0)) {
                    case 'K': 
                    case 'k': {
                        l2 *= 1024L;
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        l2 *= 0x100000L;
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        l2 *= 0x40000000L;
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (l2 <= 0L) {
            l2 = Runtime.getRuntime().maxMemory();
            logger.debug("maxDirectMemory: {} bytes (maybe)", (Object)l2);
        } else {
            logger.debug("maxDirectMemory: {} bytes", (Object)l2);
        }
        return l2;
    }

    private static File tmpdir0() {
        File file;
        try {
            file = PlatformDependent.toDirectory(SystemPropertyUtil.get("io.grpc.netty.shaded.io.netty.tmpdir"));
            if (file != null) {
                logger.debug("-Dio.netty.tmpdir: {}", (Object)file);
                return file;
            }
            file = PlatformDependent.toDirectory(SystemPropertyUtil.get("java.io.tmpdir"));
            if (file != null) {
                logger.debug("-Dio.netty.tmpdir: {} (java.io.tmpdir)", (Object)file);
                return file;
            }
            if (PlatformDependent.isWindows()) {
                file = PlatformDependent.toDirectory(System.getenv("TEMP"));
                if (file != null) {
                    logger.debug("-Dio.netty.tmpdir: {} (%TEMP%)", (Object)file);
                    return file;
                }
                String string = System.getenv("USERPROFILE");
                if (string != null) {
                    file = PlatformDependent.toDirectory(string + "\\AppData\\Local\\Temp");
                    if (file != null) {
                        logger.debug("-Dio.netty.tmpdir: {} (%USERPROFILE%\\AppData\\Local\\Temp)", (Object)file);
                        return file;
                    }
                    file = PlatformDependent.toDirectory(string + "\\Local Settings\\Temp");
                    if (file != null) {
                        logger.debug("-Dio.netty.tmpdir: {} (%USERPROFILE%\\Local Settings\\Temp)", (Object)file);
                        return file;
                    }
                }
            } else {
                file = PlatformDependent.toDirectory(System.getenv("TMPDIR"));
                if (file != null) {
                    logger.debug("-Dio.netty.tmpdir: {} ($TMPDIR)", (Object)file);
                    return file;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        file = PlatformDependent.isWindows() ? new File("C:\\Windows\\Temp") : new File("/tmp");
        logger.warn("Failed to get the temporary directory; falling back to: {}", (Object)file);
        return file;
    }

    private static File toDirectory(String string) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        file.mkdirs();
        if (!file.isDirectory()) {
            return null;
        }
        try {
            return file.getAbsoluteFile();
        }
        catch (Exception exception) {
            return file;
        }
    }

    private static int bitMode0() {
        int n4 = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.bitMode", 0);
        if (n4 > 0) {
            logger.debug("-Dio.netty.bitMode: {}", (Object)n4);
            return n4;
        }
        n4 = SystemPropertyUtil.getInt("sun.arch.data.model", 0);
        if (n4 > 0) {
            logger.debug("-Dio.netty.bitMode: {} (sun.arch.data.model)", (Object)n4);
            return n4;
        }
        n4 = SystemPropertyUtil.getInt("com.ibm.vm.bitmode", 0);
        if (n4 > 0) {
            logger.debug("-Dio.netty.bitMode: {} (com.ibm.vm.bitmode)", (Object)n4);
            return n4;
        }
        String string = SystemPropertyUtil.get("os.arch", "").toLowerCase(Locale.US).trim();
        if ("amd64".equals(string) || "x86_64".equals(string)) {
            n4 = 64;
        } else if ("i386".equals(string) || "i486".equals(string) || "i586".equals(string) || "i686".equals(string)) {
            n4 = 32;
        }
        if (n4 > 0) {
            logger.debug("-Dio.netty.bitMode: {} (os.arch: {})", (Object)n4, (Object)string);
        }
        String string2 = SystemPropertyUtil.get("java.vm.name", "").toLowerCase(Locale.US);
        Pattern pattern = Pattern.compile("([1-9][0-9]+)-?bit");
        Matcher matcher = pattern.matcher(string2);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return 64;
    }

    private static int addressSize0() {
        if (!PlatformDependent.hasUnsafe()) {
            return -1;
        }
        return PlatformDependent0.addressSize();
    }

    private static long byteArrayBaseOffset0() {
        if (!PlatformDependent.hasUnsafe()) {
            return -1L;
        }
        return PlatformDependent0.byteArrayBaseOffset();
    }

    private static boolean equalsSafe(byte[] byArray, int n4, byte[] byArray2, int n7, int n8) {
        int n10 = n4 + n8;
        while (n4 < n10) {
            if (byArray[n4] != byArray2[n7]) {
                return false;
            }
            ++n4;
            ++n7;
        }
        return true;
    }

    private static boolean isZeroSafe(byte[] byArray, int n4, int n7) {
        int n8 = n4 + n7;
        while (n4 < n8) {
            if (byArray[n4] != 0) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    static int hashCodeAsciiSafe(byte[] byArray, int n4, int n7) {
        int n8 = -1028477387;
        int n10 = n7 & 7;
        int n11 = n4 + n10;
        for (int i3 = n4 - 8 + n7; i3 >= n11; i3 -= 8) {
            n8 = PlatformDependent0.hashCodeAsciiCompute(PlatformDependent.getLongSafe(byArray, i3), n8);
        }
        switch (n10) {
            case 7: {
                return ((n8 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(byArray[n4])) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(byArray, n4 + 1))) * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(byArray, n4 + 3));
            }
            case 6: {
                return (n8 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(byArray, n4))) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(byArray, n4 + 2));
            }
            case 5: {
                return (n8 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(byArray[n4])) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(byArray, n4 + 1));
            }
            case 4: {
                return n8 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getIntSafe(byArray, n4));
            }
            case 3: {
                return (n8 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(byArray[n4])) * 461845907 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(byArray, n4 + 1));
            }
            case 2: {
                return n8 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(PlatformDependent.getShortSafe(byArray, n4));
            }
            case 1: {
                return n8 * -862048943 + PlatformDependent0.hashCodeAsciiSanitize(byArray[n4]);
            }
        }
        return n8;
    }

    public static String normalizedArch() {
        return NORMALIZED_ARCH;
    }

    public static String normalizedOs() {
        return NORMALIZED_OS;
    }

    private static String normalize(String string) {
        return string.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }

    private static String normalizeArch(String string) {
        if ((string = PlatformDependent.normalize(string)).matches("^(x8664|amd64|ia32e|em64t|x64)$")) {
            return "x86_64";
        }
        if (string.matches("^(x8632|x86|i[3-6]86|ia32|x32)$")) {
            return "x86_32";
        }
        if (string.matches("^(ia64|itanium64)$")) {
            return "itanium_64";
        }
        if (string.matches("^(sparc|sparc32)$")) {
            return "sparc_32";
        }
        if (string.matches("^(sparcv9|sparc64)$")) {
            return "sparc_64";
        }
        if (string.matches("^(arm|arm32)$")) {
            return "arm_32";
        }
        if ("aarch64".equals(string)) {
            return "aarch_64";
        }
        if (string.matches("^(ppc|ppc32)$")) {
            return "ppc_32";
        }
        if ("ppc64".equals(string)) {
            return "ppc_64";
        }
        if ("ppc64le".equals(string)) {
            return "ppcle_64";
        }
        if ("s390".equals(string)) {
            return "s390_32";
        }
        if ("s390x".equals(string)) {
            return "s390_64";
        }
        return "unknown";
    }

    private static String normalizeOs(String string) {
        if ((string = PlatformDependent.normalize(string)).startsWith("aix")) {
            return "aix";
        }
        if (string.startsWith("hpux")) {
            return "hpux";
        }
        if (string.startsWith("os400") && (string.length() <= 5 || !Character.isDigit(string.charAt(5)))) {
            return "os400";
        }
        if (string.startsWith("linux")) {
            return "linux";
        }
        if (string.startsWith("macosx") || string.startsWith("osx")) {
            return "osx";
        }
        if (string.startsWith("freebsd")) {
            return "freebsd";
        }
        if (string.startsWith("openbsd")) {
            return "openbsd";
        }
        if (string.startsWith("netbsd")) {
            return "netbsd";
        }
        if (string.startsWith("solaris") || string.startsWith("sunos")) {
            return "sunos";
        }
        if (string.startsWith("windows")) {
            return "windows";
        }
        return "unknown";
    }

    private PlatformDependent() {
    }

    static /* synthetic */ InternalLogger access$100() {
        return logger;
    }

    static {
        CAN_ENABLE_TCP_NODELAY_BY_DEFAULT = !PlatformDependent.isAndroid();
        UNSAFE_UNAVAILABILITY_CAUSE = PlatformDependent.unsafeUnavailabilityCause0();
        MAX_DIRECT_MEMORY = PlatformDependent.maxDirectMemory0();
        BYTE_ARRAY_BASE_OFFSET = PlatformDependent.byteArrayBaseOffset0();
        TMPDIR = PlatformDependent.tmpdir0();
        BIT_MODE = PlatformDependent.bitMode0();
        NORMALIZED_ARCH = PlatformDependent.normalizeArch(SystemPropertyUtil.get("os.arch", ""));
        NORMALIZED_OS = PlatformDependent.normalizeOs(SystemPropertyUtil.get("os.name", ""));
        ADDRESS_SIZE = PlatformDependent.addressSize0();
        BIG_ENDIAN_NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        NOOP = new PlatformDependent$1();
        RANDOM_PROVIDER = PlatformDependent.javaVersion() >= 7 ? new PlatformDependent$2() : new PlatformDependent$3();
        long l2 = SystemPropertyUtil.getLong("io.grpc.netty.shaded.io.netty.maxDirectMemory", -1L);
        if (l2 == 0L || !PlatformDependent.hasUnsafe() || !PlatformDependent0.hasDirectBufferNoCleanerConstructor()) {
            USE_DIRECT_BUFFER_NO_CLEANER = false;
            DIRECT_MEMORY_COUNTER = null;
        } else {
            USE_DIRECT_BUFFER_NO_CLEANER = true;
            DIRECT_MEMORY_COUNTER = l2 < 0L ? ((l2 = MAX_DIRECT_MEMORY) <= 0L ? null : new AtomicLong()) : new AtomicLong();
        }
        logger.debug("-Dio.netty.maxDirectMemory: {} bytes", (Object)l2);
        DIRECT_MEMORY_LIMIT = l2 >= 1L ? l2 : MAX_DIRECT_MEMORY;
        int n4 = SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.uninitializedArrayAllocationThreshold", 1024);
        UNINITIALIZED_ARRAY_ALLOCATION_THRESHOLD = PlatformDependent.javaVersion() >= 9 && PlatformDependent0.hasAllocateArrayMethod() ? n4 : -1;
        logger.debug("-Dio.netty.uninitializedArrayAllocationThreshold: {}", (Object)UNINITIALIZED_ARRAY_ALLOCATION_THRESHOLD);
        MAYBE_SUPER_USER = PlatformDependent.maybeSuperUser0();
        CLEANER = !PlatformDependent.isAndroid() ? (PlatformDependent.javaVersion() >= 9 ? (CleanerJava9.isSupported() ? new CleanerJava9() : NOOP) : (CleanerJava6.isSupported() ? new CleanerJava6() : NOOP)) : NOOP;
        boolean bl3 = DIRECT_BUFFER_PREFERRED = CLEANER != NOOP && !SystemPropertyUtil.getBoolean("io.grpc.netty.shaded.io.netty.noPreferDirect", false);
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.noPreferDirect: {}", (Object)(!DIRECT_BUFFER_PREFERRED ? 1 : 0));
        }
        if (CLEANER == NOOP && !PlatformDependent0.isExplicitNoUnsafe()) {
            logger.info("Your platform does not provide complete low-level API for accessing direct buffers reliably. Unless explicitly requested, heap buffer will always be preferred to avoid potential system instability.");
        }
    }
}

