/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal;

import java.util.Collection;

public final class ObjectUtil {
    private ObjectUtil() {
    }

    public static <T> T checkNotNull(T t3, String string) {
        if (t3 == null) {
            throw new NullPointerException(string);
        }
        return t3;
    }

    public static int checkPositive(int n4, String string) {
        if (n4 <= 0) {
            throw new IllegalArgumentException(string + ": " + n4 + " (expected: > 0)");
        }
        return n4;
    }

    public static long checkPositive(long l2, String string) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException(string + ": " + l2 + " (expected: > 0)");
        }
        return l2;
    }

    public static int checkPositiveOrZero(int n4, String string) {
        if (n4 < 0) {
            throw new IllegalArgumentException(string + ": " + n4 + " (expected: >= 0)");
        }
        return n4;
    }

    public static long checkPositiveOrZero(long l2, String string) {
        if (l2 < 0L) {
            throw new IllegalArgumentException(string + ": " + l2 + " (expected: >= 0)");
        }
        return l2;
    }

    public static <T> T[] checkNonEmpty(T[] TArray, String string) {
        ObjectUtil.checkNotNull(TArray, string);
        ObjectUtil.checkPositive(TArray.length, string + ".length");
        return TArray;
    }

    public static <T extends Collection<?>> T checkNonEmpty(T t3, String string) {
        ObjectUtil.checkNotNull(t3, string);
        ObjectUtil.checkPositive(t3.size(), string + ".size");
        return t3;
    }

    public static int intValue(Integer n4, int n7) {
        return n4 != null ? n4 : n7;
    }

    public static long longValue(Long l2, long l10) {
        return l2 != null ? l2 : l10;
    }
}

