/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal;

import io.grpc.netty.shaded.io.netty.util.concurrent.FastThreadLocalThread;
import io.grpc.netty.shaded.io.netty.util.internal.ConcurrentSet;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectCleaner$1;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectCleaner$2;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectCleaner$AutomaticCleanerReference;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObjectCleaner {
    private static final int REFERENCE_QUEUE_POLL_TIMEOUT_MS = Math.max(500, SystemPropertyUtil.getInt("io.grpc.netty.shaded.io.netty.util.internal.ObjectCleaner.refQueuePollTimeout", 10000));
    static final String CLEANER_THREAD_NAME = ObjectCleaner.class.getSimpleName() + "Thread";
    private static final Set<ObjectCleaner$AutomaticCleanerReference> LIVE_SET = new ConcurrentSet<ObjectCleaner$AutomaticCleanerReference>();
    private static final ReferenceQueue<Object> REFERENCE_QUEUE = new ReferenceQueue();
    private static final AtomicBoolean CLEANER_RUNNING = new AtomicBoolean(false);
    private static final Runnable CLEANER_TASK = new ObjectCleaner$1();

    public static void register(Object object, Runnable runnable) {
        ObjectCleaner$AutomaticCleanerReference objectCleaner$AutomaticCleanerReference = new ObjectCleaner$AutomaticCleanerReference(object, ObjectUtil.checkNotNull(runnable, "cleanupTask"));
        LIVE_SET.add(objectCleaner$AutomaticCleanerReference);
        if (CLEANER_RUNNING.compareAndSet(false, true)) {
            FastThreadLocalThread fastThreadLocalThread = new FastThreadLocalThread(CLEANER_TASK);
            fastThreadLocalThread.setPriority(1);
            AccessController.doPrivileged(new ObjectCleaner$2(fastThreadLocalThread));
            fastThreadLocalThread.setName(CLEANER_THREAD_NAME);
            fastThreadLocalThread.setDaemon(true);
            fastThreadLocalThread.start();
        }
    }

    public static int getLiveSetCount() {
        return LIVE_SET.size();
    }

    private ObjectCleaner() {
    }

    static /* synthetic */ Set access$000() {
        return LIVE_SET;
    }

    static /* synthetic */ int access$100() {
        return REFERENCE_QUEUE_POLL_TIMEOUT_MS;
    }

    static /* synthetic */ ReferenceQueue access$200() {
        return REFERENCE_QUEUE;
    }

    static /* synthetic */ AtomicBoolean access$300() {
        return CLEANER_RUNNING;
    }
}

