/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal;

import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import io.grpc.netty.shaded.io.netty.util.internal.NativeLibraryLoader$1;
import io.grpc.netty.shaded.io.netty.util.internal.NativeLibraryLoader$2;
import io.grpc.netty.shaded.io.netty.util.internal.NativeLibraryLoader$NoexecVolumeDetector;
import io.grpc.netty.shaded.io.netty.util.internal.NativeLibraryUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.SystemPropertyUtil;
import io.grpc.netty.shaded.io.netty.util.internal.ThrowableUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;

public final class NativeLibraryLoader {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NativeLibraryLoader.class);
    private static final String NATIVE_RESOURCE_HOME = "META-INF/native/";
    private static final File WORKDIR;
    private static final boolean DELETE_NATIVE_LIB_AFTER_LOADING;
    private static final boolean TRY_TO_PATCH_SHADED_ID;
    private static final byte[] UNIQUE_ID_BYTES;

    public static void loadFirstAvailable(ClassLoader classLoader, String ... stringArray) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        for (String string : stringArray) {
            try {
                NativeLibraryLoader.load(string, classLoader);
                return;
            }
            catch (Throwable throwable) {
                arrayList.add(throwable);
                logger.debug("Unable to load the library '{}', trying next name...", (Object)string, (Object)throwable);
            }
        }
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Failed to load any of the given libraries: " + Arrays.toString(stringArray));
        ThrowableUtil.addSuppressedAndClear(illegalArgumentException, arrayList);
        throw illegalArgumentException;
    }

    private static String calculatePackagePrefix() {
        String string;
        String string2 = NativeLibraryLoader.class.getName();
        if (!string2.endsWith(string = "io!netty!util!internal!NativeLibraryLoader".replace('!', '.'))) {
            throw new UnsatisfiedLinkError(String.format("Could not find prefix added to %s to get %s. When shading, only adding a package prefix is supported", string, string2));
        }
        return string2.substring(0, string2.length() - string.length());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void load(String string, ClassLoader classLoader) {
        String string2 = NativeLibraryLoader.calculatePackagePrefix().replace('.', '_');
        String string3 = string2 + string;
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        try {
            NativeLibraryLoader.loadLibrary(classLoader, string3, false);
            return;
        }
        catch (Throwable throwable) {
            arrayList.add(throwable);
            logger.debug("{} cannot be loaded from java.library.path, now trying export to -Dio.netty.native.workdir: {}", string3, WORKDIR, throwable);
            String string4 = System.mapLibraryName(string3);
            String string5 = NATIVE_RESOURCE_HOME + string4;
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            File file = null;
            URL uRL = classLoader == null ? ClassLoader.getSystemResource(string5) : classLoader.getResource(string5);
            try {
                if (uRL == null) {
                    if (!PlatformDependent.isOsx()) {
                        FileNotFoundException fileNotFoundException = new FileNotFoundException(string5);
                        ThrowableUtil.addSuppressedAndClear(fileNotFoundException, arrayList);
                        throw fileNotFoundException;
                    }
                    String string6 = string5.endsWith(".jnilib") ? "META-INF/native/lib" + string3 + ".dynlib" : "META-INF/native/lib" + string3 + ".jnilib";
                    uRL = classLoader == null ? ClassLoader.getSystemResource(string6) : classLoader.getResource(string6);
                    if (uRL == null) {
                        FileNotFoundException fileNotFoundException = new FileNotFoundException(string6);
                        ThrowableUtil.addSuppressedAndClear(fileNotFoundException, arrayList);
                        throw fileNotFoundException;
                    }
                }
                int n4 = string4.lastIndexOf(46);
                String string7 = string4.substring(0, n4);
                String string8 = string4.substring(n4);
                file = File.createTempFile(string7, string8, WORKDIR);
                inputStream = uRL.openStream();
                fileOutputStream = new FileOutputStream(file);
                if (NativeLibraryLoader.shouldShadedLibraryIdBePatched(string2)) {
                    NativeLibraryLoader.patchShadedLibraryId(inputStream, fileOutputStream, string, string3);
                } else {
                    int n7;
                    byte[] byArray = new byte[8192];
                    while ((n7 = inputStream.read(byArray)) > 0) {
                        ((OutputStream)fileOutputStream).write(byArray, 0, n7);
                    }
                }
                fileOutputStream.flush();
                NativeLibraryLoader.closeQuietly(fileOutputStream);
                fileOutputStream = null;
                NativeLibraryLoader.loadLibrary(classLoader, file.getPath(), true);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                try {
                    try {
                        if (file != null && file.isFile() && file.canRead() && !NativeLibraryLoader$NoexecVolumeDetector.access$000(file)) {
                            logger.info("{} exists but cannot be executed even when execute permissions set; check volume for \"noexec\" flag; use -D{}=[path] to set native working directory separately.", (Object)file.getPath(), (Object)"io.grpc.netty.shaded.io.netty.native.workdir");
                        }
                    }
                    catch (Throwable throwable2) {
                        arrayList.add(throwable2);
                        logger.debug("Error checking if {} is on a file store mounted with noexec", (Object)file, (Object)throwable2);
                    }
                    ThrowableUtil.addSuppressedAndClear(unsatisfiedLinkError, arrayList);
                    throw unsatisfiedLinkError;
                    catch (Exception exception) {
                        UnsatisfiedLinkError unsatisfiedLinkError2 = new UnsatisfiedLinkError("could not load a native library: " + string3);
                        unsatisfiedLinkError2.initCause(exception);
                        ThrowableUtil.addSuppressedAndClear(unsatisfiedLinkError2, arrayList);
                        throw unsatisfiedLinkError2;
                    }
                }
                catch (Throwable throwable3) {
                    NativeLibraryLoader.closeQuietly(inputStream);
                    NativeLibraryLoader.closeQuietly(fileOutputStream);
                    if (file == null) throw throwable3;
                    if (DELETE_NATIVE_LIB_AFTER_LOADING) {
                        if (file.delete()) throw throwable3;
                    }
                    file.deleteOnExit();
                    throw throwable3;
                }
            }
            NativeLibraryLoader.closeQuietly(inputStream);
            NativeLibraryLoader.closeQuietly(fileOutputStream);
            if (file == null) return;
            if (DELETE_NATIVE_LIB_AFTER_LOADING) {
                if (file.delete()) return;
            }
            file.deleteOnExit();
            return;
        }
    }

    static boolean patchShadedLibraryId(InputStream inputStream, OutputStream outputStream, String string, String string2) {
        boolean bl3;
        int n4;
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(inputStream.available());
        while ((n4 = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n4);
        }
        byteArrayOutputStream.flush();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        if (!NativeLibraryLoader.patchShadedLibraryId(byArray2, string, string2)) {
            String string3 = PlatformDependent.normalizedOs();
            String string4 = PlatformDependent.normalizedArch();
            String string5 = "_" + string3 + "_" + string4;
            bl3 = string.endsWith(string5) ? NativeLibraryLoader.patchShadedLibraryId(byArray2, string.substring(0, string.length() - string5.length()), string2) : false;
        } else {
            bl3 = true;
        }
        outputStream.write(byArray2, 0, byArray2.length);
        return bl3;
    }

    private static boolean shouldShadedLibraryIdBePatched(String string) {
        return TRY_TO_PATCH_SHADED_ID && PlatformDependent.isOsx() && !string.isEmpty();
    }

    private static boolean patchShadedLibraryId(byte[] byArray, String string, String string2) {
        int n4;
        byte[] byArray2 = string.getBytes(CharsetUtil.UTF_8);
        int n7 = -1;
        block0: for (n4 = 0; n4 < byArray.length && byArray.length - n4 >= byArray2.length; ++n4) {
            int n8 = n4;
            int n10 = 0;
            while (n10 < byArray2.length && byArray[n8++] == byArray2[n10++]) {
                if (n10 != byArray2.length) continue;
                n7 = n4;
                break block0;
            }
        }
        if (n7 == -1) {
            logger.debug("Was not able to find the ID of the shaded native library {}, can't adjust it.", (Object)string2);
            return false;
        }
        for (n4 = 0; n4 < byArray2.length; ++n4) {
            byArray[n7 + n4] = UNIQUE_ID_BYTES[PlatformDependent.threadLocalRandom().nextInt(UNIQUE_ID_BYTES.length)];
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Found the ID of the shaded native library {}. Replacing ID part {} with {}", string2, string, new String(byArray, n7, byArray2.length, CharsetUtil.UTF_8));
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadLibrary(ClassLoader classLoader, String string, boolean bl3) {
        Throwable throwable = null;
        try {
            Class<?> clazz = NativeLibraryLoader.tryToLoadClass(classLoader, NativeLibraryUtil.class);
            NativeLibraryLoader.loadLibraryByHelper(clazz, string, bl3);
            logger.debug("Successfully loaded the library {}", (Object)string);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                block5: {
                    throwable = unsatisfiedLinkError;
                    logger.debug("Unable to load the library '{}', trying other loading mechanism.", (Object)string, (Object)unsatisfiedLinkError);
                    break block5;
                    catch (Exception exception) {
                        throwable = exception;
                        logger.debug("Unable to load the library '{}', trying other loading mechanism.", (Object)string, (Object)exception);
                    }
                }
                NativeLibraryUtil.loadLibrary(string, bl3);
                logger.debug("Successfully loaded the library {}", (Object)string);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                if (throwable == null) throw unsatisfiedLinkError2;
                ThrowableUtil.addSuppressed((Throwable)unsatisfiedLinkError2, throwable);
                throw unsatisfiedLinkError2;
            }
        }
    }

    private static void loadLibraryByHelper(Class<?> clazz, String string, boolean bl3) {
        Object object = AccessController.doPrivileged(new NativeLibraryLoader$1(clazz, string, bl3));
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            assert (!(throwable instanceof UnsatisfiedLinkError)) : throwable + " should be a wrapper throwable";
            Throwable throwable2 = throwable.getCause();
            if (throwable2 instanceof UnsatisfiedLinkError) {
                throw (UnsatisfiedLinkError)throwable2;
            }
            UnsatisfiedLinkError unsatisfiedLinkError = new UnsatisfiedLinkError(throwable.getMessage());
            unsatisfiedLinkError.initCause(throwable);
            throw unsatisfiedLinkError;
        }
    }

    private static Class<?> tryToLoadClass(ClassLoader classLoader, Class<?> clazz) {
        try {
            return Class.forName(clazz.getName(), false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (classLoader == null) {
                throw classNotFoundException;
            }
            try {
                byte[] byArray = NativeLibraryLoader.classToByteArray(clazz);
                return (Class)AccessController.doPrivileged(new NativeLibraryLoader$2(classLoader, clazz, byArray));
            }
            catch (ClassNotFoundException classNotFoundException2) {
                ThrowableUtil.addSuppressed((Throwable)classNotFoundException2, classNotFoundException);
                throw classNotFoundException2;
            }
            catch (RuntimeException runtimeException) {
                ThrowableUtil.addSuppressed((Throwable)runtimeException, classNotFoundException);
                throw runtimeException;
            }
            catch (Error error) {
                ThrowableUtil.addSuppressed((Throwable)error, classNotFoundException);
                throw error;
            }
        }
    }

    private static byte[] classToByteArray(Class<?> clazz) {
        URL uRL;
        String string = clazz.getName();
        int n4 = string.lastIndexOf(46);
        if (n4 > 0) {
            string = string.substring(n4 + 1);
        }
        if ((uRL = clazz.getResource(string + ".class")) == null) {
            throw new ClassNotFoundException(clazz.getName());
        }
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        InputStream inputStream = null;
        try {
            int n7;
            inputStream = uRL.openStream();
            while ((n7 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n7);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(clazz.getName(), iOException);
        }
        finally {
            NativeLibraryLoader.closeQuietly(inputStream);
            NativeLibraryLoader.closeQuietly(byteArrayOutputStream);
        }
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private NativeLibraryLoader() {
    }

    static {
        UNIQUE_ID_BYTES = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes(CharsetUtil.US_ASCII);
        String string = SystemPropertyUtil.get("io.grpc.netty.shaded.io.netty.native.workdir");
        if (string != null) {
            File file = new File(string);
            file.mkdirs();
            try {
                file = file.getAbsoluteFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            WORKDIR = file;
            logger.debug("-Dio.netty.native.workdir: " + WORKDIR);
        } else {
            WORKDIR = PlatformDependent.tmpdir();
            logger.debug("-Dio.netty.native.workdir: " + WORKDIR + " (io.netty.tmpdir)");
        }
        DELETE_NATIVE_LIB_AFTER_LOADING = SystemPropertyUtil.getBoolean("io.grpc.netty.shaded.io.netty.native.deleteLibAfterLoading", true);
        logger.debug("-Dio.netty.native.deleteLibAfterLoading: {}", (Object)DELETE_NATIVE_LIB_AFTER_LOADING);
        TRY_TO_PATCH_SHADED_ID = SystemPropertyUtil.getBoolean("io.grpc.netty.shaded.io.netty.native.tryPatchShadedId", true);
        logger.debug("-Dio.netty.native.tryPatchShadedId: {}", (Object)TRY_TO_PATCH_SHADED_ID);
    }
}

