/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal;

public final class MathUtil {
    private MathUtil() {
    }

    public static int findNextPositivePowerOfTwo(int n4) {
        assert (n4 > Integer.MIN_VALUE && n4 < 0x40000000);
        return 1 << 32 - Integer.numberOfLeadingZeros(n4 - 1);
    }

    public static int safeFindNextPositivePowerOfTwo(int n4) {
        return n4 <= 0 ? 1 : (n4 >= 0x40000000 ? 0x40000000 : MathUtil.findNextPositivePowerOfTwo(n4));
    }

    public static boolean isOutOfBounds(int n4, int n7, int n8) {
        return (n4 | n7 | n4 + n7 | n8 - (n4 + n7)) < 0;
    }

    public static int compare(int n4, int n7) {
        return n4 < n7 ? -1 : (n4 > n7 ? 1 : 0);
    }

    public static int compare(long l2, long l10) {
        return l2 < l10 ? -1 : (l2 > l10 ? 1 : 0);
    }
}

