/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal;

import io.grpc.netty.shaded.io.netty.util.NetUtil;
import io.grpc.netty.shaded.io.netty.util.internal.EmptyArrays;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.SocketUtils;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MacAddressUtil {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MacAddressUtil.class);
    private static final int EUI64_MAC_ADDRESS_LENGTH = 8;
    private static final int EUI48_MAC_ADDRESS_LENGTH = 6;

    public static byte[] bestAvailableMac() {
        InetAddress inetAddress;
        Enumeration<InetAddress> enumeration;
        Object object;
        Object object2 = EmptyArrays.EMPTY_BYTES;
        InetAddress inetAddress2 = NetUtil.LOCALHOST4;
        LinkedHashMap<NetworkInterface, InetAddress> linkedHashMap = new LinkedHashMap<NetworkInterface, InetAddress>();
        try {
            object = NetworkInterface.getNetworkInterfaces();
            if (object != null) {
                while (object.hasMoreElements()) {
                    NetworkInterface object3 = object.nextElement();
                    enumeration = SocketUtils.addressesFromNetworkInterface(object3);
                    if (!enumeration.hasMoreElements() || (inetAddress = enumeration.nextElement()).isLoopbackAddress()) continue;
                    linkedHashMap.put(object3, inetAddress);
                }
            }
        }
        catch (SocketException socketException) {
            logger.warn("Failed to retrieve the list of available network interfaces", socketException);
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            byte[] byArray;
            enumeration = (NetworkInterface)entry.getKey();
            inetAddress = (InetAddress)entry.getValue();
            if (((NetworkInterface)((Object)enumeration)).isVirtual()) continue;
            try {
                byArray = SocketUtils.hardwareAddressFromNetworkInterface((NetworkInterface)((Object)enumeration));
            }
            catch (SocketException socketException) {
                logger.debug("Failed to get the hardware address of a network interface: {}", (Object)enumeration, (Object)socketException);
                continue;
            }
            boolean bl3 = false;
            int n4 = MacAddressUtil.compareAddresses(object2, byArray);
            if (n4 < 0) {
                bl3 = true;
            } else if (n4 == 0) {
                n4 = MacAddressUtil.compareAddresses(inetAddress2, inetAddress);
                if (n4 < 0) {
                    bl3 = true;
                } else if (n4 == 0 && ((byte[])object2).length < byArray.length) {
                    bl3 = true;
                }
            }
            if (!bl3) continue;
            object2 = byArray;
            inetAddress2 = inetAddress;
        }
        if (object2 == EmptyArrays.EMPTY_BYTES) {
            return null;
        }
        switch (((byte[])object2).length) {
            case 6: {
                object = new byte[8];
                System.arraycopy(object2, 0, object, 0, 3);
                object[3] = -1;
                object[4] = -2;
                System.arraycopy(object2, 3, object, 5, 3);
                object2 = object;
                break;
            }
            default: {
                object2 = Arrays.copyOf(object2, 8);
            }
        }
        return object2;
    }

    public static byte[] defaultMachineId() {
        byte[] byArray = MacAddressUtil.bestAvailableMac();
        if (byArray == null) {
            byArray = new byte[8];
            PlatformDependent.threadLocalRandom().nextBytes(byArray);
            logger.warn("Failed to find a usable hardware address from the network interfaces; using random bytes: {}", (Object)MacAddressUtil.formatAddress(byArray));
        }
        return byArray;
    }

    public static byte[] parseMAC(String string) {
        byte[] byArray;
        char c10;
        switch (string.length()) {
            case 17: {
                c10 = string.charAt(2);
                MacAddressUtil.validateMacSeparator(c10);
                byArray = new byte[6];
                break;
            }
            case 23: {
                c10 = string.charAt(2);
                MacAddressUtil.validateMacSeparator(c10);
                byArray = new byte[8];
                break;
            }
            default: {
                throw new IllegalArgumentException("value is not supported [MAC-48, EUI-48, EUI-64]");
            }
        }
        int n4 = byArray.length - 1;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n4) {
            int n10 = n7 + 2;
            byArray[n8] = StringUtil.decodeHexByte(string, n7);
            if (string.charAt(n10) != c10) {
                throw new IllegalArgumentException("expected separator '" + c10 + " but got '" + string.charAt(n10) + "' at index: " + n10);
            }
            ++n8;
            n7 += 3;
        }
        byArray[n4] = StringUtil.decodeHexByte(string, n7);
        return byArray;
    }

    private static void validateMacSeparator(char c10) {
        if (c10 != ':' && c10 != '-') {
            throw new IllegalArgumentException("unsupported separator: " + c10 + " (expected: [:-])");
        }
    }

    public static String formatAddress(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(24);
        for (byte by2 : byArray) {
            stringBuilder.append(String.format("%02x:", by2 & 0xFF));
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    static int compareAddresses(byte[] byArray, byte[] byArray2) {
        if (byArray2 == null || byArray2.length < 6) {
            return 1;
        }
        boolean bl3 = true;
        for (byte by2 : byArray2) {
            if (by2 == 0 || by2 == 1) continue;
            bl3 = false;
            break;
        }
        if (bl3) {
            return 1;
        }
        if ((byArray2[0] & 1) != 0) {
            return 1;
        }
        if ((byArray2[0] & 2) == 0) {
            if (byArray.length != 0 && (byArray[0] & 2) == 0) {
                return 0;
            }
            return -1;
        }
        if (byArray.length != 0 && (byArray[0] & 2) == 0) {
            return 1;
        }
        return 0;
    }

    private static int compareAddresses(InetAddress inetAddress, InetAddress inetAddress2) {
        return MacAddressUtil.scoreAddress(inetAddress) - MacAddressUtil.scoreAddress(inetAddress2);
    }

    private static int scoreAddress(InetAddress inetAddress) {
        if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) {
            return 0;
        }
        if (inetAddress.isMulticastAddress()) {
            return 1;
        }
        if (inetAddress.isLinkLocalAddress()) {
            return 2;
        }
        if (inetAddress.isSiteLocalAddress()) {
            return 3;
        }
        return 4;
    }

    private MacAddressUtil() {
    }
}

