/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal;

import io.grpc.netty.shaded.io.netty.util.internal.DefaultPriorityQueue$PriorityQueueIterator;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PriorityQueue;
import io.grpc.netty.shaded.io.netty.util.internal.PriorityQueueNode;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public final class DefaultPriorityQueue<T extends PriorityQueueNode>
extends AbstractQueue<T>
implements PriorityQueue<T> {
    private static final PriorityQueueNode[] EMPTY_ARRAY = new PriorityQueueNode[0];
    private final Comparator<T> comparator;
    private T[] queue;
    private int size;

    public DefaultPriorityQueue(Comparator<T> comparator, int n4) {
        this.comparator = ObjectUtil.checkNotNull(comparator, "comparator");
        this.queue = n4 != 0 ? new PriorityQueueNode[n4] : EMPTY_ARRAY;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object object) {
        if (!(object instanceof PriorityQueueNode)) {
            return false;
        }
        PriorityQueueNode priorityQueueNode = (PriorityQueueNode)object;
        return this.contains(priorityQueueNode, priorityQueueNode.priorityQueueIndex(this));
    }

    @Override
    public boolean containsTyped(T t3) {
        return this.contains((PriorityQueueNode)t3, t3.priorityQueueIndex(this));
    }

    @Override
    public void clear() {
        for (int i3 = 0; i3 < this.size; ++i3) {
            T t3 = this.queue[i3];
            if (t3 == null) continue;
            t3.priorityQueueIndex(this, -1);
            this.queue[i3] = null;
        }
        this.size = 0;
    }

    @Override
    public void clearIgnoringIndexes() {
        this.size = 0;
    }

    @Override
    public boolean offer(T t3) {
        if (t3.priorityQueueIndex(this) != -1) {
            throw new IllegalArgumentException("e.priorityQueueIndex(): " + t3.priorityQueueIndex(this) + " (expected: " + -1 + ") + e: " + t3);
        }
        if (this.size >= this.queue.length) {
            this.queue = (PriorityQueueNode[])Arrays.copyOf(this.queue, this.queue.length + (this.queue.length < 64 ? this.queue.length + 2 : this.queue.length >>> 1));
        }
        this.bubbleUp(this.size++, t3);
        return true;
    }

    @Override
    public T poll() {
        if (this.size == 0) {
            return null;
        }
        T t3 = this.queue[0];
        t3.priorityQueueIndex(this, -1);
        T t10 = this.queue[--this.size];
        this.queue[this.size] = null;
        if (this.size != 0) {
            this.bubbleDown(0, t10);
        }
        return t3;
    }

    @Override
    public T peek() {
        return this.size == 0 ? null : (T)this.queue[0];
    }

    @Override
    public boolean remove(Object object) {
        PriorityQueueNode priorityQueueNode;
        try {
            priorityQueueNode = (PriorityQueueNode)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.removeTyped((T)priorityQueueNode);
    }

    @Override
    public boolean removeTyped(T t3) {
        int n4 = t3.priorityQueueIndex(this);
        if (!this.contains((PriorityQueueNode)t3, n4)) {
            return false;
        }
        t3.priorityQueueIndex(this, -1);
        if (--this.size == 0 || this.size == n4) {
            this.queue[n4] = null;
            return true;
        }
        T t10 = this.queue[n4] = this.queue[this.size];
        this.queue[this.size] = null;
        if (this.comparator.compare(t3, t10) < 0) {
            this.bubbleDown(n4, t10);
        } else {
            this.bubbleUp(n4, t10);
        }
        return true;
    }

    @Override
    public void priorityChanged(T t3) {
        int n4 = t3.priorityQueueIndex(this);
        if (!this.contains((PriorityQueueNode)t3, n4)) {
            return;
        }
        if (n4 == 0) {
            this.bubbleDown(n4, t3);
        } else {
            int n7 = n4 - 1 >>> 1;
            T t10 = this.queue[n7];
            if (this.comparator.compare(t3, t10) < 0) {
                this.bubbleUp(n4, t3);
            } else {
                this.bubbleDown(n4, t3);
            }
        }
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.queue, this.size);
    }

    @Override
    public <X> X[] toArray(X[] XArray) {
        if (XArray.length < this.size) {
            return Arrays.copyOf(this.queue, this.size, XArray.getClass());
        }
        System.arraycopy(this.queue, 0, XArray, 0, this.size);
        if (XArray.length > this.size) {
            XArray[this.size] = null;
        }
        return XArray;
    }

    @Override
    public Iterator<T> iterator() {
        return new DefaultPriorityQueue$PriorityQueueIterator(this, null);
    }

    private boolean contains(PriorityQueueNode priorityQueueNode, int n4) {
        return n4 >= 0 && n4 < this.size && priorityQueueNode.equals(this.queue[n4]);
    }

    private void bubbleDown(int n4, T t3) {
        int n7 = this.size >>> 1;
        while (n4 < n7) {
            int n8 = (n4 << 1) + 1;
            T t10 = this.queue[n8];
            int n10 = n8 + 1;
            if (n10 < this.size && this.comparator.compare(t10, this.queue[n10]) > 0) {
                n8 = n10;
                t10 = this.queue[n8];
            }
            if (this.comparator.compare(t3, t10) <= 0) break;
            this.queue[n4] = t10;
            t10.priorityQueueIndex(this, n4);
            n4 = n8;
        }
        this.queue[n4] = t3;
        t3.priorityQueueIndex(this, n4);
    }

    private void bubbleUp(int n4, T t3) {
        int n7;
        T t10;
        while (n4 > 0 && this.comparator.compare(t3, t10 = this.queue[n7 = n4 - 1 >>> 1]) < 0) {
            this.queue[n4] = t10;
            t10.priorityQueueIndex(this, n4);
            n4 = n7;
        }
        this.queue[n4] = t3;
        t3.priorityQueueIndex(this, n4);
    }

    static /* synthetic */ int access$100(DefaultPriorityQueue defaultPriorityQueue) {
        return defaultPriorityQueue.size;
    }

    static /* synthetic */ PriorityQueueNode[] access$200(DefaultPriorityQueue defaultPriorityQueue) {
        return defaultPriorityQueue.queue;
    }
}

