/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal;

import io.grpc.netty.shaded.io.netty.util.internal.Cleaner;
import io.grpc.netty.shaded.io.netty.util.internal.CleanerJava9$1;
import io.grpc.netty.shaded.io.netty.util.internal.CleanerJava9$2;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent0;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;

final class CleanerJava9
implements Cleaner {
    private static final InternalLogger logger;
    private static final Method INVOKE_CLEANER;

    CleanerJava9() {
    }

    static boolean isSupported() {
        return INVOKE_CLEANER != null;
    }

    @Override
    public void freeDirectBuffer(ByteBuffer byteBuffer) {
        if (System.getSecurityManager() == null) {
            try {
                INVOKE_CLEANER.invoke((Object)PlatformDependent0.UNSAFE, byteBuffer);
            }
            catch (Throwable throwable) {
                PlatformDependent0.throwException(throwable);
            }
        } else {
            CleanerJava9.freeDirectBufferPrivileged(byteBuffer);
        }
    }

    private static void freeDirectBufferPrivileged(ByteBuffer byteBuffer) {
        Exception exception = AccessController.doPrivileged(new CleanerJava9$2(byteBuffer));
        if (exception != null) {
            PlatformDependent0.throwException(exception);
        }
    }

    static /* synthetic */ Method access$000() {
        return INVOKE_CLEANER;
    }

    static {
        Throwable throwable;
        Method method;
        logger = InternalLoggerFactory.getInstance(CleanerJava9.class);
        if (PlatformDependent0.hasUnsafe()) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
            Object object = AccessController.doPrivileged(new CleanerJava9$1(byteBuffer));
            if (object instanceof Throwable) {
                method = null;
                throwable = (Throwable)object;
            } else {
                method = (Method)object;
                throwable = null;
            }
        } else {
            method = null;
            throwable = new UnsupportedOperationException("sun.misc.Unsafe unavailable");
        }
        if (throwable == null) {
            logger.debug("java.nio.ByteBuffer.cleaner(): available");
        } else {
            logger.debug("java.nio.ByteBuffer.cleaner(): unavailable", throwable);
        }
        INVOKE_CLEANER = method;
    }
}

