/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal;

import io.grpc.netty.shaded.io.netty.util.internal.Cleaner;
import io.grpc.netty.shaded.io.netty.util.internal.CleanerJava6$1;
import io.grpc.netty.shaded.io.netty.util.internal.CleanerJava6$2;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import io.grpc.netty.shaded.io.netty.util.internal.PlatformDependent0;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;

final class CleanerJava6
implements Cleaner {
    private static final long CLEANER_FIELD_OFFSET;
    private static final Method CLEAN_METHOD;
    private static final Field CLEANER_FIELD;
    private static final InternalLogger logger;

    CleanerJava6() {
    }

    static boolean isSupported() {
        return CLEANER_FIELD_OFFSET != -1L || CLEANER_FIELD != null;
    }

    @Override
    public void freeDirectBuffer(ByteBuffer byteBuffer) {
        if (!byteBuffer.isDirect()) {
            return;
        }
        if (System.getSecurityManager() == null) {
            try {
                CleanerJava6.freeDirectBuffer0(byteBuffer);
            }
            catch (Throwable throwable) {
                PlatformDependent0.throwException(throwable);
            }
        } else {
            CleanerJava6.freeDirectBufferPrivileged(byteBuffer);
        }
    }

    private static void freeDirectBufferPrivileged(ByteBuffer byteBuffer) {
        Throwable throwable = AccessController.doPrivileged(new CleanerJava6$2(byteBuffer));
        if (throwable != null) {
            PlatformDependent0.throwException(throwable);
        }
    }

    private static void freeDirectBuffer0(ByteBuffer byteBuffer) {
        Object object = CLEANER_FIELD_OFFSET == -1L ? CLEANER_FIELD.get(byteBuffer) : PlatformDependent0.getObject(byteBuffer, CLEANER_FIELD_OFFSET);
        if (object != null) {
            CLEAN_METHOD.invoke(object, new Object[0]);
        }
    }

    static /* synthetic */ void access$000(ByteBuffer byteBuffer) {
        CleanerJava6.freeDirectBuffer0(byteBuffer);
    }

    static {
        Method method;
        long l2;
        Field field;
        logger = InternalLoggerFactory.getInstance(CleanerJava6.class);
        Throwable throwable = null;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
        try {
            Object object;
            Object object2 = AccessController.doPrivileged(new CleanerJava6$1(byteBuffer));
            if (object2 instanceof Throwable) {
                throw (Throwable)object2;
            }
            field = (Field)object2;
            if (PlatformDependent.hasUnsafe()) {
                l2 = PlatformDependent0.objectFieldOffset(field);
                object = PlatformDependent0.getObject(byteBuffer, l2);
            } else {
                l2 = -1L;
                object = field.get(byteBuffer);
            }
            method = object.getClass().getDeclaredMethod("clean", new Class[0]);
            method.invoke(object, new Object[0]);
        }
        catch (Throwable throwable2) {
            l2 = -1L;
            method = null;
            throwable = throwable2;
            field = null;
        }
        if (throwable == null) {
            logger.debug("java.nio.ByteBuffer.cleaner(): available");
        } else {
            logger.debug("java.nio.ByteBuffer.cleaner(): unavailable", throwable);
        }
        CLEANER_FIELD = field;
        CLEANER_FIELD_OFFSET = l2;
        CLEAN_METHOD = method;
    }
}

