/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.internal;

import java.util.Arrays;

public final class AppendableCharSequence
implements Appendable,
CharSequence {
    private char[] chars;
    private int pos;

    public AppendableCharSequence(int n4) {
        if (n4 < 1) {
            throw new IllegalArgumentException("length: " + n4 + " (length: >= 1)");
        }
        this.chars = new char[n4];
    }

    private AppendableCharSequence(char[] cArray) {
        if (cArray.length < 1) {
            throw new IllegalArgumentException("length: " + cArray.length + " (length: >= 1)");
        }
        this.chars = cArray;
        this.pos = cArray.length;
    }

    @Override
    public int length() {
        return this.pos;
    }

    @Override
    public char charAt(int n4) {
        if (n4 > this.pos) {
            throw new IndexOutOfBoundsException();
        }
        return this.chars[n4];
    }

    public char charAtUnsafe(int n4) {
        return this.chars[n4];
    }

    @Override
    public AppendableCharSequence subSequence(int n4, int n7) {
        if (n4 == n7) {
            return new AppendableCharSequence(Math.min(16, this.chars.length));
        }
        return new AppendableCharSequence(Arrays.copyOfRange(this.chars, n4, n7));
    }

    @Override
    public AppendableCharSequence append(char c10) {
        if (this.pos == this.chars.length) {
            char[] cArray = this.chars;
            this.chars = new char[cArray.length << 1];
            System.arraycopy(cArray, 0, this.chars, 0, cArray.length);
        }
        this.chars[this.pos++] = c10;
        return this;
    }

    @Override
    public AppendableCharSequence append(CharSequence charSequence) {
        return this.append(charSequence, 0, charSequence.length());
    }

    @Override
    public AppendableCharSequence append(CharSequence charSequence, int n4, int n7) {
        if (charSequence.length() < n7) {
            throw new IndexOutOfBoundsException();
        }
        int n8 = n7 - n4;
        if (n8 > this.chars.length - this.pos) {
            this.chars = AppendableCharSequence.expand(this.chars, this.pos + n8, this.pos);
        }
        if (charSequence instanceof AppendableCharSequence) {
            AppendableCharSequence appendableCharSequence = (AppendableCharSequence)charSequence;
            char[] cArray = appendableCharSequence.chars;
            System.arraycopy(cArray, n4, this.chars, this.pos, n8);
            this.pos += n8;
            return this;
        }
        for (int i3 = n4; i3 < n7; ++i3) {
            this.chars[this.pos++] = charSequence.charAt(i3);
        }
        return this;
    }

    public void reset() {
        this.pos = 0;
    }

    @Override
    public String toString() {
        return new String(this.chars, 0, this.pos);
    }

    public String substring(int n4, int n7) {
        int n8 = n7 - n4;
        if (n4 > this.pos || n8 > this.pos) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.chars, n4, n8);
    }

    public String subStringUnsafe(int n4, int n7) {
        return new String(this.chars, n4, n7 - n4);
    }

    private static char[] expand(char[] cArray, int n4, int n7) {
        int n8 = cArray.length;
        do {
            if ((n8 <<= 1) >= 0) continue;
            throw new IllegalStateException();
        } while (n4 > n8);
        char[] cArray2 = new char[n8];
        System.arraycopy(cArray, 0, cArray2, 0, n7);
        return cArray2;
    }
}

