/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.concurrent;

import io.grpc.netty.shaded.io.netty.util.concurrent.Future;
import io.grpc.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.grpc.netty.shaded.io.netty.util.concurrent.Promise;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import io.grpc.netty.shaded.io.netty.util.internal.PromiseNotificationUtil;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import io.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public class PromiseNotifier<V, F extends Future<V>>
implements GenericFutureListener<F> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PromiseNotifier.class);
    private final Promise<? super V>[] promises;
    private final boolean logNotifyFailure;

    @SafeVarargs
    public PromiseNotifier(Promise<? super V> ... promiseArray) {
        this(true, promiseArray);
    }

    @SafeVarargs
    public PromiseNotifier(boolean bl3, Promise<? super V> ... promiseArray) {
        ObjectUtil.checkNotNull(promiseArray, "promises");
        for (Promise<? super V> promise : promiseArray) {
            if (promise != null) continue;
            throw new IllegalArgumentException("promises contains null Promise");
        }
        this.promises = (Promise[])promiseArray.clone();
        this.logNotifyFailure = bl3;
    }

    @Override
    public void operationComplete(F f8) {
        InternalLogger internalLogger;
        InternalLogger internalLogger2 = internalLogger = this.logNotifyFailure ? logger : null;
        if (f8.isSuccess()) {
            Object v3 = f8.get();
            for (Promise<? super V> promise : this.promises) {
                PromiseNotificationUtil.trySuccess(promise, v3, internalLogger);
            }
        } else if (f8.isCancelled()) {
            for (Promise<? super V> promise : this.promises) {
                PromiseNotificationUtil.tryCancel(promise, internalLogger);
            }
        } else {
            Throwable throwable = f8.cause();
            for (Promise<? super V> promise : this.promises) {
                PromiseNotificationUtil.tryFailure(promise, throwable, internalLogger);
            }
        }
    }
}

