/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.netty.util.concurrent;

import io.grpc.netty.shaded.io.netty.util.concurrent.EventExecutor;
import io.grpc.netty.shaded.io.netty.util.concurrent.Future;
import io.grpc.netty.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.grpc.netty.shaded.io.netty.util.concurrent.ImmediateEventExecutor;
import io.grpc.netty.shaded.io.netty.util.concurrent.Promise;
import io.grpc.netty.shaded.io.netty.util.concurrent.PromiseCombiner$1;
import io.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

public final class PromiseCombiner {
    private int expectedCount;
    private int doneCount;
    private Promise<Void> aggregatePromise;
    private Throwable cause;
    private final GenericFutureListener<Future<?>> listener = new PromiseCombiner$1(this);
    private final EventExecutor executor;

    @Deprecated
    public PromiseCombiner() {
        this(ImmediateEventExecutor.INSTANCE);
    }

    public PromiseCombiner(EventExecutor eventExecutor) {
        this.executor = ObjectUtil.checkNotNull(eventExecutor, "executor");
    }

    @Deprecated
    public void add(Promise promise) {
        this.add((Future)promise);
    }

    public void add(Future future) {
        this.checkAddAllowed();
        this.checkInEventLoop();
        ++this.expectedCount;
        future.addListener(this.listener);
    }

    @Deprecated
    public void addAll(Promise ... promiseArray) {
        this.addAll((Future[])promiseArray);
    }

    public void addAll(Future ... futureArray) {
        for (Future future : futureArray) {
            this.add(future);
        }
    }

    public void finish(Promise<Void> promise) {
        ObjectUtil.checkNotNull(promise, "aggregatePromise");
        this.checkInEventLoop();
        if (this.aggregatePromise != null) {
            throw new IllegalStateException("Already finished");
        }
        this.aggregatePromise = promise;
        if (this.doneCount == this.expectedCount) {
            this.tryPromise();
        }
    }

    private void checkInEventLoop() {
        if (!this.executor.inEventLoop()) {
            throw new IllegalStateException("Must be called from EventExecutor thread");
        }
    }

    private boolean tryPromise() {
        return this.cause == null ? this.aggregatePromise.trySuccess(null) : this.aggregatePromise.tryFailure(this.cause);
    }

    private void checkAddAllowed() {
        if (this.aggregatePromise != null) {
            throw new IllegalStateException("Adding promises is not allowed after finished adding");
        }
    }

    static /* synthetic */ EventExecutor access$000(PromiseCombiner promiseCombiner) {
        return promiseCombiner.executor;
    }

    static /* synthetic */ int access$204(PromiseCombiner promiseCombiner) {
        return ++promiseCombiner.doneCount;
    }

    static /* synthetic */ Throwable access$300(PromiseCombiner promiseCombiner) {
        return promiseCombiner.cause;
    }

    static /* synthetic */ Throwable access$302(PromiseCombiner promiseCombiner, Throwable throwable) {
        promiseCombiner.cause = throwable;
        return promiseCombiner.cause;
    }

    static /* synthetic */ int access$200(PromiseCombiner promiseCombiner) {
        return promiseCombiner.doneCount;
    }

    static /* synthetic */ int access$400(PromiseCombiner promiseCombiner) {
        return promiseCombiner.expectedCount;
    }

    static /* synthetic */ Promise access$500(PromiseCombiner promiseCombiner) {
        return promiseCombiner.aggregatePromise;
    }

    static /* synthetic */ boolean access$600(PromiseCombiner promiseCombiner) {
        return promiseCombiner.tryPromise();
    }
}

